<?php  

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Export
 *
 * @author miguel.sousa
 */
class Export extends AcessoBD{
    
    var $bd;

    /*
		Construtor da classe
		
		0 = Erro da BD
    */
    function Export()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }
    
    function getNomeLoja($id_loja){
       $sql = "SELECT nome from lojas WHERE id_loja=$id_loja";
       $rs = $this->bd->ExecutarSQL($sql);
       return $this->bd->obterValor($rs, "nome");
    }
    
    
   function getExportAtendimentoPorAtendente($start_date, $end_date, $local){
        
    $export=array();
    
    $time_manager=new timeManager();
    
    $sql="SELECT empregados.id_empregado, empregados.nome_utilizador, empregados.nome as empregado_nome, count(*) as senhas_atendidas, (AVG(TIME_TO_SEC(senhas.tempo_atendimento))) as media_atendimento, TIME_TO_SEC(min(tempo_atendimento)) as min_atendimento, TIME_TO_SEC(max(tempo_atendimento)) as max_atendimento, avg(TIME_TO_SEC(senhas.tempo_espera)) as media_espera
                 FROM senhas INNER join empregados on empregados.id_empregado=senhas.id_colaborador inner join balcoes on balcoes.id_balcao=senhas.id_balcao WHERE data >= DATE('$start_date') AND data <= DATE('$end_date') AND
                	(	status = '". SENHA_TERMINADA ."' OR 
                		status = '". SENHA_REDIRECCAO ."' 
                	) AND senhas.id_loja=$local group by empregados.id_empregado
                order by empregado_nome asc";
    
    
//$res = $this->bd->ExecutarSQL($sql)->GetRows();
    $res = $this->bd->getRows($sql);
    
    if(count($res)>0){
	$count = 0;
	foreach($res AS $row){
                $tempos=array();
		$export[$count] = array();
		foreach($row AS $field => $value){
			if(!is_numeric($field)){
                            $export[$count][$field] = $value;
			}
		}	
	
   $tempos['atendimento']=0;
   $tempos['suspenso']=0;
   $tempos['livre']=0;
   $tempos['servico_interno']=0;
   $tempos['total']=0;
   
    $actualTimeStamp = mktime(0, 0, 0, date("m", strtotime($start_date)), date("d", strtotime($start_date)), date("Y", strtotime($start_date)));
    $endDateTimeStamp = mktime(0, 0, 0, date("m", strtotime($end_date)), date("d", strtotime($end_date)), date("Y", strtotime($end_date)));
    
        while($actualTimeStamp <= $endDateTimeStamp){
            $data = date("Y-m-d", $actualTimeStamp);
            $tempos_update=$time_manager->getLastAvailableTempos( $export[$count]['id_empregado'], $local, $data, false);
                $tempos['atendimento']=$tempos['atendimento']+$tempos_update['atendimento'];
                $tempos['suspenso']=$tempos['suspenso']+$tempos_update['suspenso'];
                $tempos['livre']=$tempos['livre']+$tempos_update['livre'];
                $tempos['servico_interno']=$tempos['servico_interno']+$tempos_update['servico_interno'];
                $tempos['total']=$tempos['total']+$tempos_update['total'];
                
                $actualTimeStamp = mktime(0, 0, 0, date("m", $actualTimeStamp), date("d", $actualTimeStamp)+1, date("Y", $actualTimeStamp));
}
    $export[$count]['atendimento'] = $tempos['atendimento'];
    $export[$count]['suspenso'] = $tempos['suspenso'];
    $export[$count]['livre'] = $tempos['livre'];
    $export[$count]['servico_interno'] = $tempos['servico_interno'];
    $export[$count]['total'] = $tempos['total'];
    
    
    $count++;
       }
 }
  return $export;
 }
    
    
    //obter listagem de atendimentos por serviço
    function getExportAtendimentoPorServico($start_date, $end_date, $local){
        
        $sql = 	"SELECT senhas.servico_destino as id_servico, servicos.nome, AVG(TIME_TO_SEC(senhas.tempo_atendimento)) AS med_tempo_atendimento, 
                SUM(TIME_TO_SEC(senhas.tempo_atendimento)) AS tempo_atendimento, MAX(senhas.numero_senha) AS numero_senha
                 FROM senhas INNER JOIN servicos on senhas.servico_destino=servicos.id_servico
                WHERE	data >= DATE('$start_date') AND data <= DATE('$end_date') AND
                	(	status = '". SENHA_TERMINADA ."' OR 
                		status = '". SENHA_REDIRECCAO ."' 
                	) AND id_loja=$local 
                GROUP BY servico_destino";
        
        $export=array();
        
        //$res = $this->bd->ExecutarSQL($sql)->GetRows();
        $res = $this->bd->getRows($sql);

     if(count($res)>0){
	$count = 0;
	foreach($res AS $row){
		$export[$count] = array();
		foreach($row AS $field => $value){
			if(!is_numeric($field)){
                            $export[$count][$field] = $value;
			}
		}	
	$count++;
       }
    }
  

   
      
  return $export;
 }
    
    
    function getExportServicoPorAtendente($start_date, $end_date, $local){
        
    
        $sql = 	"SELECT DATE(senhas.emissao) as data, empregados.nome as nome_empregado, senhas.servico_destino as id_servico, servicos.nome as nome_servico, servicos.identificador as identificador, TIME(ADDDATE(senhas.emissao, senhas.tempo_espera)) as t_inicio , senhas.tempo_atendimento, senhas.numero_senha, balcoes.nome as nome_balcao
                 FROM senhas INNER JOIN servicos on senhas.servico_destino=servicos.id_servico INNER join empregados on empregados.id_empregado=senhas.id_colaborador inner join balcoes on balcoes.id_balcao=senhas.id_balcao
                WHERE	data >= DATE('$start_date') AND data <= DATE('$end_date') AND
                	(	status = '". SENHA_TERMINADA ."' OR 
                		status = '". SENHA_REDIRECCAO ."' 
                	) AND senhas.id_loja=$local 
                order by date(senhas.emissao), id_empregado, senhas.servico_destino, senhas.numero_senha asc";
        
        $export=array();
        
        //$res = $this->bd->ExecutarSQL($sql)->GetRows();
        $res = $this->bd->getRows($sql);

     if(count($res)>0){
	$count = 0;
	foreach($res AS $row){
		$export[$count] = array();
		foreach($row AS $field => $value){
			if(!is_numeric($field)){
                            $export[$count][$field] = $value;
			}
		}	
	$count++;
       }
    }
     return $export;
}


}

?>
