<?php  
ob_start();
// Obter acesso à classe PHPExcel
require_once '../libraries2/PHPExcel.php';
require_once("../config.inc.php");

$start_date = $_REQUEST['start_date'];
$end_date = $_REQUEST['end_date'];
$id_loja = $_REQUEST['id_loja'];

// Criar um novo objecto PHPExcel
$objPHPExcel = new PHPExcel();
$export = new Export();

$excel_data = $export->getExportAtendimentoPorAtendente($start_date, $end_date, $id_loja);

$nome_loja = $export->getNomeLoja($id_loja);


// As várias propriedades do documento que podemos definir
$objPHPExcel->getProperties()->setCreator("user_account_name")
        ->setLastModifiedBy("user_account_name")
        ->setTitle("Relatório de Dados de Atendimento por Atendente")
        ->setSubject("Relatório de Dados de Atendimento por Atendente");

// Inserir dados nas células B3 e B4
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('B3', 'Relatório de Dados de Atendimento por Atendente')
        ->setCellValue('B4', 'da Loja ' . $nome_loja . '. Período: ' . $start_date . ' a ' . $end_date);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->getStartColor()->setRGB('CCCCFF');
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getBorders()->getOutline()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);


//headers
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('B7', 'Atendente')
        ->setCellValue('C7', 'Senhas atendidas')
        ->setCellValue('D7', 'Tempo médio de atendimento')
        ->setCellValue('E7', 'Tempo mínimo de atendimento')
        ->setCellValue('F7', 'Tempo máximo de atendimento')
        ->setCellValue('G7', 'Tempo conectado')
        ->setCellValue('H7', 'Tempo livre')
        ->setCellValue('I7', 'Tempo atendendo')
        ->setCellValue('J7', 'Tempo suspenso')
        ->setCellValue('K7', 'Tempo serv. interno');
//  ->setCellValue('K7', 'Tempo serv. interno')
// ->setCellValue('L7', 'T Susp: 01')
// ->setCellValue('M7', 'T Susp: 02');
$objPHPExcel->getActiveSheet()->getStyle('B7:K7')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B7:K7')->getFill()->getStartColor()->setRGB('CCFFFF');
$objPHPExcel->getActiveSheet()->getStyle('B7:K7')->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyle('B7:K7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('B7:K7')->getFont()->setBold(true);



$last_row = 7;
$num_senhas = 0;
$min_atendimento = 0;
$max_atendimento = 0;
$t_med = 0;
$med_espera = 0;
$i = 0;

foreach ($excel_data as $data) {

    $last_row = $last_row + 1;
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row, $data['nome_utilizador'] . " - " . $data['empregado_nome']);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row, $data['senhas_atendidas']);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $last_row, Timestamp_to_Time($data['media_atendimento']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $last_row, Timestamp_to_Time($data['min_atendimento']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $last_row, Timestamp_to_Time($data['max_atendimento']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $last_row, Timestamp_to_Time($data['total']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $last_row, Timestamp_to_Time($data['livre']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $last_row, Timestamp_to_Time($data['atendimento']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, $last_row, Timestamp_to_Time($data['suspenso']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, $last_row, Timestamp_to_Time($data['servico_interno']));

    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(6, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(7, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(8, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(9, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(10, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(6, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(7, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(8, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(9, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(10, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);

    $num_senhas = $num_senhas + $data['senhas_atendidas'];
    $t_med = $t_med + $data['media_atendimento'];
    $med_espera = $med_espera + $data['media_espera'];
    $i = $i + 1;
    if ($min_atendimento == 0 || $min_atendimento > $data['min_atendimento']) {
        $min_atendimento = $data['min_atendimento'];
    }
    if ($min_atendimento == 0 || $max_atendimento < $data['min_atendimento']) {
        $max_atendimento = $data['max_atendimento'];
    }

}

$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 2)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 2)->getFill()->getStartColor()->setRGB('FFFF99');
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 3)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 3)->getFill()->getStartColor()->setRGB('FFFF99');
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row + 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row + 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row + 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row + 2)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row + 3)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 3)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row + 2, 'Total geral');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row + 3, 'Tempo médio de espera');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row + 2, $num_senhas);
//$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $last_row + 2, Timestamp_to_Time($t_med / $i));
//$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $last_row + 2, Timestamp_to_Time($min_atendimento));
//$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $last_row + 2, Timestamp_to_Time($max_atendimento));
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row + 3, Timestamp_to_Time($med_espera / $i));
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 2)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row + 2)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row + 2)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row + 2)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
//$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row + 2)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row + 3)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row + 3)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);





$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');

ob_clean();
header('Content-type: application/vnd.ms-excel');
// It will be called file.xls
header('Content-Disposition: attachment; filename="file.xlsx"');
header("Content-Transfer-Encoding: binary ");
header('Cache-Control: max-age=0');

//var_dump($objWriter); die();
// Encaminhar o ficheiro resultante para abrir no browser ou fazer download
header("Pragma: public");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream");
header("Content-Type: application/download");;
header("Content-Disposition: attachment;filename=Dados de atendimento por atendente.xlsx");
header("Content-Transfer-Encoding: binary ");

//header('Content-Type: application/vnd.ms-excel');
//header('Content-Disposition: attachment;filename="Dados de atendimento por atendente.xlsx"');
//header('Cache-Control: max-age=0');
//
$objWriter->save('php://output');
//$objWriter->save("Dados de atendimento por atendente.xlsx");

$objPHPExcel->disconnectWorksheets();

unset($objPHPExcel);
unset($objWriter);


?>
