<?php  

// Obter acesso à classe PHPExcel
require_once '../libraries2/PHPExcel.php';
require_once("../config.inc.php");

$start_date=$_REQUEST['start_date'];
$end_date=$_REQUEST['end_date'];
$id_loja=$_REQUEST['id_loja'];

// Criar um novo objecto PHPExcel
$objPHPExcel = new PHPExcel();
$export = new Export();

$excel_data=$export->getExportAtendimentoPorServico($start_date, $end_date, $id_loja);
$nome_loja=$export->getNomeLoja($id_loja);

// As várias propriedades do documento que podemos definir
$objPHPExcel->getProperties()->setCreator("user_account_name")
                ->setLastModifiedBy("user_account_name")
                ->setTitle("Dados de atendimento por serviço")
                ->setSubject("Dados de atendimento por serviço");
 
// Inserir dados nas células B3 e B4
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('B3', 'Relatório de Atendimentos por Serviço da Loja '.$nome_loja)
            ->setCellValue('B4', 'Período: '.$start_date.' a '.$end_date);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->getStartColor()->setRGB('CCCCFF');
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getBorders()->getOutline()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);





          
$objPHPExcel->getActiveSheet() 
            ->setCellValue('B7', 'Serviço')
            ->setCellValue('C7', 'Tempo atendimento')
            ->setCellValue('D7', 'Nº de Serviço')
            ->setCellValue('E7', 'Tempo médio de atendimento');
$objPHPExcel->getActiveSheet()->getStyle('B7:E7')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B7:E7')->getFill()->getStartColor()->setRGB('CCFFFF');
$objPHPExcel->getActiveSheet()->getStyle('B7:E7')->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyle('B7:E7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('B7:E7')->getFont()->setBold(true);



$last_row=7;
$num_senhas=0;
$t_atend_total=0;
$t_med=0;
$i=0;

foreach($excel_data as $data){
    $last_row=$last_row+1;
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row, $data['id_servico']." - ".$data['nome']);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row, Timestamp_to_Time($data['tempo_atendimento']));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $last_row, $data['numero_senha']);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $last_row, Timestamp_to_Time($data['med_tempo_atendimento']));
    
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    
    $num_senhas=$num_senhas+$data['numero_senha'];
    $t_atend_total=$t_atend_total+$data['tempo_atendimento'];
    $t_med=$t_med+$data['med_tempo_atendimento'];
    $i=$i+1;
}

$last_row=$last_row+3;
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getFill()->getStartColor()->setRGB('FFCC99');
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getFill()->getStartColor()->setRGB('FFCC99');
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getFill()->getStartColor()->setRGB('FFCC99');
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row, 'Total Geral');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row, Timestamp_to_Time($t_atend_total));
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $last_row, $num_senhas);




          
 
// Indicação da criação do ficheiro
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
 
// Encaminhar o ficheiro resultante para abrir no browser ou fazer download
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="Dados de atendimento por servico.xlsx"');
header('Cache-Control: max-age=0');
$objWriter->save('php://output');
//$objWriter->save("myexcel.xlsx");

$objPHPExcel->disconnectWorksheets();

unset($objPHPExcel);
unset($objWriter);
?>
