<?php  

// Obter acesso à classe PHPExcel
// Obter acesso à classe PHPExcel
require_once '../libraries2/PHPExcel.php';
require_once("../config.inc.php");

$start_date=$_REQUEST['start_date'];
$end_date=$_REQUEST['end_date'];
$id_loja=$_REQUEST['id_loja'];

// Criar um novo objecto PHPExcel
$objPHPExcel = new PHPExcel();
$export = new Export();

$excel_data=$export->getExportServicoPorAtendente($start_date, $end_date, $id_loja);
$nome_loja=$export->getNomeLoja($id_loja);
 
// As várias propriedades do documento que podemos definir
$objPHPExcel->getProperties()->setCreator("user_account_name")
                ->setLastModifiedBy("user_account_name")
                ->setTitle("Serviços por atendente")
                ->setSubject("Serviços por atendente");
 
// Inserir dados nas células B3 e B4
$objPHPExcel->setActiveSheetIndex(0)
            ->setCellValue('B3', 'Relatório de Serviços por Categoria da Loja '.$nome_loja)
            ->setCellValue('B4', 'Período: '.$start_date.' a '.$end_date);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getFill()->getStartColor()->setRGB('CCCCFF');
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getBorders()->getOutline()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('B3:B4')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);

$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);

//headers
$objPHPExcel->getActiveSheet()->setCellValue('B7', 'Serviços Efetuados Pelos Atendentes');
$objPHPExcel->getActiveSheet()->getStyle('B7')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B7')->getFill()->getStartColor()->setRGB('00CCFF');
$objPHPExcel->getActiveSheet()->getStyle('B7')->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyle('B7')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('B7')->getFont()->setBold(true);


          
$objPHPExcel->getActiveSheet() 
            ->setCellValue('B9', 'Data')
            ->setCellValue('C9', 'Nome')
            ->setCellValue('D9', 'Cod Svc')
            ->setCellValue('E9', 'Descr Svc')
            ->setCellValue('F9', 'Hora Inicio')
            ->setCellValue('G9', 'Duracao')
            ->setCellValue('H9', 'Senha')
            ->setCellValue('I9', 'Terminal');
$objPHPExcel->getActiveSheet()->getStyle('B9:I9')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
$objPHPExcel->getActiveSheet()->getStyle('B9:I9')->getFill()->getStartColor()->setRGB('CCFFFF');
$objPHPExcel->getActiveSheet()->getStyle('B9:I9')->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_MEDIUM);
$objPHPExcel->getActiveSheet()->getStyle('B9:I9')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('B9:I9')->getFont()->setBold(true);



$last_row=9;
$num_senhas=0;

foreach($excel_data as $data){
    $last_row=$last_row+1;
   
        
       
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, $last_row, $data['data']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, $last_row, $data['nome_empregado']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, $last_row, $data['id_servico']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, $last_row, $data['nome_servico']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, $last_row, $data['t_inicio']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, $last_row, $data['tempo_atendimento']);
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, $last_row, $data['identificador'].str_pad($data['numero_senha'], 4, "0", STR_PAD_LEFT));
   $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, $last_row, $data['nome_balcao']);
   
    
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(6, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(7, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(8, $last_row)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);  

    
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(1, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(2, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(3, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(4, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(5, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(6, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(7, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    $objPHPExcel->getActiveSheet()->getStyleByColumnAndRow(8, $last_row)->getBorders()->getAllBorders()->setBorderStyle(PHPExcel_Style_Border::BORDER_THIN);
    
}
          
 
// Indicação da criação do ficheiro
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
 
// Encaminhar o ficheiro resultante para abrir no browser ou fazer download
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="Serviços por Atendente.xlsx"');
header('Cache-Control: max-age=0');
$objWriter->save('php://output');
//$objWriter->save("myexcel.xlsx");

$objPHPExcel->disconnectWorksheets();

unset($objPHPExcel);
unset($objWriter);
?>
