<?php 



/**
 *  Classe de Gestão de Horários
 *  Corresponde à tabela 'horario' da base de dados.
 */
class FormSubmission extends AcessoBD {

	var $bd;
	var $id;
	var $id_form;   // FK to corresponding Form
    var $id_senha;  // FK to corresponding Senha (Ticket)
	var $data;	    // The Data that was submitted with the form
	var $created;   // Date created
	var $modified;  // Date modified
	var $writer;

	/*
	  Construtor da classe

	  0 = Erro da BD
	 */

	function FormSubmission() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		$writer = new XLSXWriter();
		return $this->bd;
	}

	/*
	  Função de inserção

	  0 = Erro da BD
	  5 = Erro Existente
	  true = Sucesso
	 */

	function Inserir($dados) {

		// Get the form template in order to know which fields
		// are valid so as to not allow anyone to inject invalid
		// fields and values into this form
		$form = new Form();
		$form->get($dados["id_form"]);


		if (!$form->getId()) {
			debug("ERROR Form Data Insert: Form template with the provided Id (" . $dados["id_form"] . ") does not exist.");
			return "nok";
		}

		$templateFields = json_decode($form->data, true);
		if (!is_array($templateFields)) {
			debug("ERROR Form Data Insert: Form template has no specified fields.");
			debug($templateFields);
			return "nok";
		}

		$formData = array();
		foreach ($templateFields as $name => $field) { // the name is also available at $field['name']
			if (isset($dados[$name])) {
				// array('Label Text' => 'Field Value');
				$formData[$field['label']] = $dados[$name];
			}
		}

		$formSubmission = new FormSubmission();


		$formSubmission->id_form = $dados["id_form"];
        $formSubmission->id_senha = $dados["id_senha"];
		$formSubmission->data = addslashes(json_encode($formData));
		$formSubmission->created = date("Y-m-d H:i:s", time());
		$formSubmission->modified = $formSubmission->created;

		$formSubmission->save();

        return "ok";
	}

	/**
	 * Função de Edição
	 *
	 * @param array   $dados   Um array com todos os dados de um Formulário
	 * @param integer $id      O id do Formulário a editar
	 * @return mixed           0 = Erro da BD
	 *                         5 = Erro Existente
	 *                         true = Sucesso
	 */
	function Editar($dados, $id) {
		return "ok";
	}

	function GetFormSubmission($id="") {
		$this->get($id);
		return $this;
	}

	/*
	  Fun��o de leitura de dados

	  0 = Erro da BD
	  true = Sucesso
	 */

	function LerDados($id) {
		$this->get($id);
		$_SESSION["sessao_campos"]['form_submission'] = $this;
		return "ok";
	}

	/**
	 * Função de Remoção.
	 *
	 * @param  mixed $id    Um único id ou um array de ids
	 * @return mixed
	 */
	function Remover($id) {
		// Nothing here for now
		return "nok";
	}

	function Exportar($dados) {

		$form_id = $dados['form'];
		if (!isset($form_id) || !is_numeric($form_id)) {
			return "nok";
		}

		$sql = "SELECT f.id, f.id_form, f.id_senha, f.data, f.created, f.modified, ";
		$sql.= "s.id_senha, s.numero_senha, ";
		$sql.= "svc_emi.id_servico as id_servico_emissao, svc_emi.nome as nome_servico_emissao, svc_emi.identificador as identificador_servico_emissao, ";
		$sql.= "svc_dest.id_servico as id_servico_destino, svc_dest.nome as nome_servico_destino, svc_dest.identificador as identificador_servico_destino ";
		$sql.= "FROM form_submission f ";
		$sql.= "LEFT JOIN senhas s ON s.id_senha = f.id_senha ";
		$sql.= "LEFT JOIN servicos svc_emi ON svc_emi.id_servico = s.servico_emissao ";
		$sql.= "LEFT JOIN servicos svc_dest ON svc_dest.id_servico = s.servico_destino ";
		$sql.= "WHERE f.id_form = " . addslashes($form_id). " ";

		// Expected date format: YYYY-MM-DD
		if (isset($dados['datestart']) && !empty($dados['datestart'])) {
			list($y, $m, $d) = explode('-', $dados['datestart']);
			$time = @mktime(0, 0, 0, $m, $d, $y);
			if ($time != -1 && $time != FALSE) {
				$sql.= "AND created >= '" . date("Y-m-d H:i:s", $time) . "' ";
			}
		}
		if (isset($dados['dateend']) && !empty($dados['dateend'])) {
			list($y, $m, $d) = explode('-', $dados['dateend']);
			$time = @mktime(23, 59, 59, $m, $d, $y);
			if ($time != -1 && $time != FALSE) {
				$sql.= "AND created <= '" . date("Y-m-d H:i:s", $time) . "' ";
			}
		}
		$sql.= "ORDER BY f.created ASC";

		global $ERROS, $N_REGISTOS;
		if (!$rs = $this->bd->executarSQL($sql)) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			exit();
		}

		// Get all the different fields that exist and store the values of
		// the submission with their associated field labels, different versions
		// of the Form template can have added different fields
		$numResults = $this->bd->obterNumRegistos($rs);
		$fieldValues = array();
		$fieldValues['id_senha'] = array();

		for ($i = 0; $i < $numResults; $i++) {
			$this->bd->moverRegisto($rs, $i);
			$submission = $this->bd->obterRegisto($rs);

			$fieldValues['submissao'][$i] = $submission['created'];
			$fieldValues['id_senha'][$i] = $submission['id_senha']; // Set the id_senha "manually" since it doesn't belong to the data JSON object
			$fieldValues['numero_senha'][$i] = $submission['numero_senha'];
			$fieldValues['id_servico_emissao'][$i] = $submission['id_servico_emissao'];
			$fieldValues['nome_servico_emissao'][$i] = $submission['nome_servico_emissao'];
			$fieldValues['identificador_servico_emissao'][$i] = $submission['identificador_servico_emissao'];
			$fieldValues['id_servico_destino'][$i] = $submission['id_servico_destino'];
			$fieldValues['nome_servico_destino'][$i] = $submission['nome_servico_destino'];
			$fieldValues['identificador_servico_destino'][$i] = $submission['identificador_servico_destino'];

			$data = json_decode($submission['data'], true);
			if (!is_array($data)) continue;
			foreach ($data as $name => $value) {
				if (!isset($fieldValues[$name])) {
					$fieldValues[$name] = array();
                }
				$fieldValues[$name][$i] = $value;
			}
		}
		$format = array('font'=>'Calibri','font-size'=>12);
		$sheetName = 'Respostas Formulários';

		//header('Content-type: text/csv');
		//header('Content-disposition: attachment;filename=FormSubmissionsExport_Form' . $form_id . "_" . date('Ymd_His') . '.csv');

		//$out = fopen('php://output', 'w');
		// Write the BOM (Byte order mark) to the beginning of the UTF-8 CSV file
		//fputs($out, "\xEF\xBB\xBF");
		$headings = array_keys($fieldValues);

		if (isset($_REQUEST['sort']) && $_REQUEST['sort'] == "true")
			sort($headings);

		$headerStack = array();
		foreach($headings as $head){
			switch($head) {
                case 'id_senha':
                    $headerStack['ID Senha'] = 'integer';
                break;
                case 'submissao':
                    $headerStack['Submissão'] = 'integer';
                    break;
                case 'numero_senha':
                    $headerStack['Número Senha'] = 'integer';
                break;
                case 'id_servico_emissao':
                    $headerStack['ID Serviço Emissão'] = 'integer';
                break;
                case 'nome_servico_emissao':
                    $headerStack['Nome Serviço Emissão'] = 'integer';
                break;
                case 'identificador_servico_emissao':
                    $headerStack['Identificador Servico Emissão'] = 'integer';
                break;
                case 'id_servico_destino':
                    $headerStack['ID Serviço Destino'] = 'integer';
                break;
                case 'nome_servico_destino':
                    $headerStack['Nome Serviço Destino'] = 'integer';
                break;
                case 'identificador_servico_destino':
                    $headerStack['Identificador Servico Destino'] = 'integer';
                break;
                default:
                	$headerStack[$head] = 'integer';
            }			
		}

		$writer = new XLSXWriter();

		
		$writer->writeSheetHeader($sheetName, $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 
			'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15,15]] );

		$format = array('font'=>'Calibri','font-size'=>12);
		$rowStack = array();
		//fputcsv($out, $headings, CSV_EXPORT_SEPARATOR); // Write the CSV Header Row

		for ($i = 0; $i < $numResults; $i++) {
			$line = array();
			foreach ($headings as $name) {

				if (!isset($fieldValues[$name][$i]))
					//$line[] = '';
					array_push($line,'');
				else if (is_array($fieldValues[$name][$i])) {
					//$line[] = join("||", $fieldValues[$name][$i]);
					 array_push($line,join("||", $fieldValues[$name][$i]));
				}
				else {
					//$line[] = $fieldValues[$name][$i];
					 array_push($line,$fieldValues[$name][$i]);
				}
				
			}
			$writer->writeSheetRow($sheetName, $line, $format);			
			//fputcsv($out, $line, CSV_EXPORT_SEPARATOR);
		}
		//fclose($out);
		//exit();

		ini_set('display_errors', 0);
	   // ini_set('log_errors', 1);
	   // error_reporting(E_ALL & ~E_NOTICE);

	    //$filename = "example.xlsx";
	    header('Content-disposition: attachment; filename="'.XLSXWriter::sanitize_filename('FormSubmissionsExport_Form' . $form_id . "_" . date('Ymd_His') .'.xlsx').'"');
	    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
	    header('Content-Transfer-Encoding: binary');
	    header('Cache-Control: must-revalidate');
	    header('Pragma: public');
	    $writer->writeToStdOut();
	    exit(0);
	}

	/*
	 * Função de listagem de Forms
	 *
	 * 0 = Erro da BD
	 * true = Sucesso
	 */

	//!!!! ATTENTION: This method lists the forms and not the form submissions themselves
	function ListarForms() {

		$sql = "SELECT f.id, f.descr, f.path FROM form f ";

		if (array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
			$sql .= "ORDER BY f." . $_REQUEST["campo"] . " ";
		else
			$sql .= "ORDER BY f.descr ";

		if (array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else
			$sql .= "ASC";

		global $ERROS, $N_REGISTOS;
		if (!$rs = $this->bd->executarSQL($sql)) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$forms = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($forms, $row);

		$n = 1;
		$incremento = 1;
		$numRegPag = $N_REGISTOS; // número de registos por página
		$numPaginas = 1; // número de páginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // número total registos
		// caso haja eliminação de registos que diminua o número de páginas
		if (array_key_exists("pagina", $_REQUEST) && ($numTuplos / $numRegPag) <= ( $_REQUEST["pagina"] - 1))
			$_REQUEST["pagina"] -= 1;

		// caso não existam registos
		if ($numTuplos == 0) {
			echo "<div class='empty_msg'>" . translate('word_nao_existem') . " " . translate("word_forms") . " " . translate('word_registados_sistema') . "</div>";
			return;
		}

		// calculo do número de páginas de registos
		if ($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoDiversa.php?accao=exportar_form_submissions' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";

						//#1 - Re-design: store layout of navigation numbers in
						$TEMPLATE_navigation = "<tr>
								<td class='button_page' colspan='6'>";
								if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
								{
										$pagAnterior = $_REQUEST["pagina"] - 1;
										$TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
								}
								else
								{
										$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
										$TEMPLATE_navigation .= "<div> < </div>";
								}

								while($n <= $numPaginas)
								{
										if($n == $_REQUEST["pagina"])
												$TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='current_page'>$n</div></a>";
										else
												$TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='other_page'>$n</div></a>";
										$n++;
								}

								$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
								$incremento = $n;

								if($_REQUEST["pagina"] < $numPaginas)
								{
										$pagPosterior = $_REQUEST["pagina"] + 1;
										$TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
								}
								else
								{
										if($numTuplos % $numRegPag != 0)
												$numRegPag = $numTuplos % $numRegPag;
										$TEMPLATE_navigation .= "<div> > </div>";
								}

								$TEMPLATE_navigation .= "		</td>
								</tr>";

		// Filters row
		echo '<tr>';
		echo '<td colspan="2">';
		echo '<table class="form_table" cellspacing="0" cellpadding="0" style="width: 550px">

								<!-- Filter data -->
								<tr class="form-filter-inline">
									<td class="form-filter-name" style="padding-left: 0;text-align: left;width: 12%;">
											' . translate('word_periodo_relatorio') . ':
									</td>
									<!-- From -->
									<td class="input_space " style="position:relative;width: 6%;">
									<div class="date-filters-inline" >
											<span>' . ucfirst(translate('word_de')) . ':</span>
											<input id="datestart" type="text" name="datestart" maxlength="10" size="11" value="'. (getRequestValue('data') ? getRequestValue('data') : date('Y-m-d')) .'">
											<a href="javascript:var cal1 = new calendar1(document.getElementById(\'datestart\'));
																			cal1.year_scroll = true;
																			cal1.time_comp = false;
																			cal1.popup();">
											<img src="../img/icons_zqueue/definir_datas_20x15.png" width="20" height="15" style="position: absolute; right: -15px;top: 19px !important;" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>

											<span id="msg_datestart" class="error_msg">&nbsp;</span>
											</div>
									</td>
									<td style="width: 1%;padding: 0 14px;"></td>
									<!-- Until -->
									<td class="input_space " style="position:relative;width: 6%;">
										<div class="date-filters-inline">
											<span style="margin-left:30px;">' . translate('word_ate') . ':</span>
											<input id="dateend" type="text" name="dateend" maxlength="10" size="11" value="'. (getRequestValue('data') ? getRequestValue('data') : date('Y-m-d')) .'">
											<a href="javascript:var cal1 = new calendar1(document.getElementById(\'dateend\'));
																			cal1.year_scroll = true;
																			cal1.time_comp = false;
																			cal1.popup();">
											<img src="../img/icons_zqueue/definir_datas_20x15.png" width="20" height="15" style="position: absolute; right: -15px;top: 19px !important;" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>

											<span id="msg_dateend" class="error_msg">&nbsp;</span>
											</div>
									</td>


								</tr>


            <!-- <tr>
                    <td class="question_space" colspan="5">'.
                        translate('word_filters', false).'
                    </td>
                </tr>
                <tr>
                    <td class="input_space right top">'.
                        translate('word_data_start') .':
                    </td>
                    <td class="input_space left top">
                        <input id="datestart" type="text" name="datestart" maxlength="10" size="11" value="'.getRequestValue('data').'">
                        <a href="javascript:var cal1 = new calendar1(document.getElementById(\'datestart\'));
                                        cal1.year_scroll = true;
                                        cal1.time_comp = false;
                                        cal1.popup();">
                        <img src="../img/calendario/cal.gif" width="16" height="16" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>
                                <font class="info_msg">(aaaa-mm-dd)</font>
                        <span id="msg_datestart" class="error_msg">&nbsp;</span>
                    </td>
                    <td class="input_space right top">'.
                        translate('word_data_end') .':
                    </td>
                    <td class="input_space left top">
                        <input id="dateend" type="text" name="dateend" maxlength="10" size="11" value="'.getRequestValue('data').'">
                        <a href="javascript:var cal1 = new calendar1(document.getElementById(\'dateend\'));
                                        cal1.year_scroll = true;
                                        cal1.time_comp = false;
                                        cal1.popup();">
                        <img src="../img/calendario/cal.gif" width="16" height="16" border="0" alt="'.translate('word_click_to_calendar', true).'"></a>
                                <font class="info_msg">(aaaa-mm-dd)</font>
                        <span id="msg_dateend" class="error_msg">&nbsp;</span>
                    </td>
                    <td class="right">
						&nbsp;
                    </td>
                </tr> -->
                <tr>
                </tr>
            </table>';
		echo '</td>';
		echo '</tr>';



		echo "<tr class='column_row'>";

		if ($_SESSION["sessao_perms"]["perm_forms"] > 0) {
			echo "<td width='18' style='padding-left:8px;text-align:left' >" . translate('word_select') . "</td>";
		}

		if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"], "descr") == 0)
			if ($_REQUEST["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div style='text-align:left'>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=1'><div style='text-align:left'>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div style='text-align:left'>" . translate('word_name', true) . "</div></a></td>";

		echo "</tr>";

		//while ($n < ($numRegPag + $incremento)) {
		//	$this->bd->moverRegisto($rs, $n);
		for ($i=$n; $i<$numRegPag + $incremento; $i++)
        {
			$legacy = false;// $forms[$i]["path"] /*$this->bd->obterValor($rs, "path")*/ != "";

			echo"<tr class='form-data-tr'>";
			/*if ($_SESSION["sessao_perms"]["perm_forms"] > 0 && !$legacy) {
				// Only show the edit checkbox if we have permission to edit it and it is not one of the legacy file-based forms
				//echo "<td><input name='form' type='radio' value='" . $this->bd->obterValor($rs, "id") . "'/> </td>";
			*/	echo "
				<td class='form-data-td' style='height: 35px;'>
					<label class='custom-radio-container' style='margin-bottom:0;width: 140px;'>
						<input  type='radio' name='form'
										value='" . $forms[$i]["id"] /* $this->bd->obterValor($rs, "id")*/ . "' onchange='activateRadioRow(this)'>
						<span class='radio-checkmark'></span>
					</label>
				</td>";

			/*}
			else if ($legacy) {
				echo "<td class='form-data-td'>&nbsp;</td>";
			}*/

			if (!$legacy) {
				echo "<td class='form-data-td' style='text-align:left'>" . $forms[$i]["descr"] /*$this->bd->obterValor($rs, "descr")*/ . "</td>";
			}
			else {
				echo "<td class='form-data-td' style='text-align:left'>" . $forms[$i]["descr"] /*$this->bd->obterValor($rs, "descr")*/ . " (" . translate('word_form_not_exportable', true) . ")</td>";
			}

			echo "</tr>";

			$n++;
		}

		//#3 - Re-design present NAVIGATION after table
		echo $TEMPLATE_navigation;

		echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div><span id='msg_form' class='error_msg'>&nbsp;</span></div>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
		echo "<tr>
					<td>
					<table>
						<tr>
							<td class='button'>
								<div class='button-thin-green' onClick='validaFormFormSubmission()'>" . translate('word_exportar_xlsx', true) . "</div>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
		echo "</table>";



		echo "</form>";
	}

	/*
	  Destrutor da classe

	  0 = Erro da BD
	 */

	function Fechar() {
		$this->bd->fecharBD();
	}

	//----------------------------//
	//   Forms Model Methods   //
	//----------------------------//

	function getId() {
		return $this->id;
	}

	function get($id) {


		// TODO write this method


		$sql = "SELECT form_submission.id submission_id, ";
		$sql.= "form_submission.id_form form_id, ";
        $sql.= "form_submission.id_senha senha_id, ";
		$sql.= "form_submission.data submission_data, ";
		$sql.= "form_submission.created submission_created, ";
		$sql.= "form_submission.modified submission_modified ";
		$sql.= "FROM form_submission ";
		$sql.= "WHERE form_submission.id = "; // Add the id of the form here
		$rows = $this->bd->getRows($sql . $id);
		// Map the SQL result to the actual Form Class
		$this->mapDatabaseToObject($rows);
	}

	/**
	 * Lists forms according to a $where clause and returns only Form's $fields fields.
	 *
	 * @param string $where   Optional. Where clause in the form of "id = 5 AND descr = 'some name'"
	 * @param array  $fields  Optional. An array of which Form fields to return.
	 */
	function listFormSubmissions($where = "", $fields = array('id')) {
		if (is_array($fields) == false)
			return null;

		$sql = "SELECT " . implode(", ", $fields);
		$sql.= " FROM form_submission ";
		if (empty($where) == false) {
			$sql.= "WHERE $where ";
		}
		return $this->bd->getRows($sql);
	}

	function save($validate = true) {
		$success = true;

		if ($this->id > 0) {
			// We're editing an existing Form Data Submission
			$sql = "UPDATE form_submission SET ";
			$sql.= "data = '" . $this->data . "', ";
			$sql.= "modified = NOW() ";
			$sql.= "WHERE id = " . $this->id . ";";
			if ($this->bd->executarSQL($sql) == false) {
				$success = false;
			}
		} else {
			$sql = "INSERT INTO form_submission(id, id_form, id_senha, data, created, modified) VALUES(0, ";
			$sql.= "'" . $this->id_form . "', ";
            $sql.= "'" . $this->id_senha . "', ";
			$sql.= "'" . $this->data . "',";
			$sql.= "NOW(), NOW());";
			if ($this->bd->executarSQL($sql) == false) {
				$success = false;
			} else {
				$autoIncrementId = $this->bd->obterUltimoInsertId();
				$this->id = $autoIncrementId;
			}
		}

		if ($success) {
			return "ok";
		} else {
			return false;
		}
	}

	/**
	 * This function maps the database query result rows into
	 * the Domain Model represented by this class and its associations.
	 *
	 * Each row is expected to be something like the following
	 *     [0] => Array
	 *         (
	 *             [submission_id] => 22
	 *             [form_id] => 1
     *             [senha_id] => 5678
	 *             [submission_data] => "<JSON Encoded Form Submission Data>"
	 *             [submission_created] => "<some date time>"
	 *             [submission_modified] => "<some date time>"
	 *         )
	 *
	 */
	private function mapDatabaseToObject($rows, $submissionTarget = null) {

		if ($submissionTarget == null) {
			$submissionTarget = $this;
		}

		if (empty($rows)) {
			return false;
		}

		foreach ($rows as $row) {
			$submissionTarget->id = $row['submission_id'];
			$submissionTarget->id_form = $row['form_id'];
            $submissionTarget->id_senha = $row['senha_id'];
			$submissionTarget->data = $row['submission_data'];
			$submissionTarget->created = $row['submission_created'];
			$submissionTarget->modified = $row['submission_modified'];
		}
	}
}
?>
