<?php 

/**
 *  Classe de Gestão de Horários
 *  Corresponde à tabela 'horario' da base de dados.
 */
class Form extends AcessoBD {

    var $bd;

    var $id;
	var $descr;
    var $path;
	var $data;

    /*
      Construtor da classe

      0 = Erro da BD
     */
    function Form() {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
      Função de inserção

      0 = Erro da BD
      5 = Erro Existente
      true = Sucesso
     */

    function Inserir($dados) {
        $form = new Form();

		$form->descr = $dados["descr"];
        $form->path = null;
		$form->data = addslashes($dados["form_data"]);

        $form->save();
        return "ok";
    }

    /**
     * Função de Edição
     *
     * @param array   $dados   Um array com todos os dados de um Formulário
     * @param integer $id      O id do Formulário a editar
     * @return mixed           0 = Erro da BD
     *                         5 = Erro Existente
     *                         true = Sucesso
     */
    function Editar($dados, $id) {

        $form = new Form();
        $form->get($id);

		if (!$form->id) {
			echo "form nok<br />";
			return "nok";
		}

		$form->descr = $dados["descr"];
        $form->path = null;
		$form->data = addslashes($dados["form_data"]);

		$form->save();

		return "ok";
    }

    function GetForms($id="") {
        $this->get($id);
        return $this;
    }

    /*
      Fun��o de leitura de dados

      0 = Erro da BD
      true = Sucesso
     */

    function LerDados($id) {
        $this->get($id);
        $_SESSION["sessao_campos"]['form'] = $this;
        return "ok";
    }

    /**
     * Função de Remoção.
     *
     * @param  mixed $id    Um único id ou um array de ids
     * @return mixed
     */
    function Remover($id) {

		$success = true;
        if ($this->bd->executarSQL("START TRANSACTION;") == false) {
            return false;
        }

        // get the form names that will be deleted so we can log them at the end
        $numEntradas = count($id);
        $descrs = array();
        $sql = "SELECT descr FROM form WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id = " . $id[$i] . " OR ";
        $sql .= "id = " . $id[0] . ";";

        if ($rs = $this->bd->executarSQL($sql)) {
            for ($i = 0; $i < $numEntradas; $i++) {
                $this->bd->moverRegisto($rs, $i);
                array_push($descrs, $this->bd->obterValor($rs, "descr"));
            }
        } else {
            $this->bd->executarSQL("ROLLBACK;");
            return 0;
        }

        $sql = "DELETE FROM form ";
        $sql.= "WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id = " . $id[$i] . " OR ";
        $sql .= "id = " . $id[0] . ";";

        if ($this->bd->executarSQL($sql) == false) {
            $success = false;
        }

        if (!$success) {
            // Failure
            $this->bd->executarSQL("ROLLBACK;");
            return false;
        }

        if ($this->bd->executarSQL("COMMIT;") == false) {
            return false;
        }
        $objecto = new LogAccao();
        for ($i = count($descrs) - 1; $i >= 0; $i--) {
            $rs = $objecto->Inserir("Remoção", "Forms", $descrs[$i]);
        }
        $objecto->fechar();
        return "ok";

    }

    /*
     * Função de listagem
     *
     * 0 = Erro da BD
     * true = Sucesso
     */

    function Listar() {

        $sql = "SELECT f.id, f.descr, f.path FROM form f ";

        if (array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY f." . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY f.descr ";

        if (array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";


        global $ERROS, $N_REGISTOS;
        if (!$rs = $this->bd->executarSQL($sql)) {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $forms = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($forms, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
        $numRegPag = $N_REGISTOS; // número de registos por página
        $numPaginas = 1; // número de páginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // número total registos
        // caso haja eliminação de registos que diminua o número de páginas
        if (array_key_exists("pagina", $_REQUEST) && intVal($_REQUEST["pagina"]) > 0 && ($numTuplos / $numRegPag) <= ( $_REQUEST["pagina"] - 1))
            $_REQUEST["pagina"] -= 1;

        // caso não existam registos
        if ($numTuplos == 0) {
            echo "<div class='empty_msg'>" . translate('word_nao_existem') . " " . translate("word_forms") . " " . translate('word_registados_sistema') . "</div>";
            return;
        }

        // calculo do número de páginas de registos
        if ($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=forms&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "campo") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "") . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";

            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
								<td class='button_page' colspan='6'>";

                if($pagina > 1)
                {
                    $pagAnterior = $pagina - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $pagina = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $pagina)
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($pagina - 1)*$numRegPag;
                $incremento = $n;

                if($pagina < $numPaginas)
                {
                    $pagPosterior = $pagina + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
				</tr>";

        echo "<tr class='column_row'>";

        if ($_SESSION["sessao_perms"]["perm_forms"] == 2) {
            echo "<td width='18' style='padding-left:8px'>&nbsp;</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"], "descr") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=1'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=descr&ordem=0'><div>" . translate('word_name', true) . "</div></a></td>";

        echo "<td width='135'>" . translate('word_operations', true) . "</td>
				</tr>";

        //while ($n < ($numRegPag + $incremento)) {
         //   $this->bd->moverRegisto($rs, $n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {
			$legacy = false;//$forms[$i]["path"] /*$this->bd->obterValor($rs, "path")*/ != "";

            echo"<tr class='form-data-tr'>";
            if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && !$legacy ) {
				          // Only show the edit checkbox if we have permission to edit it and it is not one of the legacy file-based forms
                //echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs, "id") . "'/> </td>";
                echo "<td class='form-data-td'>
                        <label class='custom-check-container'>
                            <input name='grupo' type='checkbox' value='" . $forms[$i]["id"]  /*$this->bd->obterValor($rs, "id")*/ . "' onClick='selectEntireRow(this)'>
                            <span class='custom-checkmark'></span>
                        </label>
                    </td>";
            }
			else if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && $legacy) {
				echo "<td class='form-data-td'>&nbsp;</td>";
			}

			if ($legacy) {
				echo "<td class='form-data-td'>" . $forms[$i]["descr"] /*$this->bd->obterValor($rs, "descr")*/ . " (" . translate('word_form_not_editable', true) .")</td>";
			}
			else {
				echo "<td class='form-data-td'>" . $forms[$i]["descr"] /*$this->bd->obterValor($rs, "descr")*/ . "</td>";
			}

			echo "<td class='form-data-td'>";
            if ($_SESSION["sessao_perms"]["perm_forms"] == 2 && !$legacy) {
                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=forms&id=" . $forms[$i]["id"] /*$this->bd->obterValor($rs, "id")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_edit', true) . "</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=forms&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "&id=" . $forms[$i]["id"] /*$this->bd->obterValor($rs, "id")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>" . translate('word_remove', true) . "</div></a>";
            } else {
                echo "&nbsp;";
            }
            echo "</td>";
			echo "</tr>";

            //$n++;
        }

        //#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        if ($_SESSION["sessao_perms"]["perm_forms"] == 2) {
            echo "<tr>
					<td>
					<table>
						<tr>
							<td class='button'>";
                if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_entidade"] == 2) {
                  echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
                }
								echo "
                  <div class='button-thin-green' onClick='seleccionaCaixa(true)'>" . translate('word_mark_all', true) . "</div>
  								<div class='button-thin-green' onClick='seleccionaCaixa(false)'>" . translate('word_unmark_all', true) . "</div>
  								<div class='button-thin-green' onClick='removerMarcados(this);'>" . translate('word_remove', true) . "</div>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
        }

        echo "</table>
		</form>";
    }

    /*
      Destrutor da classe

      0 = Erro da BD
     */

    function Fechar() {
        $this->bd->fecharBD();
    }

    //----------------------------//
    //   Forms Model Methods   //
    //----------------------------//

    function getId() {
        return $this->id;
    }

    function get($id) {

        $sql = "SELECT form.id form_id, ";
		$sql.= "form.descr form_descr, ";
        $sql.= "form.path form_path, ";
		$sql.= "form.data form_data ";
        $sql.= "FROM form ";
        $sql.= "WHERE form.id = "; // Add the id of the form here
        $rows = $this->bd->getRows($sql . $id);
        // Map the SQL result to the actual Form Class
        $this->mapDatabaseToObject($rows);
    }

    /**
     * Lists forms according to a $where clause and returns only Form's $fields fields.
     *
     * @param string $where   Optional. Where clause in the form of "id = 5 AND descr = 'some name'"
     * @param array  $fields  Optional. An array of which Form fields to return.
     */
    function listForms($where = "", $fields = array('id')) {
        if (is_array($fields) == false)
            return null;

        $sql = "SELECT " . implode(", ", $fields);
        $sql.= " FROM form ";
        if (empty($where) == false) {
            $sql.= "WHERE $where ";
        }
        return $this->bd->getRows($sql);
    }

    function save($validate = true) {
        $success = true;

        if ($this->id > 0) {
            // We're editing an existing Form
            $sql = "UPDATE form SET ";
			$sql.= "descr = '" . $this->descr. "', ";
			$sql.= "data = '" . $this->data. "' ";
            $sql.= "WHERE id = " . $this->id . ";";
            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            }
        } else {
            $sql = "INSERT INTO form(id, descr, data) VALUES(0, ";
			$sql.= "'" . $this->descr . "',";
			$sql.= "'" . $this->data . "');";
            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            } else {
                $autoIncrementId = $this->bd->obterUltimoInsertId();
                $this->id = $autoIncrementId;
            }
        }

        if ($success) {
            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Form", $this->descr);
            $objecto->fechar();
            return "ok";
        } else {
            return false;
        }
    }


    /**
     * This function maps the database query result rows into
     * the Domain Model represented by this class and its associations.
	 * Currently, this is only used for
     *
     * Each row is expected to be something like the following
     *     [0] => Array
     *         (
     *             [form_id] => 1
     *             [form_descr] => "<some description of the form fields>"
     *             [form_path] => "<the file path of the form (for legacy forms)>"
	 *             [form_data] => "<the JSON encoded form data object>"
     *         )
     *
     */
    private function mapDatabaseToObject($rows, $formTarget = null) {

        if ($formTarget == null) {
            $formTarget = $this;
        }

        if (empty($rows)) {
            return false;
        }

		foreach ($rows as $row) {

			$formTarget->id = $row['form_id'];
			$formTarget->descr = $row['form_descr'];
            $formTarget->path = $row['form_path'];
			$formTarget->data = $row['form_data'];
		}

    }

}

?>
