<?php  
	// session is started in the lang.inc.php file that is included by the config.inc.php file below
	//session_start();

	require_once("../config.inc.php");

	if($_SESSION["sessao_autenticado"] == 0) {
		header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);
        return;
    }

	include(dirname(__FILE__)."/form_builder/formbuilder.php");

    $id_form = $_GET['id'];
    $id_senha = $_GET['id_senha'];

    // Load the dynamically built form that was requested
    $form = new Form();
    $form->get($id_form);
    if (!$form->id) {
        $header = "Location: http://" . $_SERVER['HTTP_HOST'] . $DIR . "qterminal/?servico=" . $_SESSION["servico_activo"];
        return;
    }
    $form_data = $form->data;

    // Transform the Form structure description from JSON to a PHP array
    $formArr = json_decode($form_data, true);
    $hiddenFields = array('id_form' => $id_form, 'id_senha' => $id_senha);

?>

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title><?php   echo "Zqueue - " . translate('word_form', true) . ": " . $form->descr; ?></title>
        <link rel="stylesheet" type="text/css" media="screen" href="../css/formbuilder.css">
        <link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">
    </head>
    <body class="form_submission">

        <table class="full_area" cellpadding="0" cellspacing="0" >
          <tr>
          <td>&nbsp;</td>
            <td class="atendimento">
                <table width="100%">
                    <tr>
                            <td class="current_user">
                            <div class="current_user_name">
                            <?
                                if($_SESSION["sessao_autenticado"] == 0)
                                    echo "".translate('word_bem_vindo', true) ."";
                                else
                                    echo "<a href=\"../sair.php\"><img alt=\"Sair\" class=\"middle\" onClick =\"javascript:flag=true; submitAction('terminar');\" src=\"../img/buttons/button_log_out.gif\"></a>&nbsp;" .
                                    "<img class=\"middle\" src=\"../img/buttons/button_user.gif\"></a>"
                                        . " <strong>" . $_SESSION["sessao_nome"] . " @ " . $_SESSION["sessao_nome_balcao"] . "</strong>";
                            ?>
                            </div>
                            <div class="current_user_date_time"><?php  echo devolveDataHora(); ?></div>
                        </td>
                    </tr>
                </table>
                <table class="bg_title_center" cellspacing="0" cellpadding="0">
                    <tr>
                        <td class="bg_title_left">
                        </td>
                        <td class="module_space">
                                <?php   echo $form->descr;  ?>
                        </td>
                        <td class="function_space">
                        </td>
                        <td class="bg_title_right">
                        </td>
                    </tr>
                </table>
                <?php  
                    $formBuilder = new Formbuilder();
                    $formBuilder->render(
                            $formArr,
                            $form->descr,
                            $hiddenFields,
                            array('action' => '../accoes_intermedias/accaoTratarFormSubmission.php', 'method' => 'post'),
                            translate('word_submeter', true));
                ?>
            </td>
          </tr>
        </table>
    </body>
</html>
