<?php 

	// Used to be able to have direct access to the Code Igniter Form Helper
	define('BASEPATH','SOMETHING');
	// Include the Code Igniter Form Helper to create the form elements
	include(dirname(__FILE__) . "/lib/form_helper.php");

	class Formbuilder
	{

		function render($data, $title = "Form", $hiddenFields = null, $attributes = null, $submitValue = null) {
			$items = $this->build($data);
			if ($items) {
				include(dirname(__FILE__) . "/render.php");
			}
		}

		/**
		 * Builds an array that contains all the elements of the form.
		 * The elements themselves are comprised of an array that
		 * describes the settings (like name, etc) and a key
		 * that defines the actual html representation of the element
		 *
		 * @param string $data    The data array that describes a form template
		 * @return array          The array that describes a rendered form
		 */
		function build($data)
		{

			if (!isset($data) || empty($data)) {
				return null;
			}

			// Sort the form elements by their defined order of appearance
			usort($data, array($this, 'cmp_order'));

			foreach ($data as $k => $val)
			{

				if (!isset($data[$k])) $data[$k] = NULL;
				if (!isset($val['options'])) $val['options'] = NULL;

				$elements[$k]/*['content']*/ = $data[$k];

				$name = $val['name'];

				switch ($val['type'])
				{
					//case 'statictext': $elements[$k]['html'] = $data[$k]; break;
					case 'textarea':
						$elements[$k]['html'] = form_textarea(array(
							'name' => $name,
							'rows' => 5,
							'cols' => 40,
							'value' => $data[$k]['value'],
							'class' => ((isset($val['required']))?'required'.((isset($val['required_vars']))?'{'.$val['required_vars'].'}':null):null),
							($val['required']=='true' ?'required': '' ) => ''
						));
						break;
					case 'text':
						$elements[$k]['html'] = form_input(array(
							'name'=>$name,
							'value'=>$data[$k]['value'],
							'class' => ((isset($val['required']))?'required'.((isset($val['required_vars']))?'{'.$val['required_vars'].'}':null):null),
							($val['required']=='true' ?'required': '' ) => ''
						));
						break;
					case 'select':
						if (!$val['options']) { unset($elements[$k]); break; }
						$options = explode("\n",$val['options']);
						if (empty($options)) { unset($elements[$k]); break; }
						$options = array_combine($options, $options); // create an array with both key and value as the value

						$values = array(); // a select box should have only one selected value, but you never know...
						if ($val['value']) { $values = explode("\n", $val['value']); }
	
						$elements[$k]['html'] = form_dropdown($name,$options, $values,'', ($val['required']=='true'));
						break;
					case 'checkbox':
						$input = null;

						if (!$val['options']) { unset($elements[$k]); break; }
						$options = explode("\n",$val['options']);
						if (empty($options)) { unset($elements[$k]); break; }

						$values = array();
						if ($val['value']) { $values = array_flip(explode("\n", $val['value'])); }					

						foreach ($options as $option) {
							$input .= form_checkbox($name.'[]', $option, isset($values[$option]), '', ($val['required']=='true')).' '.$option.'<br/>';
						}
						//if($val['required'])
						//	$values['required'] = 'required';
						$elements[$k]['html'] = $input;
						break;
					case 'radio':
						$input = null;

						if (!$val['options']) { unset($elements[$k]); break; }						
						$options = explode("\n",$val['options']);
						if (empty($options)) { unset($elements[$k]); break; }

						$values = array();
						if ($val['value']) { $values = array_flip(explode("\n", $val['value'])); }

						foreach ($options as $option) {
							$input .= form_radio($name.'[]', $option, isset($values[$option]), '', ($val['required']=='true')).' '.$option.'<br/>';
						}
						$elements[$k]['html'] = $input;
						break;
//					case 'datetime':
//						$elements[$k]['html'] = form_input(array(
//							'name'=>$name,
//							'value'=>$data[$k],
//							'class' => 'datepicker '.((isset($val['required']))?'required'.((isset($val['required_vars']))?'{'.$val['required_vars'].'}':null):null)
//						));
//						break;
//					case 'fileupload':
//						$elements[$k]['html'] = form_upload(array(
//							'name'=>$name,
//							'class' => ((isset($val['required']))?'required'.((isset($val['required_vars']))?'{'.$val['required_vars'].'}':null):null)
//						));
//						break;
//					case 'button':
//						$elements[$k]['html'] = form_input(array(
//							'name'=>$name,
//							'value'=>((isset($val['value']))?$val['value']:'Button'),
//							'type'=>'button'
//						));
//						break;
				}
			}

			return $elements;
		}

		/*
		Element is generated and spat onscreen
		*/
		function element($attr)
		{
			$id = 'element_'.uniqid();
			switch($attr['type'])
			{
//				case 'statictext':
//					$element = form_textarea(array(
//						'class' => 'wysiwyg',
//						'id' => $id,
//						'name' => $id,
//						'rows' => 5,
//						'cols' => 40
//					));
//					break;
				case 'textarea':
					$element = form_textarea(array(
						'name' => $id,
						'rows' => 5,
						'cols' => 40
					));
					break;
				case 'text': $element = form_input($id); break;
				case 'select': $element = form_dropdown($id,array(''=>'No Content')); break;
				case 'checkbox': $element = '<span class="values '.$id.'"><input type="checkbox"></span>'; break;
				case 'radio': $element = '<span class="values '.$id.'"><input type="radio"></span>'; break;
//				case 'datetime': $element = form_input(array('name'=>$id,'class'=>'datepicker')); break;
//				case 'fileupload': $element = form_upload($id); break;
//				case 'button': $element = form_input(array('name'=>$id,'value'=>'No Content','type'=>'button')); break;
				default: $element = null; break;
			}

			//give the text box a differnt label
			$label = ($attr['type'] == 'text') ? 'Static Text' : 'No Label';

			//basic output list element.
			$output = "
				<li>
				<label for='".$id."'><a href='#' rel='".$attr['type']."' class='properties tooltip' title='Edit'>".$label."</a></label>
					<div class='block'>
						<div class='handle'><span class='icon move'>Move</span></div>
						".$element."
						<span class='note ".$id."'></span>
					</div>
					<div class='clear'></div>
					<div class='attrs clear ".$id."'>
						<input type='hidden' name='properties[".$id."][type]' value='".$attr['type']."'/>
					</div>
				</li>
			";

			if ($element) {
				//set output to AJAX
				echo $output;
			}
		}

		/**
		 * Array order comparator for the usort() method
		 *
		 * @param int $a
		 * @param int $b
		 * @return array
		 */
		protected function cmp_order($a, $b) {
			if (!isset($a['order'])) $a['order'] = 99999;
			if (!isset($b['order'])) $b['order'] = 99999;
			return $a['order'] - $b['order'];
		}
	}
