/**
 * Contactline Form Builder
 *
 * The contactline Form Builder allows the dynamic creation and editing of HTML Forms.
 * It is heavily based on Admin.FormBuilder by Sonuku. His version was very depending
 * on server side code to generate the form elements. This version creates the whole form
 * in JavaScript (jQuery) and only uses server-side code to generate the form preview
 * and final layout for filling out the form.
 *
 * Author: Tiago Alves (Zqueue - Queue Management System)
 * Original Author: Sonuku
 * Original Blog Post: http://blog.sonuku.com/2009/04/11/php-formbuilder/
 * Original Demo: http://dontlink.me/formbuilder/
 *
 */

var Contactline = {};

Contactline.formbuilder =
{

    PREVIEWURL: 'preview.php',

    initialize: function()
    {

        this.layout('body');

        this.elementProps = {};
        this.curElementName = "";

        var that = this;
        // Register the Event Handler that will update the properties
        // of the element that is currently being edited
        $('#form_builder_properties').find('.property_field').each( function(index) {
            $(this).change(function(e) {
                var curElementProps = that.elementProps[that.curElementName];
                curElementProps[$(this).attr('name')] = $(this).val();
                // the arguments are something like #element_2349875, {type, ...}, label
                that.updateElementField(that.curElementName, curElementProps, $(this).attr('name'));
                that.save();

            });
        });

        $('#form_builder_preview_button').click(function(){
            that.preview();
        });
    },


    layout: function(e)
    {
        var that = this;
        var $active_layout = $(e);

        $active_layout.find('form[id=""]').each(function(){
            $(this).attr('id','f'+randomString(50)); //an ID for every form.
        });

        $active_layout.find('.tooltip').tooltip({track: true, delay: 0, showURL: false, fade: 0, showBody: " - "});

        $active_layout.find("#form_builder_toolbox li").click(function(){

            Contactline.formbuilder.add($(this).attr('id'));
        });

        $active_layout.find("#form_builder_panel ol").sortable({
            cursor: 'ns-resize',
            axis: 'y',
            handle: '.handle',
            update: that.reorder,
            start: that.onDragStart
        });

        $active_layout.find('div.dialog').each(function(){

            $.metadata.setType("class");
            var w = $(this).metadata().w;
            var h = $(this).metadata().h;

            $(this).dialog({
                modal: true,
                zIndex: 400000, /* TinyMCE grief. Their default is literally 300000... Fail*/
                autoOpen: false,
                shadow: false,
                width: (w?parseInt(w, 10):400),
                height: (h?parseInt(h, 10):'auto'),
                title: $(this).attr('title'),
                dragStart: function(event, ui) {
                    $(this).find('iframe').hide();
                },
                dragStop: function(event, ui) {
                    $(this).find('iframe').show();
                },
                resizeStart: function(event, ui) {
                    $(this).find('iframe').hide();
                },
                resizeStop: function(event, ui) {
                    $(this).find('iframe').show();
                },
                stack: true
            });
        });

        $active_layout.find('#remove_button').click(function() {
            that.remove($(this));
        });

        $active_layout = null; //destroy
    },

    add: function(type, name, props)
    {
        var that = this;

        var newElementName = name || "element_" + randomString(10);
        // Clone an element group and give the <li> grouper an id
        // such as #element_2349875
        var newElement = $('#template_'+type).clone().appendTo('.sml ol').hide().slideDown('slow');
        newElement.attr('id', newElementName);
        newElement.addClass('element_container').removeClass('template');

        // Rename the element's property fields such as the label to something like
        // #element_2349875_label (for the 'label' field)
        newElement.find('#template_'+type+'_label').attr('id', newElementName + '_label');
        newElement.find('#template_'+type+'_description').attr('id', newElementName + '_description');
        var field = newElement.find('#template_'+type+'_field');
        if (field.length) {
            field.attr('id', newElementName + '_field');
            // Register the field change event handler so that we can
            // keep our #form_data store updated
            field.change(function(e) {
                that.valueChanged(e, newElementName, $(this), $(this).val());
            });
        }

        // The event handler when a field's is clicked to be edited
        newElement.find('a.properties:first').click(function(e) {
            that.edit(e, $(this));
            return false;
        });

        // Translation: Edit
        newElement.find('.tooltip').attr('title', 'Editar').tooltip({track: true, delay: 0, showURL: true, fade: 0, showBody: " - "});

        this.elementProps[newElementName] = $.extend(
            {},
            {
                type: type,
                name: newElementName,
                label: 'Sem Nome',      // Translation: No Label
                options: '',
                value: '',
                description: '',
                order: 99999,
                required: false
            },
            props);

        // Update the form elements to show the defined property values
        this.updateElement(newElementName, this.elementProps[newElementName]);

        this.reorder();

        // Serialize our result
        this.save();

    },

    // formData is a string containing a serialized JSON object
    // describing a full form with all of its fields and properties
    load: function(formData) {
        var props = JSON.parse(formData);
        var that = this;

        var sortedPropNames = this.getOrderedElementNames(props);
        $.each(sortedPropNames, function(index, element) {
            that.add(props[element]['type'], element, props[element]);
        });
    },
    // Order the element properties object according to each elements order value
    // Returns an array with the form element names ordered by ascending order value
    getOrderedElementNames: function (props) {
        var tmp = [];
        for (var key in props) {
            tmp.push(key);
        }
        tmp.sort(function () {
            // Sort by order and consider order to be 99999 if it isn't defined
            if (props[arguments[0]]['order'] == undefined) props[arguments[0]]['order'] = 99999;
            if (props[arguments[1]]['order'] == undefined) props[arguments[1]]['order'] = 99999;
            return props[arguments[0]]['order'] > props[arguments[1]]['order'];
        });
        return tmp;
    },

    updateElement: function(name, properties) {
        var that = this;
        // Force the 'options' property to be the 1st since
        // the 'value' property depends on it
        that.updateElementField(name, properties, 'options');
        $.each(properties, function (index) {
            if (index == 'options') return;
            that.updateElementField(name, properties, index);
        });
    },

    updateElementField: function(name, properties, property) {
        var value = properties[property];
        switch (property) {
            case 'options':
                this.updateElementOptions(name, properties);
                break;
            case 'value':
                switch (properties['type']) {
                    case 'checkbox':

                    case 'radio':
                        $.each(value.split("\n"), function(index, value){

                            var elem = $('#' + name).find('input[name='+name+'][value='+value+']');
                            if (value && elem)
                                elem.attr('checked', true);
                        });
                        break;
                    /*case 'radio':
                        if (value != '')
                            $('#' + name).find('input[name='+name+'][value='+value+']').attr('checked', true);
                        break;
                        */
                    default:
                        $('#' + name + "_field").val(value);
                        break;
                }
                break;
            default:
                $('#' + name + "_" + property).text(value);
                break;
        }
    },

    updateElementOptions: function(name, properties) {
        var that = this;
        var type = properties.type;
        var newElement = null;
        var options = [];
        var element = $('#' + name);
        var optionsContainer = null;
        var enabledOptions = null;
        var inputName = null;
        var checked = "";

        if (properties.options != undefined) {
            options =  properties.options.split("\n");
        }

        switch (type) {
            case 'select':
                optionsContainer = element.find('select');
                enabledOptions = optionsContainer.find('option:selected').map(function() {
                    return $(this).val();
                });

                optionsContainer.empty();
                $.each(options, function (index, value) {
                    inputName = name+'_'+index;
                    checked = ($.inArray(value, enabledOptions) > -1) ? "selected" : "";
                    optionsContainer.append($('<option value="'+value+'" '+checked+'>'+value+'</option>'));
                });

                //Call initialize of dropdown
                clearSingleDropdown(name + "_field");
                initializeDropdown(name + "_field");
                break;
            case 'checkbox': //#redesign - removed because layout
              let allOptions = [];
              // Store the selected options before removing all elements
              optionsContainer = element.find('.values:first');

              enabledOptions = element.find('input:checked').map(function() {
                  return $(this).val();
              });
              element.find('.value-line').remove();
              newElement = ''; //reset for redesign (we will use as string here)
              $.each(options, function (index, value) {
                  inputName = name+'_'+index;
                  // If a value was selected/checked before, restore it checked again
                  checked = (value != "" && $.inArray(value, enabledOptions) > -1) ? "checked" : "";
                  //newElement = $('<div class="value-line"><input id="'+inputName+'" type="'+type+'" name="'+name+'" value="'+value+'" '+checked+' /><label class="input-label" for="'+inputName+'">'+value+'</label></div>')
                  let templateRow = `
                    <tr class="value-line form-data-tr ${ (checked === 'checked' ? 'form-tr-selected' : '') }">
                      <td class="form-data-td">
                        <label class='custom-check-container'>
                            <input   id='${inputName}' type='checkbox'
                                    name='${name}' value='${value} ${checked}'
                                    onClick='selectCustomCheck(this)'>
                            <span class='custom-checkmark'></span>
                        </label>
                      </td>
                      <td class="form-data-td">${value}</td>
                    </tr>`;
                  //newElement = $(templateRow);
                  newElement += templateRow;

                  allOptions.push($(templateRow));
                  //optionsContainer.append(newElement);
              });

              let tableTemplate = $(`
                <div class="form-builder-check-container">
                  <table cellspacing="0" cellpadding="0">
                    ${newElement}
                  </table>
                </div>`);

              optionsContainer.append(tableTemplate)
              $.each(allOptions, function (index, value) {
                value.find('input:first').click(function(e){
                    that.valueChanged(e, name, $(this), $(this).val());
                })
              });


              //Re position edition properties
              this.updateVisualInEdition();

              break;
            case 'radio':
                let allRadioOptions = [];
                // Store the selected options before removing all elements
                optionsContainer = element.find('.values:first');
                enabledOptions = element.find('input:checked').map(function() {
                    return $(this).val();
                });
                element.find('.value-line').remove();
                newElement = ''; //reset for redesign (we will use as string here)
                $.each(options, function (index, value) {
                    inputName = name+'_'+index;
                    // If a value was selected/checked before, restore it checked again
                    checked = (value != "" && $.inArray(value, enabledOptions) > -1) ? "checked" : "";
                    //newElement = $('<div class="value-line"><input id="'+inputName+'" type="'+type+'" name="'+name+'" value="'+value+'" '+checked+' /><label class="input-label" for="'+inputName+'">'+value+'</label></div>')

                    let templateRow = `
                      <tr class="value-line">
                        <td>
                          <label class='custom-radio-container ${ (checked === 'checked' ? 'custom-radio-selected' : '') }'>
                              <div>${value}</div>
                              <input   id='${inputName}' type='radio'
                                      name='${name}' value='${value} ${checked}'
                                      onClick='activateRadio(this)'>
                              <span class='radio-checkmark'></span>
                          </label>
                        </td>
                      </tr>`;
                    //newElement = $(templateRow);
                    newElement += templateRow;

                    allRadioOptions.push($(templateRow));
                    //optionsContainer.append(newElement);


                });

                let tableRadioTemplate = $(`
                  <div class="form-builder-radio-container">
                    <table cellspacing="0" cellpadding="0">
                      ${newElement}
                    </table>
                  </div>`);

                optionsContainer.append(tableRadioTemplate)
                $.each(allRadioOptions, function (index, value) {
                  value.find('input:first').click(function(e){
                      that.valueChanged(e, name, $(this), $(this).val());
                  })
                });


                //Re position edition properties
                this.updateVisualInEdition();

                break;
            case 'radio_backup':
                // Store the selected options before removing all elements
                optionsContainer = element.find('.values:first');
                enabledOptions = element.find('input:checked').map(function() {
                    return $(this).val();
                });
                element.find('.value-line').remove();
                $.each(options, function (index, value) {
                    inputName = name+'_'+index;
                    // If a value was selected/checked before, restore it checked again
                    checked = (value != "" && $.inArray(value, enabledOptions) > -1) ? "checked" : "";
                    newElement = $('<div class="value-line"><input id="'+inputName+'" type="'+type+'" name="'+name+'" value="'+value+'" '+checked+' /><label class="input-label" for="'+inputName+'">'+value+'</label></div>')
                    optionsContainer.append(newElement);
                    newElement.find('input:first').click(function(e){
                        that.valueChanged(e, name, $(this), $(this).val());
                    })
                });

                //Re position edition properties
                this.updateVisualInEdition();

                break;
            default:
                // don't do anything
                break;
        }
    },

    edit: function (event, target) {
        var that = this;

        $('#form_builder_panel li.on').removeClass('on');
	       target.parents('li:first').addClass('on');

        this.curElementName = target.parents('.element_container:first').attr('id');
        // Update the properties' fields' values to reflect the row that needs to be edited
        $('#form_builder_properties').find('.property_field').each( function(index) {
            $(this).val(that.elementProps[that.curElementName][$(this).attr('name')]);
        });
        if ($.inArray(this.elementProps[this.curElementName]['type'], ['checkbox', 'radio', 'select']) < 0) {
            // We're editing either a checkbox, a radio, or a select input in which case
            // we want to be able to edit their options
            $('#form_builder_properties').find('textarea[name=options]').val('').parent().parents('li:first').hide();
        }
        else {
            $('#form_builder_properties').find('textarea[name=options]').parent().parents('li:first').show();
        }
        //set checkbox of filed Required
        $('#form_builder_properties').find('input[type="checkbox"].property_required_checkbox').attr('checked', $('#form_builder_properties').find('input[type="hidden"].property_required_text').val()=='true' ?'checked':'');
        $('#form_builder_properties').find('input[type="checkbox"].property_required_checkbox').attr('parentid',this.curElementName);
        $('#form_builder_properties').hide().slideDown('slow');

        /*var properties =   $('#form_builder_properties');
        var e =  $('.sml #form_prop_test');
      	e.html(properties.html()); //replace all html exists in events
    */
      this.updateVisualInEdition();


    },

    updateVisualInEdition: function(){
      var elementInEdition = $('.element_container.on #form_prop_hover');
      $('#form_builder_properties').css('position', 'absolute');
      $('#form_builder_properties').offset($(elementInEdition).offset());

      var elementInEditionMoveBtn = $('.element_container.on #form_prop_delete_hover');
      $('.button#remove_button').css('position', 'absolute');
      $('.button#remove_button').offset($(elementInEditionMoveBtn).offset());
    },

    valueChanged: function(event, elementName, target, value) {
        var options = "";
        if (target.is('input[type="checkbox"]')) {
            // Checkboxes can have multiple options, when one is clicked
            // we get all the checked options of the affected group
            var name = target.attr('name');
            options = $('#' + elementName).find('input[type="checkbox"][name='+name+']:checked').map(function() {
                return $(this).val();
            }).get().join("\n");
        }
        else {
            options = value;
        }
        this.elementProps[elementName]['value'] = options;
        this.save();
    },

    reorder: function() {
        var order = 0;
        $('.element_container').each(function(index, element){
            Contactline.formbuilder.elementProps[$(element).attr('id')]['order'] = order++;
        });
        Contactline.formbuilder.save();
    },

    onDragStart: function(){
      //hide edition
      $('#form_builder_panel li.on').removeClass('on');
      $('#form_builder_properties').hide();
    },

    save: function() {
        // Update our form_data form input field
        $('#form_data').val(JSON.stringify(this.elementProps));
    },

    remove: function(e)
    {
        var that = this;
        Contactline.formbuilder.confirm("Remover o elemento seleccionado?",       // Translation: Really remove this element?
            function(options){
                var elementName = options.rel;
                $('#' + elementName).slideUp('slow',function(){
                    $(this).remove();
                    delete that.elementProps[elementName];
                    that.save();
                    $('#form_builder_properties').show().slideUp('fast');
                });
            },
            {
                rel: this.curElementName
            }
        );
    },

    dialog: function(rel,link)
    {
        var external = $("#"+rel).hasClass('external');
        if (external) {
            $("#"+rel).show().html("<iframe src='"+link+"' name='"+rel+"' width='100%' height='100%' frameborder='0' border='0'></iframe>").dialog('open');
            return;
        }
        if (link) {
            if (link.indexOf('http') >= 0) {
                $("#"+rel).html("");
                $.get(link,function(result){
                    $("#"+rel).html(result).show().dialog('open');
                    Contactline.formbuilder.layout("#"+rel);
                    delete result;
                });
                return;
            }
        }
        $("#"+rel).show().dialog('open');
    },

    confirm: function(msg,callback,options)
    {
        var id = 'confirm_'+Math.ceil(100*Math.random());
        $('body').append('<div id="'+id+'"><p></p></div>');
        $('#'+id+' p').html(msg).dialog({
            modal: true,
            overlay: {
                opacity: 0.5,
                background: "black"
            },
            title: 'Confirmar',                            // Translation: Confirm
            buttons: {
                "Confirmar": function() {                  // Translation: Confirm
                    if (callback) callback(options);
                    $(this).dialog("close");
                    $(this).parents('div:first').remove();
                },
                "Cancelar": function() {                   // Translation: Cancel
                    $(this).dialog("close");
                    $(this).parents('div:first').remove();
                }
            }
        });
    },

    preview: function()
    {
        var that = this;
        var data = $('#form_data').val();

        $.post(this.PREVIEWURL, {'form': data}, function(result) {
            $('#form_builder_preview').html(result);
            Contactline.formbuilder.dialog('form_builder_preview');
        });
    }


}

function randomString(length)
{
    var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
    var string_length = length;
    var randomstring = '';
    for (var i=0; i<string_length; i++) {
        var rnum = Math.floor(Math.random() * chars.length);
        randomstring += chars.substring(rnum,rnum+1);
    }
    return randomstring;
}
