<?php 

/**
 *  Classe de Gestão de Horários
 *  Corresponde à tabela 'horario' da base de dados.
 */


class Horario extends AcessoBD{
	var $bd;

        var $id;
        var $nome;

        // Se este horário é para ser listado nos Locais/Lojas, Serviços e Balcões
        var $listavel;

        // The Horario object from which this horario inherits. Currently, only one
        // inheritance level is supported.
        var $horarioBase;

        var $horariosSemana = array();

	/*
		Construtor da classe

		0 = Erro da BD
	*/
	function Horario()
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
		Função de inserção

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
	*/
	function Inserir($dados)
	{
		$data = json_decode($dados["data"]);

		$h = new Horario();
		$hs = new HorarioSemana();

		$h->nome = $dados["nome"];
		$h->listavel = 0;
		$h->horarioBase = 0;
		$h->horariosSemana = array($hs);

		$hs->horario = &$h;
		$hs->data = '';
		$hs->periodos = array();

		foreach($data as $periodo)
		{
			if(!isset($periodo->readOnly))
			{
				$p = new Periodo();

				$p->diaInteiro = $periodo->diaInteiro;
				$p->inicio = $periodo->inicio;
				if($p->diaInteiro == 0)
				{
					$p->fim = $periodo->fim;
					$p->dia = $periodo->dia;
				}
				$p->tipo = 1;
				$p->horarioSemana = &$hs;

				$hs->periodos[] = $p;
			}
		}

		if(isset($dados['parent']))
		{
			$p = new Horario();
			$p->get($dados['parent']);
			$h->horarioBase = $p;
		}
		//print_r($h);
		$h->save();
		echo "OK";
		die();
	}

	        /**
         * Função de Edição
         *
         * @param array   $dados   Um array com todos os dados de um Horario
         *                         incl HorarioSemana e Periodos
         * @param integer $id      O id do Horario a editar
         * @return mixed           0 = Erro da BD
         *                         5 = Erro Existente
         *                         true = Sucesso
         */
	function Editar($dados, $id)
	{

		$data = json_decode($dados["data"]);

		$h = new Horario();
		$h->get($id);

		$h->nome = $dados["nome"];

		$hs = new HorarioSemana();
		$hs->horario = &$h;

		$date = strtotime($dados["date"]);
		$ano = date("Y",$date);
		$semana = date("W", $date);
		$primeirodia = strtotime($ano.'W'.$semana." UTC");

		$hs->data = $primeirodia;  // if baseline, will be deleted below

		$hs->periodos = array();

		foreach($data as $periodo)
		{
			if(!isset($periodo->readOnly))
			{
				$p = new Periodo();

				/*$p->diaInteiro = $periodo->diaInteiro;*/
				$p->inicio = $periodo->inicio;
				/*if($p->diaInteiro == 0)
				{*/
					$p->fim = $periodo->fim;
					$p->dia = $periodo->dia;
				/*}*/
				$p->tipo = 1;
				$p->horarioSemana = &$hs;

				$hs->periodos[] = $p;
			}
		}

		if($dados["baseline"]>0)
		{
			// We're saving a baseline and it could happen that the user
			// is saving the baseline while viewing an exception week.
			// In this case, we must delete the exception week that the user
			// was viewing.
			$hs2 = $h->getHorarioSemanaByTimestamp((int)($hs->data), false);

			if ($hs2 != null) {
				$h->removeHorarioSemana($hs2);
			}
			$hs->data = null;
		}

		// If it is a baseline and the baseline already existed,
		// the old one will be replaced.
		$h->addHorarioSemana($hs);

		if(isset($dados['parent']))
		{
			$p = new Horario();
			$p->get($dados['parent']);
			$h->horarioBase = $p;
		}

		$h->save();
		echo "OK";
		die();
	}

	function GetHorarios($id="")
	{
            // TODO test this new return methodology
            $this->get($id);
            return $this;
            // Changed from...
            //return $this->bd->getRows($sql);
	}

	/*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
	*/

	function LerDados($id) {

		// Read the Horario with id $id from db and map its values
		// to this very same object ($this)
		$this->get($id);

		// TODO store this horario to the session with the intended format
		$_SESSION["sessao_campos"]['horario'] = $this;

		return "ok";
	}

    /**
     * Função de Remoção.
     *
     * @param  mixed $id    Um único id ou um array de ids
     * @return mixed
     */
    function Remover($id) {

        $this->EscreveXMLSync($id, "remover");

	if ($this->bd->executarSQL("START TRANSACTION;") == false) {
	    return false;
	}

        $id_str = implode(", ", $id);
        $sql = "select count(*) n from lojas l, servicos s where l.horario in (" . $id_str . ") or s.horario in (" . $id_str . ")";
        $res = $this->bd->getRows($sql);

        if ($res[0]["n"]) {
            // one or more horarios are still being referenced by a loja or service, can't continue
	    	$this->bd->executarSQL("ROLLBACK;");
            return 14; // why 14? [Tiago]
        }

        // get horario names that will be deleted so we can log them later
        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT nome FROM horario WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id = " . $id[$i] . " OR ";
        $sql .= "id = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
        {
        	$this->bd->executarSQL("ROLLBACK;");
            return 0;
        }
        
        $res2 = $this->bd->getRows($sql);
        foreach ($res2 as $r)
        { 
        	array_push($nomes, $r["nome"]);
        }

        /*if ($rs = $this->bd->executarSQL($sql)) {
            for ($i = 0; $i < $numEntradas; $i++) {
                $this->bd->moverRegisto($rs, $i);
                array_push($nomes, $this->bd->obterValor($rs, "nome"));
            }
        }
        else {
	    	$this->bd->executarSQL("ROLLBACK;");
            return 0;
		}*/

	$success = true;

	// TODO add id_horario to empregados or to empregados_lojas...
	// Delete any reference that might exist from a colaborador/empregado
	// to the Horario we're deleting
	/*$sql = "UPDATE empregados SET id_horario = NULL WHERE ";
	for ($i = $numEntradas - 1; $i > 0; $i--)
	    $sql .= "id_horario = " . $id[$i] . " OR ";
	$sql .= "id_horario = " . $id[0] . ";";

	if ($this->bd->executarSQL($sql) == false) {
	    $success = false;
	}
	 */

	if ($success) {

	    // Delete any reference that might exist from an horario
	    // to the Horario we're deleting (break the inheritance
	    // that might exist).
	    $sql = "UPDATE horario SET id_horario_base = NULL WHERE ";
	    for ($i = $numEntradas - 1; $i > 0; $i--)
		$sql .= "id_horario_base = " . $id[$i] . " OR ";
	    $sql .= "id_horario_base = " . $id[0] . ";";

	    if ($this->bd->executarSQL($sql) == false) {
		$success = false;
	    }
	}
	if ($success) {
	    // Delete the chosen horarios
	    // (Their associated HorarioSemana and Periodos objects will be
	    // automatically deleted as well because of the CASCADE delete defined
	    // in the database)
	    $sql = "DELETE FROM horario ";
	    $sql.= "WHERE ";
	    for ($i = $numEntradas - 1; $i > 0; $i--)
		$sql .= "id = " . $id[$i] . " OR ";
	    $sql .= "id = " . $id[0] . ";";

	    if ($this->bd->executarSQL($sql) == false) {
		$success = false;
	    }
	}



	if ($success) {
	    if ($this->bd->executarSQL("COMMIT;") == false) {
		return false;
	    }

            $objecto = new LogAccao();
            for ($i = count($nomes) - 1; $i >= 0; $i--) {
                $rs = $objecto->Inserir("Remoção", "Horário", $nomes[$i]);
            }
            $objecto->fechar();

            return "ok";
        }

        // Failure
	$this->bd->executarSQL("ROLLBACK;");
        return 0;


    }

    /*
     * Função de listagem
     *
     * 0 = Erro da BD
     * true = Sucesso
     */
    function Listar() {

        $sql = "SELECT h.id, h.nome FROM horario h ";

        if (array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY h." . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY h.nome ";

        if (array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";


        global $ERROS, $N_REGISTOS;
        if (!$rs = $this->bd->executarSQL($sql)) {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $horarios = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($horarios, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if (array_key_exists("pagina", $_REQUEST) && intVal($_REQUEST["pagina"]) > 0 && ($numTuplos / $numRegPag) <= ( $_REQUEST["pagina"] - 1))
            $_REQUEST["pagina"] -= 1;

        // caso não existam registos
        if ($numTuplos == 0) {
            echo "<div class='empty_msg'>" . translate('word_nao_existem') ." ". translate("word_horarios") ." ". translate('word_registados_sistema') . "</div>";
            return;
        }

        // calculo do n�mero de p�ginas de registos
        if ($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=horarios&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "") . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>	";

            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
                <td class='button_page' colspan='6'>";

                if($pagina > 1)
                {
                    $pagAnterior = $pagina - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $pagina = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $pagina)
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($pagina - 1)*$numRegPag;
                $incremento = $n;

                if($pagina < $numPaginas)
                {
                    $pagPosterior = $pagina + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
        </tr>";

        echo "<tr class='column_row'>";

        if ($_SESSION["sessao_perms"]["perm_lojas"] == 2) {
            echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"], "nome") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

        echo "<td width='155'>" . translate('word_operations', true) . "</td>
				</tr>";

        ///while ($n < ($numRegPag + $incremento)) {
         //   $this->bd->moverRegisto($rs, $n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {

            echo"<tr class='form-data-tr'>";
            if ($_SESSION["sessao_perms"]["perm_lojas"] == 2) {
							echo "<td class='form-data-td'>
											<label class='custom-check-container'>
													<input name='grupo' type='checkbox' value='" . $horarios[$i]["id"] /*$this->bd->obterValor($rs,"id")*/ . "' onClick='selectEntireRow(this)'>
													<span class='custom-checkmark'></span>
											</label>
									</td>";
            }
            echo "<td class='form-data-td'>" . $horarios[$i]["nome"] /*$this->bd->obterValor($rs, "nome")*/ . "</td>
									<td class='form-data-td'>";
				            if ($_SESSION["sessao_perms"]["perm_lojas"] == 2) {
				                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=horarios&id=" . $horarios[$i]["id"] /*$this->bd->obterValor($rs, "id") */. "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_edit', true) . "</div></a>
										<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=horarios&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "&id=" . $horarios[$i]["id"] /*$this->bd->obterValor($rs, "id")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>" . translate('word_remove', true) . "</div></a>";
				            } else {
				                echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=horarios&id=" . $horarios[$i]["id"] /*$this->bd->obterValor($rs, "id")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_details', true) . "</div></a>";
				            }
				            echo "</td>
								</tr>";

            //$n++;
        }

				//#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
        if ($_SESSION["sessao_perms"]["perm_lojas"] == 2) {
            echo "<tr>
									<td>
										<table>
											<tr>
												<td class='button'>
													<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>
													<div class='button-thin-green' onClick='seleccionaCaixa(true)'>" . translate('word_mark_all', true) . "</div>
													<div class='button-thin-green' onClick='seleccionaCaixa(false)'>" . translate('word_unmark_all', true) . "</div>
													<div class='button-thin-green' onClick='removerMarcados(this);'>" . translate('word_remove', true) . "</div>
												</td>
												<td class='button'>
													<a href='../lojas/'><div class='button-thin-green'>" . translate('word_create', true) . " Loja</div></a>
												</td>
											</tr>
										</table>
									</td>
					</tr>";
        }

        echo "</table>
		</form>";
    }

    /*
		Destrutor da classe

		0 = Erro da BD
	*/
	function Fechar()
	{
		$this->bd->fecharBD();
	}













    //----------------------------//
    //   Horarios Model Methods   //
    //----------------------------//

    function getId() {
        return $this->id;
    }

    function get($id) {

        $sql = "SELECT horario.id horario_id, ";
        $sql.= "horario.nome horario_nome, ";
        $sql.= "horario.id_horario_base horario_id_horario_base, ";
        $sql.= "horario.listavel horario_listavel, ";

        $sql.= "horario_semana.id horario_semana_id, ";
        $sql.= "UNIX_TIMESTAMP(horario_semana.start_date) horario_semana_start_date, ";
        $sql.= "horario_semana.id_horario horario_semana_id_horario, ";

        $sql.= "periodo.id periodo_id, ";
        $sql.= "periodo.dia_inteiro periodo_dia_inteiro, ";
        $sql.= "periodo.inicio periodo_inicio, ";
        $sql.= "periodo.fim periodo_fim, ";
        $sql.= "periodo.dia periodo_dia, ";
        $sql.= "periodo.tipo periodo_tipo, ";
        $sql.= "periodo.id_horario_semana period_horario_semana_id ";

        $sql.= "FROM horario ";
        $sql.= "LEFT JOIN horario_semana ";
        $sql.= "ON horario.id = horario_semana.id_horario ";
        $sql.= "LEFT JOIN periodo ";
        $sql.= "ON horario_semana.id = periodo.id_horario_semana ";
        $sql.= "WHERE horario.id = "; // Add the id of the horario here
        // Get the horario that corresponds to the passed id
        $rows = $this->bd->getRows($sql . $id);
        // Map the SQL result to the actual Horario/HorarioSemana/Periodo
        $this->mapDatabaseToObject($rows);

        if ($this->horarioBase > 0) {
            // Yes, this Horario inherits from a base Horario.
            // Read that horario as well.
            $rows = $this->bd->getRows($sql . $this->horarioBase);
            $horarioBase = new Horario();
            $this->mapDatabaseToObject($rows, $horarioBase);
            $this->horarioBase = $horarioBase;
        }
    }

    /**
     * Lists horarios according to a $where clause and returns only Horario's $fields fields.
     * Only the horario table is queried, no joins are performed.
     *
     * @param string $where   Optional. Where clause in the form of "id = 5 AND nome = 'some name'"
     * @param array  $fields  Optional. An array of which Horario fields to return.
     */
    function listHorarios($where = "", $fields = array('id')) {
        if (is_array($fields) == false)
            return null;

        $sql = "SELECT ".implode(", ", $fields);
        $sql.= " FROM horario ";
        if (empty($where) == false) {
            $sql.= "WHERE $where ";
        }
        return $this->bd->getRows($sql);
    }

    function save($validate = true) {

        $oldHorarioSemanaIds = array();
        $newHorarioSemanaIds = array();
        $deleteHorarioSemanaIds = array();

        if ($this->bd->executarSQL("START TRANSACTION;") == false) {
            return false;
        }
        // First save or update the parent Horario if there is any
        if ($this->horarioBase instanceof Horario) {
            $success = $this->horarioBase->save();
            if (!$success) {
            $this->bd->executarSQL("ROLLBACK;");
                return false;
            }
        }
        $success = true;

        if ($this->id > 0) {
            // We're editing an existing Horario
            $sql = "UPDATE horario SET ";
            $sql.= "nome = '" . $this->nome . "', ";
            $sql.= "listavel = " . $this->listavel . ", ";
            if ($this->horarioBase instanceof Horario && $this->horarioBase->getId() > 0) {
                $sql.= "id_horario_base = " . $this->horarioBase->getId() . " ";
            }
            else {
                $sql.= "id_horario_base = NULL ";
            }
            $sql.= "WHERE id = " . $this->id . ";";

            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            }

            // We must also check which HorarioSemana objects exist associated
            // to this Horario because we will save the HorarioSemana objects
            // below and need to know if there are HorarioSemana that have to be
            // removed.
            $sql = "SELECT id FROM horario_semana WHERE id_horario = ".$this->id.";";
            $result = $this->bd->executarSQL($sql);
            if ($result == false){
                // Some error occurred
              
                $this->bd->executarSQL("ROLLBACK;");
                    return false;
            }
            
            while ($row = $this->bd->obterRegisto($result))
	        {
	            array_push($oldHorarioSemanaIds, $row['id']);
	        }
	       /* var_dump( $dispensadores );
            while (($row = $this->bd->obterRegisto($result)) !== false) {
            	//echo 'test save 0.0001 '.  $row['id']; 
                $oldHorarioSemanaIds[] = $row['id'];
            }*/
        } else {
            $sql = "INSERT INTO horario(id, nome, listavel) VALUES(0, ";
            $sql.= "'".$this->nome . "', ";
            $sql.= $this->listavel . ");";
            if ($this->bd->executarSQL($sql) == false) {
                $success = false;
            } else {
                $autoIncrementId = $this->bd->obterUltimoInsertId();
                $this->id = $autoIncrementId;
            }
        }
        if ($success) {
            // Save the horarioSemana objects after we save the horario
            // because HorarioSemana needs to point to us and thus needs
            // our id to be already set.
            // This will cascade the save to its Periodo objects as well.
            foreach ($this->horariosSemana as $horarioSemana) {

                $success = $horarioSemana->save($this->bd);
                if (!$success) {

                    $this->bd->executarSQL("ROLLBACK;");
                    return false;
                }
            }

            // Get the ids of all the HorarioSemana objects that we have for this week
            foreach ($this->horariosSemana as $horarioSemana) {
            	array_push($newHorarioSemanaIds, $horarioSemana->id);
                //$newHorarioSemanaIds[] = $horarioSemana->id;
            }
            // Delete the old periodo objects which
            // do not belong to this week anymore
            $deleteHorarioSemanaIds = array_diff($oldHorarioSemanaIds, $newHorarioSemanaIds);



            if (count($deleteHorarioSemanaIds) > 0) {
                $sql = "DELETE FROM periodo WHERE ";
                for($i = count($deleteHorarioSemanaIds)-1; $i > 0; $i--)
                $sql .= "id_horario_semana = " . $deleteHorarioSemanaIds[$i]['id'] . " OR ";
            	$sql .= "id_horario_semana = " . $deleteHorarioSemanaIds[0]['id'] . ";";
                //$sql.= implode(" OR id_horario_semana = ", $deleteHorarioSemanaIds);
                //$sql.= ";";
        
                if ($this->bd->executarSQL($sql) == false) {
                    // Some error occurred
                    $this->bd->executarSQL("ROLLBACK;");
                    return false;
                }

                $sql = "DELETE FROM horario_semana WHERE ";
                for($i = count($deleteHorarioSemanaIds)-1; $i > 0; $i--)
                $sql .= "id = " . $deleteHorarioSemanaIds[$i]['id'] . " OR ";
            	$sql .= "id = " . $deleteHorarioSemanaIds[0]['id'] . ";";
                //$sql.= implode(" OR id = ", $deleteHorarioSemanaIds);
                //$sql.= ";";
   
                if ($this->bd->executarSQL($sql) == false) {
                    // Some error occurred
                    $this->bd->executarSQL("ROLLBACK;");
                    return false;
                }
            }

            if ($this->bd->executarSQL("COMMIT;") == false) {
                return false;
            }

            $this->EscreveXMLSync($autoIncrementId, "inserir");
            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Horário", $this->nome);
            $objecto->fechar();
            return "ok";
        } else {
            $this->bd->executarSQL("ROLLBACK;");
            return false;
        }
    }

    function addHorarioSemana($horarioSemana) {

	if (($horarioSemana instanceof HorarioSemana) == false) {
            return false;
        }

	foreach ($this->horariosSemana as $k => $hs) {
            if ($horarioSemana->getId() > 0) {
                // The given horarioSemana does have an id, check
                // if any of the existing horarioSemana objects have the same
                if ($hs->getId() == $horarioSemana->getId()) {
                    unset($this->horariosSemana[$k]);
                }
            }
            else if ($horarioSemana->getYearWeek() == $hs->getYearWeek()) {
                // We are adding an horarioSemana for a week that already
                // exists (either the base week or an exception),
		// remove the old one so the new one can be added
                $horarioSemana->setId($hs->getId());
                unset($this->horariosSemana[$k]);
            }
        }

	$this->horariosSemana[] = $horarioSemana;

    }

    function removeHorarioSemana($horarioSemana) {

        if (($horarioSemana instanceof HorarioSemana) == false || ($horarioSemana->getId() > 0) == false ) {
            return false;
        }
        
        
        foreach ($this->horariosSemana as $k => $hs) {
            if ($hs->getId() == $horarioSemana->getId()) {
                unset($this->horariosSemana[$k]);
                return true;
            }
        }
        return false;
    }

    /**
     * Gets the valid HorarioSemana object for the given week
     *
     * @param string $year   The year of the week
     * @param string $week   The number of the week
     * @param string $baselineOnNotFound   Whether or not to return the baseline / baseweek if
     *                                     no HorarioSemana exception for the given time is found.
     * @return HorarioSemana The valid HorarioSemana object for the given week.
     *                       It can be an exception HorarioSemana if one is found
     *                       or it will be the base HorarioSemana otherwise.
     */
    function getHorarioSemana($year, $week, $baselineOnNotFound = true) {
        $yearWeek = $year."-".$week;
        $baseHorarioSemana = null;
        foreach ($this->horariosSemana as $hs) {
            if ($hs->getYearWeek() == $yearWeek) {
                return $hs;
            }
            if ($hs->data == null) {
                // Temporarily store the base horario semana which we will
                // return if no exception horarioSemana is found for
                // the given week
                $baseHorarioSemana = $hs;
            }
        }
        if ($baselineOnNotFound) {
            return $baseHorarioSemana;
        }
        return null;
    }

    /**
     * Gets the valid HorarioSemana object for the given week
     *
     * @param string $timestamp            The year of the week
     * @param string $baselineOnNotFound   Whether or not to return the baseline / baseweek if
     *                                     no HorarioSemana exception for the given time is found.
     * @return HorarioSemana               The valid HorarioSemana object for the given week.
     *                                     It can be an exception HorarioSemana if one is found
     *                                     or it will be the base HorarioSemana otherwise.
     */
    function getHorarioSemanaByTimestamp($timestamp, $baselineOnNotFound = true) {
        $year = date("Y", $timestamp);
        $week = date("W", $timestamp);
        return $this->getHorarioSemana($year, $week, $baselineOnNotFound);
    }

    function getHorarioSemanaCurrent() {
	    return $this->getHorarioSemanaByTimestamp(time());
    }

    function getBaseHorarioSemana() {
	// Provide a fake date so that we surely get the baseline
	return $this->getHorarioSemana(0, 0, true);
    }

	function isContinuouslyOpenToday() {
	    $currWeek = $this->getHorarioSemanaCurrent();
	    if ($currWeek == null) {
		    return false;
	    }
	    return $currWeek->isContinuouslyOpenToday();
        }






    /**
     * This function maps the database query result rows into
     * the Domain Model represented by this class and its associations.
     *
     * Each row is expected to be something like the following
     *     [0] => Array
     *         (
     *             [horario_id] => 1
     *             [horario_nome] => "Turno da manhã"
     *             [horario_id_horario_base] => 2
     *             [horario_listavel] => 1
     *
     *             [horario_semana_id] => 1
     *             [horario_semana_start_date] => 12345679 // timestamp
     *             [horario_semana_id_horario] => 1 // same as horario_id
     *
     *             [periodo_id] => 1
     *             [periodo_dia_inteiro] => 0   // full day or not?
     *             [periodo_inicio] => 10:00
     *             [periodo_fim] => 12:00
     *             [periodo_dia] => 1
     *             [periodo_tipo] => 1
     *             [period_horario_semana_id] => 1
     *         )
     *
     *
     *
     */
    private function mapDatabaseToObject($rows, $horarioTarget = null) {

        if ($horarioTarget == null) {
            $horarioTarget = $this;
        }

        if (empty($rows)) {
            return false;
        }

        // First set up the Horario
        $firstRow = $rows[0];
        $horarioTarget->id = $firstRow['horario_id'];
        // The horario from which this horario inherits might or might not exist.
        // Here we temporarily store the id and later this method's caller
        // will have to load the actual Horario object and store it in here.
        $horarioTarget->horarioBase = $firstRow['horario_id_horario_base'];
        $horarioTarget->horariosSemana = array();
        $horarioTarget->listavel = $firstRow['horario_listavel'];
        $horarioTarget->nome = $firstRow['horario_nome'];

        // Store the horarioSemana objects indexed by their ids
        $readHorarioSemanaIds = array();

        foreach ($rows as $row) {
            // Each row has
            // - the same horario information -> ignore
            // - all the different horariSemana information
            // - all the different periodo information


            if ($row['horario_semana_id'] == null) {
                // for some weird reason there is no horarioSemana in this
                // result row, ignore it
                continue;
            }

            if (isset($readHorarioSemanaIds[$row['horario_semana_id']])) {
                // we already read and stored this HorarioSemana object
                $horarioSemana = $readHorarioSemanaIds[$row['horario_semana_id']];
            }
            else {
                $horarioSemana = new HorarioSemana();
                $horarioSemana->setId($row['horario_semana_id']);
                $horarioSemana->setData($row['horario_semana_start_date']);
                $horarioSemana->setHorario($horarioTarget);

                $horarioTarget->horariosSemana[] = $horarioSemana;

                // Indicate that this horarioSemana has already been read and stored
                $readHorarioSemanaIds[$row['horario_semana_id']] = $horarioSemana;
            }

            if ($row['periodo_id'] != null) {
                // Only create and add the periodo if the current
                // HorarioSemana actually has periods. Although it
                // should always have at least one period.

                $periodo = new Periodo();
                $periodo->setId($row['periodo_id']);
                $periodo->setDiaInteiro($row['periodo_dia_inteiro']);
                $periodo->setInicio($row['periodo_inicio']);
                $periodo->setFim($row['periodo_fim']);
                $periodo->setDia($row['periodo_dia']);
                $periodo->setTipo(($row['periodo_tipo']));
                $periodo->setHorarioSemana($horarioSemana);

                $horarioSemana->addPeriodo($periodo);
            }

        }
    }

    //----------------------------//
    // Legacy non-maintained code //
    //----------------------------//

    /*
     * Este método está actualizado e não é mantido.
     *
     * Procede à criação e escrita de um
     * ficheiro XML para as alterações feitas
     * serem replicadas pelas base de dados necessárias.
     *
     */
    function EscreveXMLSync($id, $accao, $enderecos_lojas=null) {

        // ATTENTION! We're returning right here
        // since this seems to be of no use
        return;

        if (!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM horario_loja WHERE ";
        for ($i = $numEntradas - 1; $i > 0; $i--)
            $sql .= "id_horario_loja = " . $id[$i] . " OR ";
        $sql .= "id_horario_loja = " . $id[0] . ";";

        if (!$rs = $this->bd->executarSQL($sql))
            return 0;

        $documento = abreXMLSync();
        $raiz = $documento->firstChild;


        if (is_null($enderecos_lojas)) {
            $loja = new Loja();
            $enderecos = $loja->listaIpLojas();
            //$loja->Fechar();
        } else {
            $enderecos = $enderecos_lojas;
        }

        if (count($enderecos) > 0) {
            $destinos = $documento->createElement("destinos");
            $raiz->appendChild($destinos);
        }

        for ($i = 0; $i < count($enderecos); $i++) {
            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);
        }

        $numEntradas = $this->bd->obterNumRegistos($rs);

        for ($i = 0; $i < $numEntradas; $i++) {
            $this->bd->moverRegisto($rs, $i);

            $no_horarioLoja = $documento->createElement("horarioLoja");
            $raiz->appendChild($no_horarioLoja);

            $no_horarioLoja->setAttribute("id", $this->bd->obterValor($rs, "id_horario_loja"));
            $no_horarioLoja->setAttribute("accao", $accao);

            $elemento = $documento->createElement("nome");
            $elemento->nodeValue = $this->bd->obterValor($rs, "nome");
            $no_horarioLoja->appendChild($elemento);

            $valor = $this->bd->obterValor($rs, "abertura_0");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura0");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_0");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho0");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_1");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura1");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_1");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho1");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_2");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura2");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_2");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho2");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_3");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura3");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_3");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho3");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_4");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura4");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_4");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho4");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_5");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura5");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_5");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho5");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "abertura_6");
            if (isset($valor)) {
                $elemento = $documento->createElement("abertura6");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "fecho_6");
            if (isset($valor)) {
                $elemento = $documento->createElement("fecho6");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_0");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio0");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_0");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim0");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_1");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio1");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_1");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim1");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_2");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio2");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_2");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim2");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_3");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio3");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_3");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim3");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_4");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio4");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_4");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim4");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_5");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio5");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_5");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim5");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_inicio_6");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervaloinicio6");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }

            $valor = $this->bd->obterValor($rs, "intervalo_fim_6");
            if (isset($valor)) {
                $elemento = $documento->createElement("intervalofim6");
                $elemento->nodeValue = $valor;
                $no_horarioLoja->appendChild($elemento);
            }
        }

        fechaXMLsync($documento);
    }

}
?>
