<?php 

/**
 *
 * @author Tiago Alves
 */
class WeekDay {
        // The constants to use as the day of the week
        // ISO-8601 numeric representation of the day of the week
        // 1 (for Monday) through 7 (for Sunday)
        const MONDAY = 1;
        const TUESDAY = 2;
        const WEDNESDAY = 3;
        const THURSDAY = 4;
        const FRIDAY = 5;
        const SATURDAY = 6;
        const SUNDAY = 7;

        /**
         * Gets a WeekDay for the given date
         *
         * @param date The date for which to calculate the WeekDay
         * @param <type> $timestamp
         * @return <type>
         */
        public static function fromTimestamp($timestamp) {
                return date("N", $timestamp);
        }

        public static function today() {
                return date("N");
        }
	
	/**
	 * Returns the const string name for a given WeekDay value.
	 * For instance, given 1, it returns "MONDAY".
	 * 
	 * @param int $day a valid WeekDay value (1 to 7)
	 * @return string the String representation of the day or "" if not a valid WeekDay value.
	 */
	public static function toString($day) {
		switch($day) {
                        case 1:
                                return "MONDAY";
                        case 2:
                                return "TUESDAY";
                        case 3:
                                return "WEDNESDAY";
                        case 4:
                                return "THURSDAY";
                        case 5:
                                return "FRIDAY";
                        case 6:
                                return "SATURDAY";
                        case 7:
                                return "SUNDAY";
                        default:
                                return "";
                }
	}
}
?>
