<?php	
/**
 * Objecto elaborado para explicar operações CRUD 
 */
class DatabaseAdapter {
	
	private $_host;
	private $_user;
	private $_pass;
	private $_name;
	private $_port;
        public $newId;
	
	private $connection;
	
        public function __construct($name, $host = '127.0.0.1', $user = 'zquser', $pass = 'zq0livais', $port = 3306) {
		$this->_host = $host;
		$this->_user = $user;
		$this->_pass = $pass;
		$this->_port = $port;
		$this->_name = $name;
	}
	
	public function connect() {
		$this->connection = new mysqli($this->_host, $this->_user, $this->_pass, $this->_name, $this->_port);
	}
	
	public function disconnect() {
		$this->connection->close();
		$this->connection = null;
	}
	
	public function getConnection() {
		if(!empty($this->connection))
			return $this->connection;
		throw new Exception('Connection not created!', 1);
	}
	
	public function getResultSet($sql) {
		$conn = $this->getConnection();
                $conn->set_charset("utf8");
		return $conn->query($sql);
	}
	
	public function fetch($table, $where = null, $fields = null, $order = null, $limit = null, $returnObject = 'stdClass') {
		
                //RETURNS ALL THE FIELDS
		if(empty($fields))
			$fields = '*';
		else
                //RETURNS SPECIFIC FIELDS 
			$fields = implode(', ', $fields);
		
                //QUERY OF WHAT FIELDS IN WHAT TABLE 
		$sql = "SELECT {$fields} FROM {$table}";
		
                //FILTERS
		if(!empty($where))
			$sql .= " WHERE {$where}";
		//DEFINES ORDER 
		if(!empty($order))
			$sql .= " ORDER BY " . $order[0] . " " . strtoupper($order[1]);
		//DEFINES LIMIT FROM WHAT POSISITION IN THE TABLE WE WANT		
		if(!empty($limit))
			$sql .= " LIMIT " . $limit;
		//RETURNS THE RESULT OF THE QUERY OF THE OBJECT	
		return $this->rawQuery($sql, $returnObject);
	}
	
        
	public function insert($name, $data) {
            
		$fields = array();
		$values = array();
		
		foreach($data as $key => $value) {
			$fields[] = $key;
			$values[] = $value;
		}
		
		$fieldsAsString = implode($fields, ', ');
		$valuesAsString = "'" . implode($values, "', '") . "'";
		
		$sql = "INSERT INTO {$name} ({$fieldsAsString}) VALUES ({$valuesAsString})";
		$conn = $this->getConnection();
		$conn->set_charset("utf8");
                
		if($conn->query($sql))
			return $conn->insert_id;
		return -1;
	}
	
	public function update($table, $data, $where = null) {
		
		$fields = array();
		
		foreach($data as $key => $value) {
			$fields[] = $key . " = '" . $value . "'";
		}
		
		$fieldsAsString = implode($fields, ', ');
		
		$sql = "UPDATE {$table} SET {$fieldsAsString}";
		
		if(!empty($where))
			$sql .= " WHERE {$where}";
		
		$conn = $this->getConnection();
                $conn->set_charset("utf8");
		
		return $conn->query($sql);
	}
	
	public function delete($table, $where = null) {
		$sql = "DELETE FROM {$table}";
		
		if(!empty($where))
			$sql .= " WHERE {$where} LIMIT 1";
		
		$conn = $this->getConnection();
                $conn->set_charset("utf8");
		
		return $conn->query($sql);
	}
        
        public function truncate($table, $where = null) {
		$sql = "TRUNCATE TABLE {$table}";
		
		if(!empty($where))
			$sql .= " WHERE {$where}";
		
		$conn = $this->getConnection();
                $conn->set_charset("utf8");
		
		return $conn->query($sql);
	}
	
	public function exists($table, $field, $value) {
		$sql = "SELECT COUNT(*) as counter FROM {$table} WHERE {$field} = '{$value}'";
		$rs = $this->getResultSet($sql);
		
		$row = $rs->fetch_array();
		return ($row['counter'] > 0);
	}
	
	public function rawQuery($sql, $returnObject = 'stdClass') {
		$rs = $this->getResultSet($sql);
		
		if($rs->num_rows > 1) {
			$list = array();
			
			while($row = $rs->fetch_object($returnObject)) 
				$list[] = $row;
			
			return $list;
		}
		else if($rs->num_rows == 1) {
			return $rs->fetch_object($returnObject);
		}
		
		return null;
	}
	
	public function __toString() {
		return "[DatabaseAdapter(host: {$this->_host}:{$this->_port}, user: {$this->_user}, pass: {$this->_pass}, database: {$this->_name})]";
	}
}
	
?>