<?php 

	include '../config.inc.php';

	$nextid = 1;
	extract($_GET, EXTR_PREFIX_ALL, 'g');
	extract($_POST, EXTR_PREFIX_ALL, 'x');

	$readOnly = false;
	if($g_calParent>0)
	{
		$g_id = $g_calParent;
		$readOnly = true;
	}

	$start = $_GET["start"];
	$end= $_GET["end"];

	echo getCal($g_id, $readOnly);

	function getCal($g_id = '', $readOnly = false)
	{

		$cal = new stdClass();
		$cal->events = array();

		if(is_numeric($g_id))
		{
			$h = new Horario();
			$h->get($g_id);

			//if horarioBase or exceptions found, don't return baseline
			$found = false;

			if($h->horarioBase!=0)
			{
				$cal->calParent = $h->horarioBase->id;
				foreach($h->horarioBase->horariosSemana as $hs)
					$cal->events = array_merge($cal->events, getPeriodos($hs,true));
			}
			//print_r(json_decode(getCal($h->horarioBase, false)));

			if(!$readOnly)
				$cal->nome = $h->nome;

			//if we want parent baseline to copy, return 1970-01-01 (there will surely be no exception that week)
			if($g_calParent>0)
				$start_ts = 0;
			else
				$start_ts = (int)($start/1000);

			$hs = $h->getHorarioSemanaByTimestamp($start_ts);

			if ($hs != null)
			{
				// Baseline
				if($hs->data=='')
				{
					$cal->events = array_merge($cal->events, getPeriodos($hs, $readOnly));
					$cal->baseline = true;
				}
				// HorarioSemana exception for the given week found
				else
				{
					$cal->events = getPeriodos($hs, $readOnly);
					$cal->baseline = false;
				}
			}

			//echo "<pre>";
			//print_r($h);
			//echo "</pre>";
		}
		return json_encode($cal);
	}

	function getPeriodos($horarioSemana, $readOnly = false)
	{
		global $start;
		global $nextid;

		$dateformat = 'Y-m-d';
		$timeformat = 'H:i:s';
		$ending = '.000';

		$events = array();

		foreach($horarioSemana->periodos as $p)
		{
			$e = new stdClass();
			$e->id = $nextid++;

			$base = $start/1000 + (($p->dia-1)*24*60*60);

			if($p->fim == '24:00')
				$p->fim = '23:59';

			$e->start = date($dateformat,$base).'T'.date($timeformat,strtotime($p->inicio)).$ending;
			$e->end = date($dateformat,$base).'T'.date($timeformat,strtotime($p->fim)).$ending;

			/*if($readOnly)
				$e->readOnly = $readOnly;*/

			$events[] = $e;
		}
		return $events;
	}

?>
