<?php
	
/* Classe de Gest�o de Lojas */

class HorarioPromocao extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function HorarioPromocao() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	

	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados2($id_loja, $id_servico)
	{
		$sql = "SELECT id_servico servico, id_loja loja, promocao_0, promocao_1,
						promocao_2, promocao_3, promocao_4, promocao_5, promocao_6
				FROM servicos_prestados
				WHERE id_servico=".$id_servico."
				AND id_loja= ".$id_loja.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
		
		return "ok";
	}
	
	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT id_servico servico, id_loja loja, promocao_0, promocao_1,
						promocao_2, promocao_3, promocao_4, promocao_5, promocao_6
				FROM servicos_prestados
				WHERE id_servico_prestado=".$id.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
		
		return "ok";
	}

	/*
		Fun��o de Inserção
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados)
	{
		for($i = 0; $i < 7 ; $i++){
			if($dados["promocao_".$i] == "")
				$dados["promocao_".$i] = "null";
			else
				$dados["promocao_".$i] = "'".$dados["promocao_".$i]."'";
		}
		
		$sql = "SELECT l.nome loja, s.nome servico 
				FROM servicos s, lojas l
				WHERE s.id_servico = ". $dados["servico"]."
				AND l.id_loja= ". $dados["loja"].";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$servico = $this->bd->obterValor($rs, "servico");
		$loja = $this->bd->obterValor($rs, "loja");
		
		$sql = "SELECT id_servico_prestado FROM servicos_prestados
				WHERE id_loja =".$dados["loja"]."
				AND id_servico = ".$dados["servico"].";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$id_servico_prestado = $this->bd->obterValor($rs, "id_servico_prestado");
		
		$sql = "UPDATE servicos_prestados SET promocao_0= ".$dados["promocao_0"].",
												promocao_1= ".$dados["promocao_1"].",
												promocao_2= ".$dados["promocao_2"].",
												promocao_3= ".$dados["promocao_3"].",
												promocao_4= ".$dados["promocao_4"].",
												promocao_5= ".$dados["promocao_5"].",
												promocao_6= ".$dados["promocao_6"]."
				WHERE id_servico_prestado = ".$id_servico_prestado." ; ";
		
		if($rs = $this->bd->executarSQL($sql))
		{
			$this->EscreveXMLSync($id_servico_prestado);
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Horário Promoções", $loja." - ".$servico);
			$objecto->fechar();				
			return "ok";
		}
		else
			return 0;

	}
	
	
	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id)
	{
		for($i = 0; $i < 7 ; $i++){
			if($dados["promocao_".$i] == "")
				$dados["promocao_".$i] = "null";
			else
				$dados["promocao_".$i] = "'".$dados["promocao_".$i]."'";
		}
		
		$sql = "SELECT l.nome loja, s.nome servico 
				FROM servicos s, lojas l, servicos_prestados sp
				WHERE s.id_servico = sp.id_servico
				AND l.id_loja = sp.id_loja
				AND sp.id_servico_prestado = ". $id .";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$servico = $this->bd->obterValor($rs, "servico");
		$loja = $this->bd->obterValor($rs, "loja");
		
		$sql = "UPDATE servicos_prestados SET promocao_0= ".$dados["promocao_0"].",
												promocao_1= ".$dados["promocao_1"].",
												promocao_2= ".$dados["promocao_2"].",
												promocao_3= ".$dados["promocao_3"].",
												promocao_4= ".$dados["promocao_4"].",
												promocao_5= ".$dados["promocao_5"].",
												promocao_6= ".$dados["promocao_6"]."
				WHERE id_servico_prestado = ".$id." ; ";

		if($rs = $this->bd->executarSQL($sql))
		{
			$this->EscreveXMLSync($id);
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Edição", "Horário Promoções", $loja." - ".$servico);
			$objecto->fechar();				
			return "ok";
		}
		else
			return 0;

	}
	
	
	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id)
	{		
		$numEntradas = count($id);
		$nomes = array();
		$sql = "SELECT s.nome servico, l.nome loja FROM servicos_prestados sp, lojas l, servicos s
				WHERE sp.id_servico = s.id_servico
				AND sp.id_loja = l.id_loja 
				AND ( ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_servico_prestado = " . $id[$i] . " OR ";
		$sql .= "id_servico_prestado = " . $id[0] . " );";

		if($rs = $this->bd->executarSQL($sql)) 
		{
			for($i = 0; $i < $numEntradas; $i++)
			{
				$this->bd->moverRegisto($rs,$i);
				array_push($nomes, $this->bd->obterValor($rs,"loja") ." - ". $this->bd->obterValor($rs,"servico"));
			}
		}
		else 
			return 0;

		$sql = "UPDATE servicos_prestados SET promocao_0= null,
												promocao_1= null,
												promocao_2= null,
												promocao_3= null,
												promocao_4= null,
												promocao_5= null,
												promocao_6= null 
				WHERE ";
		for($i = count($id); $i > 1; $i--)
			$sql .= "id_servico_prestado = ". $id[$i-1] . " OR ";
		$sql .= "id_servico_prestado = ". $id[0] . ";";
		
		if($rs = $this->bd->executarSQL($sql))
		{	
			$this->EscreveXMLSync($id);
			
			$objecto = new LogAccao();
			for($i = count($nomes)-1; $i >= 0; $i--){
				$rs = $objecto->Inserir("Remoção", "Horário Promoções", $nomes[$i]);
			}
			$objecto->fechar();			
			return "ok";
		}
		else
			return 0;	
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM servicos_prestados WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_servico_prestado = " . $id[$i] . " OR ";
		$sql .= "id_servico_prestado = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$documento = abreXMLSync();
		$raiz = $documento->firstChild;
		
		$loja = new Loja();
		$enderecos = array();
		
		$destinos = $documento->createElement("destinos");
		$raiz->appendChild($destinos);
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$enderecos = array_merge($enderecos, $loja->listaIpLojas($this->bd->obterValor($rs, "id_loja")));
			
			$no_servico_prestado = $documento->createElement("servicoPrestado");
			$raiz->appendChild($no_servico_prestado);
			
			$no_servico_prestado->setAttribute("id", $this->bd->obterValor($rs, "id_servico_prestado"));
			$no_servico_prestado->setAttribute("accao", "editar");
			
			$elemento = $documento->createElement("idServico");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_servico");
			$no_servico_prestado->appendChild($elemento);
			
			$elemento = $documento->createElement("idLoja");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_loja");
			$no_servico_prestado->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "promocao_0");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao0");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_1");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao1");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_2");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao2");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_3");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao3");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_4");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao4");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_5");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao5");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_6");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao6");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
		}
		
		$enderecos = array_unique($enderecos);
		
		for($i = 0 ; $i < count($enderecos) ; $i++){
			
			$loja = $documento->createElement("loja");
			$loja->nodeValue = $enderecos[$i];
			$destinos->appendChild($loja);
			
		}
		
		fechaXMLsync($documento);
		
	}
	
	
	/*
		Fun��o de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	
	function Listar()
	{
		$sql = "SELECT sp.id_servico_prestado, s.nome servico, l.nome loja
				FROM servicos s , lojas l, servicos_prestados sp
				WHERE (promocao_0 IS NOT NULL
						OR promocao_1 IS NOT NULL
						OR promocao_2 IS NOT NULL
						OR promocao_3 IS NOT NULL
						OR promocao_4 IS NOT NULL
						OR promocao_5 IS NOT NULL
						OR promocao_6 IS NOT NULL)
				AND sp.id_servico = s.id_servico
				AND sp.id_loja = l.id_loja ";
		
		if($_REQUEST["campo"] != "")		
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";	
		else	
			$sql .= "ORDER BY loja ";
			
		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";			


		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem', false) . " " . translate('word_schedule', false) ." ".  transalate('word_de', false) . "  ". translate("word_promotions", false) ." ".translate('word_registados_sistema', false) ."</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=horarios_promocao&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"]  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'><strong>". translate('word_pages', true)." </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
			echo "<td width='8'>&nbsp;</td>";
		}
			
		
		if (strcmp($_REQUEST["campo"],"loja") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>".translate('word_store', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=1'><div>".translate('word_store', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=loja&ordem=0'><div>".translate('word_store', true)."</div></a></td>";
			
		if (strcmp($_REQUEST["campo"],"servico") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0'><div>". translate("word_service", true) ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=1'><div>" . translate("word_service", true) ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=servico&ordem=0'><div>". translate("word_service", true) ."</div></a></td>";

		echo "<td width='135'>". translate('word_operations', true)."</td>								
				</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>";
			if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
				echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs,"id_servico_prestado") . "'/></td>";
			}
			echo	"<td>" . $this->bd->obterValor($rs, "loja") . "</td>
					<td>" . $this->bd->obterValor($rs, "servico") . "</td>
					<td>";
		if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=horarios_promocao&id=" . $this->bd->obterValor($rs,"id_servico_prestado") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=horarios_promocao&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST['ordem'] . "&id=" . $this->bd->obterValor($rs,"id_servico_prestado") . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
		} else {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=horarios_promocao&id=" . $this->bd->obterValor($rs,"id_servico_prestado") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
		}
			echo	"</td>							
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						 
				<tr>
					<td> 
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
	if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
		echo	"<tr>
					<td>
					<table>
						<tr>
							<td class='button_large'>
								<div onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
								<div onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
								<div onClick='removerMarcados(this);'>". translate('word_remove', true)."</div>
							</td>
							<td class='button_large' style='padding-left: 55px;' }>
								<a href='../promocoes/'><div>" .  translate('word_create', true)  . " Promo&ccedil;&atilde;o</div></a>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
	}
	
	echo	"</table>
		</form>";		
	}
			
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>