<?php  

/* devolve a lang do user ou do client ou a do sistema */
function getUserLang(){
	global $LANG;

	//$userLang = $_SESSION['sessao_user_lang'];
	$userLang = 'sistema';

	// a lang do user pode ser sistema ou cliente
	if($userLang == 'sistema'){
		$userLang = $LANG;
	}else if($userLang == 'cliente'){
		// se for a lang do cliente este pode ser a do sistema
		if($_SESSION['sessao_client_lang'] == 'sistema')
			$userLang = $LANG;
		else
			$userLang = $_SESSION['sessao_client_lang'];
	}
	if($userLang == '')
		$userLang = $LANG;

	return $userLang;
}

function getPathScriptJS($file){
	$lang = getUserLang();
	$pathFile = "../lang/$lang/scripts/$file";
	if(!file_exists($pathFile))
		return "../scripts/$file";
	return $pathFile;
}

function getAvailableLangs(){
	global $LANG_PATH;
	$langs = glob("$LANG_PATH*", GLOB_ONLYDIR);
	return array_map("basename", $langs);
}

function my_ucwords($word) {
	$newWord = ucwords($word);
	$lastWord = array();
	foreach(explode(" ",$newWord) as $word) {
		if (strlen($word) == '2')
			$word = strtolower($word);
		array_push($lastWord,$word);
	}
	return implode(" ", $lastWord);
}

function load() {
	global $LANG;
	global $LANG_PATH;
	global $session, $langArray;

	$messages = array();
	$lang = getUserLang();
	debug("loading files $lang ...");
	$files2load = glob($LANG_PATH . $lang . "/*.lang");
	foreach($files2load as $file){
		$messages = array_merge($messages, file($file));
	}
	foreach($messages as $message) {
		$info = explode(":",$message);
		$key = array_shift($info);
		
		if(!$session){
			$langArray[trim($key)] = trim(implode(':',$info));
		}else{
			$_SESSION['langArray'][trim($key)] = trim(implode(':',$info));
		}
	}
}

function setupURI() {
	global $DIR;
	$uri = $_SERVER['REQUEST_URI'];
	$posArgs = strpos($uri, '?');
	if($posArgs !== false)
		$uri = substr($uri, 0, $posArgs);
	$uri = str_replace("$DIR", "", $uri);
	if (!isset($uri[strlen($uri)-1]) || $uri[strlen($uri)-1] == '/')
		$uri .= "index.php";
	return $uri;
}

function translate($msg,$cap=false) {
	global $session, $langArray;

	if ((!isset($_SESSION['langArray']) || count($_SESSION['langArray']) == 0) 
		&& count($langArray) == 0) {
		// If for some reason the session and the translations were destroyed
		// after being loaded, we relado them here again into the $langArray
		load();
	}

	$uri = setupURI();
	if ($uri != '')
		$key = $uri . "/" . $msg;
	else
		$key = $msg;
	do {
		if($session){
			$value = @$_SESSION['langArray'][$key];
		}
		else if(isset($langArray[$key])){
			$value = $langArray[$key];
		}
		if (isset($value))
			return ($cap == 2)?my_ucwords($value):($cap?ucfirst($value):$value);
		$key = removeLevel($key);
	} while($key);
	return $msg;
}

function removeLevel($uri) {
	if (!strpos($uri,"/"))
		return false;
	$split = explode("/", $uri);
	if (count($split) != 1)
		unset($split[0]);
	return implode("/",$split);
}

@session_start();

$langArray = null;
$session = true;
if(!isset($_SESSION['sessao_lang_correcta']) || $_SESSION['sessao_lang_correcta'] == ''){
	$session = false;
}

if($session){
	// verify first time
	if(count($_SESSION['langArray']) == 0){
		load();
	} // else ignore
}else{
	// no session, just load to langArray
	$langArray = array();
	load();
}

?>
