// manipula as listas para a seleccao dos campos nas estatisticas

function estatisticasAddListElement(modulo, idObj, nameObj){
    return AddElementToListBox(modulo,idObj,nameObj);
}

function AddElementToListBox(modulo, idObj, nameObj){
	var table = getElem('list_table_' + modulo);
	var elem = getElem('item_' + modulo + '-' + idObj);
	if(elem == undefined){ // element ainda nao existe
		if(getElem('null_item_' + modulo))
			table.tBodies[0].removeChild(getElem('null_item_' + modulo));
		if(getElem('item_' + modulo + '-TODOS'))
			table.tBodies[0].removeChild(getElem('item_' + modulo + '-TODOS'));
		
		elem = estatisticasCreateListRow(modulo, idObj, nameObj);
		table.tBodies[0].appendChild(elem);
	}
}

function estatisticasCreateListRow(modulo, idObj, nameObj){
	var row = document.createElement('tr');
	row.setAttribute('id', 'item_' + modulo + '-' + idObj);
	
	var col = document.createElement('td');
	col.innerHTML = '<div style="overflow:hidden;">' + nameObj + '</div>';
	
	row.appendChild(col);
	
	if(!isNaN(idObj)){ // se e' numero entao mostra imagem...
		var colImg = document.createElement('td');
		colImg.setAttribute('style', 'text-align:right;');
		var img = document.createElement('img');
		img.setAttribute('src', '../img/buttons/button_delete.gif');
		img.setAttribute('style', 'cursor:pointer');
		img.setAttribute('onClick', 'estatisticasDelListElement(\'' + modulo + '\', \'' + idObj + '\')');
		
		colImg.appendChild(img);
		row.appendChild(colImg);
	}
	
	return row;
}

function estatisticasDelList(modulo) {
    var table = getElem('list_table_' + modulo);
    for(i=table.tBodies[0].childNodes.length;i>0;i--)
        table.tBodies[0].removeChild(table.tBodies[0].childNodes[0]);
}


function estatisticasDelListElement(modulo, idObj){
	var elem = getElem('item_' + modulo + '-' + idObj);
	if(elem != undefined){
		var table = getElem('list_table_' + modulo);
		table.tBodies[0].removeChild(elem);
		if(table.tBodies[0].childNodes.length <= 1)
			estatisticasAddListElement(modulo, 'TODOS', 'TODOS');
	}
}

function estatisticasAddListItem(selectBox){
	var idObj = selectBox.value;
	if(idObj == '')
		return;
	var modulo = selectBox.name;
	var label = selectBox.options[selectBox.selectedIndex].text;
	
	estatisticasAddListElement(modulo, idObj, label);
	selectBox.selectedIndex = 0;
}

// fill hidden input to send data to server!
function fillValuesFromMultipleSelect(nodeName){
	var arraySeleccoes = getSeleccoesFromListTable(nodeName);
	getElem('values_' + nodeName).value = arraySeleccoes;
}

function fillValuesFromMultipleSelectNew(nodeName, arraySeleccoes){
	getElem('values_' + nodeName).value = arraySeleccoes;
}

function fillValuesFromMultipleSelectNewFrequency(nodeName, arraySeleccoes){
	getElem(nodeName).value = arraySeleccoes;
}

// bloco de funcoes para enviar a pesquisa ao servidor e recebe-la
function realizaPesquisa(pagina, ordem, campoOrdem){
	showErrorMessage('');
	drawLoadMessage();
	
	var xmlDoc = makeXML2send(pagina, ordem, campoOrdem);
	sendXMLquery('request.php', XML.toString(xmlDoc), receiveListagem);
}

// apresenta mensagem de loading data...
function drawLoadMessage(){
	getElem('estatisticasDivPesquisa').innerHTML = "A carregar dados... Por favor aguarde!";
	getElem('estatisticasDivListagem').innerHTML = "";
}


// apresenta uma mensagem ao utilizador
function showErrorMessage(message){
	getElem('estatisticasDivPesquisa').innerHTML = "";
	getElem('estatisticasDivListagem').innerHTML = "";
	getElem('msg_erro').innerHTML = message;
}

var outputPdf = false;
// constroi uma string XML para ser enviada para o servidor como pesquisa a efectuar
function makeXML2send(pagina, ordem, campoOrdem){
	var xmlDoc = XML.newDocument('estatisticas');
	
	var attrInicio = xmlDoc.createAttribute('dataInicio');
	var attrFim = xmlDoc.createAttribute('dataFim');
	var attrPagina = xmlDoc.createAttribute('pagina');
	var attrOrdem = xmlDoc.createAttribute('ordenacao');
  var attrCampoOrdem = xmlDoc.createAttribute('campoOrdem');
	//var attrPdf = xmlDoc.createAttribute('pdf');
	
	attrInicio.value = document.forms[0].elements['dataInicio'].value;
	attrFim.value = document.forms[0].elements['dataFim'].value;
  attrPagina.value = pagina;
	attrOrdem.value = ordem;
  attrCampoOrdem.value = campoOrdem;
	//attrPdf.value = outputPdf;
	
	if(attrInicio.value == '' || attrFim.value == ''){
		// reporta erro
		showErrorMessage('Tem que definir um intervalo de datas!');
		return;
	}
	
	xmlDoc.firstChild.setAttributeNode(attrFim);
	xmlDoc.firstChild.setAttributeNode(attrInicio);
	xmlDoc.firstChild.setAttributeNode(attrPagina);
	xmlDoc.firstChild.setAttributeNode(attrOrdem);
	xmlDoc.firstChild.setAttributeNode(attrCampoOrdem);
	
	var attrNames;
	var attrValues;
	
	var modulos = new Array('clientes', 'canais', 'terminais', 'conteudos');
	var labelsModulo = new Array('cliente', 'canal', 'terminal', 'conteudo');
	for(var i in modulos){
		var arraySeleccoes = getSeleccoesFromListTable(modulos[i]);
		if(arraySeleccoes.length > 0){
			var moduloXML = XML.appendChildNode(xmlDoc, false, modulos[i], [], []);
			for(var n in arraySeleccoes){
				XML.appendChildNode(xmlDoc, moduloXML, labelsModulo[i], ['id'], [arraySeleccoes[n]]);
			}
		}
	}
	return xmlDoc;
}

function receiveListagem(){
	if (req.readyState == 4) {
		// only if "OK"
		if (req.status == 200) {
			if(outputPdf){
				self.location = './downloadPDF.php?file=' + req.responseText;
			}else{
				getElem('estatisticasDivPesquisa').innerHTML = "";
				getElem('estatisticasDivListagem').innerHTML = req.responseText;
			}
			outputPdf = false;
		} else {
			alert("Ocorreu um erro a carregar os dados XML:\n" +
				req.statusText);
		}
	}
}

function geraRelatorioEstatisticas(relCompleto){
	outputPdf = true;
	var xmlDoc = makeXML2send();
	var url = 'request.php?relComplete=';
	if(relCompleto)
		url += 'true';
	else
		url += 'false';
	sendXMLquery(url, XML.toString(xmlDoc), receiveListagem);
}

function getSeleccoesFromListTable(modulo){
	var seleccoes = new Array();
	var rows = getElem('list_table_' + modulo).tBodies[0].rows;
	
	for(var i = 0; i < rows.length; i++){
		var id = rows[i].id.split('-')[1];
		if(id != 'TODOS'){
			seleccoes[i] = id;
		}
	}
	return seleccoes;
}


function seleccoesToString(modulo) {
    seleccoes = getSeleccoesFromListTable(modulo);
    if (seleccoes == undefined || seleccoes.length == 0)
       return ""; 
    ret = "";
    for(i=0;i<seleccoes.length-1;i++)
        ret += seleccoes[i] + ",";
    ret += seleccoes[i];
    return ret;
}

// abre o popup dos detalhes
function openDetalhes(idConteudos, idTerminais, dataInicio, dataFim){
	var url = 'detalhes.php?id_conteudos=' + idConteudos + '&id_terminais=' + idTerminais + '&dataInicio=' + dataInicio + '&dataFim=' + dataFim;
	window.open(url ,'detalhes_' + idConteudos + '_' + idTerminais + '_' + dataInicio + '_' + dataFim,"width=480,height=450,resizable=yes,scrollbars=yes,status=no,channelmode=yes");
}


// devolve um objecto sobre o qual se envia XML
function getXMLRequester(){
	var request = false;
	// branch for native XMLHttpRequest object
	if (window.XMLHttpRequest) {
		try {
			request = new XMLHttpRequest();
		} catch(e) {
			request = false;
		}
	// branch for IE/Windows ActiveX version
	} else if (window.ActiveXObject) {
		isIE = true;
		try {
			request = new ActiveXObject("Microsoft.XMLHTTP");
		} catch(e) {
			request = false;
		}
	}
	return request;
}

// objecto para realizar as chamadas ao servidor
var req = false;

// envia um XML para o servidor a pedir os resultados na pesquisa efectuada
function sendXMLquery(url2send, xml2send, onReceiveFunction){
	req = getXMLRequester();
	
	if(req){
		req.onreadystatechange = onReceiveFunction;
		req.open("POST", url2send, true);
		req.setRequestHeader("Content-Type", "text/html; charset=UTF-8");
		req.send(xml2send);
	}
}

function seleccionaConteudosEstatisticas(seleccoes){
    idConteudos = seleccoes.split(",");
    for(var i = 0; i < idConteudos.length; i++){
        if(idConteudos[i] != ''){
            req = new XMLHttpRequest();
            req.open("GET", "../conteudos/getContentInfo.php?id=" + idConteudos[i], false);
            req.send("");
            ret = req.responseText.split("&");
            estatisticasAddListElement('conteudos', idConteudos[i], ret[1]);
        }
    }
}

