<?php

/* Classe de Gest�o dos Locais de Trabalho de um Colaborador */

class LocalColaborador extends AcessoBD
{
    var $bd;

    /*
	 * Construtor da classe
	 *
	 * 0 = Erro da BD
    */
    function LocalColaborador()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
	 * Fun��o de inser��o
	 *
	 * 0 = Erro da BD
	 * 5 = Erro Existente
	 * true = Sucesso	
    */
    function Inserir($dados, $id, $documento)
    {

        if(!is_array($dados))
        {
            $temp=$dados;
            $dados = array();
            $dados[0] = $temp;
        }

        for( $i = 0 ; $i < count($dados) ; $i++ )
        {
            $sql = "INSERT INTO local_colaborador(id_local, id_colaborador)
					VALUES (" . $dados[$i] . "," . $id . ");";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
        }
        return "ok";
    }

    /*
	 * Fun��o de leitura de dados
	 * 	
	 * 0 = Erro da BD
	 * true = Sucesso	
    */
    function LerDados($id="")
    {
        $sql = "SELECT id_loja, nome
                FROM lojas 
                WHERE id_loja > 0;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);
            
        $num_registos = $this->bd->obterNumRegistos($rs);
        
        $lojas = array();
        $lojas["nome"] = array();
        $lojas["id"] = array();
            
        for ($i = 0; $i < $num_registos ; $i++){
            //$this->bd->moverRegisto($rs, $i);
            
            $lojas["nome"][$i] = $dados[$i]["nome"]; 
            $lojas["id"][$i] = $dados[$i]["id_loja"]; 
        }

        $_SESSION["sessao_campos"]["lojas"] = $lojas;
        
        $sql = "SELECT id_local
                FROM local_colaborador
                WHERE id_colaborador = ".$id.";";


        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
            
        
        $locais_trabalho = array();
        $dados2 = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados2, $row);

        $num_registos = $this->bd->obterNumRegistos($rs);
        $locais_rel = array();       
        for ($i = 0; $i < $num_registos ; $i++){
            $locais_trabalho[$i] = $dados2[$i]["id_local"];
        }

        $_SESSION["sessao_campos"]["locais_trabalho"]= $locais_trabalho;
        
        return "ok";

       
    }

    function LerDados2($id="")
    {
        $sql = "SELECT id_loja, nome
				FROM lojas 
				WHERE id_loja > 0;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $num_registos = $this->bd->obterNumRegistos($rs);
        
        $lojas = array();
        $lojas["nome"] = array();
        $lojas["id"] = array();

        for ($i = 0; $i < $num_registos ; $i++)
        {
            $this->bd->moverRegisto($rs, $i);

            $lojas["nome"][$i] = $this->bd->obterValor($rs, "nome");
            $lojas["id"][$i] = $this->bd->obterValor($rs, "id_loja");
        }

        $_SESSION["sessao_campos"]["lojas"] = $lojas;

        if ($id)
        {
            $aux = array();
            if (is_array($id))
            {
                $aux = $id;
            }
            else
            {
                array_push($aux, $id);
            }

            $sql = "SELECT id_local
                                    FROM local_colaborador
                                    WHERE id_colaborador in (".implode(",", $aux).");";

            if(!$rs = $this->bd->executarSQL($sql))
                return 0;

            $num_registos = $this->bd->obterNumRegistos($rs);
            $locais_trabalho = array();

            for ($i = 0; $i < $num_registos ; $i++)
            {
                $this->bd->moverRegisto($rs, $i);
                $locais_trabalho[$i] = $this->bd->obterValor($rs, "id_local");
            }

            $_SESSION["sessao_campos"]["locais_trabalho"] = $locais_trabalho;
        }

        return "ok";
    }

    /*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
    */
    function Editar($dados, $id, $documento)
    {

        if(!is_array($dados))
        {
            $temp=$dados;
            $dados = array();
            $dados[0] = $temp;
        }

        if (!is_array($id))
        {
            $id = array($id);
        }

        $sql = "delete from local_colaborador where id_colaborador in (".implode(", ", $id).")";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        foreach ($id as $id)
        {
            if (count($dados))
            {
                $novos_locais_values = implode(", $id), (", $dados);
                $sql = "INSERT INTO local_colaborador VALUES (" . $novos_locais_values . ", $id);";
                if (!$rs = $this->bd->executarSQL($sql)) return 0;
            }
        }

//        //file_put_contents("/tmp/debug.txt" , $dados[0]."\n" , FILE_APPEND);
//        $sql = "SELECT id_local FROM local_colaborador WHERE id_colaborador in (".implode(", ", $id).");";
//        debug($sql);
//        if(!$rs = $this->bd->executarSQL($sql))
//            return 0;
//
//        // obtem os locais de trabalho a apagar,
//        // e quais os que permanecem
//        $num_registos = $this->bd->obterNumRegistos($rs);
//        $obsoletos = array();
//        $existentes = array();
//        for ($i = 0; $i < $num_registos ; $i++)
//        {
//            $this->bd->moverRegisto($rs, $i);
//            $local = $this->bd->obterValor($rs, "id_local");
//            if (in_array($local, $dados))
//            {
//                array_push($existentes, $local);
//            } else
//            {
//                // o local foi desassociado
//                array_push($obsoletos, $local);
//            }
//        }
//        // apaga os locais que foram desassociados do colaborador, caso existam
//        if (count($obsoletos))
//        {
//            $sql = "DELETE FROM local_colaborador
//							WHERE id_colaborador in (".implode(", ", $id).") AND id_local IN ("
//                    . implode(",", $obsoletos) . ");";
//            debug($sql);
//            if(!$rs = $this->bd->executarSQL($sql))
//                return 0;
//        }
//        // filtra os novos locais
//        $novos_locais = array_diff($dados, $existentes);
//        // insere os novos servicos
//
//        foreach ($id as $id)
//        {
//            if (count($novos_locais))
//            {
//                $novos_locais_values = implode(", $id), (", $novos_locais);
//                $sql = "INSERT INTO local_colaborador VALUES (" . $novos_locais_values . ", $id);";
//                debug($sql);
//                if(!$rs = $this->bd->executarSQL($sql))
//                    return 0;
//            }
//        }

        return "ok";
    }

    /*
	 * Fun��o de remo��o dos locais associados a um colaborador.
    */
    function Remover($id)
    {
    }

    /*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao, $documento)
    {

    }



    /*
		Destrutor da classe
		
		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }
    
    
}
?>
