<?php

/* Classe de Gest�o de Empregados */

class Loja extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Loja()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        //$this->bd = new AcessoBD();
        //return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;


    }

    function GetLojas($id=0)
    {
        debug($id);
        if (!is_array($id))
        {
            $aux = array();
            if ($id) array_push($aux, $id);
            $id = $aux;
        }
        debug($id);


        $sql = "select * from lojas";
        if (count($id)) $sql .= " WHERE id_loja in (".implode(",", $id).")";
        $sql .= " order by nome";

        return $this->bd->getRows($sql);
    }

    /*
		Fun��o de inser��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function obterDados()
    {
        $sql = "SELECT * FROM lojas;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $num = $this->bd->obterNumRegistos($rs);

        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);

        $lojas = array();      

        for($i=0; $i < $num; $i++)
        {
            //$this->bd->moverRegisto($rs , $i);
            $lojas[$i] = $dados[$i]["id_loja"]; //$this->bd->obterValor($rs,"id_loja");
        }

        return $lojas;

    }
    function Inserir($dados)
    {
        if(array_key_exists("previsao_atendimento", $dados) && $dados["previsao_atendimento"] == "on")
            $dados["previsao_atendimento"] = 1;
        else
            $dados["previsao_atendimento"] = 0;

        if(array_key_exists("imprimir_nome", $dados) && $dados["imprimir_nome"] == "on")
            $dados["imprimir_nome"] = 1;
        else
            $dados["imprimir_nome"] = 0;

        if(array_key_exists("imprimir_morada", $dados) && $dados["imprimir_morada"] == "on")
            $dados["imprimir_morada"] = 1;
        else
            $dados["imprimir_morada"] = 0;

        if(array_key_exists("imprimir_telefone", $dados) && $dados["imprimir_telefone"] == "on")
            $dados["imprimir_telefone"] = 1;
        else
            $dados["imprimir_telefone"] = 0;

        if(array_key_exists("imprimir_email", $dados) && $dados["imprimir_email"] == "on")
            $dados["imprimir_email"] = 1;
        else
            $dados["imprimir_email"] = 0;

        if(array_key_exists("morada", $dados) && $dados["morada"] != "")
            $dados["morada"] = "'".$dados["morada"]."'";
        else
            $dados["morada"] = "null";

        if(array_key_exists("telefone", $dados) && $dados["telefone"] != "")
            $dados["telefone"] = "'".$dados["telefone"]."'";
        else
            $dados["telefone"] = "null";

        if(array_key_exists("email", $dados) && $dados["email"] != "")
            $dados["email"] = "'".$dados["email"]."'";
        else
            $dados["email"] = "null";

        if(array_key_exists("endereco", $dados) && $dados["endereco"] == "")
            $dados["endereco"] = "null";

        @$sql = "INSERT INTO lojas (nome, identificador, morada, telefone, email, horario, previsao_atendimento,
									imprimir_nome, imprimir_morada, imprimir_telefone,
									imprimir_email, endereco) VALUES ('"
                . $dados["nome"] . "', '"
                . $dados["identificador"] . "', "
                . $dados["morada"] . ","
                . $dados["telefone"] . ","
                . $dados["email"] . ","
                . $dados["horario"] .","
                . $dados["previsao_atendimento"] .","
                . $dados["imprimir_nome"] .","
                . $dados["imprimir_morada"] .","
                . $dados["imprimir_telefone"] .","
                . $dados["imprimir_email"] .",'"
                . $dados["endereco"] . "');";


        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $sql = "SELECT MAX(id_loja) as max FROM lojas;";

        $res = $this->bd->getRows($sql);
        $id = $res[0]["max"];

        //if(!$rs = $this->bd->executarSQL($sql))
        //    return 0;
        //$id = $this->bd->obterValor($rs,0);

//        $documento = abreXMLSync();
//        $this->EscreveXMLSync($id, "inserir", $documento);

        $lojas_entidades = new EntidadeAssociada();
        if (isset($dados["entidades_trabalho"])) {
          // only try to associate entities to a local if they were actually provided
          $resultado = $lojas_entidades->Inserir($dados["entidades_trabalho"], $id);
        }
        else {
          $resultado = true;
        }
//        fechaXMLsync($documento);

        $usrLoc = new UtilizadorLoja();
        $usrLoc->Inserir($_SESSION["sessao_id_utilizador"], $id);

        array_push($_SESSION["loja"], $id);



        /* id_hist */
        $sql = "insert into id_hist (id, name, type) values (
                    ".$id.",
                    '".$dados["nome"]."',
                    'loja')";
        if(!$rs = $this->bd->executarSQL($sql))
        {
            return 0;
        }

        if (!$_SESSION["super_user"])
        {
            $usr = new Utilizador();
            $su = $usr->GetSuperusers();

            foreach ($su as $u)
            {
                $usrLoc->Inserir($u, $id);
            }

            $usr->fechar();
        }

        $usrLoc->Fechar();

        if($resultado)
        {
            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Loja", $dados["nome"]);
            $objecto->fechar();
            $lojas_entidades->Fechar();
            return "ok";
        }
        else
        {
            $lojas_entidades->Fechar();
            return 0;
        }
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {

        $sql = "SELECT * FROM lojas WHERE id_loja = " . $id . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);

        $lojas_entidades = new EntidadeAssociada();
        $resultado = $lojas_entidades->LerDados($id);
        $lojas_entidades->Fechar();

        return $resultado;
    }

    /*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {

		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array("local"=>"Local","entidade" => "Entidade", "nome"=>"Nome", "identificador" => "Identificador", "nome_ecra"=>"Nome Ecrã");

        if(array_key_exists("previsao_atendimento", $dados) && $dados["previsao_atendimento"] == "on")
            $dados["previsao_atendimento"] = 1;
        else
            $dados["previsao_atendimento"] = 0;

        if(array_key_exists("imprimir_nome", $dados) && $dados["imprimir_nome"] == "on")
            $dados["imprimir_nome"] = 1;
        else
            $dados["imprimir_nome"] = 0;

        if(array_key_exists("imprimir_morada", $dados) && $dados["imprimir_morada"] == "on")
            $dados["imprimir_morada"] = 1;
        else
            $dados["imprimir_morada"] = 0;

        if(array_key_exists("imprimir_telefone", $dados) && $dados["imprimir_telefone"] == "on")
            $dados["imprimir_telefone"] = 1;
        else
            $dados["imprimir_telefone"] = 0;

        if(array_key_exists("imprimir_email", $dados) && $dados["imprimir_email"] == "on")
            $dados["imprimir_email"] = 1;
        else
            $dados["imprimir_email"] = 0;

        if(array_key_exists("morada", $dados) && $dados["morada"] != "")
            $dados["morada"] = "'".$dados["morada"]."'";
        else
            $dados["morada"] = "null";

        if(array_key_exists("telefone", $dados) && $dados["telefone"] != "")
            $dados["telefone"] = "'".$dados["telefone"]."'";
        else
            $dados["telefone"] = "null";

        if(array_key_exists("email", $dados) && $dados["email"] != "")
            $dados["email"] = "'".$dados["email"]."'";
        else
            $dados["email"] = "null";

        if(array_key_exists("endereco", $dados) && $dados["endereco"] == "")
            $dados["endereco"] = "null";

        @$sql = "UPDATE lojas SET
								nome = '" . $dados["nome"] . "',
								identificador = '" . $dados["identificador"] . "',
								morada = " . $dados["morada"] . ",
								horario = ". $dados["horario"] .",
								telefone = ". $dados["telefone"].",
								email = ". $dados["email"].",
								imprimir_nome = ".$dados["imprimir_nome"].",
								imprimir_morada = ".$dados["imprimir_morada"].",
								imprimir_telefone = ".$dados["imprimir_telefone"].",
								imprimir_email = ".$dados["imprimir_email"].",
								previsao_atendimento = ". $dados["previsao_atendimento"] .",
								endereco = '".$dados["endereco"]."'
							WHERE id_loja = " . $id . " ;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        /* id_hist */
        $sql = "update id_hist
                set name='".$dados["nome"]."'
                where id=".$id."
                and type='loja'";
        if (!$rs = $this->bd->executarSQL($sql))
        {
            return 0;
        }

        $documento = abreXMLSync();
        $this->EscreveXMLSync($id, "editar", $documento);
        //~ file_put_contents("/tmp/debug.txt" , "\ndados entidades   ".$dados["entidades_trabalho"] , FILE_APPEND);
        $lojas_entidades = new EntidadeAssociada();
        $resultado = @$lojas_entidades->Editar($dados["entidades_trabalho"],$id, $documento) ;
        
        fechaXMLsync($documento);

        //debug("res::\n" . $resultado);

        if($resultado)
        {
            $objecto = new LogAccao();

            $diff = my_array_diff_values($oldInfo,$newInfo,$labels);

            // Faz o mesmo para as entidades
            $locaisOld = array();
            $EntidadesOld = @$oldInfo["lojas_entidades"];
            $locaisNew = array();
            $EntidadesNew = @$dados['entidades_trabalho'];
            $diffServicos = my_array_diff_values4($locaisOld,$locaisNew,$EntidadesOld,$EntidadesNew);

            $msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
            $msg .= action_msg_info($diff,false,'lojas');
            $msg .= action_msg_info($diffServicos,false,'lojas');
            $msg .= "</table>";

            $rs = $objecto->Inserir("Edição", "Loja", $msg);
            $objecto->fechar();
            $lojas_entidades->Fechar();
            return "ok";
        }
        else
        {
            $lojas_entidades->Fechar();
            return 0;
        }
    }

    function existemEcrasAssociados($id)
    {
        $sql = "select count(id_ecra) as n from ecra where id_loja='" . $id . "'";
        if($rs = $this->bd->executarSQL($sql))
        {
            return $this->bd->obterValor($rs,"n");
        }
        else
            return 0;
    }


    function existemDispensadoresAssociados($id)
    {
        $sql = "select count(id_dispensador) as n from dispensador where id_loja='" . $id . "'";
        if($rs = $this->bd->executarSQL($sql))
        {
            return $this->bd->obterValor($rs,"n");
        }
        else
            return 0;
    }


    function existemBalcoesAssociados($id)
    {
        $sql = "select count(id_balcao) as n from balcoes where id_loja='" . $id . "'";
        if($rs = $this->bd->executarSQL($sql))
        {
            return $this->bd->obterValor($rs,"n");
        }
        else
            return 0;
    }


    /*
		Fun��o de remo��o

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {
        for ($i=0; $i<count($id); $i++)
        {
            if ($this->existemEcrasAssociados($id[$i]) || $this->existemDispensadoresAssociados($id[$i]) || $this->existemBalcoesAssociados($id[$i])) return 13;
        }

        /*
        lojas
        lojas_entidades
        utilizadores_lojas
        local_colaborador
        */

        $documento = abreXMLSync();
        $this->EscreveXMLSync($id, "remover", $documento);
        fechaXMLsync($documento);

        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT nome FROM lojas WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_loja = " . $id[$i] . " OR ";
        $sql .= "id_loja = " . $id[0] . ";";

        if($rs = $this->bd->executarSQL($sql))
        {
            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs,$i);
                array_push($nomes, $this->bd->obterValor($rs,"nome"));
            }
        }
        else
            return 0;

        $sql = "delete from local_colaborador where id_local='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_local='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from utilizadores_lojas where id_loja='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_loja='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from lojas_entidades where id_loja='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_loja='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from lojas where id_loja='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_loja='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $objecto = new LogAccao();
        for($i = count($nomes)-1; $i >= 0; $i--)
        {
            $rs = $objecto->Inserir("Remoção", "Loja", $nomes[$i]);
        }
        $objecto->fechar();
        return "ok";


        //~ $sql = "DELETE FROM lojas WHERE ";
        //~ for($i = count($id); $i > 1; $i--)
        //~ $sql .= "id_loja = ". $id[$i-1] . " OR ";
        //~ $sql .= "id_loja = ". $id[0] . ";";

        //~ if($rs = $this->bd->executarSQL($sql))
        //~ {
        //~ $objecto = new LogAccao();
        //~ for($i = count($nomes)-1; $i >= 0; $i--){
        //~ $rs = $objecto->Inserir("Remoção", "Loja", $nomes[$i]);
        //~ }
        //~ $objecto->fechar();
        //~ return "ok";
        //~ }
        //~ else
        //~ return 0;
    }

    /*
		Constroi um array com os endere�os IP
		de todas as lojas registadas no sistema
    */

    function listaIpLojas($id = null)
    {

        $sql = "SELECT endereco FROM lojas ";

        if(!is_null($id))
            $sql .= "WHERE id_loja = ".$id;

        $sql .= ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;


        $enderecos = array();
        $numRegistos = $this->bd->obterNumRegistos($rs);
        for($i=0 ; $i < $numRegistos ; $i++)
        {
            $this->moverRegisto($rs, $i);
            array_push($enderecos, $this->obterValor($rs, "endereco"));
        }

        return $enderecos;
    }

    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao, $documento)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM lojas WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_loja = " . $id[$i] . " OR ";
        $sql .= "id_loja = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $raiz = $documento->firstChild;

        $loja = new Loja();
        $enderecos = array();

        $destinos = $documento->createElement("destinos");
        $raiz->appendChild($destinos);

        $numEntradas = $this->bd->obterNumRegistos($rs);

        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            //$this->bd->moverRegisto($rs, $i);

            $enderecos = array_merge($enderecos, $loja->listaIpLojas($dados[$i]["id_loja"] /*$this->bd->obterValor($rs, "id_loja")*/));

            $no_loja = $documento->createElement("loja");
            $raiz->appendChild($no_loja);

            $no_loja->setAttribute("id", $dados[$i]["id_loja"] /*$this->bd->obterValor($rs, "id_loja")*/);
            $no_loja->setAttribute("accao", $accao);

            $elemento = $documento->createElement("nome");
            $elemento->nodeValue = $dados[$i]["nome"] /*$this->bd->obterValor($rs, "nome")*/;
            $no_loja->appendChild($elemento);

            $valor =  $dados[$i]["morada"] /*$this->bd->obterValor($rs, "morada")*/;
            if(isset($valor))
            {
                $elemento = $documento->createElement("morada");
                $elemento->nodeValue = $valor;
                $no_loja->appendChild($elemento);
            }

            $elemento = $documento->createElement("idHorarioLoja");
            $elemento->nodeValue = $dados[$i]["horario"] /*$this->bd->obterValor($rs, "horario")*/;
            $no_loja->appendChild($elemento);

            $elemento = $documento->createElement("previsaoAtendimento");
            $elemento->nodeValue = $dados[$i]["previsao_atendimento"] /*$this->bd->obterValor($rs, "previsao_atendimento")*/;
            $no_loja->appendChild($elemento);

            $valor = $dados[$i]["telefone"] /*$this->bd->obterValor($rs, "telefone")*/;
            if(isset($valor))
            {
                $elemento = $documento->createElement("telefone");
                $elemento->nodeValue = $valor;
                $no_loja->appendChild($elemento);
            }

            $valor = $dados[$i]["email"] /*$this->bd->obterValor($rs, "email")*/;
            if(isset($valor))
            {
                $elemento = $documento->createElement("email");
                $elemento->nodeValue = $valor;
                $no_loja->appendChild($elemento);
            }

            $elemento = $documento->createElement("imprimirNome");
            $elemento->nodeValue = $dados[$i]["imprimir_nome"]  /*$this->bd->obterValor($rs, "imprimir_nome")*/;
            $no_loja->appendChild($elemento);

            $elemento = $documento->createElement("imprimirMorada");
            $elemento->nodeValue = $dados[$i]["imprimir_morada"]  /*$this->bd->obterValor($rs, "imprimir_morada")*/;
            $no_loja->appendChild($elemento);

            $elemento = $documento->createElement("imprimirTelefone");
            $elemento->nodeValue = $dados[$i]["imprimir_telefone"]  /*$this->bd->obterValor($rs, "imprimir_telefone")*/;
            $no_loja->appendChild($elemento);

            $elemento = $documento->createElement("imprimirEmail");
            $elemento->nodeValue = $dados[$i]["imprimir_email"]  /*$this->bd->obterValor($rs, "imprimir_email")*/;
            $no_loja->appendChild($elemento);

            $elemento = $documento->createElement("enderecoIp");
            $elemento->nodeValue = $dados[$i]["endereco"]  /*$this->bd->obterValor($rs, "endereco")*/;
            $no_loja->appendChild($elemento);
        }

        $enderecos = array_unique($enderecos);

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {

            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);

        }

        if($accao == "inserir")
            $this->initLojaXML($enderecos);

    }

    function initLojaXML($enderecos)
    {



        $sql = "SELECT id_entidade FROM entidades;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id_entidade"));
        }

        $servico = new Servico();
        $servico->EscreveXMLSync($ids, "inserir", $enderecos);

        $sql = "SELECT id FROM horario;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id"));
        }

        $horario = new HorarioLoja();
        $horario->EscreveXMLSync($ids, "inserir", $enderecos);

        $sql = "SELECT id_empregado FROM empregados;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id_empregado"));
        }

        $empregado = new Empregado();
        $empregado->EscreveXMLSync($ids, "inserir", $enderecos);

        $sql = "SELECT id_promocao FROM promocao;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id_promocao"));
        }

        $promocao = new Promocao();
        $promocao->EscreveXMLSync($ids, "inserir", $enderecos);

        $documento = abreXMLSync();
        $tipo = new Tipo();

        $sql = array("SELECT id_tipos_impressora id_tipo, nome_tabela
				FROM tipos_impressora WHERE id_tipos_impressora > 0;",

                "SELECT id_tipos_dispensador id_tipo, nome_tabela
				FROM tipos_dispensador WHERE id_tipos_dispensador > 0;",

                "SELECT id_tipos_terminal id_tipo, nome_tabela
				FROM tipos_terminal WHERE id_tipos_terminal > 0;");

        $modulo = array("impressora", "dispensador", "terminal");

        for($k = 0 ; $k < count($sql) ; $k++)
        {

            if(!$rs = $this->bd->executarSQL($sql[$k]))
                return 0;

            $numEntradas = $this->bd->obterNumRegistos($rs);

            for($i = 0; $i < $numEntradas; $i++)
            {
                $this->bd->moverRegisto($rs, $i);

                $dados = array();
                $dados["nomes"] = array();
                $dados["tipos"] = array();
                $dados["refs"] = array();
                $dados["obrigs"] = array();


                $sql_tabela = "SHOW FULL COLUMNS FROM ".$this->bd->obterValor($rs, "nome_tabela").";";

                if(!$rs_tabela = $this->bd->executarSQL($sql_tabela))
                    return 0;

                $numCampos = $this->bd->obterNumRegistos($rs_tabela);
                for($j = 0 ; $j < $numCampos ; $j++ )
                {
                    $this->bd->moverRegisto($rs_tabela, $j);

                    $comentario = $this->obterValor($rs_tabela, "Comment");

                    if($comentario == "")
                        continue;

                    $args = construcaoVector($comentario, ",");

                    array_push($dados["nomes"], $args[0]);
                    array_push($dados["tipos"], $args[3]);
                    array_push($dados["obrigs"], $args[5]);
                    if($args[3] == 16)
                        array_push($dados["refs"], $args[7]);
                }

                $ids = array($this->bd->obterValor($rs, "id_tipo"));
                $tipo->EscreveXMLSync($ids, "inserir", $documento, $modulo[$k], $dados, $enderecos);
                $enderecos = array();

            }
        }


        $sql = "SELECT id_tipos_teclado FROM tipos_teclado WHERE id_tipos_teclado > 1;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id_tipos_teclado"));
        }

        $tipo_teclado = new TipoTeclado();
        $tipo_teclado->EscreveXMLSync($ids, "inserir", $documento);

        $sql = "SELECT id_mapa_teclado FROM mapa_teclado WHERE id_mapa_teclado > 15;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $ids = array();
        $numEntradas = $this->bd->obterNumRegistos($rs);

        for($i = 0; $i < $numEntradas; $i++)
        {
            $this->bd->moverRegisto($rs, $i);
            array_push($ids, $this->obterValor($rs, "id_mapa_teclado"));
        }

        $mapa_teclado = new MapaTeclado();
        $mapa_teclado->EscreveXMLSync($ids, "inserir", $documento);

        fechaXMLsync($documento);

        $sql = "SELECT id_teclado, nome_tabela FROM teclado, tipos_teclado
				WHERE tipo_teclado = id_tipos_teclado ORDER BY nome_tabela;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $numEntradas = $this->bd->obterNumRegistos($rs);
        $teclado = new Teclado();

        for($i = 0; $i < $numEntradas; )
        {
            $ids = array();
            $tabela = $this->bd->obterValor($rs, "nome_tabela");

            for(; $i < $numEntradas ; $i++)
            {
                $this->bd->moverRegisto($rs, $i);

                if($tabela != $this->bd->obterValor($rs, "nome_tabela"))
                    break;

                array_push($ids, $this->obterValor($rs, "id_teclado"));
            }

            $teclado->EscreveXMLSync($ids, "inserir", $tabela, $enderecos);
        }

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
        $sql = "SELECT l.id_loja, l.nome, l.identificador
				FROM lojas l ";

        if($_SESSION["super_user"] == 0)
        {
            $sql .= " WHERE (l.id_loja = ".$_SESSION["loja"][0];
            for($i=1; $i<count($_SESSION["loja"]);$i++)
                $sql .= " OR l.id_loja = ".$_SESSION["loja"][$i];
            $sql .= ") ";

        }
        if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
            $sql .= "ORDER BY l." . $_REQUEST["campo"] . " ";
        else
            $sql .= "ORDER BY l.nome ";

        if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
            $sql .= "DESC";
        else
            $sql .= "ASC";


        global $ERROS, $N_REGISTOS;
        if(!$rs = $this->bd->executarSQL($sql))
        {
            echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
            return;
        }

        $lojas = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($lojas, $row);

        $n = 1;
        $pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];
        $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
        $numPaginas = 1; // n�mero de p�ginas de registos
        $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

        // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
        if(array_key_exists("pagina", $_REQUEST) && intVal($_REQUEST["pagina"]) > 0 && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
            $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem')." ".translate('word_locals')." ".translate('word_registados_sistema') ."</div>";
            return;
        }

        // calculo do n�mero de p�ginas de registos
        if($numTuplos % $numRegPag == 0)
            $numPaginas = $numTuplos / $numRegPag;
        else
            $numPaginas = (int) ($numTuplos / $numRegPag + 1);

        echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=lojas&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "")  . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "")  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";
            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
            <tr>
                <td class='button_page' colspan='6'>";

                if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
                {
                    $pagAnterior = $_REQUEST["pagina"] - 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                }
                else
                {
                    $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
                    $TEMPLATE_navigation .= "<div> < </div>";
                }

                while($n <= $numPaginas)
                {
                    if($n == $_REQUEST["pagina"])
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                    else
                        $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
                    $n++;
                }

                $n = ($pagina - 1)*$numRegPag;
                $incremento = $n;

                if($pagina < $numPaginas)
                {
                    $pagPosterior = $_REQUEST["pagina"] + 1;
                    $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
                }
                else
                {
                    if($numTuplos % $numRegPag != 0)
                        $numRegPag = $numTuplos % $numRegPag;
                    $TEMPLATE_navigation .= "<div> > </div>";
                }

        $TEMPLATE_navigation .= "		</td>
        </tr>";

        echo "<tr class='column_row'>";

        if ( $_SESSION["sessao_perms"]["perm_lojas"] == 2 )
        {
            echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
        }

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

        if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"identificador") == 0)
            if ($_REQUEST["ordem"] == 1)
                echo "<td width='100' class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>". translate('word_identificador', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
            else
                echo "<td width='100' class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=1'><div>". translate('word_identificador', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
        else
            echo "<td width='100' class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>". translate('word_identificador', true)."</div></a></td>";

        echo "<td width='155'>". translate('word_operations', true)."</td>
				</tr>";



        //while($n < ($numRegPag + $incremento))
        //{
        //    $this->bd->moverRegisto($rs,$n);
        for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {
            echo"<tr class='form-data-tr'>";
            if ( $_SESSION["sessao_perms"]["perm_lojas"] == 2 )
            {
              echo "<td class='form-data-td'>
                      <label class='custom-check-container'>
                          <input name='grupo' type='checkbox' value='" . $lojas[$i]["id_loja"] /*$this->bd->obterValor($rs,"id_loja")*/ . "' onClick='selectEntireRow(this)'>
                          <span class='custom-checkmark'></span>
                      </label>
                  </td>";

            }
            echo "<td class='form-data-td'>" . $lojas[$i]["nome"] /*$this->bd->obterValor($rs, "nome")*/ . "</td>";
            echo "<td class='form-data-td'>" . $lojas[$i]["identificador"] /*$this->bd->obterValor($rs, "identificador")*/ . "</td>";
            echo "<td class='form-data-td'>";
              if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_lojas"] == 2 )
              {
                  echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=lojas&id=" . $lojas[$i]["id_loja"] /*$this->bd->obterValor($rs,"id_loja")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
  						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=lojas&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] :"") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "&id=" . $lojas[$i]["id_loja"] /*$this->bd->obterValor($rs,"id_loja")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
              } else
              {
                  echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=lojas&id=" . $lojas[$i]["id_loja"] /*$this->bd->obterValor($rs,"id_loja")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
              }
        echo	"</td>
				</tr>";

            //$n++;
        }
        //#3 - Re-design present NAVIGATION after table
        echo $TEMPLATE_navigation;

        echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";

            echo	"<tr>
					<td>
					<table>
						<tr>
							<td class='button'>";
          if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_entidade"] == 2) {
            echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
          }
        if ( $_SESSION["sessao_perms"]["perm_lojas"] == 2 )
        {
            echo "<div class='button-thin-green' onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
  								<div class='button-thin-green' onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
                  <div class='button-thin-green' onClick='removerMarcados(this);'>". translate('word_remove_selected', true)."</div>";
        }
        echo "</td>
							<td class='button'>";
        if ( $_SESSION["sessao_perms"]["perm_horarios"] == 2 )
        {
            echo "<a href='../horarios/'><div class='button-thin-green'>" .  translate('word_create', true)  . "  ". translate("word_horario", true) ."</div></a>";
        }
        echo            "</td>
						</tr>
					</table>
					</td>
				</tr>";

        echo	"</table>
		</form>";
    }


    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }



    function getTotalPositivo($loja){
        global $EVALUATION_POSITIVE_MIN;
        //$sql = "SELECT count(satisfacao) as total from senhas WHERE id_loja=$loja AND status='Terminado' AND satisfacao=1";
        $sql = "SELECT count(satisfacao) as total from senhas WHERE id_loja=$loja AND status='Terminado' AND satisfacao >= $EVALUATION_POSITIVE_MIN" ;
            $res = $this->bd->GetRows($sql);

             return $res[0]['total'];
     }

     function getTotalNegativo($loja){

        global $EVALUATION_POSITIVE_MIN;        
        //$sql = "SELECT count(satisfacao) as total from senhas WHERE id_loja=$loja AND status='Terminado' AND satisfacao=0";
        $sql = "SELECT count(satisfacao) as total from senhas WHERE id_loja=$loja AND status='Terminado' AND satisfacao<$EVALUATION_POSITIVE_MIN";
            $res = $this->bd->GetRows($sql);

             return $res[0]['total'];
     }

}
?>
