<?php
	
/* Classe de Gest�o de Configura��es de Teclados */

class MapaTeclado extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function MapaTeclado() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($codigos, $id_tipo_terminal, $documento)
	{	
		$ids_mapa = array();
		
		$sql = "SELECT nome FROM tipos_terminal WHERE id_tipos_terminal=".$id_tipo_terminal.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$nome_terminal = $this->bd->obterValor($rs, "nome");
		
		for($i = 0; $i < count($codigos) ; $i++){
		
			$sql = "INSERT INTO mapa_teclado(id_tipos_terminal, codigo_tecla, numero_tecla)
					VALUES (". $id_tipo_terminal. ",'" . $codigos[$i] . "',". ($i+1). ");";
					
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_mapa_teclado) FROM mapa_teclado;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_mapa, $this->bd->obterValor($rs,0));
		}
		
		$this->EscreveXMLSync($ids_mapa, "inserir", $documento);
		
		$objecto = new LogAccao();
		$rs = $objecto->Inserir("Inserção", "Mapa de Teclado", "Mapa ".$nome_terminal);
		$objecto->fechar();
		return "ok";
	}
	
	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$mapa = array();
	
		$sql = "SELECT codigo_tecla FROM mapa_teclado 
				WHERE id_tipos_terminal = " . $id . " ORDER BY numero_tecla ASC;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0; $i < $numEntradas; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			array_push($mapa, $this->bd->obterValor($rs,"codigo_tecla"));
		}
		
		$_SESSION["sessao_campos_tipo"]["valor_campo"]["codigos"] = $mapa;
		
		return "ok";
	}

	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($codigos, $id, $nome_terminal, $documento)
	{
		$num_teclas = count($codigos);
		$ids_mapa = array();
		
		$sql = "SELECT id_mapa_teclado FROM mapa_teclado WHERE id_tipos_terminal=". $id .";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_teclas_anterior = $this->bd->obterNumRegistos($rs);
		
		
		for( $i=1; $i <= $num_teclas_anterior && $i <= $num_teclas ; $i++){
		
			$sql = "SELECT id_mapa_teclado FROM mapa_teclado
					WHERE id_tipos_terminal=". $id ." AND numero_tecla=". $i .";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$id_mapa_teclado = $this->bd->obterValor($rs, "id_mapa_teclado");
			
			$sql = "UPDATE mapa_teclado SET codigo_tecla='".$codigos[$i-1]."' 
					WHERE id_mapa_teclado =". $id_mapa_teclado .";";

			array_push($ids_mapa, $id_mapa_teclado);
						
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
		}
		
		$this->EscreveXMLSync($ids_mapa, "editar", $documento);
		$ids_mapa = array();
		
		if ( $num_teclas < $num_teclas_anterior) {
			
			$sql = "SELECT id_mapa_teclado FROM mapa_teclado
					WHERE id_tipos_terminal = ".$id."
					AND numero_tecla > ".$num_teclas.";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$num_registos = $this->bd->obterNumRegistos($rs);
				
			for($i=0 ; $i < $num_registos ; $i++){
				array_push($ids_mapa, $this->bd->obterValor($rs, "id_mapa_teclado"));
			}
			
			$this->EscreveXMLSync($ids_mapa, "remover", $documento);
		
			$sql = "DELETE FROM mapa_teclado WHERE id_tipos_terminal=".$id."
					AND numero_tecla > ".$num_teclas.";";
			
			if(!$rs = $this->bd->executarSQL($sql))
					return 0;
		
		} else {
			for(; $i <= $num_teclas ; $i++){
			
				$sql = "INSERT INTO mapa_teclado(id_tipos_terminal, codigo_tecla, numero_tecla)
						VALUES (". $id. ",'" . $codigos[$i-1] . "',". $i. ");";
				
				if(!$rs = $this->bd->executarSQL($sql))
					return 0;
					
				$sql = "SELECT MAX(id_mapa_teclado) FROM mapa_teclado;";
				
				if(!$rs = $this->bd->executarSQL($sql))
					return 0;
					
				array_push($ids_mapa, $this->bd->obterValor($rs, 0));
			}
			
			$this->EscreveXMLSync($ids_mapa, "inserir", $documento);
		}
		
		
		$objecto = new LogAccao();
		$rs = $objecto->Inserir("Edição", "Mapa de Teclado", "Mapa ".$nome_terminal);
		$objecto->fechar();
		return "ok";
	}

	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id, $nomes, $documento)
	{
		$num_items = count($id)-1;
		$ids_mapa = array();
		
		$sql = "SELECT id_mapa_teclado FROM mapa_teclado WHERE ";
		
		for($i=0 ; $i < $num_items ; $i ++)
			$sql .= " id_tipos_terminal=".$id[$i]." OR ";
		$sql .= " id_tipos_terminal=".$id[$i]." ;";
		
		if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
		$num_registos = $this->bd->obterNumRegistos($rs);
		
		for($i=0 ; $i < $num_registos ; $i++){
			array_push($ids_mapa, $this->bd->obterValor($rs, "id_mapa_teclado"));
		}
		
		$this->EscreveXMLSync($ids_mapa, "remover", $documento);
	
		$sql = "DELETE FROM mapa_teclado WHERE ";
		
		for($i=0 ; $i < $num_items ; $i ++)
			$sql .= " id_tipos_terminal=".$id[$i]." OR ";
		$sql .= " id_tipos_terminal=".$id[$i]." ;";
		
		if(!$rs = $this->bd->executarSQL($sql))
				return 0;
		
		$objecto = new LogAccao();
		for($i=0 ; $i <= $num_items ; $i ++)
			$objecto->Inserir("Remoção", "Mapa de Teclado", "Mapa ".$nomes[$i]);
		$objecto->fechar();
		return "ok";
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $documento){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM mapa_teclado WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_mapa_teclado = " . $id[$i] . " OR ";
		$sql .= "id_mapa_teclado = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$raiz = $documento->firstChild;
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$no_mapa = $documento->createElement("mapaTeclado");
			$raiz->appendChild($no_mapa);
			
			$no_mapa->setAttribute("id", $this->bd->obterValor($rs, "id_mapa_teclado"));
			$no_mapa->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("idTipoTerminal");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_tipos_terminal");
			$no_mapa->appendChild($elemento);
			
			$elemento = $documento->createElement("codigoTecla");
			$elemento->nodeValue = $this->bd->obterValor($rs, "codigo_tecla");
			$no_mapa->appendChild($elemento);
			
			$elemento = $documento->createElement("numeroTecla");
			$elemento->nodeValue = $this->bd->obterValor($rs, "numero_tecla");
			$no_mapa->appendChild($elemento);			
		}
		
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>