<?php
	
/* Classe de Gest�o de Empregados */

class Previsao extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Previsao() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	
	/*
		Calcula o n�mero de empregados necess�rios
		para atenderem um certo servi�o sem que os
		cliente esperem mais que um determinado tempo
			
		0 = Erro da BD
	*/
	function Calcula($dados)
	{
		$HORA_EM_SEGUNDOS = 60 * 60;
		$DIA_EM_SEGUNDOS = 24 * $HORA_EM_SEGUNDOS;
		
		$atendimento = new TempoAtendimento();
		$inicio = strtotime($dados["inicio"]);
		$fim = strtotime($dados["fim"]);
		$previsao = array();
		$previsao["valor"] = array();
		$previsao["label"] = array();
		
		$loja = array();
		$loja[0]["id"] = $dados["loja"];
		$loja[0]["nome"] = obterNomeGeral($dados["loja"], "id_loja", "nome", "lojas");
		
		$servico = array();
		$servico[0]["id"] = $dados["servico"];
		$servico[0]["nome"] = obterNomeGeral($dados["servico"], "id_servico", "nome", "servicos");
		
		for($hora = 0 ; $hora < $DIA_EM_SEGUNDOS ; $hora += $HORA_EM_SEGUNDOS )
		{
			$numero_clientes = 0;
			$tempo_atendimento = 0;
			$items_atendimento = 0;
			
			for($data = $inicio + $hora, $numero_dias = 0; 
				$data < $fim ; 
				$data += $DIA_EM_SEGUNDOS, $numero_dias++)
			{
				$tempo_inicio = date("Y-n-j G:i:s",$data);
				$tempo_fim = date("Y-n-j G:i:s",$data + $HORA_EM_SEGUNDOS);
				
				$tmp = $atendimento->SubgrupoLoja($loja,$servico, "", "", $tempo_inicio, $tempo_fim);
				$tempo_atendimento += $tmp[0]["valor"] * 60 * $tmp[0]["num_items"];
				$items_atendimento += $tmp[0]["num_items"];
				
				$sql = "SELECT COUNT(numero_senha) FROM log_atendimentos
						WHERE data_hora BETWEEN '". $tempo_inicio ."' AND '". $tempo_fim ."'
						AND id_servico = ". $dados["servico"] ."
						AND id_loja = ". $dados["loja"] ."
						AND (tipo = 'Emissao' OR tipo = 'Redireccao') ;";

				if(!$rs = $this->bd->executarSQL($sql))
					return 0;
					
				$numero_clientes += $this->bd->obterValor($rs, 0);
			}
			
			if($items_atendimento != 0)
				$media_atendimento = $tempo_atendimento / $items_atendimento;
			else
				$media_atendimento = 0;
			
			if( $numero_dias != 0)	
				$media_clientes = $numero_clientes / $numero_dias;
			else 
				$media_clientes = 0;
			
			if($dados["limite"] > 0)
				$minimo_empregados = $media_atendimento * $media_clientes / ($dados["limite"] * 60);
			else
				$minimo_empregados = 0;
				
			$minimo_empregados = round($minimo_empregados,1);
			
			array_push($previsao["valor"], $minimo_empregados);
			array_push($previsao["label"], gmdate("G:i", $hora) ." - ". gmdate("G:i", $hora + $HORA_EM_SEGUNDOS));
		}
		
		$_SESSION["sessao_campos"]["previsao"] = $previsao;
		$_SESSION["sessao_campos"]["nome_servico"] = obterNomeGeral($dados["servico"], "id_servico", "nome", "servicos");
		
		return "ok";
	}
	
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>
