<?php
	
/* Classe de Gest�o de Empregados */

class Promocao extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Promocao() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$this->bd = new AcessoBD();
		return $this->bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
	}
	
	function AssociarImagem($dados, $id)
	{
		global $TAMANHO_MAX_IMAGEM;
		
		if(!isset($id) || $id == "")
		{
			if(file_exists("../imagens_promocoes/inserir_tmp0.bmp"))
				unlink("../imagens_promocoes/inserir_tmp0.bmp");
				
			if(move_uploaded_file($_FILES["ficheiro"]["tmp_name"], "../imagens_promocoes/inserir_tmp0.bmp"))
				return "ok";
			else 
				return 0;
		}
		
		$sql = "SELECT imagem, nome FROM promocao WHERE id_promocao = ".$id.";";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$imagem_antiga = $this->bd->obterValor($rs,"imagem");
		$nome_promo = $this->bd->obterValor($rs, "nome");
		
		if(isset($imagem_antiga) && file_exists($imagem_antiga))
			unlink($imagem_antiga);
		
		if ($_FILES["ficheiro"]["name"] != "" )
		{
			$vector_nome = construcaoVector($_FILES["ficheiro"]["name"],".");
			$extensao = ".". $vector_nome[count($vector_nome)-1];
			
			$i = 0;
			
			do 
			{
				$i++;
				$nome = "../imagens_promocoes/".$nome_promo.$i.$extensao;	
			} while (file_exists($nome));
			
			$sucesso_copia = move_uploaded_file($_FILES["ficheiro"]["tmp_name"], $nome);
		}
		else
			return 0;
		
		if($sucesso_copia){
			if(stristr(php_uname(), "Windows") == false)
				shell_exec("mogrify -resize \"".$TAMANHO_MAX_IMAGEM.">\" ".$nome);
			chmod($nome, 0777);
			
			$sql = "UPDATE promocao SET imagem = '".basename($nome)."' WHERE id_promocao = " . $id . " ;";
		}
		else 
			$sql = "UPDATE promocao SET imagem = null WHERE id_promocao = " . $id . " ;";
		

		if($rs = $this->bd->executarSQL($sql))
		{
			$this->EscreveXMLSync($id, "editar");
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Edição", "Promoções", $nome_promo);
			$objecto->fechar();
			
			return "ok";
		}
		else
			return 0;
	}
	
	function RemoverImagem($id)
	{
		
		$sql = "SELECT imagem, nome FROM promocao WHERE id_promocao = ".$id.";";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$imagem_antiga = $this->bd->obterValor($rs,"imagem");
		$nome_promo = $this->bd->obterValor($rs, "nome");
		
		if(isset($imagem_antiga) && file_exists($imagem_antiga))
			unlink($imagem_antiga);
			
		$sql = "UPDATE promocao SET imagem = null WHERE id_promocao = " . $id . " ;";

		if($rs = $this->bd->executarSQL($sql))
		{
			$this->EscreveXMLSync($id, "editar");
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Edição", "Promoções", $nome_promo);
			$objecto->fechar();
			
			return "ok";
		}
		else
			return 0;
		
	}
	
	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados)
	{
		
		if (file_exists("../imagens_promocoes/inserir_tmp0.bmp"))
		{			
			$i = 0;
			
			do 
			{
				$i++;
				$nome = "../imagens_promocoes/".$dados["nome"].$i.".bmp";	
			} while (file_exists($nome));
			
			if(!rename("../imagens_promocoes/inserir_tmp0.bmp", $nome))
				return 0;
			chmod($nome, 0777);
			if(stristr(php_uname(), "Windows") == false)
				shell_exec("mogrify -resize \"".$TAMANHO_MAX_IMAGEM.">\" ".$nome);
		}
		
		$sql = "INSERT INTO promocao (nome, texto, imagem) VALUES ('"
									. $dados["nome"] . "', '" 
									. $dados["texto"] . "' ";
									
		if(isset($nome))
			$sql .= ", '".basename($nome) . "');";
		else
			$sql .= ", null );";

		if($rs = $this->bd->executarSQL($sql))
		{
			$sql = "SELECT MAX(id_promocao) FROM promocao;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$this->EscreveXMLSync($this->bd->obterValor($rs,0), "inserir");
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Promoções", $dados["nome"]);
			$objecto->fechar();
			return "ok";
		}
		else
		{
			if(isset($nome))
				unlink($nome);
			return 0;
		}
			
	}

	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT * FROM promocao WHERE id_promocao = " . $id . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
		
		return "ok";
	}

	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id)
	{			
		$sql = "UPDATE promocao SET 
								nome = '" . $dados["nome"] . "',
								texto = '" . $dados["texto"] . "' ";
		$sql .= "WHERE id_promocao = " . $id . " ;";
		

		if($rs = $this->bd->executarSQL($sql))
		{
			$this->EscreveXMLSync($id, "editar");
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Edição", "Promoções", $dados["nome"]);
			$objecto->fechar();
			return "ok";
		}
		else
			return 0;
	}

	/*
		Fun��o de Remoção
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id)
	{
		$this->EscreveXMLSync($id, "remover");
		
		$numEntradas = count($id);
		$nomes = array();
		$imagens = array();
		
		$sql = "SELECT nome, imagem FROM promocao WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_promocao = " . $id[$i] . " OR ";
		$sql .= "id_promocao = " . $id[0] . ";";


		if($rs = $this->bd->executarSQL($sql)) 
		{
			for($i = 0; $i < $numEntradas; $i++)
			{
				$this->bd->moverRegisto($rs,$i);
				array_push($nomes, $this->bd->obterValor($rs,"nome"));
				array_push($imagens, $this->bd->obterValor($rs,"imagem"));
			}
		}
		else 
			return 0;

		$sql = "DELETE FROM promocao WHERE ";
		for($i = count($id); $i > 1; $i--)
			$sql .= "id_promocao = ". $id[$i-1] . " OR ";
		$sql .= "id_promocao = ". $id[0] . ";";
		
		if($rs = $this->bd->executarSQL($sql))
		{	
			$objecto = new LogAccao();
			for($i = count($nomes)-1; $i >= 0; $i--){
				$rs = $objecto->Inserir("Remoção", "Promoções", $nomes[$i]);
				if(isset($imagens[$i]) && file_exists($imagens[$i]))
					unlink($imagens[$i]);
			}
			$objecto->fechar();			
			return "ok";
		}
		else
			return 0;	
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $enderecos_lojas=null){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM promocao WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_promocao = " . $id[$i] . " OR ";
		$sql .= "id_promocao = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$documento = abreXMLSync();
		$raiz = $documento->firstChild;
		
		
		if(is_null($enderecos_lojas)){
			$loja = new Loja();
			$enderecos = $loja->listaIpLojas();
			//$loja->Fechar();
		} else {
			$enderecos = $enderecos_lojas;
		}
		
		if(count($enderecos) > 0){
			$destinos = $documento->createElement("destinos");
			$raiz->appendChild($destinos);
		}
		
		for($i = 0 ; $i < count($enderecos) ; $i++){
			$loja = $documento->createElement("loja");
			$loja->nodeValue = $enderecos[$i];
			$destinos->appendChild($loja);
		}
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$no_promocao = $documento->createElement("promocao");
			$raiz->appendChild($no_promocao);
			
			$no_promocao->setAttribute("id", $this->bd->obterValor($rs, "id_promocao"));
			$no_promocao->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("nome");
			$elemento->nodeValue = $this->bd->obterValor($rs, "nome");
			$no_promocao->appendChild($elemento);
			
			$elemento = $documento->createElement("texto");
			$elemento->nodeValue = $this->bd->obterValor($rs, "texto");
			$no_promocao->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "imagem");
			if(isset($valor)){
				$elemento = $documento->createElement("imagem");
				$elemento->nodeValue = $valor;
				$no_promocao->appendChild($elemento);
			}
		}
		
		fechaXMLsync($documento);
		
	}
	
	/*
		Fun��o de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	
	function Listar()
	{
		$sql = "SELECT p.id_promocao, p.nome
				FROM promocao p ";
		
		if($_REQUEST["campo"] != "")		
			$sql .= "ORDER BY p." . $_REQUEST["campo"] . " ";	
		else	
			$sql .= "ORDER BY p.nome ";
			
		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";			


		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem', true) ."  ". translate("word_promotions", true) ." ". translate('word_valor_minutos', true)."!</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=promocoes&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"]  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'><strong>". translate('word_pages', true)." </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
			echo "<td width='8'>&nbsp;</td>";
		}
				
		if (strcmp($_REQUEST["campo"],"nome") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div". translate('word_name', true)."/div></a></td>";

		echo "<td width='135'>". translate('word_operations', true)."</td>								
				</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>";
			if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
				echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs,"id_promocao") . "'/></td>";
			}
			echo	"<td>" . $this->bd->obterValor($rs, "nome") . "</td>
					<td>";
		if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=promocoes&id=" . $this->bd->obterValor($rs,"id_promocao") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=promocoes&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST['ordem'] . "&id=" . $this->bd->obterValor($rs,"id_promocao") . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
		} else {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=promocoes&id=" . $this->bd->obterValor($rs,"id_promocao") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
		}
			echo	"</td>							
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						 
				<tr>
					<td> 
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
	if ( $_SESSION["sessao_perms"]["perm_promocoes"] == 2 ) {
		echo	"<tr>
					<td>
					<table>
						<tr>
							<td class='button_large'>
								<div onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
								<div onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
								<div onClick='removerMarcados(this);'>". translate('word_remove', true)."</div>
							</td>
							<td class='button_large' style='padding-left: 55px;' }>
								<a href='../horarios_promocao/'><div>".  translate('word_create', true)  ."  ". translate("word_horario", true) ."</div></a>
							</td>
						</tr>
					</table>
					</td>
				</tr>";
	}
	
	echo	"</table>
		</form>";		
	}
			
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>