<?php
session_start();

require_once("../config.inc.php");

if ($_SESSION["sessao_autenticado"] == 0)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

if ($_SESSION["sessao_perms"]["perm_resumo_sistema"] == 0)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR . "mobline/");
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <META HTTP-EQUIV="Refresh" CONTENT="60">
        <title>Zqueue - <?php   echo  translate("word_definition", true) ?> <?php   echo  translate('word_daily', true) ?></title>

        <link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">

        <!-- Re-design -->
        <link rel="stylesheet" type="text/css" media="screen" href="../css/components/custom-form.css">

        <script type="text/javascript" src="<?php   echo getPathScriptJS("menu.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("validacoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("funcoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("calendario.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("sorttable.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("periodicalrefresh.js"); ?>"></script>

        <style>
            .custom-menu {
                position: fixed !important;
            }
        </style>

    </head>
    <body onload="setupRefresh(20000);">
        <?php
        include("../cabecalho.php");
        $data = getRequestValue('data', date("Y-m-d"));

        $servicos = new Servico();
        $srv = $servicos->GetServicos((is_array($_SESSION["loja"]) && count($_SESSION["loja"])) ? "l.id_loja in (" . implode(",", $_SESSION["loja"]) . ")" : "");

        $balcoes = new Balcao();
        $blc = $balcoes->GetBalcoes((is_array($_SESSION["loja"]) && count($_SESSION["loja"])) ? "l.id_loja in (" . implode(",", $_SESSION["loja"]) . ")" : "");

        $senhas = new Senhas();
        $ns = $senhas->GetNumeroSenhasPorServico(date("Y-m-d"), false, true);

        $ecras = new Ecra();
        $scr = $ecras->GetEcras((is_array($_SESSION["loja"]) && count($_SESSION["loja"])) ? "l.id_loja in (" . implode(",", $_SESSION["loja"]) . ")" : "");

        $dispensadores = new Dispensador();
        $dsp = $dispensadores->GetDispensadores((is_array($_SESSION["loja"]) && count($_SESSION["loja"])) ? "l.id_loja in (" . implode(",", $_SESSION["loja"]) . ")" : "");
        ?>



        <div class="full_area">
        	<!-- Title + Description -->
        	<div class="form-title">
        		<h2 class="text-bold text-green-light"><?php   echo  translate("word_resume", true) ?> <?php   echo  translate("word_do", true) ?> <?php   echo  translate("word_system", true) ?></h2>

        		<!-- Extra description -->
        		<div class="form-extra-desc text-bold text-gray-dark"></div>
        	</div>

        	<!-- Main Table Content -->
        	<div class="form-table-container">
        		<table cellspacing="0" cellpadding="0">
        			<tr>
        				<td width="758">

                  <!-- Dispensadores -->
                  <h3 class="text-bold text-green-light"><?php   echo  translate('word_disp', true) ?> </h3>
                  <table class='form_table' cellspacing='0' cellpadding='0'>
            				<tr>
            					<td>
            						<table class='data_table' cellspacing='0' cellpadding='0'>
                          <thead>
                              <tr class="column_row">
                                  <td><?php   echo  translate('word_local', true) ?></td>
                                  <td><?php   echo  translate('word_dispensador', true) ?></td>
                                  <td><?php   echo  translate("word_state", true) ?></td>
                                  <td><?php   echo  translate("word_last_actualization", true) ?></td>
                              </tr>
                          </thead>
                          <tbody id="estados_servicos_body">
                              <?php 
                              for ($i = 0; $i < count($dsp); $i++) {
                                  switch ($dsp[$i]["status_id"]) {
                                      case "1":
                                      case "4":
                                          $color = "#008800";
                                          break;
                                      case "2":
                                          $color = "#880000";
                                          break;
                                      case "3":
                                          $color = "#888800";
                                          break;
                                      default:
                                          $color = "#ffffff";
                                          break;
                                  }
                                  ?>
                                  <tr class='form-data-tr'>
                                      <td class='form-data-td' style="white-space: nowrap;padding-left: 20px;">
                                        <?php 
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                            echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $dsp[$i]["id_loja"] . (($_SESSION["sessao_perms"]["perm_lojas"] < 2) ? '&accao=ver_detalhes' : '') . '">';
                                        }
                                        echo $dsp[$i]["local"];
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                            echo '</a>';
                                        ?>
                                      </td>
                                      <td class='form-data-td'>
                                          <?php 
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_dispensador"]) {
                                              echo '<a href="../accoes_intermedias/accaoLer.php?modulo=dispensadores&id=' . $dsp[$i]["id_dispensador"] . '&tipo=' . $dsp[$i]["tipo"] . (($_SESSION["sessao_perms"]["perm_dispensador"] < 2) ? '&accao=ver_detalhes' : '') . '">';
                                          }
                                          echo $dsp[$i]["dispensador"];
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_dispensador"])
                                              echo '</a>';
                                          ?>
                                      </td>
                                      <td class='form-data-td' style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $dsp[$i]["estado"]; ?></td>
                                      <td class='form-data-td'><?php   echo $dsp[$i]["desde"]; ?></td>
                                  </tr>
                                  <?php 
                              }
                              ?>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </table>

                  <br><br>

                  <!-- Ecras -->
                  <h3 class="text-bold text-green-light"><?php   echo  translate('word_ecras', true) ?> </h3>
                  <table class='form_table' cellspacing='0' cellpadding='0'>
            				<tr>
            					<td>
            						<table class='data_table' cellspacing='0' cellpadding='0'>
                          <thead>
                              <tr class="column_row">
                                <td><?php   echo  translate('word_local', true) ?></td>
                                <td><?php   echo  translate("word_ecra", true) ?></td>
                                <td><?php   echo  translate("word_state", true) ?></td>
                                <td><?php   echo  translate("word_last_actualization", true) ?></td>
                              </tr>
                          </thead>
                          <tbody id="estados_servicos_body">
                            <?php 
                            for ($i = 0; $i < count($scr); $i++) {
                                switch ($scr[$i]["status_id"]) {
                                    case "1":
                                        $color = "#008800";
                                        $label = translate("word_activo", true);//"Activo";
                                        break;
                                    case "2":
                                        if ($scr[$i]["estado_ecra"] == '1') {
                                            $color = "#880000";
                                        } else {
                                            $color = "#888800";
                                        }
                                        $label = translate("word_inactivo", true);//"Inactivo";
                                        break;
                                    default:
                                        $color = "#ffffff";
                                        $label = "";
                                        break;
                                }
                                ?>
                                <tr class='form-data-tr'>
                                    <td class='form-data-td' style="white-space: nowrap;padding-left: 20px;">
                                <?php 
                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                    echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $scr[$i]["id_loja"] . (($_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                }
                                echo $scr[$i]["local"];
                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                    echo '</a>';
                                ?>
                                    </td>
                                    <td class='form-data-td'>
                                        <?php 
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_ecra"]) {
                                            echo '<a href="../accoes_intermedias/accaoLer.php?modulo=ecras&id=' . $scr[$i]["id_ecra"] . (($_SESSION["sessao_perms"]["perm_ecra"] == 2) ? '' : '&accao=ver_detalhes') . '">';
                                        }
                                        echo $scr[$i]["ecra"];
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_ecra"])
                                            echo '</a>';
                                        ?>
                                    </td>
                                    <td class='form-data-td' style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $label ?></td>
                                    <td class='form-data-td'><?php   echo $scr[$i]["desde"]; ?></td>
                                </tr>
                                        <?php 
                                    }
                                    ?>
                        </tbody>
                        </table>
                      </td>
                    </tr>
                  </table>

                  <br><br>

                  <!-- Balcoes -->
                  <h3 class="text-bold text-green-light"><?php   echo  translate('word_agencies', true) ?> </h3>
                  <table class='form_table' cellspacing='0' cellpadding='0'>
            				<tr>
            					<td>
            						<table class='data_table' cellspacing='0' cellpadding='0'>
                          <thead>
                              <tr class="column_row">
                                <td><?php   echo  translate('word_entity', true) ?></td>
                                <td><?php   echo  translate('word_local', true) ?></td>
                                <td><?php   echo  translate("word_agency", true) ?></td>
                                <td><?php   echo  translate("word_state", true) ?></td>
                                <td><?php   echo  translate("word_since", true) ?></td>
                              </tr>
                          </thead>
                          <tbody>
                                <?php 
                                for ($i = 0; $i < count($blc); $i++) {
                                    switch ($blc[$i]["status_id"]) {
                                        case "1":
                                            $color = "#008800";
                                            break;
                                        case "2":
                                            $color = "#888800";
                                            break;
                                        case "3":
                                            $color = "#880000";
                                            break;
                                        case "4":
                                            $color = "#00aa00";
                                            break;
                                        default:
                                            $color = "#ffffff";
                                            break;
                                    }
                                    ?>
                                  <tr class='form-data-tr'>
                                      <td class='form-data-td' class='form-data-td' style="white-space: nowrap;padding-left: 20px;">
                                  <?php 
                                  if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"]) {
                                      echo '<a href="../accoes_intermedias/accaoLer.php?modulo=entidades&id=' . $blc[$i]["id_entidade"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                  }
                                  echo $blc[$i]["entidade"];
                                  if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"])
                                      echo '</a>';
                                  ?>
                                      </td>
                                      <td class='form-data-td'>
                                          <?php 
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                              echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $blc[$i]["id_loja"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                          }
                                          echo $blc[$i]["local"];
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                              echo '</a>';
                                          ?>
                                      </td>
                                      <td class='form-data-td'>
                                          <?php 
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_balcoes"]) {
                                              echo '<a href="../accoes_intermedias/accaoLer.php?modulo=balcoes&id=' . $blc[$i]["id_balcao"] . (($_SESSION["sessao_perms"]["perm_balcoes"] == 2) ? '' : '&accao=ver_detalhes') . '">';
                                          }
                                          echo $blc[$i]["balcao"];
                                          if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_balcoes"])
                                              echo '</a>';
                                          ?>
                                      </td>
                                      <td class='form-data-td' style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $blc[$i]["estado"]; ?></td>
                                      <td class='form-data-td'><?php   echo $blc[$i]["desde"]; ?></td>
                                  </tr>
                              <?php  } ?>
                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </table>

                  <br><br>

                  <!-- Servicos -->
                  <h3 class="text-bold text-green-light"><?php   echo  translate('word_services', true) ?> </h3>
                  <table class='form_table' cellspacing='0' cellpadding='0'>
            				<tr>
            					<td>
            						<table class='data_table' cellspacing='0' cellpadding='0'>
                          <thead>
                              <tr class="column_row">
                                <td><?php   echo  translate('word_entity', true) ?></td>
                                <td><?php   echo  translate('word_local', true) ?></td>
                                <td><?php   echo  translate("word_service", true) ?></td>
                                <td><?php   echo  translate("word_tempo_espera_prox_senha", true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_emitidas', true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_waiting', true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_in_attendance', true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_atendidas', true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_desistidas', true) ?></td>
                                <td><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_anuladas', true) ?></td>
                              </tr>
                          </thead>
                          <tbody>
                            <tbody>
                              <?php 
                              for ($i = 0; $i < count($srv); $i++) {
                                  //$ultimaSenhaChamada = $senhas->GetUltimaSenhaChamada($srv[$i]["id_loja"], $srv[$i]["id_servico"]);
                                  //$tempoEsperaProximaSenha = Timestamp_to_Time($senhas->GetTempoEsperaProximaSenha($srv[$i]["id_loja"], $srv[$i]["id_servico"]));
                                  $tempoEsperaProximaSenha = gmdate("H:i:s", $senhas->GetTempoEsperaProximaSenha($srv[$i]["id_loja"], $srv[$i]["id_servico"]));
                                  //$ultimaSenhaEmitida = $senhas->GetNumeroUltimaSenhaEmitida($srv[$i]["id_loja"], $srv[$i]["id_servico"]);

                                  if (@$ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Emitidas"]) {
                                      ?>
                                        <tr class='form-data-tr'>
                                            <td class='form-data-td'>
                                        <?php 
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"]) {
                                            echo '<a href="../accoes_intermedias/accaoLer.php?modulo=entidades&id=' . $srv[$i]["id_entidade"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                        }
                                        echo $srv[$i]["entidade"];
                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"])
                                            echo '</a>';
                                        ?></td>
                                            <td class='form-data-td'>
                                                <?php 
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                                    echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $srv[$i]["id_loja"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                }
                                                echo $srv[$i]["local"];
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                                    echo '</a>';
                                                ?></td>
                                            <td class='form-data-td'>
                                                <?php 
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"]) {
                                                    echo '<a href="../accoes_intermedias/accaoLer.php?modulo=servicos&id=' . $srv[$i]["id_servico"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                }
                                                echo $srv[$i]["servico"];
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"])
                                                    echo '</a>';
                                                ?></td>
                                            <!--<td class='form-data-td'><?php   /* echo $ultimaSenhaEmitida; */ ?></td>-->
                                            <!--<td class='form-data-td'><?php   /* echo isset($ultimaSenhaChamada)?$ultimaSenhaChamada["numero_senha"]:""; */ ?></td>-->
                                            <td class='form-data-td'><?php   echo $tempoEsperaProximaSenha; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Emitidas"] : "0"; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["EmEspera"] : "0"; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["EmAtendimento"] : "0"; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Terminadas"] : "0"; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Desistidas"] : "0"; ?></td>
                                            <td class='form-data-td'><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Anuladas"] : "0"; ?></td>
                                        </tr>
                                          <?php 
                                      }
                                  }
                                  ?>
                            </tbody>
                        </table>
                      </td>
                    </tr>
                  </table>

                  <br><br>

                  <!-- Satisfacao -->
                  <h3 class="text-bold text-green-light"><?php   echo  translate('word_satisfacao_geral', true) ?></h3>
                  <table class='form_table' cellspacing='0' cellpadding='0'>
            				<tr>
            					<td>
            						<table class='data_table' cellspacing='0' cellpadding='0'>
                          <thead>
                              <tr class="column_row">
                                <td class='first_td'><?php   echo  translate('word_local', true) ?></td>
                                <td><?php   echo  translate('word_avaliacoes_positivas', true) ?></td>
                                <td><?php   echo  translate('word_avaliacoes_negativas', true) ?></td>
                                <td><?php   echo  translate('word_total_avaliacoes', true) ?></td>
                                <td>%</td>
                              </tr>
                          </thead>
                          <tbody>
                            <?php 
                            $lojas = new Loja();
                            $todas_as_lojas = $lojas->GetLojas();

                            foreach ($todas_as_lojas as $local) {

                            $total_positivo=$lojas->getTotalPositivo($local['id_loja']);
                            $total_negativo=$lojas->getTotalNegativo($local['id_loja']);
                            $total_avaliado=$total_negativo+$total_positivo;
                            @$percentagem=($total_positivo/$total_avaliado)*100;

                            echo " <tr class='form-data-tr'>";
                            echo "     <td class='form-data-td' style='white-space: nowrap;padding-left: 20px;'>";
                            echo $local['nome'];
                            echo "</td>";
                            echo "   <td class='form-data-td'>";
                            echo $total_positivo;
                            echo "</td>";
                            echo "<td class='form-data-td'>";
                            echo $total_negativo;
                            echo "</td>";
                            echo "<td class='form-data-td'>";
                            echo $total_avaliado;
                            echo "</td>";
                            echo "<td class='form-data-td'>";
                            echo $percentagem;
                            echo "</td>";

                            echo "</tr>";
                            }
                            ?>

                          </tbody>
                        </table>
                      </td>
                    </tr>
                  </table>

        				</td>
        			</tr>
        		</table>
        	</div>

        </div>



        <table class="full_area" cellpadding="0" cellspacing="0" style="display:none"> 
            <tr>
                <td>&nbsp;</td>
                <td class="content">
                    <table class="title_space" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="module_space" width="650">
                                <?php   echo  translate("word_resume", true) ?> <?php   echo  translate("word_do", true) ?> <?php   echo  translate("word_system", true) ?></ td>
                            <!--<td class="function_space" width="120">
                                                <a class="function" href=""><img alt="O que &eacute;?" src="../img/buttons/button_help.gif"><div><?php   echo  translate("word_definition", true) ?></div></a>
                                        </td>-->
                        </tr>
                    </table>
                    <table width="770" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td width="758">
                                <br/>
                                <!-- dispensadores -->
                                <table id="estados_servicos" class="sortable" style="width:100%; text-align:center">
                                    <caption style="color: #07a7ba; font-weight: bold"> <?php   echo  translate('word_disp', true) ?></caption>
                                    <thead>
                                        <tr class="column_row">
                                            <th><?php   echo  translate('word_local', true) ?></th>
                                            <th><?php   echo  translate('word_dispensador', true) ?></th>
                                            <th><?php   echo  translate("word_state", true) ?></th>
                                            <th><?php   echo  translate("word_last_actualization", true) ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="estados_servicos_body">
                                        <?php 
                                        for ($i = 0; $i < count($dsp); $i++) {
                                            switch ($dsp[$i]["status_id"]) {
                                                case "1":
                                                case "4":
                                                    $color = "#008800";
                                                    break;
                                                case "2":
                                                    $color = "#880000";
                                                    break;
                                                case "3":
                                                    $color = "#888800";
                                                    break;
                                                default:
                                                    $color = "#ffffff";
                                                    break;
                                            }
                                            ?>
                                            <tr>
                                                <td>
                                                  <?php 
                                                  if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                                      echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $dsp[$i]["id_loja"] . (($_SESSION["sessao_perms"]["perm_lojas"] < 2) ? '&accao=ver_detalhes' : '') . '">';
                                                  }
                                                  echo $dsp[$i]["local"];
                                                  if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                                      echo '</a>';
                                                  ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_dispensador"]) {
                                                        echo '<a href="../accoes_intermedias/accaoLer.php?modulo=dispensadores&id=' . $dsp[$i]["id_dispensador"] . '&tipo=' . $dsp[$i]["tipo"] . (($_SESSION["sessao_perms"]["perm_dispensador"] < 2) ? '&accao=ver_detalhes' : '') . '">';
                                                    }
                                                    echo $dsp[$i]["dispensador"];
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_dispensador"])
                                                        echo '</a>';
                                                    ?>
                                                </td>
                                                <td style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $dsp[$i]["estado"]; ?></td>
                                                <td><?php   echo $dsp[$i]["desde"]; ?></td>
                                            </tr>
                                            <?php 
                                        }
                                        ?>
                                    </tbody>
                                </table>
                                <br/>
                                <br/>
                                <!-- Ecras -->
                                <table id="estados_servicos" class="sortable" style="width:100%; text-align:center">
                                    <caption style="color: #07a7ba; font-weight: bold"><?php   echo translate("word_ecras", true); ?></caption>
                                    <thead>
                                        <tr class="column_row">
                                            <th><?php   echo  translate('word_local', true) ?></th>
                                            <th><?php   echo  translate("word_ecra", true) ?></th>
                                            <th><?php   echo  translate("word_state", true) ?></th>
                                            <th><?php   echo  translate("word_last_actualization", true) ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        for ($i = 0; $i < count($scr); $i++) {
                                            switch ($scr[$i]["status_id"]) {
                                                case "1":
                                                    $color = "#008800";
                                                    $label = "Activo";
                                                    break;
                                                case "2":
                                                    if ($scr[$i]["estado_ecra"] == '1') {
                                                        $color = "#880000";
                                                    } else {
                                                        $color = "#888800";
                                                    }
                                                    $label = "Inactivo";
                                                    break;
                                                default:
                                                    $color = "#ffffff";
                                                    $label = "";
                                                    break;
                                            }
                                            ?>
                                            <tr>
                                                <td>
                                            <?php 
                                            if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                                echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $scr[$i]["id_loja"] . (($_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                            }
                                            echo $scr[$i]["local"];
                                            if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                                echo '</a>';
                                            ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_ecra"]) {
                                                        echo '<a href="../accoes_intermedias/accaoLer.php?modulo=ecras&id=' . $scr[$i]["id_ecra"] . (($_SESSION["sessao_perms"]["perm_ecra"] == 2) ? '' : '&accao=ver_detalhes') . '">';
                                                    }
                                                    echo $scr[$i]["ecra"];
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_ecra"])
                                                        echo '</a>';
                                                    ?>
                                                </td>
                                                <td style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $label ?></td>
                                                <td><?php   echo $scr[$i]["desde"]; ?></td>
                                            </tr>
                                                    <?php 
                                                }
                                                ?>
                                    </tbody>
                                </table>
                                <br/>
                                <br/>
                                <!-- Balcoes -->
                                <table id="estados_servicos" class="sortable" style="width:100%; text-align:center">
                                    <caption style="color: #07a7ba; font-weight: bold"><?php   echo translate("word_agencies", true); ?></caption>
                                    <thead>
                                        <tr class="column_row">
                                            <th><?php   echo  translate('word_entity', true) ?></th>
                                            <th><?php   echo  translate('word_local', true) ?></th>
                                            <th><?php   echo  translate("word_agency", true) ?></th>
                                            <th><?php   echo  translate("word_state", true) ?></th>
                                            <th><?php   echo  translate("word_since", true) ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                          <?php 
                                          for ($i = 0; $i < count($blc); $i++) {
                                              switch ($blc[$i]["status_id"]) {
                                                  case "1":
                                                      $color = "#008800";
                                                      break;
                                                  case "2":
                                                      $color = "#888800";
                                                      break;
                                                  case "3":
                                                      $color = "#880000";
                                                      break;
                                                  case "4":
                                                      $color = "#00aa00";
                                                      break;
                                                  default:
                                                      $color = "#ffffff";
                                                      break;
                                              }
                                              ?>
                                            <tr>
                                                <td>
                                            <?php 
                                            if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"]) {
                                                echo '<a href="../accoes_intermedias/accaoLer.php?modulo=entidades&id=' . $blc[$i]["id_entidade"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                            }
                                            echo $blc[$i]["entidade"];
                                            if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"])
                                                echo '</a>';
                                            ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                                        echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $blc[$i]["id_loja"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                    }
                                                    echo $blc[$i]["local"];
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                                        echo '</a>';
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_balcoes"]) {
                                                        echo '<a href="../accoes_intermedias/accaoLer.php?modulo=balcoes&id=' . $blc[$i]["id_balcao"] . (($_SESSION["sessao_perms"]["perm_balcoes"] == 2) ? '' : '&accao=ver_detalhes') . '">';
                                                    }
                                                    echo $blc[$i]["balcao"];
                                                    if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_balcoes"])
                                                        echo '</a>';
                                                    ?>
                                                </td>
                                                <td style="color: <?php   echo $color; ?>; font-weight: bold"><?php   echo $blc[$i]["estado"]; ?></td>
                                                <td><?php   echo $blc[$i]["desde"]; ?></td>
                                            </tr>
                                        <?php  } ?>
                                    </tbody>
                                </table>
                                <br/>
                                <br/>
                                <!-- Services -->
                                <table id="estados_servicos" class="sortable" style="width:100%; text-align:center">
                                    <caption style="color: #07a7ba; font-weight: bold"><?php   echo translate("word_services", true); ?></caption>
                                    <thead>
                                        <tr class="column_row">
                                            <th><?php   echo  translate('word_entity', true) ?></th>
                                            <th><?php   echo  translate('word_local', true) ?></th>
                                            <th><?php   echo  translate("word_service", true) ?></th>
                                            <!--<th><?php   echo  translate("word_ultima_senha_impressa", true) ?></th>
                                            <th><?php   echo  translate("word_ultima_senha_chamada", true) ?></th>-->
                                            <th><?php   echo  translate("word_tempo_espera_prox_senha", true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_emitidas', true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_waiting', true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_in_attendance', true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_atendidas', true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_desistidas', true) ?></th>
                                            <th><?php   echo  translate('word_total_senhas', true) ?> <?php   echo  translate('word_anuladas', true) ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                      <?php 
                                      for ($i = 0; $i < count($srv); $i++) {
                                      //									$ultimaSenhaChamada = $senhas->GetUltimaSenhaChamada($srv[$i]["id_loja"], $srv[$i]["id_servico"]);
                                          //$tempoEsperaProximaSenha = Timestamp_to_Time($senhas->GetTempoEsperaProximaSenha($srv[$i]["id_loja"], $srv[$i]["id_servico"]));
                                          $tempoEsperaProximaSenha = gmdate("H:i:s", $senhas->GetTempoEsperaProximaSenha($srv[$i]["id_loja"], $srv[$i]["id_servico"]));
                                      //									$ultimaSenhaEmitida = $senhas->GetNumeroUltimaSenhaEmitida($srv[$i]["id_loja"], $srv[$i]["id_servico"]);

                                          if ($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Emitidas"]) {
                                              ?>
                                                <tr>
                                                    <td>
                                                <?php 
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"]) {
                                                    echo '<a href="../accoes_intermedias/accaoLer.php?modulo=entidades&id=' . $srv[$i]["id_entidade"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                }
                                                echo $srv[$i]["entidade"];
                                                if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_entidade"])
                                                    echo '</a>';
                                                ?></td>
                                                    <td>
                                                        <?php 
                                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"]) {
                                                            echo '<a href="../accoes_intermedias/accaoLer.php?modulo=lojas&id=' . $srv[$i]["id_loja"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                        }
                                                        echo $srv[$i]["local"];
                                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_lojas"])
                                                            echo '</a>';
                                                        ?></td>
                                                    <td>
                                                        <?php 
                                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"]) {
                                                            echo '<a href="../accoes_intermedias/accaoLer.php?modulo=servicos&id=' . $srv[$i]["id_servico"] . ((CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"] == 2 ) ? '' : '&accao=ver_detalhes') . '">';
                                                        }
                                                        echo $srv[$i]["servico"];
                                                        if (CENTRAL === FALSE && $_SESSION["sessao_perms"]["perm_servicos"])
                                                            echo '</a>';
                                                        ?></td>
                                                    <!--<td><?php   /* echo $ultimaSenhaEmitida; */ ?></td>-->
                                                    <!--<td><?php   /* echo isset($ultimaSenhaChamada)?$ultimaSenhaChamada["numero_senha"]:""; */ ?></td>-->
                                                    <td><?php   echo $tempoEsperaProximaSenha; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Emitidas"] : "0"; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["EmEspera"] : "0"; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["EmAtendimento"] : "0"; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Terminadas"] : "0"; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Desistidas"] : "0"; ?></td>
                                                    <td><?php   echo isset($ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]) ? $ns[$srv[$i]["id_loja"]][$srv[$i]["id_servico"]]["Anuladas"] : "0"; ?></td>
                                                </tr>
                                                  <?php 
                                              }
                                          }
                                          ?>
                                    </tbody>
                                </table>
                                <br/><br/><br/>
                                <!-- Satisfaction -->
                                <table id="estados_servicos" class="sortable" style="width:100%; text-align:center">
                                    <caption style="color: #07a7ba; font-weight: bold">Satisfação Geral</caption>
                                    <thead>
                                        <tr class="column_row">
                                            <th>Local</th>
                                            <th>Avaliações Positivas</th>
                                            <th>Avaliações Negativas</th>
                                            <th>Total de Avaliações</th>
                                            <th>%</th>
                                        </tr>
                                    </thead>
                                    <tbody>
<?php 
$lojas = new Loja();
$todas_as_lojas = $lojas->GetLojas();

foreach ($todas_as_lojas as $local) {

    $total_positivo=$lojas->getTotalPositivo($local['id_loja']);
    $total_negativo=$lojas->getTotalNegativo($local['id_loja']);
    $total_avaliado=$total_negativo+$total_positivo;
    @$percentagem=($total_positivo/$total_avaliado)*100;

    echo " <tr>";
    echo "     <td>";
    echo $local['nome'];
    echo "</td>";
    echo "   <td>";
    echo $total_positivo;
    echo "</td>";
    echo "<td>";
    echo $total_negativo;
    echo "</td>";
    echo "<td>";
    echo $total_avaliado;
    echo "</td>";
    echo "<td>";
    echo $percentagem;
    echo "</td>";

    echo "</tr>";
}
?>

                                    </tbody>
                                </table>
                            </td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_bottom" colspan="3">&nbsp;</td>
                        </tr>
                    </table>
                </td>
                <td>&nbsp;</td>

            </tr>


        </table>
<?php
$_SESSION["sessao_msg"] = "&nbsp;"; // limpa a var�avel que guarda a �ltima mensagem de erro
?>
        <?php
        include("../rodape.php");
        ?>
    </body>
</html>
