<?php   include '../config.inc.php' ?>

function isInserir()
{
	return window.location.href.indexOf('inserir')>=0;
}

function removeReadOnly()
{
	data = $('#calendar').weekCalendar("serializeEvents");
	if(!isInserir())
	{
		for(i in data)
		{
			data[i].readOnly = false;
			$('#calendar').weekCalendar("updateEvent",data[i]);
		}
	}
}

function setCalParent(val)
{
	calParent = val;
}

$(document).ready(function() {

	$.blockUI.defaults.fadeIn = 1500;
	$.blockUI.defaults.fadeOut = 1600;

	$(document).ajaxStop($.unblockUI);

	$(function() {
		if(!isInserir())
		{
			$("#datepicker").datepicker({
				dayNamesMin:
				[
					'<?php   echo translate('word_sun', true)?>',
					'<?php   echo translate('word_mon', true)?>',
					'<?php   echo translate('word_tue', true)?>',
					'<?php   echo translate('word_wed', true)?>',
					'<?php   echo translate('word_thu', true)?>',
					'<?php   echo translate('word_fri', true)?>',
					'<?php   echo translate('word_sat', true)?>'
				],
				monthNames:
				[
					'<?php   echo translate('word_january', true)?>',
					'<?php   echo translate('word_february', true)?>',
					'<?php   echo translate('word_march', true)?>',
					'<?php   echo translate('word_april', true)?>',
					'<?php   echo translate('word_may', true)?>',
					'<?php   echo translate('word_june', true)?>',
					'<?php   echo translate('word_july', true)?>',
					'<?php   echo translate('word_august', true)?>',
					'<?php   echo translate('word_september', true)?>',
					'<?php   echo translate('word_october', true)?>',
					'<?php   echo translate('word_november', true)?>',
					'<?php   echo translate('word_december', true)?>'
				],
				showOtherMonths: true,
				selectOtherMonths: true,
				firstDay: 1,
				dateFormat: 'yy-mm-dd',
				onSelect: function(dateText, inst)
				{
					dateText += 'T00:00:00.000';
					$calendar.weekCalendar("gotoDate",new Date($('#datepicker').datepicker('getDate')));
				},
				showOn: 'button',
				buttonImage: '../img/icons_zqueue/definir_datas_horarios_39x30.png',
				buttonImageOnly: true,
				currentText: 'Now'
			});
			$("#datepicker").datepicker("setDate", '+0d');
		}
	});

   var $calendar = $('#calendar');
   var id = 10;

   var dateFormat = "j/n";
   if(isInserir())
		dateFormat = "";

   $calendar.weekCalendar({
	  timeFormat : "H:i",
	  dateFormat : dateFormat,
	  use24Hour : true,
	  buttons : false,
	  useShortDayNames: false,
	  timeSeparator : " &gt; ",
	  shortMonths :
	  [
		'<?php   echo translate('word_jan', true)?>',
		'<?php   echo translate('word_feb', true)?>',
		'<?php   echo translate('word_mar', true)?>',
		'<?php   echo translate('word_apr', true)?>',
		'<?php   echo translate('word_may', true)?>',
		'<?php   echo translate('word_jun', true)?>',
		'<?php   echo translate('word_jul', true)?>',
		'<?php   echo translate('word_aug', true)?>',
		'<?php   echo translate('word_sep', true)?>',
		'<?php   echo translate('word_oct', true)?>',
		'<?php   echo translate('word_nov', true)?>',
		'<?php   echo translate('word_dec', true)?>'
	],
	  longMonths :
	  [
		'<?php   echo translate('word_january', true)?>',
		'<?php   echo translate('word_february', true)?>',
		'<?php   echo translate('word_march', true)?>',
		'<?php   echo translate('word_april', true)?>',
		'<?php   echo translate('word_may', true)?>',
		'<?php   echo translate('word_june', true)?>',
		'<?php   echo translate('word_july', true)?>',
		'<?php   echo translate('word_august', true)?>',
		'<?php   echo translate('word_september', true)?>',
		'<?php   echo translate('word_october', true)?>',
		'<?php   echo translate('word_november', true)?>',
		'<?php   echo translate('word_december', true)?>'
	],
	  shortDays :
	  [
		'<?php   echo translate('word_sun', true)?>',
		'<?php   echo translate('word_mon', true)?>',
		'<?php   echo translate('word_tue', true)?>',
		'<?php   echo translate('word_wed', true)?>',
		'<?php   echo translate('word_thu', true)?>',
		'<?php   echo translate('word_fri', true)?>',
		'<?php   echo translate('word_sat', true)?>'
	],
	  longDays :
	  [
		'<?php   echo translate('word_sunday', true)?>',
		'<?php   echo translate('word_monday', true)?>',
		'<?php   echo translate('word_tuesday', true)?>',
		'<?php   echo translate('word_wednesday', true)?>',
		'<?php   echo translate('word_thursday', true)?>',
		'<?php   echo translate('word_friday', true)?>',
		'<?php   echo translate('word_saturday', true)?>'
	],
	  timeslotHeight: 5,
	  showAsSeparateUsers : false,

      timeslotsPerHour : 4,
      allowCalEventOverlap : false,
      overlapEventsSeparate: false,
      firstDayOfWeek : 1,
      businessHours :{start: 0, end: 24, limitDisplay: true },
      daysToShow : 7,
      height : function($calendar) {
         return $(window).height() - $("h1").outerHeight() - 1;
      },
      eventRender : function(calEvent, $event) {
		 if (calEvent.readOnly) {
            $event.css({
				"filter": "progid:DXImageTransform.Microsoft.gradient(startColorstr='#f0f0f0', endColorstr='#dbdbdb'", /* for IE */
				"background": "-webkit-gradient(linear, left top, left bottom, from(#f0f0f0), to(#dbdbdb)", /* for webkit browsers */
				"background": "-moz-linear-gradient(top,  #f0f0f0,  #dbdbdb)" /* for firefox 3.6+ */
            });
         }

		if(calEvent.end.getHours() == 0 && calEvent.end.getMinutes() == 0)
		{
			calEvent.end.setHours(23);
			calEvent.end.setMinutes(59);
			calEvent.end.setTime(calEvent.end.getTime()-24*60*60*1000);
		}
	 },

      draggable : function(calEvent, $event) {
         return calEvent.readOnly != true;
      },
      resizable : function(calEvent, $event) {
         return calEvent.readOnly != true;
      },
      eventNew : function(calEvent, $event) {
         var $dialogContent = $("#event_edit_container");
         resetForm($dialogContent);
         var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
         var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
         var titleField = $dialogContent.find("input[name='title']");
         var bodyField = $dialogContent.find("textarea[name='body']");


         $dialogContent.dialog({
            modal: true,
            title: "",
            close: function() {
               $dialogContent.dialog("destroy");
               $dialogContent.hide();
               $('#calendar').weekCalendar("removeUnsavedEvents");
            },
            buttons: {
               "<?php   echo translate('word_cancel', true)?>" : function() {
				  $dialogContent.dialog("close");
               },
						 	"<?php   echo translate('word_ok', false)?>" : function() {
                  calEvent.id = id;
                  id++;
                  calEvent.start = new Date(startField.val());
                  calEvent.end = new Date(endField.val());
                  //calEvent.title = titleField.val();
                  //calEvent.body = bodyField.val();

                  $calendar.weekCalendar("removeUnsavedEvents");
                  $calendar.weekCalendar("updateEvent", calEvent);

                  $dialogContent.dialog("close");
               }
            }
         }).show();

         $dialogContent.find(".date_holder").text($calendar.weekCalendar("formatDate", calEvent.start));
         setupStartAndEndTimeFields(startField, endField, calEvent, $calendar.weekCalendar("getTimeslotTimes", calEvent.start));

      },
      eventDrop : function(calEvent, $event) {
      },
      eventResize : function(calEvent, $event) {
		if(calEvent.end.getHours()==0)
			calEvent.end.setMinutes(0);
		else if(calEvent.end.getHours()<23 && calEvent.end.getMinutes()>=52)
			calEvent.end.setHours(calEvent.end.getHours() + 1);
		calEvent.end.setMinutes(calEvent.end.getMinutes()-calEvent.end.getMinutes() % 15);

		$calendar.weekCalendar("updateEvent",calEvent);
      },
      eventClick : function(calEvent, $event) {

         if (calEvent.readOnly && !isInserir()) {
			removeReadOnly();
            return;
         }

         var $dialogContent = $("#event_edit_container");
         resetForm($dialogContent);
         var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
         var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
         var titleField = $dialogContent.find("input[name='title']").val(calEvent.title);
         var bodyField = $dialogContent.find("textarea[name='body']");
         bodyField.val(calEvent.body);

         if (!$.browser.msie)
		 $dialogContent.dialog({
            modal: true,
            //title: "Editar ",// + calEvent.title,
            close: function() {
               $dialogContent.dialog("destroy");
               $dialogContent.hide();
               $('#calendar').weekCalendar("removeUnsavedEvents");
            },
            buttons: {
               "<?php   echo translate('word_cancel', true)?>" : function() {
                  $dialogContent.dialog("close");
               },
               "<?php   echo translate('word_erase', true)?>" : function() {
                  $calendar.weekCalendar("removeEvent", calEvent.id);
                  $dialogContent.dialog("close");
               },
               "<?php   echo translate('word_ok', false)?>" : function() {

                  calEvent.start = new Date(startField.val());
                  calEvent.end = new Date(endField.val());
                  //calEvent.title = titleField.val();
                  //calEvent.body = bodyField.val();

                  $calendar.weekCalendar("updateEvent", calEvent);
                  $dialogContent.dialog("close");
               }
            }
         }).show();

         var startField = $dialogContent.find("select[name='start']").val(calEvent.start);
         var endField = $dialogContent.find("select[name='end']").val(calEvent.end);
         $dialogContent.find(".date_holder").text($calendar.weekCalendar("formatDate", calEvent.start));
         setupStartAndEndTimeFields(startField, endField, calEvent, $calendar.weekCalendar("getTimeslotTimes", calEvent.start));
         $(window).resize().resize(); //fixes a bug in modal overlay size ??
      },
      eventMouseover : function(calEvent, $event) {
      },
      eventMouseout : function(calEvent, $event) {
      },
      noEvents : function() {

      },
      data : function(start, end, callback) {
		//callback(getEventData());
		$.blockUI({ message: $('#domMessage') });
		$.getJSON("get_cal.php", {
			start: start.getTime() + start.getTimezoneOffset() * -60000,
			end: end.getTime() + end.getTimezoneOffset() * -60000,
			id: querySt('id'),
			calParent: calParent
		},  function(result) {
			if(result==null)
			{
				$.unblockUI({fadeOut: 0});
				$('#errordialog').dialog({
							modal: true,
							close: function() {
							   $dialogContent.dialog("destroy");
							   $dialogContent.hide();
							},
							buttons: {
							   "<?php   echo translate('word_ok', true)?>" : function() {
								  $('#errordialog').dialog("close");
							   }
							}
						 }).show();
				return;
			}

			if(querySt('id')!=undefined)
				$('#nome').val(result.nome);
			callback(result);
			baseline = result.baseline;
			calParent = result.calParent;
			if(!baseline)
			{
				$('#labelRemoveExcepcao').show();
				$('#botaoRemoveExcepcao').show();
				//$('div.wc-cal-event').addClass('wc-cal-event-exception');
			}
			else
			{
				$('#labelRemoveExcepcao').hide();
				$('#botaoRemoveExcepcao').hide();
			}
			$('#calParent').val(calParent);
		});
      }

   });

   function resetForm($dialogContent) {
      $dialogContent.find("input").val("");
      $dialogContent.find("textarea").val("");
   }

   function getEventData() {
      /*
	  var year = new Date().getFullYear();
      var month = new Date().getMonth();
      var day = new Date().getDate();

      return {
         events : [
		 /*
            {
               "id":1,
               "start": new Date(year, month, day, 12),
               "end": new Date(year, month, day, 17, 30),
			   readOnly:true,
			   "userId": 0
            },
            {
               "id":2,
               "start": new Date(year, month, day, 12),
               "end": new Date(year, month, day, 13, 30),
			   "userId": 1
            },
            {
               "id":3,
               "start": new Date(year, month, day + 1, 17),
               "end": new Date(year, month, day + 1, 17, 45),
            },
            {
               "id":4,
               "start": new Date(year, month, day - 1, 8),
               "end": new Date(year, month, day - 1, 9, 30),
            },
            {
               "id":5,
               "start": new Date(year, month, day + 1, 14),
               "end": new Date(year, month, day + 1, 15),
            },
            {
               "id":6,
               "start": new Date(year, month, day, 10),
               "end": new Date(year, month, day, 11),
               readOnly : true
            }

         ]
      };*/
   }


   /*
    * Sets up the start and end time fields in the calendar event
    * form for editing based on the calendar event being edited
    */
   function setupStartAndEndTimeFields($startTimeField, $endTimeField, calEvent, timeslotTimes) {

		$startTimeField.children().remove();
		$endTimeField.children().remove();

      for (var i = 0; i < timeslotTimes.length; i++) {
         var startTime = timeslotTimes[i].start;
         var endTime = timeslotTimes[i].end;
         var startSelected = "";
         if (startTime.getTime() === calEvent.start.getTime()) {
            startSelected = "selected=\"selected\"";
         }
         var endSelected = "";
         if (endTime.getTime() === calEvent.end.getTime()) {
            endSelected = "selected=\"selected\"";
         }
         $startTimeField.append("<option value=\"" + startTime + "\" " + startSelected + ">" + timeslotTimes[i].startFormatted + "</option>");
         $endTimeField.append("<option value=\"" + endTime + "\" " + endSelected + ">" + timeslotTimes[i].endFormatted + "</option>");
      }

	  var d = new Date(endTime.getTime()-1000);
	  if (d.getTime() === calEvent.end.getTime()) {
            endSelected = "selected=\"selected\"";
      }

	  $endTimeField.append("<option value=\"" + d + "\" " + endSelected + ">23:59</option>");
      $endTimeOptions = $endTimeField.find("option");
      $startTimeField.trigger("change");
   }

   var $endTimeField = $("select[name='end']");
   var $endTimeOptions = $endTimeField.find("option");

   //reduces the end time options to be only after the start time options.
   $("select[name='start']").change(function() {
      var startTime = $(this).find(":selected").val();
      var currentEndTime = $endTimeField.find("option:selected").val();
      $endTimeField.html(
            $endTimeOptions.filter(function() {
               return startTime < $(this).val();
            })
            );

      var endTimeSelected = false;
      $endTimeField.find("option").each(function() {
         if ($(this).val() === currentEndTime) {
            $(this).attr("selected", "selected");
            endTimeSelected = true;
            return false;
         }
      });

      if (!endTimeSelected) {
         //automatically select an end date 2 slots away.
         $endTimeField.find("option:eq(1)").attr("selected", "selected");
      }

   });


   var $about = $("#about");

   $("#about_button").click(function() {
      $about.dialog({
         title: "About this calendar demo",
         width: 600,
         close: function() {
            $about.dialog("destroy");
            $about.hide();
         },
         buttons: {
            close : function() {
               $about.dialog("close");
            }
         }
      }).show();
   });

});

function trim(str, chars) {
	return ltrim(rtrim(str, chars), chars);
}

function ltrim(str, chars) {
	chars = chars || "\\s";
	return str.replace(new RegExp("^[" + chars + "]+", "g"), "");
}

function rtrim(str, chars) {
	chars = chars || "\\s";
	return str.replace(new RegExp("[" + chars + "]+$", "g"), "");
}

function querySt(ji) {
	hu = window.location.search.substring(1);
	gy = hu.split("&");
	for (i=0;i<gy.length;i++) {
		ft = gy[i].split("=");
		if (ft[0] == ji) {
			return ft[1];
		}
	}
}

var baseline = 1;
var calParent = 0;
var curDate = '';
var eventOverlap = !isInserir();

function removeHorario()
{
	id = querySt('id');
	if(id == undefined)
		id = 0;

	postdata = { };

	dia = $("#datepicker").datepicker("getDate");
	postdata.date = Math.round(dia.getTime()/1000);
	postdata.id = id;

	var decision = confirm("<?php   echo translate('word_remove', true)?>?");
	if(!decision)
		return;

	$.blockUI({ message: $('#domMessage') });
	$.post("rm_ex.php", postdata,
		function(data)
		{
			if(data=="OK")
			$('#calendar').weekCalendar("refresh");
		}
	);
}

function insereHorario()
{
	id = querySt('id');
	if(id == undefined)
		id = 0;

	nome = $('#nome').val();
	if(trim(nome) == '')
	{
		$('#nome').focus();
		return;
	}

	data = $('#calendar').weekCalendar("serializeEvents");

	for(i in data)
	{
		data[i].dia = (data[i].start.getDay()>0) ? data[i].start.getDay() : 7;
		minutos = data[i].start.getMinutes();
		if(minutos<10)
			minutos = '0'+minutos;
		data[i].inicio = data[i].start.getHours()+':'+minutos;
		minutos = data[i].end.getMinutes();
		if(minutos<10)
			minutos = '0'+minutos;
		data[i].fim = data[i].end.getHours()+':'+minutos;
		if(data[i].fim == '23:59')
			data[i].fim = '24:00';
	}
	postdata = { nome: nome, baseline: baseline, data:JSON.stringify(data) };

	/*if(calParent!=0)
		postdata.parent = calParent;*/

	if(id==0)
		$.post("../accoes_intermedias/accaoInserir.php?modulo=horarios", postdata, function(data){ if(data=="OK") window.location.href='./'; } );
	else
	{
		dia = $("#datepicker").datepicker("getDate");
		postdata.date = dia.getFullYear()+'-'+(dia.getMonth()+1)+'-'+dia.getDate();
		postdata.id = id;

		$.blockUI({ message: $('#domMessage') });
		$.post("../accoes_intermedias/accaoEditar.php?modulo=horarios&id="+id, postdata, function(data){ $('#calendar').weekCalendar("refresh"); } );
	}
}
