<?php 

class Senhas
{
    var $_db;

    function __construct()
    {
        global $NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->_db = new AcessoBD($conn);
    }

    function __destruct()
    {
        unset($this->_db);
    }

    function EmiteSenha($data, $numero_senha, $id_loja, $servico_emissao, $emissao)
    {
        $status = 'Emissao';
        //$previsao_atendimento = '00:00:00';
        $tempo_espera = '00:00:00';

        $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, emissao, tempo_espera, status)
		values (
			'" . $data . "',
			'" . $numero_senha . "',
			'" . $id_loja . "',
			'" . $servico_emissao . "',
			'" . $emissao . "',
			'" . $tempo_espera . "',
			'" . $status . "')";

        $this->_db->Execute($sql);
    }

    function ChamaSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico, $id_balcao, $id_colaborador)
    {
        $status='Chamada';

        $stat = new EstatisticaAtendimentos;
        $tempo_espera = $stat->GetTempoEspera($id_loja, $servico, $data, $numero_senha . "_" . $servico_emissao);
        unset($stat);

        $sql = "select max(id_senha) as id_senha from senhas
			where data='" . $data . "'
			and numero_senha='" . $numero_senha . "'
			and id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'";
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");

        $sql = "update senhas set
			tempo_espera = '" . date("H:i:s", $tempo_espera - 3600 ) . "',
			id_balcao = '" . $id_balcao . "',
			id_colaborador = '" . $id_colaborador . "',
			status = '" . $status ."'
			where id_senha = '" . $id . "'";
        $res = $this->_db->Execute($sql);
    }

    function SetStatus($data, $numero_senha, $id_loja, $servico_emissao, $status)
    {
        $sql = "select max(id_senha) as id_senha from senhas
			where data='" . $data . "'
			and numero_senha='" . $numero_senha . "'
			and id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'";
        $res = $this->_db->executarSQL($sql);
        $id = $this->_db->obterValor($res, "id_senha");

        $sql = "update senhas set
			status = '" . $status ."'
			where id_senha = '" . $id . "'";
        $res = $this->_db->executarSQL($sql);
    }

    function SetStatus_Terminal($id_senha, $status)
    {
		$sql = "update senhas set
				tempo_espera = '" . $this->GetTempoEsperaAtendimento($id_senha) . "',
				status = '" . $status ."'
				where id_senha = '" . $id_senha . "'";
		return $this->_db->executarSQL($sql);
    }

    function TerminaSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico, $desistencia=false)
    {
        $status = "Terminado";
        if ($desistencia) $status = "Desistencia";

        $stat = new EstatisticaAtendimentos;
        $tempo_atendimento = $stat->GetTempoAtendimento($id_loja, $servico, $data, $numero_senha . "_" . $servico_emissao);
        unset($stat);

        //debug ($tempo_atendimento);

        $sql = "select max(id_senha) as id_senha from senhas
			where data='" . $data . "'
			and numero_senha='" . $numero_senha . "'
			and id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'";
        //debug($sql);
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");

        //debug($id);

        $sql = "update senhas set
			tempo_atendimento = '" . date("H:i:s", $tempo_atendimento - 3600 ) . "',
			status = '" . $status ."'
			where id_senha = '" . $id . "'";
        $res = $this->_db->Execute($sql);
    }

    function GetTempoEspera($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino)
    {
        $sql = "select max(id_senha) as id_senha from senhas
			where data='" . $data . "'
			and numero_senha='" . $numero_senha . "'
			and id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'
			and servico_destino='" . $servico_destino . "'";
        //debug($sql);
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");

        if (!$id) return 0;

        $sql = "select tempo_espera from senhas where id_senha='" . $id . "'";
        $res = $this->_db->Execute($sql);
        return $this->_db->Fields($res, "tempo_espera");
    }

    function GetTempoAtendimento($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino)
    {
        $sql = "select max(id_senha) as id_senha from senhas
			where data='" . $data . "'
			and numero_senha='" . $numero_senha . "'
			and id_loja='" . $id_loja . "'
			and servico_emissao='" . $servico_emissao . "'
			and servico_destino='" . $servico_destino . "'";
        //debug($sql);
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");

        if (!$id) return 0;

        $sql = "select tempo_atendimento from senhas where id_senha='" . $id . "'";
        $res = $this->_db->Execute($sql);
        return $this->_db->Fields($res, "tempo_atendimento");
    }

    function GetNumeroSenhasPorServico($data, $porHora=false, $porLocal=false)
    {
        $extraSelect = "";
        $groupBy = "";

        if ($porLocal) $groupBy = "id_loja, ";

        $groupBy .= "servico_destino, ";

        if($porHora)
        {
            $extraSelect = ", CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas ";
            $groupBy .= "horas, ";
        }

        $senhas = array();

        $sql =	"SELECT id_loja, servico_destino, status, count(*) AS n $extraSelect".
                "FROM senhas ".
                "WHERE data LIKE '$data%' ".
                "GROUP BY $groupBy status ";
        $res = $this->_db->executarSQL($sql);

        while ($row = $this->_db->obterRegisto($res))
        {
            if($porHora)
            {
                if ($porLocal)
                {
                    if(!isset($senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]))
                    {
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']] = array();
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['Emitidas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['EmEspera'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['EmAtendimento'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['Desistidas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']][$row['horas']]['Anuladas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_loja']][$row['servico_destino']][$row['horas']];
                }
                else
                {
                    if(!isset($senhas[$row['servico_destino']][$row['horas']]))
                    {
                        $senhas[$row['servico_destino']][$row['horas']] = array();
                        $senhas[$row['servico_destino']][$row['horas']]['Emitidas'] = 0;
                        $senhas[$row['servico_destino']][$row['horas']]['EmEspera'] = 0;
                        $senhas[$row['servico_destino']][$row['horas']]['EmAtendimento'] = 0;
                        $senhas[$row['servico_destino']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['servico_destino']][$row['horas']]['Desistidas'] = 0;
                        $senhas[$row['servico_destino']][$row['horas']]['Anuladas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['servico_destino']][$row['horas']];
                }
            }else
            {
                if ($porLocal)
                {
                    if(!isset($senhas[$row['id_loja']][$row['servico_destino']]))
                    {
                        $senhas[$row['id_loja']][$row['servico_destino']] = array();
                        $senhas[$row['id_loja']][$row['servico_destino']]['Emitidas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']]['EmEspera'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']]['EmAtendimento'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']]['Terminadas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']]['Desistidas'] = 0;
                        $senhas[$row['id_loja']][$row['servico_destino']]['Anuladas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_loja']][$row['servico_destino']];
                }
                else
                {
                    if(!isset($senhas[$row['servico_destino']]))
                    {
                        $senhas[$row['servico_destino']] = array();
                        $senhas[$row['servico_destino']]['Emitidas'] = 0;
                        $senhas[$row['servico_destino']]['EmEspera'] = 0;
                        $senhas[$row['servico_destino']]['EmAtendimento'] = 0;
                        $senhas[$row['servico_destino']]['Terminadas'] = 0;
                        $senhas[$row['servico_destino']]['Desistidas'] = 0;
                        $senhas[$row['servico_destino']]['Anuladas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['servico_destino']];
                }
            }

            switch ($row['status'])
            {
                case 'Emissao':
                case 'Suspensa':
                    $arrayPos['EmEspera'] += $row['n'];
                    $arrayPos['Emitidas'] += $row['n'];
                    break;
                case 'Chamada':
                case 'Rechamada':
                    $arrayPos['EmAtendimento'] += $row['n'];
                    $arrayPos['Emitidas'] += $row['n'];
                    break;
                case 'Terminado':
                case 'Redireccao':
                    $arrayPos['Terminadas'] += $row['n'];
                    $arrayPos['Emitidas'] += $row['n'];
                    break;
                case 'Desistencia':
                    $arrayPos['Desistidas'] += $row['n'];
                    $arrayPos['Emitidas'] += $row['n'];
                    break;
                case 'Anulada':
                    $arrayPos['Anuladas'] += $row['n'];
                    $arrayPos['Emitidas'] += $row['n'];
                    break;
                default:
                    break;
            }
        }
        return $senhas;
    }

    function GetTemposPorServico($data, $porHora=false, $porLocal=false)
    {
        $extraSelect = "";
        $extraGroupBy = "";

        if ($porLocal)
        {
            $extraSelect = ", id_loja";
            $extraGroupBy = "id_loja, ";
        }

        if($porHora)
        {
            $extraSelect .= ", CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas ";
            $extraGroupBy .= "horas,";
        }

        $tempos = array();

        $sql = 	"SELECT	servico_destino, ".
                "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) as med_tempo_espera, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS max_tempo_espera $extraSelect ".
                "FROM senhas ".
                "WHERE	data LIKE '$data%' AND ".
                "	(	status = '" . SENHA_CHAMADA . "' OR ".
                "		status = '" . SENHA_RECHAMADA . "' OR ".
                "		status = '" . SENHA_SUSPENSA . "' OR ".
                "		status = '" . SENHA_TERMINADA . "' OR ".
                "		status = '" . SENHA_DESISTIDA . "' OR ".
                "		status = '" . SENHA_REDIRECCAO . "' ".
                "	) ".
                "GROUP BY $extraGroupBy servico_destino";

              
        $res = $this->_db->executarSQL($sql);

        while ($row = $this->_db->ObterRegisto($res))
        {
            if($porHora)
            {
                if ($porLocal)
                {
                    if(!isset($tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]))
                    {
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']] = array();
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['espera'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['esperaMax'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']][$row['horas']];
                }
                else
                {
                    if(!isset($tempos[$row['servico_destino']][$row['horas']]))
                    {
                        $tempos[$row['servico_destino']][$row['horas']] = array();
                        $tempos[$row['servico_destino']][$row['horas']]['espera'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['esperaMax'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['servico_destino']][$row['horas']];
                }
            }else
            {
                if ($porLocal)
                {
                    if(!isset($tempos[$row['id_loja']][$row['servico_destino']]))
                    {
                        $tempos[$row['id_loja']][$row['servico_destino']] = array();
                        $tempos[$row['id_loja']][$row['servico_destino']]['espera'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['esperaMax'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']];
                }
                else
                {
                    if(!isset($tempos[$row['servico_destino']]))
                    {
                        $tempos[$row['servico_destino']] = array();
                        $tempos[$row['servico_destino']]['espera'] = "00:00:00";
                        $tempos[$row['servico_destino']]['esperaMax'] = "00:00:00";
                        $tempos[$row['servico_destino']]['atendimento'] = "00:00:00";
                        $tempos[$row['servico_destino']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['servico_destino']];
                }
            }

            $arrayPos['espera'] = $row['med_tempo_espera'];
            $arrayPos['esperaMax'] = $row['max_tempo_espera'];
        }

        $sql = 	"SELECT	servico_destino, ".
                "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS med_tempo_atendimento, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) as max_tempo_atendimento $extraSelect ".
                "FROM senhas ".
                "WHERE	data LIKE '$data%' AND ".
                "	(	status = '" . SENHA_TERMINADA . "' OR ".
                "		status = '" . SENHA_REDIRECCAO . "' ".
                "	) ".
                "GROUP BY $extraGroupBy servico_destino";

        $res = $this->_db->executarSQL($sql);

        while ($row = $this->_db->obterRegisto($res))
        {
            if($porHora)
            {
                if ($porLocal)
                {
                    if(!isset($tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]))
                    {
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']] = array();
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['espera'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['esperaMax'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']][$row['horas']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']][$row['horas']];
                }
                else
                {
                    if(!isset($tempos[$row['servico_destino']][$row['horas']]))
                    {
                        $tempos[$row['servico_destino']][$row['horas']] = array();
                        $tempos[$row['servico_destino']][$row['horas']]['espera'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['esperaMax'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['servico_destino']][$row['horas']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['servico_destino']][$row['horas']];
                }
            }else
            {
                if ($porLocal)
                {
                    if(!isset($tempos[$row['id_loja']][$row['servico_destino']]))
                    {
                        $tempos[$row['id_loja']][$row['servico_destino']] = array();
                        $tempos[$row['id_loja']][$row['servico_destino']]['espera'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['esperaMax'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_loja']][$row['servico_destino']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_loja']][$row['servico_destino']];
                }
                else
                {
                    if(!isset($tempos[$row['servico_destino']]))
                    {
                        $tempos[$row['servico_destino']] = array();
                        $tempos[$row['servico_destino']]['espera'] = "00:00:00";
                        $tempos[$row['servico_destino']]['esperaMax'] = "00:00:00";
                        $tempos[$row['servico_destino']]['atendimento'] = "00:00:00";
                        $tempos[$row['servico_destino']]['atendimentoMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['servico_destino']];
                }
            }

            $arrayPos['atendimento'] = $row['med_tempo_atendimento'];
            $arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
        }
        return $tempos;
    }

    function GetNumeroSenhasPorColaborador($data, $porHora=false, $entityIndependent=false, $porLocal=false)
    {
        $extraSelect = "";
        $extraGroupBy = "";

        if($porLocal)
        {
            $extraSelect .= ", s.id_loja local ";
            $extraGroupBy .= "local,";
        }

        if($porHora)
        {
            $extraSelect .= ", CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas ";
            $extraGroupBy .= "horas,";
        }

        $sql =	"SELECT";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .=
                "	s.id_colaborador, ".
                "	s.status, ".
                "	count(*) AS n $extraSelect ".
                "FROM senhas AS s ";
        if (!$entityIndependent) $sql .=
                    "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ";
        $sql .=
                "WHERE	s.data_string LIKE '$data%' AND ".
                //"WHERE  s.data = '$data' AND ".  // 2022-05-20 (GE) Fixed Resumo Por colaborador
                "	s.id_colaborador IS NOT NULL AND ".
                "	(	s.status = '" . SENHA_TERMINADA . "' OR ".
                "		s.status = '" . SENHA_DESISTIDA . "' OR ".
                "		s.status = '" . SENHA_REDIRECCAO . "' ".
                "	) ".
                "GROUP BY $extraGroupBy";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .= " s.id_colaborador, s.status";
//        debug($sql);

        $res = $this->_db->executarSQL($sql);
//        debug(print_r($res, true));

        $senhas = array();
        while ($row = $this->_db->obterRegisto($res))
        {

            if ($entityIndependent)
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['horas']]))
                    {
                        $senhas[$row['id_colaborador']][$row['horas']] = array();
                        $senhas[$row['id_colaborador']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['id_colaborador']][$row['horas']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_colaborador']][$row['horas']];
                }
                else
                if (!$porHora && $porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['local']]))
                    {
                        $senhas[$row['id_colaborador']][$row['local']] = array();
                        $senhas[$row['id_colaborador']][$row['local']]['Terminadas'] = 0;
                        $senhas[$row['id_colaborador']][$row['local']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_colaborador']][$row['local']];
                }else
                if ($porHora && $porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['local']][$row['horas']]))
                    {
                        $senhas[$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $senhas[$row['id_colaborador']][$row['local']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['id_colaborador']][$row['local']][$row['horas']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($senhas[$row['id_colaborador']]))
                    {
                        $senhas[$row['id_colaborador']] = array();
                        $senhas[$row['id_colaborador']]['Terminadas'] = 0;
                        $senhas[$row['id_colaborador']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_colaborador']];
                }
            }
            else
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['horas']]))
                    {
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['horas']] = array();
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_entidade']][$row['id_colaborador']][$row['horas']];
                }else
                if (!$porHora && $porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['horas']]))
                    {
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']] = array();
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']]['Terminadas'] = 0;
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']];
                }else
                if ($porHora && $porLocal)
                {
                    if(!isset($senhas[$row['id_colaborador']][$row['horas']]))
                    {
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['Terminadas'] = 0;
                        $senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($senhas[$row['id_entidade']][$row['id_colaborador']]))
                    {
                        $senhas[$row['id_entidade']][$row['id_colaborador']] = array();
                        $senhas[$row['id_entidade']][$row['id_colaborador']]['Terminadas'] = 0;
                        $senhas[$row['id_entidade']][$row['id_colaborador']]['Desistidas'] = 0;
                    }
                    $arrayPos = &$senhas[$row['id_entidade']][$row['id_colaborador']];
                }
            }

            switch ($row['status'])
            {
                case SENHA_TERMINADA:
                case SENHA_REDIRECCAO:
                    $arrayPos['Terminadas'] += $row['n'];
                    break;
                case SENHA_DESISTIDA:
                    $arrayPos['Desistidas'] += $row['n'];
                    break;
            }
        }
        return $senhas;
    }

    function GetTemposPorColaborador($data, $porHora=false, $entityIndependent=false, $porLocal=false)
    {
//        debug("inside GetTemposPorColaborador\n");

        $extraSelect = "";
        $extraGroupBy = "";

        if($porLocal)
        {
            $extraSelect .= ", s.id_loja local ";
            $extraGroupBy .= "local,";
        }

        if($porHora)
        {
            $extraSelect .= ", CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas ";
            $extraGroupBy .= "horas,";
        }

        $sql =	"SELECT";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .=
                "	s.id_colaborador, ".
                "	SEC_TO_TIME(AVG(TIME_TO_SEC(s.tempo_atendimento))) AS med_tempo_atendimento, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(s.tempo_atendimento))) AS max_tempo_atendimento $extraSelect ".
                "FROM senhas AS s ";
        if (!$entityIndependent) $sql .=
                    "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ";
        $sql .=
                "WHERE	s.data_string LIKE '$data%' AND ". 
                //"WHERE  s.data = '$data' AND ".             // 2022-05-20 (GE) Fixed Resumo Por colaborador
                "	s.id_colaborador IS NOT NULL AND ".
                "	(	s.status = '" . SENHA_REDIRECCAO . "' OR ".
                "		s.status = '" . SENHA_TERMINADA . "' ".
                "	) ".
                "GROUP BY $extraGroupBy";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .= " s.id_colaborador";
//        debug($sql);

        $res = $this->_db->executarSQL($sql);
//        debug(print_r($res, true));

        $tempos = array();
        while ($row = $this->_db->obterRegisto($res))
        {
//            debug("how many times?\n");

            if ($entityIndependent)
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['horas']]))
                    {
                        $tempos[$row['id_colaborador']][$row['horas']] = array();
                        $tempos[$row['id_colaborador']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['horas']];
                }else
                if(!$porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['local']]))
                    {
                        $tempos[$row['id_colaborador']][$row['local']] = array();
                        $tempos[$row['id_colaborador']][$row['local']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['local']];
                }else
                if($porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['local']][$row['horas']]))
                    {
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($tempos[$row['id_colaborador']]))
                    {
                        $tempos[$row['id_colaborador']] = array();
                        $tempos[$row['id_colaborador']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']];
                }
            }
            else
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']];
                }else
                if(!$porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']];
                }else
                if($porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']];
                }
            }


            $arrayPos['atendimento'] = $row['med_tempo_atendimento'];
            $arrayPos['atendimentoMax'] = $row['max_tempo_atendimento'];
        }

        $sql =	"SELECT";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .=
                "	s.id_colaborador, ".
                "	SEC_TO_TIME(AVG(TIME_TO_SEC(s.tempo_atendimento))) AS med_tempo_desistencias, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(s.tempo_atendimento))) AS max_tempo_desistencias $extraSelect ".
                "FROM senhas AS s ";
        if (!$entityIndependent) $sql .=
                    "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ";
        $sql .=
                "WHERE	s.data_string LIKE '$data%' AND ".
                //"WHERE  s.data = '$data' AND ".             // 2022-05-20 (GE) Fixed Resumo Por colaborador
                "	s.id_colaborador IS NOT NULL AND ".
                "	s.status = '" . SENHA_DESISTIDA . "' ".
                "GROUP BY $extraGroupBy";
        if (!$entityIndependent) $sql .= " serv.id_entidade, ";
        $sql .= " s.id_colaborador";
        $res = $this->_db->executarSQL($sql);

        while ($row = $this->_db->obterRegisto($res))
        {
            if ($entityIndependent)
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['horas']]))
                    {
                        $tempos[$row['id_colaborador']][$row['horas']] = array();
                        $tempos[$row['id_colaborador']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['horas']];
                }else
                if(!$porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['local']]))
                    {
                        $tempos[$row['id_colaborador']][$row['local']] = array();
                        $tempos[$row['id_colaborador']][$row['local']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['local']];
                }else
                if($porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_colaborador']][$row['local']][$row['horas']]))
                    {
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']][$row['local']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($tempos[$row['id_colaborador']]))
                    {
                        $tempos[$row['id_colaborador']] = array();
                        $tempos[$row['id_colaborador']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_colaborador']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_colaborador']];
                }
            }
            else
            {
                if($porHora && !$porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['horas']];
                }else
                if(!$porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']];
                }else
                if($porHora && $porLocal)
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']][$row['local']][$row['horas']];
                }else
                {
                    if(!isset($tempos[$row['id_entidade']][$row['id_colaborador']]))
                    {
                        $tempos[$row['id_entidade']][$row['id_colaborador']] = array();
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['atendimento'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['atendimentoMax'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['desistencia'] = "00:00:00";
                        $tempos[$row['id_entidade']][$row['id_colaborador']]['desistenciaMax'] = "00:00:00";
                    }
                    $arrayPos = &$tempos[$row['id_entidade']][$row['id_colaborador']];
                }
            }

            $arrayPos['desistencia'] = $row['med_tempo_desistencias'];
            $arrayPos['desistenciaMax'] = $row['max_tempo_desistencias'];
        }

        return $tempos;
    }

    function GetTempoMaxAtendimento($data, $status='')
    {
        $sql = "select MAX(tempo_atendimento) as max_tempo_atendimento from senhas where data LIKE '$data%'";
        if (strlen($status)) $sql .= " and status='".$status."'";
        $res = $this->_db->Execute($sql);
        return $this->_db->Fields($res, "max_tempo_atendimento");
    }

    function GetTempoMedioMaxEspera($data, $local=null, $colaborador=null, $servico=null)
    {
        $sql = 	"SELECT	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) as med_tempo_espera, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS max_tempo_espera ".
                "FROM senhas ".
                "WHERE	data_string LIKE '$data%' ";
                //"WHERE  data = '$data' ";  // 2022-05-20 (GE) Fixed Resumo Por colaborador
        if (is_array($local))
            $sql .= " and id_loja in (".implode(", ", $local).") ";
        if (is_array($colaborador))
            $sql .= " and id_colaborador in (".implode(", ", $colaborador).") ";
        if (is_array($servico))
            $sql .= " and servico_destino in (".implode(", ", $servico).") ";
        $sql .= " and (	status = '" . SENHA_CHAMADA . "' OR ".
                "		status = '" . SENHA_RECHAMADA . "' OR ".
                "		status = '" . SENHA_SUSPENSA . "' OR ".
                "		status = '" . SENHA_TERMINADA . "' OR ".
                "		status = '" . SENHA_DESISTIDA . "' OR ".
                "		status = '" . SENHA_REDIRECCAO . "' ".
                "	)";
//        debug($sql);

        $res = $this->_db->executarSQL($sql);
        $tempo_medio_espera = $this->_db->obterValor($res, "med_tempo_espera");
        $tempo_max_espera = $this->_db->obterValor($res, "max_tempo_espera");

        if(!$tempo_medio_espera)
        {
            $tempo_medio_espera = "00:00:00";
        }
        if(!$tempo_max_espera)
        {
            $tempo_max_espera = "00:00:00";
        }

        $tempos = array();
        $tempos['avg'] = $tempo_medio_espera;
        $tempos['max'] = $tempo_max_espera;

        return $tempos;
    }

    function GetTempoMedioMaxAtendimento($data, $local=null, $colaborador=null, $servico=null)
    {
        $sql = 	"SELECT	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS med_tempo_atendimento, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) as max_tempo_atendimento ".
                "FROM senhas ".
                "WHERE	data_string LIKE '$data%' ";
                // "WHERE  data = '$data' ";   // 2022-05-20 (GE) Fixed Resumo Por colaborador
        if (is_array($local))
            $sql .= " and id_loja in (".implode(", ", $local).") ";
        if (is_array($colaborador))
            $sql .= " and id_colaborador in (".implode(", ", $colaborador).") ";
        if (is_array($servico))
            $sql .= " and servico_destino in (".implode(", ", $servico).") ";
        $sql .= " and (	status = '" . SENHA_TERMINADA . "' OR ".
                " status = '" . SENHA_REDIRECCAO . "' ".
                " ) ";
//        debug($sql);

        $res = $this->_db->executarSQL($sql);
        $tempo_medio_atendimento = $this->_db->obterValor($res, "med_tempo_atendimento");
        $tempo_max_atendimento = $this->_db->obterValor($res, "max_tempo_atendimento");

        if(!$tempo_medio_atendimento)
        {
            $tempo_medio_atendimento = "00:00:00";
        }
        if(!$tempo_max_atendimento)
        {
            $tempo_max_atendimento = "00:00:00";
        }

        $tempos = array();
        $tempos['avg'] = $tempo_medio_atendimento;
        $tempos['max'] = $tempo_max_atendimento;

        return $tempos;
    }

    function GetTempoMedioMaxAtendimentoDesistencias($data, $local=null, $colaborador=null, $servico=null)
    {

        $sql = 	"SELECT	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS med_tempo_atendimento, ".
                "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) as max_tempo_atendimento ".
                "FROM senhas ".
                "WHERE	data_string LIKE '$data%' ";
                 //"WHERE  data = '$data' "; // 2022-05-20 (GE) Fixed Resumo Por colaborador
        if (is_array($local))
            $sql .= " and id_loja in (".implode(", ", $local).") ";
        if (is_array($colaborador))
            $sql .= " and id_colaborador in (".implode(", ", $colaborador).") ";
        if (is_array($servico))
            $sql .= " and servico_destino in (".implode(", ", $servico).") ";
        $sql .= " and status = '" . SENHA_DESISTIDA . "' ";
//        debug($sql);

        $res = $this->_db->executarSQL($sql);
        $tempo_medio_atendimento = $this->_db->obterValor($res, "med_tempo_atendimento");
        $tempo_max_atendimento = $this->_db->obterValor($res, "max_tempo_atendimento");

        if(!$tempo_medio_atendimento)
        {
            $tempo_medio_atendimento = "00:00:00";
        }
        if(!$tempo_max_atendimento)
        {
            $tempo_max_atendimento = "00:00:00";
        }

        $tempos = array();
        $tempos['avg'] = $tempo_medio_atendimento;
        $tempos['max'] = $tempo_max_atendimento;

        return $tempos;
    }

    function ListarPorServico($data='', $mensal=false, $local=null, $servico=null)
    {
        $extra = array();
        $xtr_param_str = "";

        if ($local)
        {
            array_push($extra, "local");
            if (is_array($local)) $xtr_param_str .= "&local[]=".implode("&local[]=", $local);
        }
        if ($servico)
        {
            array_push($extra, "servico");
            if (is_array($servico)) $xtr_param_str .= "&servico[]=".implode("&servico[]=", $servico);
        }
        if (count($extra)) $xtr_param_str .= "&extra=".implode(";", $extra);

        if (!strlen($data))
        {
            $data = date("Y-m-d");
        }

        if($mensal)
        {
            $data = date('Y-m', strtotime($data));
        }

//		$sql = 	"SELECT e.nome AS entidade, s.nome AS servico, s.id_servico ".
//			"FROM servicos AS s ".
//			"INNER JOIN entidades AS e ON e.id_entidade = s.id_entidade where 1 ";

        $sql = "select l.nome local, s.nome servico, l.id_loja id_loja, s.id_servico
			from lojas l
			inner join lojas_entidades le on le.id_loja=l.id_loja
			inner join servicos s on s.id_entidade=le.id_entidade";

        if (is_array($local))
        {
            $sql .= " and l.id_loja in (".implode(",", $local).")";
        }
        if (is_array($servico))
        {
            $sql .= " and s.id_servico in (".implode(",", $servico).")";
        }

        $sql .= " order by local asc, servico asc";

        $res = $this->_db->executarSQL($sql);

        $servicos = array();
        while ($row = $this->_db->obterRegisto($res))
        {
            array_push($servicos, $row);
        }

        $numeroSenhas = $this->GetNumeroSenhasPorServico($data,false,true);
        $tempos = $this->GetTemposPorServico($data,false,true);

//		echo "<pre>";
//		print_r($numeroSenhas);
//		echo "<br/>";
//		echo "<br/>";
//		print_r($tempos);
//		echo "</pre>";

        echo '<table class="sortable" width="100%" style="text-align:center;border-spacing: unset;">';

        echo '<thead>';

        echo '<tr class="column_row">';
        echo '<th rowspan="2" style="width:3%">'. translate('word_local', true) .'</th>';
        echo '<th rowspan="2" style="width:3%">'. translate("word_service", true) .'</th>';
        echo '<th rowspan="2" style="width:3%">'. translate("word_emitidas", true) .'</th>';

        if ($data==date("Y-m-d"))
            echo '<th rowspan="2" style="width:3%">'. translate("word_em_espera", true) .'</th>';
        if ($data==date("Y-m-d"))
            echo '<th rowspan="2" style="width:3%">'. translate("word_em_atendimento", true) .'</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_met', true).'</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_retirements', true).'</th>';
        echo '<th style="width:5%" colspan="2">'.translate('word_tempo_medio_espera', true).'</th>';
        echo '<th style="width:5%" colspan="2">'.translate('word_tempo_medio_atendimento', true).'</th>';
        echo '</tr>';
        echo '<tr class="column_row">';

        echo '<th colspan="2" style="text-transform: capitalize;"><span style="color:#777777">'.translate('word_estatisticas_tempo_medio', true). '/</span>' .translate('word_estatisticas_tempo_maximo', true).'</th>';
        echo '<th colspan="2" style="text-transform: capitalize;"><span style="color:#777777">'.translate('word_estatisticas_tempo_medio', true). '/</span>' .translate('word_estatisticas_tempo_maximo', true).'</th>';
        echo '</tr>';
        echo '</thead>';

        echo '<tbody>';

        $total_emitidas = 0;
        $total_espera = 0;
        $total_atendimento = 0;
        $total_terminadas = 0;
        $total_desistidas = 0;

        $n_listed = 0;



        for ($i=0; $i < count($servicos); $i++)
        {
            if(isset($tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['espera']))
                $tempo_espera = $tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['espera'];
            else
                $tempo_espera = '00:00:00';

            if(isset($tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['esperaMax']))
                $tempo_esperaMax = $tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['esperaMax'];
            else
                $tempo_esperaMax = '00:00:00';

            if(isset($tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['atendimento']))
                $tempo_atendimento = $tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['atendimento'];
            else
                $tempo_atendimento = '00:00:00';

            if(isset($tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['atendimentoMax']))
                $tempo_atendimentoMax = $tempos[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['atendimentoMax'];
            else
                $tempo_atendimentoMax = '00:00:00';

            @$total_emitidas += $numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Emitidas'];
            @$total_espera += $numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['EmEspera'];
            @$total_atendimento += $numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['EmAtendimento'];
            @$total_terminadas += $numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Terminadas'];
            @$total_desistidas += $numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Desistidas'];


            /*if (@$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Emitidas']!=0)
            {*/
                $n_listed++;

                $background = '';
                if($i % 2)
                {
                    $background = 'style="background-color:#eeeeee"';
                }
                echo "<tr $background>";
                echo '<td>'.$servicos[$i]['local'].'</td>';
                echo '<td align="left">'.$servicos[$i]['servico'].'</td>';
                echo '<td>' . (0+$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Emitidas']) . '</td>';

                if ($data==date("Y-m-d")) echo '<td>'.(0+$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['EmEspera']).'</td>';
                if ($data==date("Y-m-d")) echo '<td>'.(0+$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['EmAtendimento']).'</td>';
                echo '<td>'.(0+$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Terminadas']).'</td>';
                echo '<td>'.(0+$numeroSenhas[$servicos[$i]['id_loja']][$servicos[$i]['id_servico']]['Desistidas']).'</td>';

                echo "<td class='table-join-left' style='width:2%'>$tempo_espera</td><td class='table-join-right'><font color='#23a6b9'>$tempo_esperaMax</font></td>";
                echo "<td class='table-join-left' style='width:2%'>$tempo_atendimento</td><td class='table-join-right'><font color='#23a6b9'>$tempo_atendimentoMax</font></td>";

                echo '</tr>';
            //}
        }
        echo '</tbody>';

        $temposEspera = $this->GetTempoMedioMaxEspera($data, $local, null, $servico);
        $temposAtendimento = $this->GetTempoMedioMaxAtendimento($data, $local, null, $servico);

        echo '<tfoot>';
        echo '<tr style="background-color: #ABE6ED">';
        echo '<th colspan="2">'. translate("word_totals", true) . ': </th>';
        echo '<td>'.$total_emitidas.'</td>';
        if ($data==date("Y-m-d")) echo '<td>'.$total_espera.'</td>';
        if ($data==date("Y-m-d")) echo '<td>'.$total_atendimento.'</td>';
        echo '<td>'.$total_terminadas.'</td>';
        echo '<td>'.$total_desistidas.'</td>';
        echo "<td class='background-white'></td>";
        echo "<td class='background-white'></td>";
        echo '</tr>';
        echo '<tr style="background-color: #ABE6ED">';
        echo '<th colspan="2">'. translate("word_medias", true) . ': </th>';
        echo '<td>'. (($n_listed > 0) ? intval($total_emitidas/$n_listed) : "0") .'</td>';
        if ($data==date("Y-m-d")) echo '<td>'. (($n_listed > 0) ? intval($total_espera/$n_listed) : 0).'</td>';
        if ($data==date("Y-m-d")) echo '<td>'.(($n_listed > 0) ? intval($total_atendimento/$n_listed) : 0).'</td>';
        echo '<td>'. (($n_listed > 0) ? intval($total_terminadas/$n_listed) : 0).'</td>';
        echo '<td>'. (($n_listed > 0) ? intval($total_desistidas/$n_listed) : 0).'</td>';
        echo "<td colspan='2'>$temposEspera[avg]</td>";
        echo "<td colspan='2'>$temposAtendimento[avg]</td>";
        echo '</tr>';
        echo '</tfoot>';

        echo '</table>';

        echo '<br/>';

        $temposAtendimentoDesistencias = $this->GetTempoMedioMaxAtendimentoDesistencias($data, $local, null, $servico);

     /*  echo '<table width="100%">';
        echo '<tr>';
        echo '<th>'. translate("word_tempo_maximo_espera", true) . ': </th>';
        echo "<td>$temposEspera[max]</td>";
        echo '</tr>';
        echo '<tr>';
        echo '<th>'. translate("word_tempo_maximo_espera_desistencias", true) . ': </th>';
        echo "<td>$temposAtendimentoDesistencias[max]</td>";
        echo '</tr>';
        echo '</table>';
    */

        $monthStr = "";
        $resumoLabel = translate("word_dia", true);
        if($mensal)
        {
            $monthStr = "&dataPeriod=month";
            $resumoLabel = translate("word_mes", true);
        }
        $resumo = translate("word_resume", true);
        echo '<table width="100%" style="display:none;">';
        echo "<tr><td>&nbsp;</td></tr>";
        echo '<tr>';
        echo '<th style="text-align:right; font-weight:bold;">'. translate("word_exportar_csv", true) . ': </th>';
        $downloadURL = "../senhas/chartsData.php?date=$data&dataSource=resumeServicesDay&outputFormat=downloadCSV$monthStr".$xtr_param_str;
        $downloadHorarioURL = "../senhas/chartsData.php?date=$data&dataSource=resumeServicesDayHours&outputFormat=downloadCSV$monthStr".$xtr_param_str;
        echo "<td style='text-align: right;' class='button' width=132><a href=\"$downloadURL\"><div class='button-thin-green'>$resumo $resumoLabel</div></a></td>";
        echo "<td style='text-align: right;' class='button' width=132><a href=\"$downloadHorarioURL\"><div class='button-thin-green'>$resumo $resumoLabel/" . translate("word_hora", true) . "</div></a></td>";
        echo '</tr>';
        echo "<tr><td>&nbsp;</td></tr>";
        echo '</table>';
    }

    function ListarPorColaborador($data='', $mensal=false, $local=null, $colaborador=null)
    {
        $extra = array();
        $xtr_param_str = "";

        $all_status_sql = $this->_db->executarSQL("SELECT * from estados_balcao");
        $all_status = array();
        while ($row = $this->_db->obterRegisto($all_status_sql))
        {
             array_push($all_status, $all_status_sql);
        }

        if ($local)
        {
            array_push($extra, "local");
            if (is_array($local)) $xtr_param_str .= "&local[]=".implode("&local[]=", $local);
        }
        if ($colaborador)
        {
            array_push($extra, "colaborador");
            if (is_array($colaborador)) $xtr_param_str .= "&colaborador[]=".implode("&colaborador[]=", $colaborador);
        }
        if (count($extra)) $xtr_param_str .= "&extra=".implode(";", $extra);

        $day=date('j', strtotime($data));
        $month=date('n', strtotime($data));
        $year=date('Y', strtotime($data));

        if ($data == '')
        {
            $data = date("Y-m-d");
            $day=date("j");
            $month=date("n");
            $year=date("Y");
        }

        if($mensal)
        {
            $data = date('Y-m', strtotime($data));
            $day=date('j', strtotime($data));
            $month=date('n', strtotime($data));
            $year=date('Y', strtotime($data));
        }


        $sql =	"SELECT distinct c.id_empregado, ".
                "	c.nome AS colaborador, ".
                "	c.contacto AS contacto, ".
                "	(	SELECT	b.nome ".
                "		FROM log_acessos_empregados AS lae ".
                "		INNER JOIN balcoes AS b ON b.id_balcao = lae.id_balcao ".
                "		WHERE	lae.id_empregado = c.id_empregado AND ".
                "			lae.acesso = 'Entrada' ".
                "		ORDER BY lae.data_hora DESC ".
                "		LIMIT 1 ".
                "	) AS ultimo_balcao, ".
                "	(	SELECT	b.id_balcao ".
                "		FROM log_acessos_empregados AS lae ".
                "		INNER JOIN balcoes AS b ON b.id_balcao = lae.id_balcao ".
                "		WHERE	lae.id_empregado = c.id_empregado AND ".
                "			lae.acesso = 'Entrada' ".
                "		ORDER BY lae.data_hora DESC ".
                "		LIMIT 1 ".
                "	) AS id_ultimo_balcao, ".
                "(              SELECT	b.estado ".
                "		FROM log_acessos_empregados AS lae ".
                "		INNER JOIN balcoes AS b ON b.id_balcao = lae.id_balcao ".
                "		WHERE	lae.id_empregado = c.id_empregado AND ".
                "			lae.acesso = 'Entrada' ".
                "		ORDER BY lae.data_hora DESC ".
                "		LIMIT 1 ".
                "	) AS estado_ultimo_balcao, ".
                "	l.id_loja id_loja, l.nome AS loja ".
                "FROM empregados AS c ".
                "inner join local_colaborador lc on lc.id_colaborador=c.id_empregado ".
                "inner join lojas l on l.id_loja=lc.id_local ".
                "where 1 ";

        if (is_array($local))
        {
            $sql .= " and lc.id_local in (".implode(",", $local).")";
        }
        if (is_array($colaborador))
        {
            $sql .= " and c.id_empregado in (".implode(",", $colaborador).")";
        }

        $sql .=
                " ORDER BY colaborador ";
	

        $res = $this->_db->executarSQL($sql);

        $colaboradores = array();
        while ($row = $this->_db->obterRegisto($res))
        {
            array_push($colaboradores, $row);

        }

        $numeroSenhas = $this->GetNumeroSenhasPorColaborador($data, false, true, true);
//        debug("GetNumeroSenhasPorColaborador ended.\n");
        $tempos = $this->GetTemposPorColaborador($data, false, true, true);
//        debug("GetTemposPorColaborador ended.\n");

        $resumo = translate("word_resume", true);
        echo '<table class="sortable" width="100%" style="text-align:center;border-spacing: unset;">';

        echo '<thead>';
        echo '<tr class="column_row">';
        echo '<th rowspan="2" style="width:3%">'.translate('word_local', true).'</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_costumer', true).'</th>';
        if(!CENTRAL){
             echo '<th rowspan="2" style="width:3%">'.translate('word_estado_colaborador', true).'</th>';
            echo '<th rowspan="2" style="width:5%">'.translate('word_duracao_ultimo_estado_colaborador', true).'</th>';
        }
        if ($data==date("Y-m-d"))
            echo '<th rowspan="2" style="width:3%">'.translate('word_agency', true). '</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_met', true). '</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_desistidas', true). '</th>';
        echo '<th style="width:3%" colspan="2">'.translate('word_tempo_medio_atendimento', true). '</th>';
        echo '<th style="width:4%" colspan="2">'.translate('word_tempo_medio_desistencia', true). '</th>';

//		if (!$mensal)
//		{
        echo '<th rowspan="2" style="width:3%">'.translate('word_tempo_balcao_atendimento', true). '</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_balcao_suspenso', true). '</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_tempo_balcao_livre', true). '</th>';

        echo '<th rowspan="2" style="width:3%">'.translate('word_tempo_total_balcao', true). '</th>';
        echo '<th rowspan="2" style="width:3%">'.translate('word_satisfacao', true). ' %</th>';
//		}

        echo '</tr>';
        echo '<tr class="column_row">';
        echo '<th colspan="2" style="text-transform: capitalize;"><span style="color:#777777">'.translate('word_estatisticas_tempo_medio', true). '/</span>' .translate('word_estatisticas_tempo_maximo', true).'</th>';
        echo '<th colspan="2" style="text-transform: capitalize;"><span style="color:#777777">'.translate('word_estatisticas_tempo_medio', true). '/</span>' .translate('word_estatisticas_tempo_maximo', true).'</th>';
        echo '</tr>';
        echo '</thead>';

        echo '<tbody>';

        $blc = new Balcao();
        $time_log=new timeManager();

        $total_terminadas = 0;
        $total_desistidas = 0;

        $total_balcao = 0;
        $total_balcao_suspenso = 0;
        $total_balcao_activo = 0;
        $total_livre = 0;


        $nListed = 0;
       
        for ($i=0; $i<count($colaboradores); $i++)
        {

            $idColaborador = $colaboradores[$i]['id_empregado'];

            $idLocal = $colaboradores[$i]['id_loja'];
             $empregado=new Empregado();
            if (true || isset($numeroSenhas[$idColaborador][$idLocal]))
            {
                $total_terminadas += $numeroSenhas[$idColaborador][$idLocal]['Terminadas'];
                $total_desistidas += $numeroSenhas[$idColaborador][$idLocal]['Desistidas'];

                 // balcão:
                $temposBalcao = $time_log->getLastAvailableTempos($idColaborador, $idLocal, $data, $mensal);

                if(isset($tempos[$idColaborador][$idLocal]['atendimento']))
                    $tempo_atendimento = $tempos[$idColaborador][$idLocal]['atendimento'];
                else
                    $tempo_atendimento = '00:00:00';
                if(isset($tempos[$idColaborador][$idLocal]['atendimentoMax']))
                    $tempo_atendimentoMax = $tempos[$idColaborador][$idLocal]['atendimentoMax'];
                else
                    $tempo_atendimentoMax = '00:00:00';

                if(isset($tempos[$idColaborador][$idLocal]['desistencia']))
                    $tempo_desistencias = $tempos[$idColaborador][$idLocal]['desistencia'];
                else
                    $tempo_desistencias = '00:00:00';
                if(isset($tempos[$idColaborador][$idLocal]['desistenciaMax']))
                    $tempo_desistenciasMax = $tempos[$idColaborador][$idLocal]['desistenciaMax'];
                else
                    $tempo_desistenciasMax = '00:00:00';

                if (true || $numeroSenhas[$idColaborador][$idLocal]['Terminadas'] !=0 || $numeroSenhas[$idColaborador][$idLocal]['Desistidas'] !=0 || $mensal)
                {   
                    $nListed++;
                    $background = '';
                    if($i % 2)
                    {
                        $background = 'style="background-color:#eeeeee"';
                    }
                    echo "<tr $background>";
                    echo '<td>'.$colaboradores[$i]['loja'].'</td>';
                    echo '<td>'.$colaboradores[$i]['colaborador'].'</td>';



                    if(!CENTRAL){
                        echo '<td>';
                        $empregado_status=$empregado->getEmpregadoStatus($idColaborador);

                        //se o empregado esta deslogado ou a data nao é a actual
                        if($empregado_status['estado']==3 ||  $data != date("Y-m-d")){
                            echo  "Fechado";
                        }else {

                            echo'<select name="status_selector" id="stat_select" onChange="';
                            echo "alert('O pedido foi enviado, e será processado dentro de alguns segundos.Por favor faça refresh à página.');";
                            echo ' change_balcao_status(this.options[this.selectedIndex].value, this.options[this.selectedIndex].id)"';
                            echo  "'>";


                            foreach ($all_status[0] as $value){

                                if($empregado_status['estado']==1 && $empregado_status['estado']==$value['id_estados_balcao']){

                                    echo '<option id="'.$empregado_status['id_balcao'].'" value="'.$value['id_estados_balcao'].'"';
                                    echo ' selected>';
                                    echo  $value['nome'];
                                    echo '</option>';

                                }else if(!($value['nome']=="Em atendimento")){
                                    echo '<option id="'.$empregado_status['id_balcao'].'" value="'.$value['id_estados_balcao'].'"';
                                      if($empregado_status['estado']==$value['id_estados_balcao']){
                                            echo ' selected';
                                        }
                                    echo '>';
                                    echo $value['nome'];
                                    echo '</option>';
                                }
                            }

                          echo'</select>';
                       }
                        echo '</td>';

                        echo '<td>'.$empregado_status['duracao'].'</td>';
                        if ($data==date("Y-m-d")) echo '<td>'.$colaboradores[$i]['ultimo_balcao'].'&nbsp;</td>';

                    }

                    $balcao_time_values=0;
                    if($mensal){
                        $balcao_time_values=$time_log->getTemposByMonth($idColaborador, $idLocal, $month, $year);

                    }else{
                        $balcao_time_values=$time_log->getTemposByDay($idColaborador, $idLocal, $day, $month, $year);

                    }

                    echo '<td>'.(0+$numeroSenhas[$idColaborador][$idLocal]['Terminadas']).'</td>';
                    echo '<td>'.(0+$numeroSenhas[$idColaborador][$idLocal]['Desistidas']).'</td>';
                    echo "<td class='table-join-left' style='width:2%'>$tempo_atendimento</td><td class='table-join-right'><font color='#23a6b9'>$tempo_atendimentoMax</font></td>";
                    echo "<td class='table-join-left' style='width:2%'>$tempo_desistencias</td><td class='table-join-right'><font color='#23a6b9'>$tempo_desistenciasMax</font></td>";

                    //				if (!$mensal)
                    //				{
                    //					echo "<td>".gmdate("H:i:s", $temposBalcao["atendimento"])."</td>";
                    //					echo "<td>".gmdate("H:i:s", $temposBalcao["suspenso"])."</td>";
                    //					echo "<td>".gmdate("H:i:s", $temposBalcao["total"])."</td>";

                    //tempo de atendimento
                    echo '<td sorttable_customkey="'.$temposBalcao["atendimento"].'">'.Timestamp_to_Time($temposBalcao["atendimento"])."</td>";

                    echo '<td sorttable_customkey="'.$temposBalcao["suspenso"].'">'.Timestamp_to_Time($temposBalcao["suspenso"])."</td>";

                      if($temposBalcao["livre"]){
                         echo '<td>'.Timestamp_to_Time($temposBalcao["livre"])."</td>";
                      }else{
                           echo "<td>00:00:00</td>";
                      }


                    echo '<td sorttable_customkey="'.Timestamp_to_Time($temposBalcao["total"]).'">'.Timestamp_to_Time($temposBalcao["total"])."</td>";

                    echo '<td><span class="dropt">'.$empregado->getSatisfacao($data, $idColaborador, $idLocal).'<span style="width:500px;">
                      <p>'.translate('word_total_avaliacoes', true). ': '.$empregado->getTotalAval($data, $idColaborador, $idLocal).'</p>
                      <p>'.translate('word_avaliacoes_positivas', true). ': '.$empregado->getTotalPositivo($data, $idColaborador, $idLocal).'</p>
                      <p>'.translate('word_avaliacoes_negativas', true). ': '.$empregado->getTotalNegativo($data, $idColaborador, $idLocal).'</p>

</span>
</span></td>';
                    echo '</tr>';

                    //
                    $total_balcao_activo += $temposBalcao["atendimento"];
                    $total_balcao_suspenso += $temposBalcao["suspenso"];
                    $total_livre+= $temposBalcao['livre'];
                    $total_balcao += $temposBalcao["total"];


                    //				}
                }
            }
        }
        echo '</tbody>';

        $temposEspera = $this->GetTempoMedioMaxEspera($data, $local, $colaborador);
        $temposAtendimento = $this->GetTempoMedioMaxAtendimento($data, $local, $colaborador);
        $temposAtendimentoDesistencias = $this->GetTempoMedioMaxAtendimentoDesistencias($data, $local, $colaborador);

        echo '<tfoot>';
        $numberCols = 2;
        if ($data==date("Y-m-d"))
        {
            $numberCols = 3;
        }
        echo '<tr style="background-color: #ABE6ED">';
        echo "<th colspan='$numberCols'></th>";
        if(!CENTRAL){
        echo "<td style='background-color: white'></td>";
        echo "<th style='background-color: white'>".translate('word_totals', true). ": </th>";
        }
        echo '<td>'.$total_terminadas.'</td>';
        echo '<td>'.$total_desistidas.'</td>';
        echo "<td style='background-color: white'></td>";
        echo "<td style='background-color: white'></td>";
        echo "<td style='background-color: white'></td>";
          echo "<td style='background-color: white'></td>";
          echo "<td style='background-color: white'></td>";
          echo "<td style='background-color: white'></td>";
        echo '</tr>';
        echo '<tr style="background-color: #ABE6ED">';
        echo "<th colspan='$numberCols'></th>";
        if(!CENTRAL){
        echo "<td style='background-color: white'></td>";
          echo "<th style='background-color: white'>".translate('word_medias', true). ": </th>";
        }
        echo '<td>'.(($nListed)?intval($total_terminadas/$nListed):"0").'</td>';
        echo '<td>'.(($nListed)?intval($total_desistidas/$nListed):"0").'</td>';
        echo "<td style='border-right: 0px;'>$temposAtendimento[avg]</td>";
        echo "<td style='border-left: 0px;color:#23a6b9;'>$temposAtendimento[max]</td>";
        //echo "<td debug>$temposAtendimentoDesistencias[avg]</td>";
        echo "<td style='border-right: 0px;'>$temposAtendimentoDesistencias[avg]</td>";
        echo "<td style='border-left: 0px;color:#23a6b9;'>$temposAtendimentoDesistencias[max]</td>";


        if ($nListed > 0) {
          echo "<td>".Timestamp_to_Time(intval($total_balcao_activo/$nListed))."</td>";
          echo "<td>".Timestamp_to_Time(intval($total_balcao_suspenso/$nListed))."</td>";
          echo "<td>".Timestamp_to_Time(intval($total_livre/$nListed))."</td>";
          echo "<td>".Timestamp_to_Time(intval($total_balcao/$nListed))."</td>";
        }
        else {
          echo "<td>00:00:00</td>";
          echo "<td>00:00:00</td>";
          echo "<td>00:00:00</td>";
          echo "<td>00:00:00</td>";
        }
//		}

        echo '</tr>';
        echo '</tfoot>';

        echo '</table>';

        echo '<br/>';

        echo '<table>';
        echo '<tr>';
        echo '<th class="formname_space">'.translate('word_tempo_maximo_espera', true). ': </th>';
        echo "<td>$temposEspera[max]</td>";
        echo '</tr>';
        echo '<tr>';
        echo '<th class="formname_space" style="width: 230px !important;">'.translate('word_tempo_maximo_espera_desistencias', true). ': </th>';
        echo "<td>$temposAtendimentoDesistencias[max]</td>";
        echo '</tr>';
        echo '</table>';


        $monthStr = "";
        $resumoLabel = "Dia";
        if($mensal)
        {
            $monthStr = "&dataPeriod=month";
            $resumoLabel = "M&ecirc;s";
        }

        echo '<table width="100%" style="display:none;">';
        echo "<tr><td>&nbsp;</td></tr>";
        echo '<tr>';
        echo '<th>Exportar dados (.csv): </th>';
        $downloadURL = "../senhas/chartsData.php?date=$data&dataSource=resumeEmployesDay&outputFormat=downloadCSV$monthStr".$xtr_param_str;
        $downloadHorarioURL = "../senhas/chartsData.php?date=$data&dataSource=resumeEmployesDayHours&outputFormat=downloadCSV$monthStr".$xtr_param_str;
        echo "<td style='text-align: right;' width=132 class='button'><a href=\"$downloadURL\"><div class='button-thin-green'>$resumo $resumoLabel</div></a></td>";
        echo "<td style='text-align: right;' width=132 class='button'><a href=\"$downloadHorarioURL\"><div class='button-thin-green'>$resumo $resumoLabel/Hora</div></a></td>";
        echo '</tr>';
        echo "<tr><td>&nbsp;</td></tr>";
        echo '</table>';
    }

    function displayTimeFromSeconds($seconds){
  if ($seconds > 172800) // two days or more
  {
    $format = 'j \d\a\y\s H:i:s';
  }
  else if ($seconds > 86400) // more than one day, less than two
  {
    $format = 'j \d\a\y H:i:s';
  }
  else // less than a day
  {
    $format = 'H:i:s';
  }

  return gmdate ($format, $seconds);
}


    function GetUltimaSenhaChamada($id_loja, $servico_destino)
    {

        // get last tickect called from this store and service
//		$sql = 	"SELECT id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status ".
//				"FROM senhas ".
//				"WHERE 	data = NOW() AND ".
//				"		id_loja = $id_loja AND ".
//				"		servico_destino = $servico_destino AND ".
//				"		status IN ('Terminado', 'Chamada', 'Rechamada') ".
//				"ORDER BY status, numero_senha DESC ".
//				"LIMIT 1 ";
//		$res = $this->_db->Execute($sql);
//		return $this->_db->FetchRow($res);

//        $sql = "SELECT IF( (TIME_TO_SEC(h.fecho_" . $diaAnterior . ") - TIME_TO_SEC(h.abertura_" . $diaSemana . ")) >= 86340, " . // 86340 => 23:59 - 00:00 em segundos
//                "	    1, " .
//                "	    0) AS servico24horas " .
//                "FROM servicos AS s " .
//                "INNER JOIN horario AS h ON h.id = s.horario " .
//                "WHERE s.id_servico = " . $servico_destino;

	$sql = "SELECT s.horario AS id_horario " .
                "FROM servicos AS s " .
                "WHERE s.id_servico = " . $servico_destino;

        $res = $this->_db->Execute($sql);
	$idHorario = $this->_db->Fields($res, "id_horario");

	$servico24horas = false; // by default we consider it not to be continuos

	if ($idHorario != null) {
		// This service has an Horario associated which it should anyway.
		// Check if this Horario specifies that we were open during
		// the night.
		$horario = new Horario();
		$horario->get($idHorario);

		$servico24horas = $horario->isContinuouslyOpenToday();
	}

        $sql = "select max(id_senha) max from senhas where id_loja='".$id_loja."'
			and servico_destino='".$servico_destino."'
			and (status='Terminado' or status='Suspensa' or status='Redireccao' or status='Desistencia')";
        if (!$servico24horas) $sql .= " and data=curdate()";

        $res = $this->_db->Execute($sql);
        $maxSenha = $this->_db->Fields($res, "max");

        $sql = "select id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status
			from senhas
			where id_senha='".$maxSenha."'";

        $res = $this->_db->Execute($sql);
        return $this->_db->obterRegisto($res);

        /*$sql = "select id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status,
			timestampadd(
				second,
				time_to_sec(if(tempo_espera, tempo_espera, '00:00:00')) + time_to_sec(if(tempo_atendimento, tempo_atendimento, '00:00:00')),
				emissao) as termino
			from senhas
			where id_loja='".$id_loja."'
			and servico_destino='".$servico_destino."'
			and (status='Terminado' or status='Suspensa' or status='Redireccao' or status='Desistencia')";
			if (!$servico24horas) $sql .= " and data=curdate()";
			//else $sql .= " and data>date(timestampadd(day,-2,now()))";
			$sql .= " order by termino desc limit 1";
			//$sql .= " having min(emissao)";yyyy

		$res = $this->_db->Execute($sql);
		return $this->_db->FetchRow($res);*/
    }

    function GetTempoEsperaAtendimento($id_senha, $espera=true)
    {
        $sql = "select tempo_espera, tempo_atendimento from senhas where id_senha='" . $id_senha . "'";
        $res = $this->_db->executarSQL($sql);
        $tempo_espera = ($res)?$this->_db->obterValor($res, "tempo_espera"):"00:00:00";
        $tempo_atendimento = ($res)?$this->_db->obterValor($res, "tempo_atendimento"):"00:00:00";

        $sql = "select sec_to_time(
			" . (($espera && $tempo_espera)?"time_to_sec(tempo_espera) + ":(!$espera && $tempo_atendimento?"time_to_sec(tempo_atendimento) + ":"")) . "
			timestampdiff(
				second,
				timestampadd(
					second,
					time_to_sec(" . ($tempo_espera?"tempo_espera":"'00:00:00'") . ") + time_to_sec(" . ($tempo_atendimento?"tempo_atendimento":"'00:00:00'") . "),
					timestamp(emissao)),
				now())) as tempo from senhas where id_senha='" . $id_senha . "'";
        //debug("espera: ".$sql);
        $res = $this->_db->executarSQL($sql);
        return ($res)?$this->_db->obterValor($res, "tempo"):0;
    }

    function GetIdProximaSenha($id_loja, $servico_destino)
    {
        $sql = "select min(id_senha) id_senha
            from senhas
            where id_loja='".$id_loja."'
            and servico_destino='".$servico_destino."'
            and status='Emissao'
	    and data=curdate()";
        $res = $this->_db->executarSQL($sql);
        return ($res)?$this->_db->obterValor($res, "id_senha"):"0";
    }

    function GetTempoEsperaProximaSenha($id_loja, $servico_destino)
    {
        //$id = $this->GetIdFromFirstSenha($id_loja, $servico_destino);
        $id = $this->GetIdProximaSenha($id_loja, $servico_destino);
        return GetSecondsFromTimeString($this->GetTempoEsperaAtendimento($id));
    }

    function GetNumeroUltimaSenhaEmitida($id_loja, $servico_emissao)
    {
        $sql = "SELECT MAX(numero_senha) AS numero_senha
			FROM senhas
			WHERE data = CURRENT_DATE() AND servico_emissao = '".$servico_emissao."' AND id_loja = '".$id_loja."'";
        $res = $this->_db->Execute($sql);
        return $this->_db->Fields($res, "numero_senha");
    }

    function GetSenhas($dataInicio, $dataFim, $local='', $servico='', $colaborador='')
    {
//        $sql = "select s.id_senha id, s.numero_senha senha, date(s.emissao) data, time(s.emissao) hora, l.name local, d.nome dispensador, se.name servico_emissao, sd.name servico_destino, s.previsao_atendimento previsao_atendimento,
//            s.tempo_espera tempo_espera, s.tempo_atendimento tempo_atendimento, b.name balcao, c.name colaborador, s.status status, s.observacoes observacoes
//            from senhas s
//            inner join id_hist l on (l.id=s.id_loja and l.type='loja')
//            inner join dispensador d on d.id_dispensador=s.id_dispensador
//            inner join id_hist se on (se.id=s.servico_emissao and se.type='servico')
//            inner join id_hist sd on (sd.id=s.servico_destino and sd.type='servico')
//            inner join id_hist b on (b.id=s.id_balcao and b.type='balcao')
//            inner join id_hist c on (c.id=s.id_colaborador and c.type='empregado')";

        $sql = 	"SELECT s.data, ".
                "	s.numero_senha , ".
                "	l.nome AS loja, ".
                "	se.nome AS servico_emissao, ".
                "	se2.nome as servico_destino, ".
                "	s.emissao as data_emissao, ".
                "	s.previsao_atendimento, ".
                "	s.tempo_espera, ".
                "	s.tempo_atendimento, ".
                "	b.nome AS balcao, ".
                "	e.nome as empregado, ".
                "	e.nome_utilizador, ".
                "	s.status ".
                "FROM senhas AS s ".
                "inner join lojas AS l on l.id_loja = s.id_loja ".
                "inner join servicos as se on se.id_servico = s.servico_emissao ".
                "inner join servicos as se2 on se2.id_servico = s.servico_destino ".
                "left join balcoes as b on b.id_balcao = s.id_balcao ".
                "left join empregados AS e on e.id_empregado = s.id_colaborador ";

        $w = array();

        if ($dataInicio == '' AND $dataFim == '')
        {
            // get all tickets!
}
        else
        {
            if ($dataInicio == '')
            {
                $dataInicio = "CURRENT_DATE";
            }
            else
            {
                $dataInicio = "'$dataInicio'";
            }

            if ($dataFim == '')
            {
                $dataFim = "CURRENT_DATE";
            }
            else
            {
                $dataFim = "'$dataFim'";
            }

            $w[] = "s.data BETWEEN $dataInicio AND $dataFim";
        }

        if (is_array($local) && count($local))
        {
            $w[] = "s.id_loja in (".implode(",", $local).")";
        }

        if (is_array($servico) && count($servico))
        {
            $w[] = "s.servico_destino in (".implode(",", $servico).")";
        }

        if (is_array($colaborador) && count($colaborador))
        {
            $w[] = "s.id_colaborador in (".implode(",", $colaborador).")";
        }

        if (is_array($w) && count($w))
        {
            $sql .= "where ".implode (" and ", $w);
        }

        $sql .= " order by s.id_senha";

        $res = $this->_db->executarSQL($sql);
        $senhas = array();
        while ($row = $this->_db->obterRegisto($res)) array_push($senhas, $row);

        return $senhas;
    }

    function GetSenhasFormularios($dataInicio, $dataFim, $local='', $servico='', $colaborador='')
    {
        $sql =  "SELECT s.data, ".
                "   s.numero_senha , ".
                "   l.nome AS loja, ".
                "   se.nome AS servico_emissao, ".
                "   se2.nome as servico_destino, ".
                "   s.emissao as data_emissao, ".
                "   s.previsao_atendimento, ".
                "   s.tempo_espera, ".
                "   s.tempo_atendimento, ".
                "   b.nome AS balcao, ".
                "   e.nome as empregado, ".
                "   e.nome_utilizador, ".
                "   s.status, ".
                "   f.data as dataform " .
                "FROM senhas AS s ".
                "inner join lojas AS l on l.id_loja = s.id_loja ".
                "inner join servicos as se on se.id_servico = s.servico_emissao ".
                "inner join servicos as se2 on se2.id_servico = s.servico_destino ".
                "left join balcoes as b on b.id_balcao = s.id_balcao ".
                "left join empregados AS e on e.id_empregado = s.id_colaborador " .
                "left join form_submission as f ON f.id_senha = s.id_senha ";

        $w = array();

        if ($dataInicio == '' AND $dataFim == '')
        {
            // get all tickets!
        }
        else
        {
            if ($dataInicio == '')
            {
                $dataInicio = "CURRENT_DATE";
            }
            else
            {
                $dataInicio = "'$dataInicio'";
            }

            if ($dataFim == '')
            {
                $dataFim = "CURRENT_DATE";
            }
            else
            {
                $dataFim = "'$dataFim'";
            }

            $w[] = "s.data BETWEEN $dataInicio AND $dataFim";
        }

        if (is_array($local) && count($local))
        {
            $w[] = "s.id_loja in (".implode(",", $local).")";
        }

        if (is_array($servico) && count($servico))
        {
            $w[] = "s.servico_destino in (".implode(",", $servico).")";
        }

        if (is_array($colaborador) && count($colaborador))
        {
            $w[] = "s.id_colaborador in (".implode(",", $colaborador).")";
        }

        if (is_array($w) && count($w))
        {
            $sql .= "where ".implode (" and ", $w);
        }

        $sql .= " order by s.id_senha";

        $res = $this->_db->executarSQL($sql);
        $senhas = array();
        while ($row = $this->_db->obterRegisto($res)) array_push($senhas, $row);

        return $senhas;
    }
}

/**
 * Return the employee username
 */
 function GetEmployeeUsername($dataInicio){


 }

 function getAvailableData(){

 }

?>
