<?php 

class Senhas
{
    var $_db;

    function __construct()
    {
	global $NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD;
	$this->_db = new DBAccess($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    }

    function __destruct()
    {
	unset($this->_db);
    }

    function EmiteSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino, $emissao)
    {
	$status = 'Emissao';
	//if ($servico_emissao != $servico_destino) $status = 'Redireccao';
	//$previsao_atendimento = '00:00:00';
	$tempo_espera = '00:00:00';

	/*
        $sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, tempo_espera, status)
            values (
                '" . $data . "',
                '" . $numero_senha . "',
                '" . $id_loja . "',
                '" . $servico_emissao . "',
                '" . $servico_destino . "',
                '" . $emissao . "',
                '" . $tempo_espera . "',
                '" . $status . "')";
	*/
	$sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, tempo_espera, status)
            values (
                '" . $data . "',
                '" . $numero_senha . "',
                '" . $id_loja . "',
                '" . $servico_emissao . "',
                '" . $servico_destino . "',
                now(),
                '" . $tempo_espera . "',
                '" . $status . "')";

	$this->_db->Execute($sql);
    }

    function EmiteSenhaNow($id_loja, $servico_emissao, $servico_destino, $numero_senha=0, $observacoes="", $nome_cliente=null)
    {
	if (!$numero_senha) $numero_senha = $this->GetNumeroProximaSenhaEmitida($id_loja, $servico_destino);

	$oBalcao = new Balcao;
	$piso = $oBalcao->GetPiso($_SESSION["sessao_balcao"]);

	$sql = "lock tables senhas write";
	$this->_db->Execute($sql);

	$sql = "insert into senhas (data, numero_senha, id_loja, servico_emissao, servico_destino, emissao, tempo_espera, status, observacoes, nome_cliente)
            values (
                curdate(),
                '" . $numero_senha . "',
                '" . $id_loja . "',
                '" . $servico_emissao . "',
                '" . $servico_destino . "',
                now(),
                '00:00:00',
                'Emissao',
                '$observacoes',                
                '$nome_cliente')";

                //'".mysqli_real_escape_string($this->_db, $observacoes)."',
              
	$this->_db->Execute($sql);

	$sql = "select * from senhas order by id_senha desc limit 1";
	$res = $this->_db->Execute($sql);
	$ret = $this->_db->FetchRow($res);

	$sql = "unlock tables";
	$this->_db->Execute($sql);
	return $ret;
    }

    /*function ChamaSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino="", $id_balcao, $id_colaborador)
    {
        $status='Chamada';
        
        $sql = "select max(id_senha) as id_senha from senhas
            where data='" . $data . "'
			and status!='Chamada'
			and status!='Rechamada'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
        if ($servico_destino && $servico_destino != $servico_emissao)
            $sql .= " and servico_destino='" . $servico_destino . "'";
		$res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");
        
		if ($id)
		{
			$sql = "update senhas set
				tempo_espera = '" . $this->GetTempoEsperaAtendimento($id) . "',
				id_balcao = '" . $id_balcao . "',
				id_colaborador = '" . $id_colaborador . "',
				status = '" . $status ."'
				where id_senha = '" . $id . "'";
			$res = $this->_db->Execute($sql);
			
			return true;
		}
		else return false;
    }*/

    function ChamaSenha($id_senha, $id_balcao, $id_colaborador)
    {
	$status='Chamada';

	$sql = "lock tables senhas write";
	$this->_db->Execute($sql);

	$sql = "update senhas set
			tempo_espera = '" . $this->GetTempoEsperaAtendimento($id_senha) . "',
			id_balcao = '" . $id_balcao . "',
			id_colaborador = '" . $id_colaborador . "',
			status = '" . $status ."'
			where id_senha = '" . $id_senha . "'
			";
	$this->_db->Execute($sql);

	if ($this->_db->AffectedRows()) $ret = true;
	else $ret =  false;

	$sql = "unlock tables";
	$this->_db->Execute($sql);

	return $ret;
    }

    function SetStatus($id_senha, $status)
    {
	$sql = "update senhas set
			tempo_espera = '" . $this->GetTempoEsperaAtendimento($id_senha) . "',
            status = '" . $status ."'
            where id_senha = '" . $id_senha . "'";
	return $this->_db->Execute($sql);
    }

    /*function SetStatus($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino, $status)
    {
        $sql = "select max(id_senha) as id_senha from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
        if ($servico_destino && $servico_destino != $servico_emissao)
            $sql .= " and servico_destino='" . $servico_destino . "'";
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");
        
        $sql = "update senhas set
			tempo_espera = '" . $this->GetTempoEsperaAtendimento($id) . "',
            status = '" . $status ."'
            where id_senha = '" . $id . "'";
        $res = $this->_db->Execute($sql);
    }*/

    function SuspendeSenha($id_senha)
    {
	$sql = "update senhas set
            tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($id_senha, false) . "',
            status = 'Suspensa'
            where id_senha = '" . $id_senha . "'";   
	//debug(date("Y-m-d") . " " . $sql . "\n");

	$res = $this->_db->Execute($sql);
    }

    /*function SuspendeSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino)
    {
        $status = "Suspensa";
        
        
        //debug(date("Y-m-d") . " " . $tempo_atendimento . "\n");
        
        $sql = "select max(id_senha) as id_senha from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
        if ($servico_destino && $servico_destino != $servico_emissao)
            $sql .= " and servico_destino='" . $servico_destino . "'";
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");
        
        //debug(date("Y-m-d") . " " . $sql . "\n");
        
     
         $sql = "update senhas set
            tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($id, false) . "',
            status = '" . $status ."'
            where id_senha = '" . $id . "'";   
            //debug(date("Y-m-d") . " " . $sql . "\n");
            
        $res = $this->_db->Execute($sql);
    }*/

    function TerminaSenha($id_senha, $status)
    {
		$sql = "update senhas set
				tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($id_senha, false) . "',
				status = '" . $status ."'
				where id_senha = '" . $id_senha . "'";
		//debug($sql);

		$res = $this->_db->Execute($sql);
    }

    /*function TerminaSenha($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino, $status)
    {
        //$status = "Terminado";
		//if ($desistencia) $status = "Desistencia";
        
        //$stat = new EstatisticaAtendimentos;
        //$tempo_atendimento = $stat->GetTempoAtendimento($id_loja, $servico_destino, $data, $numero_senha . "_" . $servico_emissao);
        //unset($stat);
        
		//debug ($tempo_atendimento);
		
        $sql = "select max(id_senha) as id_senha from senhas
            where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
        if ($servico_destino && $servico_destino != $servico_emissao)
            $sql .= " and servico_destino='" . $servico_destino . "'";
			//debug($sql);
        $res = $this->_db->Execute($sql);
        $id = $this->_db->Fields($res, "id_senha");
		
			//debug($id);
        
        $sql = "update senhas set
            tempo_atendimento = '" . $this->GetTempoEsperaAtendimento($id, false) . "',
            status = '" . $status ."'
            where id_senha = '" . $id . "'";
		//debug($sql);
        $res = $this->_db->Execute($sql);
    }*/

    function GetTempoDecorrido($id_senha)
    {
	$sql = "select sec_to_time(
			timestampdiff(
				second,
				timestampadd(
					second,
					time_to_sec(if(tempo_espera,tempo_espera,'00:00:00'))
					+time_to_sec(if(tempo_atendimento,tempo_atendimento,'00:00:00')),
					emissao),
				now())) as tempo
			from senhas
			where id_senha='".$id_senha."'";

	$res = $this->_db->Execute($sql);
	return ($res)?$this->_db->Fields($res, "tempo"):0;
    }

    function GetTempoEsperaAtendimento($id_senha, $espera=true)
    {
	$sql = "select tempo_espera, tempo_atendimento from senhas where id_senha='" . $id_senha . "'";
	$res = $this->_db->Execute($sql);
	$tempo_espera = ($res)?$this->_db->Fields($res, "tempo_espera"):"00:00:00";
	$tempo_atendimento = ($res)?$this->_db->Fields($res, "tempo_atendimento"):"00:00:00";

	$sql = "select sec_to_time(
			" . (($espera && $tempo_espera)?"time_to_sec(tempo_espera) + ":(!$espera && $tempo_atendimento?"time_to_sec(tempo_atendimento) + ":"")) . "
			timestampdiff(
				second,
				timestampadd(
					second,
					time_to_sec(" . ($tempo_espera?"tempo_espera":"'00:00:00'") . ") + time_to_sec(" . ($tempo_atendimento?"tempo_atendimento":"'00:00:00'") . "),
					timestamp(emissao)),
				now())) as tempo from senhas where id_senha='" . $id_senha . "'";
	//debug("espera: ".$sql);
	$res = $this->_db->Execute($sql);
	return ($res)?$this->_db->Fields($res, "tempo"):0;
    }

    function GetTempoEspera($id_senha)
    {
	$sql = "select tempo_espera from senhas
			where id_senha='" . $id_senha . "'";
	$res = $this->_db->Execute($sql);
	$ret = $this->_db->Fields($res, "tempo_espera");
	return $ret?$ret:"00:00:00";
    }

    /*function GetTempoEspera($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino)
	{
		$sql = "select tempo_espera from senhas
			where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
        if ($servico_destino && $servico_destino != $servico_emissao)
            $sql .= " and servico_destino='" . $servico_destino . "'";
        $res = $this->_db->Execute($sql);
        $ret = $this->_db->Fields($res, "tempo_espera");
		return $ret?$ret:"00:00:00";
	}*/

    function GetTempoAtendimento($data, $numero_senha, $id_loja, $servico_emissao, $servico_destino)
    {
	$sql = "select tempo_atendimento from senhas
			where data='" . $data . "'
            and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'";
	if ($servico_destino && $servico_destino != $servico_emissao)
	    $sql .= " and servico_destino='" . $servico_destino . "'";
	$res = $this->_db->Execute($sql);
	$ret = $this->_db->Fields($res, "tempo_atendimento");
	return $ret?$ret:"00:00:00";
    }

    function GetDataFromFirstSenha($numero_senha, $id_loja, $servico_emissao, $status1, $status2='', $status3='')
    {
	/*$sql = "select min(data) as data from senhas
			where emissao>=timestampadd(day,-1,now())
			and numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'
			and status='" . $status1 . "'";
		if ($status2)
			$sql .= " or status='" . $status2 . "'";
		if ($status3)
			$sql .= " or status='" . $status3 . "'";*/
	$sql = "select min(data) as data from senhas
			where numero_senha='" . $numero_senha . "'
            and id_loja='" . $id_loja . "'
            and servico_emissao='" . $servico_emissao . "'
			and (status='" . $status1 . "'";
	if ($status2)
	    $sql .= " or status='" . $status2 . "'";
	if ($status3)
	    $sql .= " or status='" . $status3 . "'";
	$sql .= ")";
	if ($status1 == 'Desistencia' || $status2 == 'Desistencia' || $status3 == 'Desistencia')
	    $sql .= " and emissao>=timestampadd(day,-1,now())";
	//debug("data: " . $sql);
	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "data");
    }

    function GetIdFromSenha($data, $id_loja, $servico_emissao, $numero_senha)
    {
	$sql = "select id_senha
			from senhas
			where data='".$data."'
			and id_loja='".$id_loja."'
			and servico_emissao='".$servico_emissao."'
			and numero_senha='".$numero_senha."'";
	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "id_senha");
    }

    function GetIdFromFirstSenha($id_loja, $servico_destino)
    {
	$sql = "select min(id_senha) as id from senhas
			where id_loja='" . $id_loja . "'
            and (servico_destino='" . $servico_destino . "' or (servico_destino='0' and servico_emissao='" . $servico_destino . "'))
			and status='Emissao'";
	//debug("id: ".$sql);
	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "id");
    }

    function GetTempoEsperaProximaSenha($id_loja, $servico_destino, $is24=false)
    {
	$ret = 0;
	//$id = $this->GetIdFromFirstSenha($id_loja, $servico_destino);
	$id = $this->GetIdProximaSenha($id_loja, $servico_destino, $is24);
	
	if ($id) $ret = GetSecondsFromTimeString($this->GetTempoEsperaAtendimento($id));
	return $ret;
    }

    function GetProximaSenha($id_loja, $servico_destino)
    {
	$ret = array();
	$id = $this->GetIdProximaSenha($id_loja, $servico_destino, $is24);
	if ($id)
	{
	    $ret["id"] = $id;
	    $ret["tempo_espera"] = GetSecondsFromTimeString($this->GetTempoEsperaAtendimento($id));
	}
	return $ret;
    }

    function GetIdProximaSenha($id_loja, $servico_destino, $is24=false)
    {
	$sql = "select min(id_senha) id_senha
            from senhas
            where id_loja='".$id_loja."'
            and servico_destino='".$servico_destino."'
            and status='Emissao' ";
	if ($is24) $sql .= "and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))";
	else $sql .= "and data = curdate()";
	$res = $this->_db->Execute($sql);
	return ($res)?$this->_db->Fields($res, "id_senha"):"0";
    }

    function GetListaDeEspera($id_loja, $servico_destino, $is24=false)
    {
	// aqui estou a negligenciar o tempo de atendimento de uma senha redireccionada (tempo de espera = tempo decorrido desde a emissao até agora)
	$sql = "select t.id_senha, t.emissao, t.numero_senha, t.servico_emissao, t.id_dispensador, t.servico_destino, t.id_loja, t.status, t.observacoes observacoes, t.nome_cliente nome_cliente,
			timediff(now(), t.emissao) tempo_espera,
			sec_to_time(time_to_sec(timediff(now(), t.emissao))*s.prioridade) tempo_espera_alt,
			t.scheduled,
			IF(t.scheduled IS NOT NULL, t.scheduled < NOW(), 0) AS scheduled_priority,
			se.identificador
			from senhas t
			inner join servicos s on s.id_servico=t.servico_destino
			inner join servicos se on se.id_servico=t.servico_emissao
			where t.id_loja='".$id_loja."'";			

	if (is_array($servico_destino))
	{
	    $sArr = implode(", ", $servico_destino);
	    $sql .= " and t.servico_destino in (".$sArr.")";
	}
	else
	{
	    $sql .= " and t.servico_destino='".$servico_destino."'";
	}
	$sql .= " and t.status='Emissao' ";
	if ($is24) $sql .= " and (t.data = curdate() OR t.data = date_add(curdate(), INTERVAL -1 DAY))";
	else $sql .= " and t.data = curdate()";
	$sql .= " order by scheduled_priority DESC, tempo_espera_alt desc";
		
	return $this->_db->Query($sql);
    }

    function GetNumeroProximaSenhaEmitida($id_loja, $servico_emissao)
    {
	$sql = "SELECT IF(MAX(numero_senha) IS NULL, 1, (MAX(numero_senha) + 1)) AS numero_senha
			FROM senhas
			WHERE data = CURRENT_DATE()
			AND servico_emissao = '".$servico_emissao."'
			AND servico_emissao = servico_destino
			AND id_loja = '".$id_loja."'";
	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "numero_senha");
    }

    function GetUltimaSenhaChamada($id_loja, $servico_destino, $is24=false)
    {
	$sql = "select max(s.id_senha) max from senhas as s inner join servicos AS se ON se.id_servico = s.servico_emissao where s.id_loja='".$id_loja."'
			and s.servico_destino='".$servico_destino."'
			and se.tipo_servico != 'agendamentos'
			and (s.status='Terminado' or s.status='Suspensa' or s.status='Redireccao' or s.status='Desistencia') ";
	if ($is24) $sql .= "and (s.data = curdate() OR s.data = date_add(curdate(), INTERVAL -1 DAY))";
	else $sql .= "and data = curdate()";

	$res = $this->_db->Execute($sql);
	$maxSenha = $this->_db->Fields($res, "max");

	$sql = "select s.id_senha, s.emissao, s.numero_senha, s.servico_emissao, s.servico_destino, s.id_loja, s.status, se.identificador
			from senhas as s inner join servicos AS se ON se.id_servico = s.servico_emissao
            where id_senha='".$maxSenha."'";

	$res = $this->_db->Execute($sql);
	return $this->_db->FetchRow($res);
    }

    function GetSenhaCorrente($id_loja, $servico_emissao, $numero_senha)
    {
	$sql = "select id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, nome_cliente
			from senhas
			where id_loja='".$id_loja."'
			and servico_emissao='".$servico_emissao."'
			and numero_senha='".$numero_senha."'
			and (status='Chamada' or status='Rechamada')
			order by emissao desc limit 1";
	$res = $this->_db->Execute($sql);
	return $this->_db->FetchRow($res);
    }

    function GetSenha($id)
    {
	$sql = "select s.id_senha, s.emissao, s.numero_senha, s.servico_emissao, s.id_dispensador, s.servico_destino, s.id_loja, s.status, s.observacoes, s.nome_cliente, if(CURDATE() = data, 1, 0) as issued_today,
			se.identificador
			from senhas as s inner join servicos AS se ON se.id_servico = s.servico_emissao
			where id_senha='".$id."'";
	$res = $this->_db->Execute($sql);
	return $this->_db->FetchRow($res);
    }

    function AtendeTerminada($id_loja, $servico_destino, $numero_senha)
    {
	$sql = "SELECT id_senha
				FROM senhas
				WHERE servico_destino = ".$servico_destino."
				AND numero_senha = ".$numero_senha."
				AND status='Desistencia'".
		" AND id_loja=" . $id_loja .
		" ORDER BY emissao DESC LIMIT 1";

	$res = $this->_db->Execute($sql);
	$id_senha = $this->_db->Fields($res, "id_senha");

	$sql = "update senhas
				set emissao=TIMESTAMPADD(
					second, 
					-time_to_sec(if(tempo_espera,tempo_espera,'00:00:00')), 
					now()),
				tempo_atendimento=null
				where id_senha='".$id_senha."'";

	$this->_db->Execute($sql);

	$sql = "SELECT id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, observacoes
				FROM senhas
				WHERE id_senha='".$id_senha."'";

	if(!$rs = $this->_db->Execute($sql))
	    return 0;

	if($this->_db->RecordCount($rs) == 0)
	    return 0;

	return $this->_db->FetchRow($rs);
    }

    function AtendeSuspensa($id_loja, $servico_destino, $numero_senha)
    {
	$sql = "SELECT id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, observacoes
				from senhas
				WHERE servico_destino = ".$servico_destino."
				AND numero_senha = ".$numero_senha."
				AND status='Suspensa'".
		" AND id_loja=" . $id_loja .
		" ORDER BY emissao DESC LIMIT 1;";

	if(!$rs = $this->_db->Execute($sql))
	    return 0;

	if($this->_db->RecordCount($rs) == 0)
	    return 0;

	return $this->_db->FetchRow($rs);
    }

    function AtendeRedireccionada($id_loja, $servico_emissao, $numero_senha)
    {
	$sql = "SELECT id_senha, emissao, numero_senha, servico_emissao, servico_destino, id_loja, status, observacoes
				from senhas
				WHERE servico_emissao = ".$servico_emissao."
				AND numero_senha = ".$numero_senha."
				AND status='Emissao'".
		" AND id_loja=" . $id_loja .
		" ORDER BY emissao DESC LIMIT 1;";

	if(!$rs = $this->_db->Execute($sql))
	    return 0;

	if($this->_db->RecordCount($rs) == 0)
	    return 0;

	return $this->_db->FetchRow($rs);
    }


    function AnulaSenhasPenduradasNoBalcao($id_balcao)
    {
	$sql = "update senhas
			set status='Anulada'
			where (status='Chamada' or status='Rechamada')
			and id_balcao='".$id_balcao."'";

	$res = $this->_db->Execute($sql);
    }

    function AnulaSenhasPenduradasPorColaborador($utilizador)
    {
	$sql = "update senhas
			set status='Anulada'
			where (status='Chamada' or status='Rechamada')
			and id_colaborador='".$utilizador."'";

	$res = $this->_db->Execute($sql);
    }

    function GetUltimaSenhaTerminada($balcao)
    {
	$sql = "select max(id_senha) max from senhas where id_balcao='".$balcao."'
			and status='Terminado' and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))";

	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "max");
    }

    /**
     * Gets the last ticket that was handled. This means any status besides Anulada
     */
    function GetUltimaSenhaTratada($balcao)
    {
	$sql = "select max(id_senha) max from senhas where id_balcao='".$balcao."'
			and (status!='Anulada') and (data = curdate() OR data = date_add(curdate(), INTERVAL -1 DAY))";

	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "max");
    }

    function GetTempoAtendimentoFromDB($id)
    {
	$sql = "select tempo_atendimento from senhas where id_senha=".$id;

	$res = $this->_db->Execute($sql);
	return $this->_db->Fields($res, "tempo_atendimento");
    }

    function SetObservacoes($id, $observacoes)
    {
	//$sql = "update senhas set observacoes='".mysqli_real_escape_string($this->_db, $observacoes)."' where id_senha=".$id;
    $sql = "update senhas set observacoes='".$observacoes."' where id_senha='" . $id . "'";
	
	return /*$res = */$this->_db->Execute($sql);
    }


	function GetIdentificador($servico)
    {
	$sql = "select identificador
			from servicos
			where id_servico='".$servico."'";
	$res = $this->_db->Execute($sql);
	return $this->_db->FetchRow($res);
    }
}
?>
