<?php
require_once("../config.inc.php");

$dataSource = getRequestValue("dataSource");

if(!validFunction($dataSource))
{
    echo "";
    return;
}

/*****************************************/
/**** U S E F U L   F U N C T I O N S ****/
/*****************************************/

function validFunction($function)
{
    $functions = array(
            "waitingTimeAvgMax", // getData1.php
            "attendanceTimeAvgMax", // getData2.php
            "ticketsNumberPerHour", // getData5.php
            "ticketsNumberPerService", // getData6.php
            "monthWaitingTimeAvgMax", // getData1Mensal.php
            "monthAttendanceTimeAvgMax", // getData2Mensal.php
            "monthTicketsNumberPerHour", // getData3Mensal.php
            "employeAttendanceTimeAvgMax", // getData3.php
            "employeTicketsNumberPerHourAndEmploye", // getData4.php
            "employeTicketsNumberPerEmploye", // getData7.php
            "employeMonthAttendanceTimeAvgMax", // getData1MensalColaborador.php
            "employeMonthTicketsNumberPerEmploye", // getData2MensalColaborador.php
            "resumeServicesDay",
            "resumeServicesDayHours",
            "resumeEmployesDay",
            "resumeEmployesDayHours",

            // statistics section
            "statistics_servicesAvgMaxWaitTime",
            "statistics_servicesAvgMaxAttendanceTime",
            "statistics_servicesTicketsNumber",
            "statistics_employesAvgMaxAttendanceTime",
            "statistics_employesTicketsNumber",

            "volumeTransaccoes"
    );

    if(function_exists($function) && in_array($function, $functions))
    {
        return TRUE;
    }
    return FALSE;
}




//--------------------------------------------------------------------------------------------------------------
//statistics_servicesAvgMaxWaitTime
//--------------------------------------------------------------------------------------------------------------
function statistics_servicesAvgMaxWaitTime($dbConn, $date, $dataPeriod, $extra = array()) {
    //printf("++++ statistics_servicesAvgMaxWaitTime: " . $extra['ssid'] . " id loja: " . $extra['idLoja'] . "<br/>");
    $chartout = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];


    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if (isset($extra['idLoja'])) {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
        $tempos = $obj->getDataDummyFunction2($groupBy, $startDate, $endDate, $stats);
    } else {
        $tempos = $obj->getDataDummyFunction1($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $headerArray = array();
    $arrayNullValues = array();
    if ($storeFilter) {
        if (!isset($tempos[$storeId])) {
            $tempos = array();
        } else {
            $tempos = $tempos[$storeId];

            // keep only the services associated with the store
            $sql = "SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            $storeServices = array();
            foreach ($res AS $row) {
                $storeServices[] = $row['id_servico'];
            }

            foreach ($tempos AS $serviceId => $values) {
                if (!in_array($serviceId, $storeServices)) {
                    unset($tempos[$serviceId]);
                }
            }
        }
    }
    //debug(print_r($tempos, true));

    foreach ($tempos AS $idService => $times) {
        foreach ($times AS $date => $timeType) {
            if (!isset($newTempos[$date])) {
                $newTempos[$date] = array();
            }
            $newTempos[$date][$idService] = $timeType['espera'];
        }

        if (!in_array($idService, $headerArray)) {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60 * 60;
    $incDates["day"] = 24 * (60 * 60); //86400;
    $incDates["month"] = 30 * (24 * 60 * 60); //2592000;
    $incDates["year"] = 12 * (30 * (24 * 60 * 60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for ($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]]) {
        if (!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)])) {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if ($countTest == count($newTempos)) {
        $newTempos = array();
    }

    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($headerArray) === 0) {
        return $chartout . " ";
    }

    $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);
    $headerNames = array();
    foreach ($res AS $row) {
        $headerNames[$row['id_servico']] = $row['nome'];
    }


    // out OBJ PARA O GRAFICO
    ksort($newTempos);
    $index = 0;
    foreach ($newTempos AS $date => $services) {
        $chartout .= "{'date':'$date'";
        foreach ($headerArray AS $idService) {
            if (isset($headerNames[$idService]) && isset($services[$idService])) {
                $chartout .= ",'$headerNames[$idService]':$services[$idService]\n";
            }
        }
        $index++;
        /* print_r("+ " . count($services[$idService]) . " | " . count($newTempos) . " | " . count($headerArray) . " | " . $idService . " | " . $index . "<br/>"); */
        $index != count($newTempos) ? $chartout .= "},\n" : $chartout .= "}\n";
    }

    //print_r("::::out: " . "<br/>");

    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
//statistics_servicesAvgMaxAttendanceTime
//--------------------------------------------------------------------------------------------------------------

function statistics_servicesAvgMaxAttendanceTime($dbConn, $date, $dataPeriod, $extra = array()) {
    $chartout = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if (isset($extra['idLoja'])) {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
        $tempos = $obj->getDataDummyFunction4($groupBy, $startDate, $endDate, $stats);
    } else {
        $tempos = $obj->getDataDummyFunction3($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $headerArray = array();
    $arrayNullValues = array();
    if ($storeFilter) {
        if (!isset($tempos[$storeId])) {
            $tempos = array();
        } else {
            $tempos = $tempos[$storeId];

            // keep only the services associated with the store
            $sql = "SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            $storeServices = array();
            foreach ($res AS $row) {
                $storeServices[] = $row['id_servico'];
            }

            foreach ($tempos AS $serviceId => $values) {
                if (!in_array($serviceId, $storeServices)) {
                    unset($tempos[$serviceId]);
                }
            }
        }
    }
    foreach ($tempos AS $idService => $times) {
        foreach ($times AS $date => $timeType) {
            if (!isset($newTempos[$date])) {
                $newTempos[$date] = array();
            }
            $newTempos[$date][$idService] = $timeType['atendimento'];
        }

        if (!in_array($idService, $headerArray)) {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60 * 60;
    $incDates["day"] = 24 * (60 * 60); //86400;
    $incDates["month"] = 30 * (24 * 60 * 60); //2592000;
    $incDates["year"] = 12 * (30 * (24 * 60 * 60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for ($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]]) {
        if (!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)])) {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if ($countTest == count($newTempos)) {
        $newTempos = array();
    }

    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($headerArray) === 0) {
        return $chartout . " ";
    }

    $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);
    $headerNames = array();
    foreach ($res AS $row) {
        $headerNames[$row['id_servico']] = $row['nome'];
    }

    // out OBJ PARA O GRAFICO
    ksort($newTempos);
    //debug(print_r($newTempos, true));
    $index = 0;
    foreach ($newTempos AS $date => $services) {
        $chartout .= "{'date':'$date'";
        foreach ($headerArray AS $idService) {

            if (isset($headerNames[$idService]) && isset($services[$idService])) {
                $chartout .= ",'$headerNames[$idService]':$services[$idService]\n";
            }
        }
        $index++;
        $index != count($newTempos) ? $chartout .= "},\n" : $chartout .= "}\n";
    }

    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
//statistics_servicesTicketsNumber
//--------------------------------------------------------------------------------------------------------------
function statistics_servicesTicketsNumber($dbConn, $date, $dataPeriod, $extra = array()) {
    $chartout = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if (isset($extra['idLoja'])) {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
        $senhas = $obj->getDataDummyFunction6($groupBy, $startDate, $endDate, $stats);
    } else {
        $senhas = $obj->getDataDummyFunction5($groupBy, $startDate, $endDate, $stats);
    }

    ksort($senhas);

    // switch dimensions
    $newSenhas = array();
    $headerArray = array();
    $arrayNullValues = array();
    if ($storeFilter) {
        if (!isset($senhas[$storeId])) {
            $senhas = array();
        } else {
            $senhas = $senhas[$storeId];

            // keep only the services associated with the store
            $sql = "SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            $storeServices = array();
            foreach ($res AS $row) {
                $storeServices[] = $row['id_servico'];
            }

            foreach ($senhas AS $serviceId => $values) {
                if (!in_array($serviceId, $storeServices)) {
                    unset($senhas[$serviceId]);
                }
            }
        }
    }
    foreach ($senhas AS $idService => $tickets) {
        foreach ($tickets AS $date => $ticketType) {
            if (!isset($newTempos[$date])) {
                $newTempos[$date] = array();
            }
            $newSenhas[$date][$idService] = $ticketType['atendidas'];
        }

        if (!in_array($idService, $headerArray)) {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60 * 60;
    $incDates["day"] = 24 * (60 * 60); //86400;
    $incDates["month"] = 30 * (24 * 60 * 60); //2592000;
    $incDates["year"] = 12 * (30 * (24 * 60 * 60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for ($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]]) {
        if (!isset($newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)])) {
            $newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if ($countTest == count($newSenhas)) {
        $newSenhas = array();
    }


    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($headerArray) === 0) {
        return $chartout . " ";
    }


    $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);
    $headerNames = array();
    foreach ($res AS $row) {
        $headerNames[$row['id_servico']] = $row['nome'];
    }


    ksort($newSenhas);
    $index = 0;
    foreach ($newSenhas AS $date => $services) {
        $chartout .= "{'date':'$date'";
        foreach ($headerArray AS $idService) {
            if (isset($headerNames[$idService]) && isset($services[$idService])) {
                $chartout .= ",'$headerNames[$idService]':$services[$idService]\n";
            }
        }
        $index++;
        $index != count($newSenhas) ? $chartout .= "},\n" : $chartout .= "}\n";
    }

    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
// statistics_employesAvgMaxAttendanceTime
//--------------------------------------------------------------------------------------------------------------
function statistics_employesAvgMaxAttendanceTime($dbConn, $date, $dataPeriod, $extra = array()) {
    $chartout = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $serviceFilter = false;
    $serviceId = '';
    if (isset($extra['idServico'])) {
        // exists services to hide
        $serviceFilter = true;
        $serviceId = $extra['idServico'];
        $tempos = $obj->getDataDummyFunction8($groupBy, $startDate, $endDate, $stats);
    } else {
        $tempos = $obj->getDataDummyFunction7($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $headerArray = array();
    $arrayNullValues = array();
    if ($serviceFilter) {
        if (!isset($tempos[$serviceId])) {
            $tempos = array();
        } else {
            $tempos = $tempos[$serviceId];

            $sql = "SELECT id_empregado, nome FROM empregados ";
            if ($stats['employes']['values'] != '') {
                $sql .= "WHERE id_empregado IN (" . $stats['employes']['values'] . ") ";
            }
            //$rows = $dbConn->executarSQL($sql)->GetRows();
            $rows = $dbConn->getRows($sql);
            foreach ($rows AS $row) {
                if (!isset($tempos[$row['id_empregado']])) {
                    $tempos[$row['id_empregado']] = array();
                }
            }

            ksort($tempos);
        }
    }
    foreach ($tempos AS $idEmploye => $times) {
        foreach ($times AS $date => $timeType) {
            if (!isset($newTempos[$date])) {
                $newTempos[$date] = array();
            }
            $newTempos[$date][$idEmploye] = $timeType['atendimento'];
        }

        if (!in_array($idEmploye, $headerArray)) {
            $headerArray[] = $idEmploye;
            $arrayNullValues[$idEmploye] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60 * 60;
    $incDates["day"] = 24 * (60 * 60); //86400;
    $incDates["month"] = 30 * (24 * 60 * 60); //2592000;
    $incDates["year"] = 12 * (30 * (24 * 60 * 60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for ($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]]) {
        if (!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)])) {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if ($countTest == count($newTempos)) {
        $newTempos = array();
    }

//SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($headerArray) === 0) {
        return $chartout . " ";
    }


    $sql = "SELECT id_empregado, nome FROM empregados WHERE id_empregado IN (" . implode(',', $headerArray) . ")";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $headerNames = array();
    foreach ($res AS $row) {
        $headerNames[$row['id_empregado']] = $row['nome'];
    }


    ksort($newTempos);
    $index = 0;
    foreach ($newTempos AS $date => $employes) {
        $chartout .= "{'date':'$date'";
        foreach ($headerArray AS $idEmploye) {

            if (isset($headerNames[$idEmploye]) && isset($employes[$idEmploye])) {
                $chartout .= ",'$headerNames[$idEmploye]':$employes[$idEmploye]\n";
            }
        }
        $index++;
        $index != count($newTempos) ? $chartout .= "},\n" : $chartout .= "}\n";
    }

    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
// statistics_employesTicketsNumber
//--------------------------------------------------------------------------------------------------------------
function statistics_employesTicketsNumber($dbConn, $date, $dataPeriod, $extra = array()) {
    $chartout = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $serviceFilter = false;
    $serviceId = '';
    if (isset($extra['idServico'])) {
        // exists stores to hide
        $serviceFilter = true;
        $serviceId = $extra['idServico'];
        $senhas = $obj->getDataDummyFunction10($groupBy, $startDate, $endDate, $stats);
    } else {
        $senhas = $obj->getDataDummyFunction9($groupBy, $startDate, $endDate, $stats);
    }

    ksort($senhas);

    // switch dimensions
    $newSenhas = array();
    $headerArray = array();
    $arrayNullValues = array();
    if ($serviceFilter) {
        if (!isset($senhas[$serviceId])) {
            $senhas = array();
        } else {
            $senhas = $senhas[$serviceId];

            $sql = "SELECT id_empregado, nome FROM empregados ";
            if ($stats['employes']['values'] != '') {
                $sql .= "WHERE id_empregado IN (" . $stats['employes']['values'] . ") ";
            }
            //$rows = $dbConn->executarSQL($sql)->GetRows();
            $rows = $dbConn->getRows($sql);
            foreach ($rows AS $row) {
                if (!isset($senhas[$row['id_empregado']])) {
                    $senhas[$row['id_empregado']] = array();
                }
            }

            ksort($senhas);
        }
    }
    foreach ($senhas AS $idService => $tickets) {
        foreach ($tickets AS $date => $ticketType) {
            if (!isset($newTempos[$date])) {
                $newTempos[$date] = array();
            }
            $newSenhas[$date][$idService] = $ticketType['atendidas'];
        }

        if (!in_array($idService, $headerArray)) {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60 * 60;
    $incDates["day"] = 24 * (60 * 60); //86400;
    $incDates["month"] = 30 * (24 * 60 * 60); //2592000;
    $incDates["year"] = 12 * (30 * (24 * 60 * 60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for ($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]]) {
        if (!isset($newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)])) {
            $newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if ($countTest == count($newSenhas)) {
        $newSenhas = array();
    }

    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($headerArray) === 0) {
        return $chartout . " ";
    }

    $sql = "SELECT id_empregado, nome FROM empregados WHERE id_empregado IN (" . implode(',', $headerArray) . ")";

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);
    $headerNames = array();
    foreach ($res AS $row) {
        $headerNames[$row['id_empregado']] = $row['nome'];
    }


    ksort($newSenhas);
    $index = 0;
    foreach ($newSenhas AS $date => $employes) {
        $chartout .= "{'date':'$date'";
        foreach ($headerArray AS $idEmploye) {

            if (isset($headerNames[$idEmploye]) && isset($employes[$idEmploye])) {
                $chartout .= ",'$headerNames[$idEmploye]':$employes[$idEmploye]\n";
            }
        }
        $index++;
        $index != count($newSenhas) ? $chartout .= "},\n" : $chartout .= "}\n";
    }

    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
// waitingTimeAvgMax
//--------------------------------------------------------------------------------------------------------------

function waitingTimeAvgMax($dbConn, $date, $dataPeriod, $extra = array()) {

    // printf("::: waitingTimeAvgMax\n\n");
    $sql = "SELECT CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, " .
            "   s.servico_destino AS id_servico, " .
            "   serv.nome AS servico_nome, " .
            "   count(*) AS number, " .
            "   ROUND(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedioSecs, " .
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedio, " .
            "   ROUND(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximoSecs, " .
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximo " .
            "FROM senhas AS s " .
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino " .
            "WHERE  s.data LIKE '$date%' AND " .
            "   (   status = '" . SENHA_CHAMADA . "' OR " .
            "       status = '" . SENHA_RECHAMADA . "' OR " .
            "       status = '" . SENHA_SUSPENSA . "' OR " .
            "       status = '" . SENHA_TERMINADA . "' OR " .
            "       status = '" . SENHA_DESISTIDA . "' OR " .
            "       status = '" . SENHA_REDIRECCAO . "' " .
            "   ) ";

    if (isset($extra['entidade']) AND $extra['entidade'] != '') {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if (isset($extra['servico']) AND $extra['servico'] != '') {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if (isset($extra['local']) AND $extra['local'] != '') {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY horas, servico_destino " .
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;
    foreach ($res AS $row) {

        $hora = $row['horas'];
        if (!isset($horas[$hora])) {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idServico = $row['id_servico'];

        $chart[$idServico]['nome'] = $row['servico_nome'];
        $chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];

        /*printf("tempo medio espera " . $row['tempoMedio'] ."<br/>");
        printf("tempo medio  espera " . $row['tempoMaximo'] ."<br/>");
        printf("tempo medio espera " . $row['tempoMedioSecs'] ."<br/>");
        printf("tempo medio espera " . $row['tempoMaximoSecs'] ."<br/>");*/
    }


     //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($idServico) === 0) {
        return $chartout . " ";
    }




    $chartout = "";
    $graphs = "";


    $chartout .= "              'graphs': [\n";


    $i = 0;
    foreach ($chart AS $idServico => $values) {
        // $graphs .= "             [";
        $index = 0;
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_medio]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Avg: $values[nome]',\n" .
                    "                   'valueField': 'tempo_medio_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_maximo]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Max: $values[nome]',\n" .
                    "                   'valueField': 'tempo_maximo_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }


        $graphs .= "                ],\n";

        $chartout .= $graphs;

        $chartout .= "  'dataProvider': [\n";
        $index = 0;
        foreach ($chart AS $idServico => $values) {
            //$chartout .= "{'date';hora;servico;tempo_medio;tempo_maximo\n";
            foreach ($values AS $hora => $tempos) {
                if ($hora == 'nome')
                    continue;
                $tempoMedio = explode("\:", $tempos[tempoMedio]);
                $tempoMedio[0];
                $tempoMedio[1];
                $tempoMedio[2];
                $tempoMedioNum = (float) $tempoMedio[1] . "." . $tempoMedio[2];

                $tempoMaximo = explode("\:", $tempos[tempoMaximo]);
                $tempoMaximo[0];
                $tempoMaximo[1];
                $tempoMaximo[2];
                $tempoMaximoNum = (float) $tempoMaximo[1] . "." . $tempoMaximo[2];
                //$chartout .= "{'date':'$date','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]','tempo_maximo':'$tempos[tempoMaximo]'},\n";
                $chartout .= "{'date':'$date $hora','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]', 'tempo_medio_num':$tempoMedioNum,'tempo_maximo':'$tempos[tempoMaximo]','tempo_maximo_num':$tempoMaximoNum},\n";
                /* $chartout .= "{'date':'$date $hora','tempo_medio_num':$tempoMedioNum,'tempo_maximo_num':$tempoMaximoNum},\n"; */
            }
            $index++;
            //$index != count($values) ? $chartout .= "},\n" : $chartout .= "}\n";
        }

        $chartout .= "              ],\n";
    }
    return $chartout . " ";
}

function waitingTimeAvgMaxNew($dbConn, $startDate, $endDate, $dataPeriod, $extra = array()) {
 
    if($dataPeriod == 'month') {
        //$endDate = strtotime(date("Y-m-d", strtotime($startDate)) . "+1 month"); 
        //$endDate = date('Y-m-d', $endDate);
        $startDate = substr($startDate, 0, -3);
    }        
        
    // printf("::: waitingTimeAvgMax\n\n");
    $sql = "SELECT " . //CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, " .
            "   s.data as datas, " .
            "   s.servico_destino AS id_servico, " .
            "   serv.nome AS servico_nome, " .
            "   count(*) AS number, " .
            "   ROUND(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedioSecs, " .
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedio, " .
            "   ROUND(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximoSecs, " .
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximo " .
            "FROM senhas AS s " .
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino " .
            "WHERE  s.data LIKE '$startDate%' AND " .
            "   (   status = '" . SENHA_CHAMADA . "' OR " .
            "       status = '" . SENHA_RECHAMADA . "' OR " .
            "       status = '" . SENHA_SUSPENSA . "' OR " .
            "       status = '" . SENHA_TERMINADA . "' OR " .
            "       status = '" . SENHA_DESISTIDA . "' OR " .
            "       status = '" . SENHA_REDIRECCAO . "' " .
            "   ) ";

    if (isset($extra['entidade']) AND $extra['entidade'] != '') {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if (isset($extra['servico']) AND $extra['servico'] != '') {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if (isset($extra['local']) AND $extra['local'] != '') {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY datas, servico_destino " .
            "ORDER BY datas";
    //$res = $dbConn->executarSQL($sql)->GetRows(); 

    $res = $dbConn->getRows($sql);
    $chart = array();
    $dias = array();

    $chartNew = array();

    $id = 0;
    foreach ($res AS $row) {
        $dia = $row['datas'];
        if (!isset($dias[$dia])) {
            $dias[$dia] = $id++;
        }
        //$idHora = $dias[$dia];
        $idServico = $row['id_servico'];

        $chart[$idServico]['id'] = $idServico;
        $chart[$idServico]['nome'] = $row['servico_nome'];
       /* $chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
        */
        $chartNew[$dia]['data'] = $dia;
        $chartNew[$dia][$idServico]['nome'] = $row['servico_nome'];
        $chartNew[$dia][$idServico]['tempoMedio'] = $row['tempoMedio'];
        $chartNew[$dia][$idServico]['tempoMaximo'] = $row['tempoMaximo'];
        $chartNew[$dia][$idServico]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chartNew[$dia][$idServico]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];

        /*printf("tempo medio espera " . $row['tempoMedio'] ."<br/>");
        printf("tempo medio  espera " . $row['tempoMaximo'] ."<br/>");
        printf("tempo medio espera " . $row['tempoMedioSecs'] ."<br/>");
        printf("tempo medio espera " . $row['tempoMaximoSecs'] ."<br/>");*/
    }

    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($idServico) === 0) {
        return $chartout . " ";
    }

    $chartout = "";
    $graphs = "";

    $chartout .= "              'graphs': [\n";

    $i = 0;
    foreach ($chart AS $idServico => $values) {
        // $graphs .= "             [";
        $index = 0;
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_medio]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Avg: $values[nome]',\n" .
                    "                   'valueField': 'tempo_medio_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_maximo]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Max: $values[nome]',\n" .
                    "                   'valueField': 'tempo_maximo_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }

    }
        $graphs .= "                ],\n";

        $chartout .= $graphs;

        $chartout .= "  'dataProvider': [\n";
        $dataprovider = "";
        $index = 0;
        
            //$chartout .= "{'date';hora;servico;tempo_medio;tempo_maximo\n";
        //$dataprovider .= "{";
        //var_dump($values);
        //die();
        //foreach ($values AS $data => $datas) {
        //    $dataprovider .= "'date':'$datas[data]'";
            /*foreach ($values AS $hora => $tempos) {
                if ($hora == 'nome')
                    continue;
                $dataprovider .= "{'date':'$hora'";
                foreach ($chart AS $idServico => $values) {*/
            //Serviços Médias
            foreach($chartNew AS $hora => $values) {
                //var_dump($values);die();
                $dataprovider .= "{'date':'$values[data]'";

                foreach ($chart AS $idServico => $service) { 
                   // echo "dipas";
                   // var_dump($idService);
                  //  var_dump($service);
                  //  die();
                    $servicoID =  $service[id];
                    if (!isset($values[$servicoID])) {
                        $dataprovider .= ",'$service[nome] T. Médio':0";
                    } else {
                //$tempoMedio = explode(":", strtok($tempos[tempoMedio], '.'));
                $tempoMedio = explode(":", strtok($values[$servicoID][tempoMedio], '.'));
                
                //$tempoMedio[0];
                //$tempoMedio[1];
                //$tempoMedio[2];
                //$tempoMedioNum = (float) $tempoMedio[1] . "." . $tempoMedio[2];
               
                $tempoMedioInMinutes =intval($tempoMedio[0])*60 + intval($tempoMedio[1]) + intval($tempoMedio[2])/60;
                
                $tempoMaximo = explode("\:", $tempos[tempoMaximo]);
                $tempoMaximo[0];
                $tempoMaximo[1];
                $tempoMaximo[2];
                $tempoMaximoNum = (float) $tempoMaximo[1] . "." . $tempoMaximo[2];
                //$chartout .= "{'date':'$date','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]','tempo_maximo':'$tempos[tempoMaximo]'},\n";
                $dataprovider .= ",'$service[nome] T. Médio':$tempoMedioInMinutes";

                //$dataprovider .= ",'Max: $values[nome]':$tempoMedioInMinutes";

                /* $chartout .= "{'date':'$date $hora','tempo_medio_num':$tempoMedioNum,'tempo_maximo_num':$tempoMaximoNum},\n"; */
            }
        }
            //Serviços Máximos
            foreach ($chart AS $idServico => $service) { 
                    $servicoID =  $service[id];
                    if (!isset($values[$servicoID])) {
                        $dataprovider .= ",'$service[nome] T. Máximo':0";
                    } else {
                
                $tempoMaximo = explode(":", strtok($values[$servicoID][tempoMaximo], '.'));
                
               
                $tempoMaximoInMinutes =intval($tempoMaximo[0])*60 + intval($tempoMaximo[1]) + intval($tempoMaximo[2])/60;

                $tempoMedio = explode(":", strtok($values[$servicoID][tempoMedio], '.'));               
                $tempoMedioInMinutes =intval($tempoMedio[0])*60 + intval($tempoMedio[1]) + intval($tempoMedio[2])/60;
                
                $tempoMaximo = explode("\:", $tempos[tempoMaximo]);
                $tempoMaximo[0];
                $tempoMaximo[1];
                $tempoMaximo[2];
                $tempoMaximoNum = (float) $tempoMaximo[1] . "." . $tempoMaximo[2];
                //$chartout .= "{'date':'$date','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]','tempo_maximo':'$tempos[tempoMaximo]'},\n";
                $dataprovider .= ",'$service[nome] T. Máximo':$tempoMaximoInMinutes";


            }
        }
            $dataprovider .= "},\n";
            $index++;
            //$index != count($values) ? $chartout .= "},\n" : $chartout .= "}\n";
        }
        return $dataprovider . " ";
        $chartout .= $dataprovider;//. "              ],\n";
        return $chartout . " ";
   // }

    return $chartout . " ";
}

function attendanceTimeAvgMaxNew($dbConn, $date, $dateEnd, $dataPeriod, $outputFormat, $extra=array())
{
    if($dataPeriod == 'month') {
        $date = substr($date, 0, -3);
    }    

    $sql =  "SELECT " . //CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "   s.data as datas, " .
            "   s.servico_destino AS id_servico, ".
            "   serv.nome AS servico_nome, ".
            "   count(*) AS number, ".
            "   ROUND(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedioSecs, ".
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "   ROUND(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximoSecs, ".
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  s.data LIKE '$date%' AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY datas, servico_destino ".
            "ORDER BY datas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $dias = array();
    $chartNew = array();
    $id = 0;
    foreach($res AS $row)
    {

        $dia = $row['datas'];
        if(!isset($dias[$dia]))
        {
            $dias[$dia] = $id++;
        }
        //$idHora = $horas[$hora];
        $idServico = $row['id_servico'];

        $chart[$idServico]['id'] = $idServico;
        $chart[$idServico]['nome'] = $row['servico_nome'];
        /*$chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];*/

        $chartNew[$dia]['data'] = $dia;
        $chartNew[$dia][$idServico]['nome'] = $row['servico_nome'];
        $chartNew[$dia][$idServico]['tempoMedio'] = $row['tempoMedio'];
        $chartNew[$dia][$idServico]['tempoMaximo'] = $row['tempoMaximo'];
        $chartNew[$dia][$idServico]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chartNew[$dia][$idServico]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
    }

    $dataprovider = "";
    
    foreach($chartNew AS $hora => $values) {
        $dataprovider .= "{'date':'$values[data]'";
        //Serviços Médias
        foreach ($chart AS $idServico => $service) { 
            $servicoID =  $service[id];
            if (!isset($values[$servicoID])) {
                $dataprovider .= ",'$service[nome] T. Médio':0";
            } else {
                $tempoMedio = explode(":", strtok($values[$servicoID][tempoMedio], '.'));
                $tempoMedioInMinutes =intval($tempoMedio[0])*60 + intval($tempoMedio[1]) + intval($tempoMedio[2])/60;
                 $dataprovider .= ",'$service[nome] T. Médio':$tempoMedioInMinutes";

            }
        }
        //Serviços Máximos
        foreach ($chart AS $idServico => $service) { 
            $servicoID =  $service[id];
            if (!isset($values[$servicoID])) {
                $dataprovider .= ",'$service[nome] T. Máximo':0";
            } else {                
                $tempoMaximo = explode(":", strtok($values[$servicoID][tempoMaximo], '.'));               
                $tempoMaximoInMinutes =intval($tempoMaximo[0])*60 + intval($tempoMaximo[1]) + intval($tempoMaximo[2])/60;
                $dataprovider .= ",'$service[nome] T. Máximo':$tempoMaximoInMinutes";
            }
        }
        $dataprovider .= "},\n";
    }
    return $dataprovider . " ";
    // download in CSV??
    /*if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;servico;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_waiting_time_avg_max') . "\n";

        foreach($chart AS $idServico => $values)
        {
            foreach($values AS $hora => $tempos)
            {
                if($hora == 'nome')
                    continue;
                $out .= "$date;$hora;$values[nome];$tempos[tempoMedio];$tempos[tempoMaximo]\n";
            }
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";
    foreach($chart AS $idServico => $values)
    {

        // dump para cada servico o tempo medio e maximo em dois graph's
        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Avg: $values[nome]' balloon_text='{description}'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMedio]'>$tempos[tempoMedioSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;

        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Max: $values[nome]' balloon_text='{description}' hidden='true'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMaximo]'>$tempos[tempoMaximoSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;
    }
    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;*/
}

//--------------------------------------------------------------------------------------------------------------
// attendanceTimeAvgMax
//--------------------------------------------------------------------------------------------------------------
function attendanceTimeAvgMax($dbConn, $date, $dataPeriod, $extra=array())
{

    $sql =  "SELECT CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "   s.servico_destino AS id_servico, ".
            "   serv.nome AS servico_nome, ".
            "   count(*) AS number, ".
            "   ROUND(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedioSecs, ".
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "   ROUND(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximoSecs, ".
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  s.data LIKE '$date%' AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY horas, servico_destino ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;

    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idServico = $row['id_servico'];

        $chart[$idServico]['nome'] = $row['servico_nome'];
        $chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];

        /*printf("tempo medio atendimento " . $row['tempoMedio'] ."<br/>");
        printf("tempo medio  atendimento " . $row['tempoMaximo'] ."<br/>");
        printf("tempo medio atendimento " . $row['tempoMedioSecs'] ."<br/>");
        printf("tempo medio atendimento " . $row['tempoMaximoSecs'] ."<br/>");*/
    }

     //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($idServico) === 0) {
        return $chartout . " ";
    }


    $chartout = "";
    $graphs = "";


    $chartout .= "              'graphs': [\n";


    $i = 0;

    foreach ($chart AS $idServico => $values) {
        // $graphs .= "             [";
        $index = 0;
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_medio]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Avg: $values[nome]',\n" .
                    "                   'valueField': 'tempo_medio_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_maximo]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Max: $values[nome]',\n" .
                    "                   'valueField': 'tempo_maximo_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }


        $graphs .= "                ],\n";

        $chartout .= $graphs;

        $chartout .= "  'dataProvider': [\n";
        $index = 0;

        foreach ($chart AS $idServico => $values) {
            //$chartout .= "{'date';hora;servico;tempo_medio;tempo_maximo\n";
            foreach ($values AS $hora => $tempos) {
                if ($hora == 'nome')
                    continue;
            

                
                $tempoMedio = explode("\:", $tempos[tempoMedio]);    
                $tempoMedio[0];
                $tempoMedio[1];
                $tempoMedio[2];
                $tempoMedioNum = (float) $tempoMedio[1] . "." . $tempoMedio[2];

                $tempoMaximo = explode("\:", $tempos[tempoMaximo]);
                $tempoMaximo[0];
                $tempoMaximo[1];
                $tempoMaximo[2];
                $tempoMaximoNum = (float) $tempoMaximo[1] . "." . $tempoMaximo[2];
                //$chartout .= "{'date':'$date','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]','tempo_maximo':'$tempos[tempoMaximo]'},\n";
                $chartout .= "{'date':'$date $hora','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]', 'tempo_medio_num':$tempoMedioNum,'tempo_maximo':'$tempos[tempoMaximo]','tempo_maximo_num':$tempoMaximoNum},\n";
                /* $chartout .= "{'date':'$date $hora','tempo_medio_num':$tempoMedioNum,'tempo_maximo_num':$tempoMaximoNum},\n"; */


            }
            $index++;
            //$index != count($values) ? $chartout .= "},\n" : $chartout .= "}\n";
        }

        $chartout .= "              ],\n";
    }

    return $chartout . " ";
}


//--------------------------------------------------------------------------------------------------------------
// ticketsNumberPerHour
//--------------------------------------------------------------------------------------------------------------

function ticketsNumberPerHour($dbConn, $date, $dataPeriod, $extra=array())
{

    $sql =  "SELECT CONCAT(LPAD(HOUR(ADDTIME(emissao, tempo_espera)), 2, '0'), ':00') AS horas, ".
            "   count(*) AS number, ".
            "   status ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  s.data LIKE '$date%' AND ".
            "       tempo_atendimento IS NOT NULL AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' OR ".
            "       status = '" . SENHA_DESISTIDA . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY horas, status ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();
    $senha = array();


    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$hora]['number'] = $row['number'];
        $senha[$hora][$label] = $row['number'];

        //printf("chart: " . $chart[$label][$hora]['number'] . "</br>");
        //printf("senha: " . $senha[$hora][$label] . "</br>");
    }
/*
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        $out = "data;hora;numero_atendidas;numero_desistidas\n";

        foreach($outputCSV AS $hora => $values)
        {
            $out .= "$date;$hora;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }*/

     //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($senha) === 0) {
        return $chartout . " ";
    }

    $chartout = "";
    $graphs = "";


    $chartout .= "              'graphs': [\n";


    $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-1',\n" .
                    "                   'balloonText': 'Foram atendidas [[atendidas]] senhas',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'type': 'column',\n" .
                    "                   'fillAlphas': 1,\n" .
                    "                   'title': 'Atendidas',\n" .
                    "                   'valueField': 'atendidas'\n";
    $graphs .= "},\n";

    $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-2',\n" .
                    "                   'balloonText': 'Foram desistidas [[desistidas]] senhas',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'type': 'column',\n" .
                    "                   'fillAlphas': 1,\n" .
                    "                   'title': 'Desistidas',\n" .
                    "                   'valueField': 'desistidas'\n";
    $graphs .= "}],\n";

    $chartout .= $graphs;


    $chartout .= "  'dataProvider': [\n";



    foreach($chart AS $hora => $values)
    {

        printf("hora: " . $hora['nome'] . "</br>");

        foreach($values AS $hora => $dados)
        {
            if($hora == 'nome')
                continue;

            printf("horas[hora]: " . $horas[$hora] . " hora: " . $hora . " desistidas: " . count($dados[Atendidas]) . " atendidas: ". $dados[Atendidas] . " teste: " . $dados[number] . "<br/>");

            $valAtendidas;
            $valDesistidas;
            count($dados[Desistidas]) != 0 ? $valDesistidas = $dados[Desistidas] : $valDesistidas = 0;
            count($dados[Atendidas]) != 0 ? $valAtendidas = $dados[Atendidas] : $valAtendidas = 0;
            $chartout .= "{'date':'$date $hora','desistidas':'$valDesistidas', 'atendidas':'$valAtendidas'},\n";





            //printf("horas[hora]: " . $values['nome'] . "</br>");
            //printf("horas[hora]: " . $values . "</br>");
            //$chartout .= "{'date':'$date $hora', 'atendidas':'$dados[number]'},\n";
            //$out .= "\t\t\t<value xid='" . $horas[$hora] . "'>$dados[number]</value>\n";
        }

    }
















   // foreach ($senha AS $hora => $values) {



         // dump para cada servico o tempo medio e maximo em dois graph's
         /*$out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";*/

        // printf("horas[hora]: " . $horas[$hora] . " hora: " . $hora . " index: ". $i . " desistidas: " . count($values[Atendidas]) . " atendidas: ". $values[Atendidas] ."<br/>");

        // $index = 0;


          //  $valAtendidas;
           // $valDesistidas;
             //   count($values[Desistidas]) != 0 ? $valDesistidas = $values[Desistidas] : $valDesistidas = 0;
               // count($values[Atendidas]) != 0 ? $valAtendidas = $values[Atendidas] : $valAtendidas = 0;
               // $chartout .= "{'date':'$date $hora','desistidas':'$valDesistidas', 'atendidas':'$valAtendidas'},\n";
          //

       //     $i ++;


         //$index++;

  //   }//end for each


     $chartout .= "             ],\n";
    return $chartout . " ";
}

function ticketsNumberPerHourNew($dbConn, $date, $endDate, $dataPeriod, $extra=array())
{
     if($dataPeriod == 'month') {
        $date = substr($date, 0, -3);
    }    

    $sql =  "SELECT " . //CONCAT(LPAD(HOUR(ADDTIME(emissao, tempo_espera)), 2, '0'), ':00') AS horas, ".
            "   s.data as datas, " .
            "   s.servico_destino AS id_servico, ".
            "   serv.nome AS servico_nome, " .
            "   count(*) AS number, ".
            "   status ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  s.data LIKE '$date%' AND ".
            "       tempo_atendimento IS NOT NULL AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' OR ".
            "       status = '" . SENHA_DESISTIDA . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY datas, status, servico_destino ".
            "ORDER BY datas";
            
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $servicos = array();
    $chart = array();
    $dias = array();
    $senha = array();
    
    $id = 0;
    foreach($res AS $row)
    {

        $dia = $row['datas'];
        if(!isset($dias[$dia]))
        {
            $dias[$dia] = $id++;
        }
        $idServico = $row['id_servico'];
        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
            default:
                $label = "Atendidas";
        }

        $servicos[$idServico]['id'] = $idServico;
        $servicos[$idServico]['nome'] = $row['servico_nome'];

        $chart[$dia]['data'] = $dia;
        $chart[$dia][$idServico]['nome'] = $row['servico_nome'];
        //$chart[$dia][$idServico]['status'] = $label;
        $chart[$dia][$idServico][$label] = $row['number'];
    }

    //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($chart) === 0) {
        return $chartout . " ";
    }

    $dataprovider = "";

    foreach($chart AS $hora => $values)
    {
        $dataprovider .= "{'date':'$values[data]'";
        
        foreach ($servicos AS $idServico => $service) { 
            $servicoID =  $service[id];
            if (!isset($values[$servicoID])) {
                $dataprovider .= ",'$service[nome] Desistidas':0";
                $dataprovider .= ",'$service[nome] Atendidas':0";
            } else {
                //var_dump($values[$servicoID]); 
                //var_dump($values[$servicoID]["Atendidas"]);
                //die();
                //if (!isset($values[$servicoID]['Desistidas']) {
                if(!array_key_exists('Desistidas', $values[$servicoID])) {
                    $dataprovider .= ",'$service[nome] Desistidas':0";
                } else {
                    //echo $values[$servicoID][Desistidas]; die();
                    $dataprovider .= ",'$service[nome] Desistidas':" . $values[$servicoID]['Desistidas'];
                }
                //if (!isset($values[$servicoID]['Atendidas']) {
                if(!array_key_exists('Atendidas', $values[$servicoID])) {
                    $dataprovider .= ",'$service[nome] Atendidas':0";
                } else {
                    $dataprovider .= ",'$service[nome] Atendidas':" . $values[$servicoID]['Atendidas'];
                }
            }
        }
        $dataprovider .= "},\n";
    }
    return $dataprovider . " ";
}

//--------------------------------------------------------------------------------------------------------------
// ticketsNumberPerService (chart4.php)
//--------------------------------------------------------------------------------------------------------------
function ticketsNumberPerService($dbConn, $date, $dataPeriod, $extra=array())
{
    $chartout = "";
    $chart = array();
    $services = array();
    $totais = array();
    $servico = array(); // For validate result

    $totais['Desistidas'] = 0;
    $totais['Atendidas'] = 0;


    // get all services
    $sql =  "SELECT nome AS serviceName ".
            "FROM servicos ".
            "WHERE 1 ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND id_servico IN ($extra[servico]) ";
    }
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $id = 0;
    foreach($res AS $row)
    {
        $service = $row['serviceName'];
        if(!isset($services[$service]))
        {
            $services[$service] = $id++;
        }

        $chart['Desistidas'][$service]['number'] = 0;
        $chart['Atendidas'][$service]['number'] = 0;
    }


    // get stats
    $sql =  "SELECT s.servico_destino AS idService, ".
            "   serv.nome AS serviceName, ".
            "   status, ".
            "   count(*) AS number ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  s.data LIKE '$date%' AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' OR ".
            "       status = '" . SENHA_DESISTIDA . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY s.servico_destino, status";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    foreach($res AS $row)
    {

        $service = $row['serviceName'];

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$service]['number'] = $row['number'];
        $totais[$label] += $row['number'];

        /*if(!isset($outputCSV[$service]))
        {
            $outputCSV[$service]["Atendidas"] = 0;
            $outputCSV[$service]["Desistidas"] = 0;
        }*/
        $servico[$service][$label] = $row['number']; // For validate result
    }

    // download in CSV??
   /* if($outputFormat == 'downloadCSV')
    {
        $out = "data;servico;numero_atendidas;numero_desistidas\n";

        foreach($outputCSV AS $service => $values)
        {
            $out .= "$date;$service;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }*/

     //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($servico) === 0) {
        return $chartout . " ";
    }

    $graphs = "";


    $chartout .= "              'graphs': [\n";


     $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-1',\n" .
                    "                   'balloonText': 'Foram atendidas [[atendidas]] senhas',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'type': 'column',\n" .
                    "                   'fillAlphas': 1,\n" .
                    "                   'title': 'Atendidas',\n" .
                    "                   'valueField': 'atendidas'\n";
    $graphs .= "},\n";

    $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-2',\n" .
                    "                   'balloonText': 'Foram desistidas [[desistidas]] senhas',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'type': 'column',\n" .
                    "                   'fillAlphas': 1,\n" .
                    "                   'title': 'Desistidas',\n" .
                    "                   'valueField': 'desistidas'\n";
    $graphs .= "}],\n";

    $chartout .= $graphs;


    $chartout .= "  'dataProvider': [\n";
    foreach($servico AS $service => $values)
    {
        //$out .= "\t\t<value xid='$value'><![CDATA[$service]]></value>\n";


         printf("servico: " . $service . " desistidas: " . count($values[Atendidas]) . " atendidas: ". $values[Atendidas] ."<br/>");


            $valAtendidas;
            $valDesistidas;
                count($values[Desistidas]) > 0 ? $valDesistidas = $values[Desistidas] : $valDesistidas = 0;
                count($values[Atendidas]) > 0 ? $valAtendidas = $values[Atendidas] : $valAtendidas = 0;
                // desistidas e atendidas têm de ser passadas sem '' porque são números
                $chartout .= "{'servico':'$service', 'desistidas':$valDesistidas, 'atendidas':$valAtendidas},\n";



    }
     $chartout .= "             ],\n";
    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
// employeAttendanceTimeAvgMax
//--------------------------------------------------------------------------------------------------------------

function employeAttendanceTimeAvgMax($dbConn, $date, $dataPeriod, $extra=array())
{

    $sql =  "SELECT CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "   s.id_colaborador, ".
            "   emp.nome AS colaborador_nome, ".
            "   count(*) AS number, ".
            "   ROUND(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedioSecs, ".
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "   ROUND(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximoSecs, ".
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "LEFT JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE  s.data = '$date' AND ".
            "   s.id_colaborador IS NOT NULL AND ".
            "   (   s.status = '" . SENHA_REDIRECCAO . "' OR ".
            "       s.status = '" . SENHA_TERMINADA . "' ".
            "   ) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .= "GROUP BY horas, id_colaborador ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idColaborador = $row['id_colaborador'];

        $chart[$idColaborador]['nome'] = $row['colaborador_nome'];
        $chart[$idColaborador][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idColaborador][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idColaborador][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idColaborador][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
    }

     //SE NÃO HOUVER RESULTADOS, DEVOLVE VAZIO E MOSTRA MSG
    if (count($idColaborador) === 0) {
        return $chartout . " ";
    }
    // download in CSV??
    /*if($outputFormat == 'downloadCSV')
    {
        $out = "data;hora;colaborador;tempo_medio;tempo_maximo\n";

        foreach($chart AS $idColaborador => $values)
        {
            foreach($values AS $hora => $tempos)
            {
                if($hora == 'nome')
                    continue;
                $out .= "$date;$hora;$values[nome];$tempos[tempoMedio];$tempos[tempoMaximo]\n";
            }
        }

        return $out;
    }*/

    $chartout = "";
    $graphs = "";


    $chartout .= "              'graphs': [\n";


    $i = 0;
    foreach ($chart AS $idColaborador => $values) {
        // $graphs .= "             [";
        $index = 0;
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_medio]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Avg: $values[nome]',\n" .
                    "                   'valueField': 'tempo_medio_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }
        foreach ($values AS $hora => $tempos) {
            $index++;
            if ($hora == 'nome')
                continue;
            $graphs .= "                            {\n" .
                    "                   'id': 'AmGraph-$i',\n" .
                    "                   'balloonText': '[[title]]: [[tempo_maximo]]',\n" .
                    "                   'legendColor': 'undefined',\n" .
                    "                   'lineThickness': 1,\n" .
                    "                   'title': 'Max: $values[nome]',\n" .
                    "                   'valueField': 'tempo_maximo_num'\n";
            $i++;
            //printf("val: " . count($values) . "  --  " . $index ."<br/>");
            //$graphs .= "},\n";
            $index != count($values) ? $graphs .= "},\n" : $graphs .= "}\n";
            break;
        }


        $graphs .= "                ],\n";

        $chartout .= $graphs;

        $chartout .= "  'dataProvider': [\n";
        $index = 0;
        foreach ($chart AS $idColaborador => $values) {
            //$chartout .= "{'date';hora;servico;tempo_medio;tempo_maximo\n";
            foreach ($values AS $hora => $tempos) {
                if ($hora == 'nome')
                    continue;
                $tempoMedio = explode("\:", $tempos[tempoMedio]);
                $tempoMedio[0];
                $tempoMedio[1];
                $tempoMedio[2];
                $tempoMedioNum = (float) $tempoMedio[1] . "." . $tempoMedio[2];

                $tempoMaximo = explode("\:", $tempos[tempoMaximo]);
                $tempoMaximo[0];
                $tempoMaximo[1];
                $tempoMaximo[2];
                $tempoMaximoNum = (float) $tempoMaximo[1] . "." . $tempoMaximo[2];
                //$chartout .= "{'date':'$date','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]','tempo_maximo':'$tempos[tempoMaximo]'},\n";
                $chartout .= "{'date':'$date $hora','hora':'$hora','servico':'$values[nome]','tempo_medio':'$tempos[tempoMedio]', 'tempo_medio_num':$tempoMedioNum,'tempo_maximo':'$tempos[tempoMaximo]','tempo_maximo_num':$tempoMaximoNum},\n";
                /* $chartout .= "{'date':'$date $hora','tempo_medio_num':$tempoMedioNum,'tempo_maximo_num':$tempoMaximoNum},\n"; */
            }
            $index++;
            //$index != count($values) ? $chartout .= "},\n" : $chartout .= "}\n";
        }

        $chartout .= "              ],\n";
    }
    return $chartout . " ";

}

//--------------------------------------------------------------------------------------------------------------
// employeTicketsNumberPerHourAndEmploye
//--------------------------------------------------------------------------------------------------------------
function employeTicketsNumberPerHourAndEmploye($dbConn, $date, $dataPeriod, $extra=array())
{

    $sql =  "SELECT CONCAT(LPAD(HOUR(ADDTIME(emissao, tempo_espera)), 2, '0'), ':00') AS horas, ".
            "   s.id_colaborador, ".
            "   emp.nome AS colaborador_nome, ".
            "   count(*) AS number ".
            "FROM senhas AS s ".
            "LEFT JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE  s.data = '$date' AND ".
            "   s.id_colaborador IS NOT NULL AND ".
            "   (   status = '" . SENHA_REDIRECCAO . "' OR ".
            "       status = '" . SENHA_TERMINADA . "' ".
            "   ) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .= "GROUP BY horas, id_colaborador ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();
    //$outputCSV = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idColaborador = $row['id_colaborador'];

        $chart[$idColaborador]['nome'] = $row['colaborador_nome'];
        $chart[$idColaborador][$hora]['number'] = $row['number'];

       /* if(!isset($outputCSV[$row['colaborador_nome']][$hora]))
        {
            $outputCSV[$row['colaborador_nome']][$hora] = 0;
        }
        $outputCSV[$row['colaborador_nome']][$hora] = $row['number'];*/
    }

    // download in CSV??
    /*if($outputFormat == 'downloadCSV')
    {
        $out = "data;hora;colaborador;numero_atendimentos\n";

        foreach($outputCSV AS $colaborador => $values)
        {
            foreach($values AS $hora => $number)
            {
                $out .= "$date;$hora;$colaborador;$number\n";
            }
        }

        return $out;
    }*/
    if (count($idColaborador) === 0) {
        return $chartout . " ";
    }


    $chartout = "";
    $graphs = "";


    foreach($chart AS $idColaborador => $values)
    {
        $colab = $values['nome'];
        $chartout .= "              'graphs': [\n";

         $graphs .= "                            {\n" .
                        "                   'id': 'AmGraph-1',\n" .
                        "                   'balloonText': 'Foram atendidas [[atendidas]] senhas',\n" .
                        "                   'legendColor': 'undefined',\n" .
                        "                   'type': 'column',\n" .
                        "                   'fillAlphas': 1,\n" .
                        "                   'title': '$colab',\n" .
                        "                   'valueField': 'atendidas'\n";
        $graphs .= "}],\n";

    }


    $chartout .= $graphs;


    $chartout .= "  'dataProvider': [\n";
    foreach($chart AS $idColaborador => $values)
    {

        printf("idColaborador: " . $idColaborador['nome'] . " values: " . $values['nome'] ."</br>");

        foreach($values AS $hora => $dados)
        {
            if($hora == 'nome')
                continue;
            //printf("horas[hora]: " . $horas[$hora] . " hora: " . $hora . "</br>");
            //printf("horas[hora]: " . $values['nome'] . "</br>");
            //printf("horas[hora]: " . $values . "</br>");
            $chartout .= "{'date':'$date $hora', 'atendidas':'$dados[number]'},\n";
            //$out .= "\t\t\t<value xid='" . $horas[$hora] . "'>$dados[number]</value>\n";
        }

    }
     $chartout .= "             ],\n";
    return $chartout . " ";
}

//--------------------------------------------------------------------------------------------------------------
// employeTicketsNumberPerEmploye
//--------------------------------------------------------------------------------------------------------------
function employeTicketsNumberPerEmploye($dbConn, $date, $dataPeriod, $extra=array())
{

    //TODO - TRABALHAR ESTE CÓDIGO PARA FUNCIONAR COM O QUE ESTÁ DESCOMENTADO

    $chart = array();
    $colaboradores = array();
    $totais = array();
    $colab = array();
    //$outputCSV = array();

    $totais['Desistidas'] = 0;
    $totais['Atendidas'] = 0;


    // get all employes
    $sql =  "SELECT e.nome ".
            "FROM empregados AS e ".
            "INNER JOIN local_colaborador AS lc ON e.id_empregado = lc.id_colaborador ".
            "WHERE 1 ";

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND e.id_empregado IN ($extra[colaborador]) ";
    }
    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND lc.id_local IN ($extra[local]) ";
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $id = 0;
    foreach($res AS $row)
    {
        $colaborador = $row['nome'];
        if(!isset($colaboradores[$colaborador]))
        {
            $colaboradores[$colaborador] = $id++;
        }

        $chart['Desistidas'][$colaborador]['number'] = 0;
        $chart['Atendidas'][$colaborador]['number'] = 0;
    }


    // get stats
    $sql =  "SELECT s.servico_destino AS idService, ".
            "   emp.nome AS nome, ".
            "   status, ".
            "   count(*) AS number ".
            "FROM senhas AS s ".
            "INNER JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE  s.data LIKE '$date%' AND ".
            "   (   s.status = '" . SENHA_DESISTIDA . "' OR ".
            "       s.status = '" . SENHA_REDIRECCAO . "' OR ".
            "       s.status = '" . SENHA_TERMINADA . "' ".
            "   ) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .= "GROUP BY s.id_colaborador, s.status ";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    foreach($res AS $row)
    {

        $colaborador = $row['nome'];

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_REDIRECCAO:
            case SENHA_TERMINADA:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$colaborador]['number'] = $row['number'];
        $totais[$label] += $row['number'];

       /* if(!isset($outputCSV[$colaborador]))
        {
            $outputCSV[$colaborador]["Atendidas"] = 0;
            $outputCSV[$colaborador]["Desistidas"] = 0;
        }
        $outputCSV[$colaborador][$label] = $row['number'];*/
        $colab[$colaborador][$label] = $row['number'];
    }

    // download in CSV??
    /*if($outputFormat == 'downloadCSV')
    {
        $out = "data;colaborador;numero_atendidas;numero_desistidas\n";

        foreach($outputCSV AS $colaborador => $values)
        {
            $out .= "$date;$colaborador;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }*/

    if (count($colab) === 0) {
        return $chartout . " ";
    }


    $chartout = "";
    $graphs = "";



    $chartout .= "              'graphs': [\n";

    foreach($colaboradores AS $colaborador => $value)
    {
        $colab_name = $value['nome'];
        printf("colaborador: " . $colaborador . " values: " . $value['nome'] . " -> " .$colab_name."<br/>");


        $graphs .= "                        {\n" .
                        "                   'id': 'AmGraph-1',\n" .
                        "                   'balloonText': 'Foram atendidas [[atendidas]] senhas',\n" .
                        "                   'legendColor': 'undefined',\n" .
                        "                   'type': 'column',\n" .
                        "                   'fillAlphas': 1,\n" .
                        "                   'title': '$colaborador',\n" .
                        "                   'valueField': 'atendidas'\n";
        $graphs .= "},\n";

        $graphs .= "                        {\n" .
                        "                   'id': 'AmGraph-2',\n" .
                        "                   'balloonText': 'Foram desistidas [[desistidas]] senhas',\n" .
                        "                   'legendColor': 'undefined',\n" .
                        "                   'type': 'column',\n" .
                        "                   'fillAlphas': 1,\n" .
                        "                   'title': '$colaborador',\n" .
                        "                   'valueField': 'desistidas'\n";
        $graphs .= "},\n";

    }
    $graphs .= "],\n";
    $chartout .= $graphs;

    $chartout .= "  'dataProvider': [\n";

    foreach($colab AS $colaborador => $dados)
    {
        //$out .= "\t\t<value xid='$value'><![CDATA[$service]]></value>\n";


         //printf("colaborador: " . $colaborador['nome'] . "values: " . $dados['nome'] ."<br/>");

            //foreach($values AS $colaborador => $dados){
                //printf("colaborador: " . $colaborador['nome'] . " values: " . $values['nome']. " dados: " . $dados[number] . " desistidas: " . count($values[Desistidas]) . " atendidas: ". $values[Atendidas] ."<br/>");
                $valAtendidas;
                $valDesistidas;
                count($dados[Desistidas]) != 0 ? $valDesistidas = $dados[Desistidas] : $valDesistidas = 0;
                count($dados[Atendidas]) != 0 ? $valAtendidas = $dados[Atendidas] : $valAtendidas = 0;
                $chartout .= "{'colaborador':'$colaborador', 'desistidas':'$valDesistidas', 'atendidas':'$valAtendidas'}\n";
           // }



    }
    $chartout .= "              ],\n";
    return $chartout . " ";

    /*foreach($colaboradores AS $colaborador => $value)
    {
        $out .= "\t\t<value xid='$value'><![CDATA[$colaborador]]></value>\n";
    }*/
    //$out .= "\t\t<value xid='$id'><![CDATA[TOTAL]]></value>\n";
    /*$out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";


    $statusType = "Desistidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $statusType = "Atendidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
    */

}

function monthAttendanceTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =  "SELECT CONCAT(data, ' ', LPAD(HOUR(emissao), 2, '0'), ':00') AS dataHora, ".
            "   data AS data, ".
            "   CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS hora, ".
            "   count(*) AS number, ".
            "   ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMedioMinutos, ".
            "   SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "   ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMaximoMinutos, ".
            "   SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE  data LIKE '$date%' AND ".
            "   (   status = '" . SENHA_TERMINADA . "' OR ".
            "       status = '" . SENHA_REDIRECCAO . "' ".
            "   ) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .= "GROUP BY dataHora, data, emissao ".
            "ORDER BY dataHora";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $out = "";
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data_hora;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_month_waiting_time_avg_max') . "\n";
    }

    foreach($res AS $row)
    {
        if($outputFormat == 'downloadCSV')
        {
            $out .= "$row[data];$row[hora];$row[tempoMedio];$row[tempoMaximo]\n";
        }else
        {
            $out .= "$row[dataHora];$row[tempoMedioMinutos];$row[tempoMaximoMinutos]\n";
        }
    }

    return $out . " ";
}

?>
