<?php

/**
 * Possible arguments: date; dataSource; dataPeriod; outputFormat
 */
session_start();
require_once("../config.inc.php");
//require('../phpUtils/xlsxwriter.class.php');

$writer = new XLSXWriter();

$dataSource = getRequestValue("dataSource");
$sheetName = $dataSource;

if(!validFunction($dataSource))
{
    echo "";
    return;
}

$formatDate = "Y-m-d";
$dataPeriod = getRequestValue("dataPeriod");
if($dataPeriod == 'month')
{
    $formatDate = "Y-m";
}

$date = getRequestValue("date");
if($date == '')
{
    $date = date($formatDate); // actual day or month
}else
{
    $date = date($formatDate, strtotime($date));
}

$outputFormat = getRequestValue("outputFormat");

$extra = array();
foreach(explode(';', getRequestValue("extra")) AS $ex)
{
    $extra[$ex] = getRequestValue($ex);
}

//debug(print_r($extra, true));

/*****************/
/**** M A I N ****/
/*****************/

$dbConn = initDBconnection();

/* getData from function (run-time decision) */
$out = $dataSource($writer, $sheetName,$dbConn, $date, $dataPeriod, $outputFormat, $extra);

switch($outputFormat)
{
    case 'downloadCSV':
        $fileSize = strlen($out);
        outputHeadersToDownload($writer, $dataSource, "$dataSource-$date.xlsx"/*.csv"*/, $fileSize);
    default:
    // do not cache pages! IE bug: http://support.microsoft.com/default.aspx?scid=kb;en-us;272359
        header("Cache-Control: ");# leave blank to avoid IE errors
        header("Pragma: ");# leave blank to avoid IE errors
		header("Content-Type: text/html; charset=utf-8");
        break;
}

echo $out;
return;



/*****************************************/
/**** U S E F U L   F U N C T I O N S ****/
/*****************************************/

function validFunction($function)
{
    $functions = array(
            "waitingTimeAvgMax", // getData1.php
            "attendanceTimeAvgMax", // getData2.php
            "ticketsNumberPerHour", // getData5.php
            "ticketsNumberPerService", // getData6.php
            "monthWaitingTimeAvgMax", // getData1Mensal.php
            "monthAttendanceTimeAvgMax", // getData2Mensal.php
            "monthTicketsNumberPerHour", // getData3Mensal.php
            "employeAttendanceTimeAvgMax", // getData3.php
            "employeTicketsNumberPerHourAndEmploye", // getData4.php
            "employeTicketsNumberPerEmploye", // getData7.php
            "employeMonthAttendanceTimeAvgMax", // getData1MensalColaborador.php
            "employeMonthTicketsNumberPerEmploye", // getData2MensalColaborador.php
            "resumeServicesDay",
            "resumeServicesDayHours",
            "resumeEmployesDay",
            "resumeEmployesDayHours",

            // statistics section
            "statistics_servicesAvgMaxWaitTime",
            "statistics_servicesAvgMaxAttendanceTime",
            "statistics_servicesTicketsNumber",
            "statistics_employesAvgMaxAttendanceTime",
            "statistics_employesTicketsNumber",

			"volumeTransaccoes"
    );

    if(function_exists($function) && in_array($function, $functions))
    {
        return TRUE;
    }
    return FALSE;
}

function initDBconnection()
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);

    //return $bd;
    return new AcessoBD($conn);

}


function outputHeadersToDownload($writer, $dataSource, $fileName, $fileSize)
{

  /*  if(ini_get('zlib.output_compression'))
    {
        ini_set('zlib.output_compression', 'Off');
    }

    header("Cache-Control: ");# leave blank to avoid IE errors
    header("Pragma: ");# leave blank to avoid IE errors
    header("Content-type: text/plain");
    header("Content-Disposition: attachment; filename=\"$fileName\"");
    header("Content-length: $fileSize");
*/
     ini_set('display_errors', 0);
    //ini_set('log_errors', 1);
    //error_reporting(E_ALL & ~E_NOTICE);

    //$filename = "example.xlsx";
    header('Content-disposition: attachment; filename="'.XLSXWriter::sanitize_filename($fileName).'"');
    header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    header('Content-Transfer-Encoding: binary');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    $writer->writeToStdOut();
    exit(0);

}


/***************************/
/**** F U N C T I O N S ****/
/***************************/

/* all functions have to respect this signature!!!
function ($dbConn, $date, $dataPeriod, $outputFormat, $extra=array()){
	return $out;
}
*/

function waitingTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "	s.servico_destino AS id_servico, ".
            "	serv.nome AS servico_nome, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedioSecs, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximoSecs, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_CHAMADA . "' OR ".
            "		status = '" . SENHA_RECHAMADA . "' OR ".
            "		status = '" . SENHA_SUSPENSA . "' OR ".
            "		status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_DESISTIDA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY horas, servico_destino ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idServico = $row['id_servico'];

        $chart[$idServico]['nome'] = $row['servico_nome'];
        $chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;servico;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_waiting_time_avg_max') . "\n";

        foreach($chart AS $idServico => $values)
        {
            foreach($values AS $hora => $tempos)
            {
                if($hora == 'nome')
                    continue;
                $out .= "$date;$hora;$values[nome];$tempos[tempoMedio];$tempos[tempoMaximo]\n";
            }
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";
    foreach($chart AS $idServico => $values)
    {

        // dump para cada servico o tempo medio e maximo em dois graph's
        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Avg: $values[nome]' balloon_text='{description}'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMedio]'>$tempos[tempoMedioSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;

        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Max: $values[nome]' balloon_text='{description}' hidden='true'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMaximo]'>$tempos[tempoMaximoSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;
    }
    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function attendanceTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "	s.servico_destino AS id_servico, ".
            "	serv.nome AS servico_nome, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedioSecs, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximoSecs, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY horas, servico_destino ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idServico = $row['id_servico'];

        $chart[$idServico]['nome'] = $row['servico_nome'];
        $chart[$idServico][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idServico][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idServico][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idServico][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;servico;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_waiting_time_avg_max') . "\n";

        foreach($chart AS $idServico => $values)
        {
            foreach($values AS $hora => $tempos)
            {
                if($hora == 'nome')
                    continue;
                $out .= "$date;$hora;$values[nome];$tempos[tempoMedio];$tempos[tempoMaximo]\n";
            }
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";
    foreach($chart AS $idServico => $values)
    {

        // dump para cada servico o tempo medio e maximo em dois graph's
        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Avg: $values[nome]' balloon_text='{description}'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMedio]'>$tempos[tempoMedioSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;

        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Max: $values[nome]' balloon_text='{description}' hidden='true'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMaximo]'>$tempos[tempoMaximoSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;
    }
    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function ticketsNumberPerHour($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(LPAD(HOUR(ADDTIME(emissao, tempo_espera)), 2, '0'), ':00') AS horas, ".
            "	count(*) AS number, ".
            "	status ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	s.data LIKE '$date%' AND ".
            "       tempo_atendimento IS NOT NULL AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' OR ".
            "		status = '" . SENHA_DESISTIDA . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY horas, status ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $outputCSV = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$hora]['number'] = $row['number'];

        if(!isset($outputCSV[$hora]))
        {
            $outputCSV[$hora]["Atendidas"] = 0;
            $outputCSV[$hora]["Desistidas"] = 0;
        }
        $outputCSV[$hora][$label] = $row['number'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;numero_atendidas;numero_desistidas\n";
        $out = translate('word_excel_out_tickets_number_per_hour') . "\n";

        foreach($outputCSV AS $hora => $values)
        {
            $out .= "$date;$hora;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";


    $statusType = "Desistidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $hora => $dados)
    {
        $out .= "\t\t\t<value xid='" . $horas[$hora] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $statusType = "Atendidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $hora => $dados)
    {
        $out .= "\t\t\t<value xid='" . $horas[$hora] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function ticketsNumberPerService($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $chart = array();
    $services = array();
    $totais = array();
    $outputCSV = array();

    $totais['Desistidas'] = 0;
    $totais['Atendidas'] = 0;


    // get all services
    $sql =	"SELECT nome AS serviceName ".
            "FROM servicos ".
            "WHERE 1 ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND id_servico IN ($extra[servico]) ";
    }
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $id = 0;
    foreach($res AS $row)
    {
        $service = $row['serviceName'];
        if(!isset($services[$service]))
        {
            $services[$service] = $id++;
        }

        $chart['Desistidas'][$service]['number'] = 0;
        $chart['Atendidas'][$service]['number'] = 0;
    }


    // get stats
    $sql = 	"SELECT	s.servico_destino AS idService, ".
            "	serv.nome AS serviceName, ".
            "	status, ".
            "	count(*) AS number ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' OR ".
            "		status = '" . SENHA_DESISTIDA . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY s.servico_destino, status";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    foreach($res AS $row)
    {

        $service = $row['serviceName'];

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$service]['number'] = $row['number'];
        $totais[$label] += $row['number'];

        if(!isset($outputCSV[$service]))
        {
            $outputCSV[$service]["Atendidas"] = 0;
            $outputCSV[$service]["Desistidas"] = 0;
        }
        $outputCSV[$service][$label] = $row['number'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;servico;numero_atendidas;numero_desistidas\n";
        $out = translate('word_excel_out_tickets_number_per_service') . "\n";

        foreach($outputCSV AS $service => $values)
        {
            $out .= "$date;$service;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($services AS $service => $value)
    {
        $out .= "\t\t<value xid='$value'><![CDATA[$service]]></value>\n";
    }
    //$out .= "\t\t<value xid='$id'><![CDATA[TOTAL]]></value>\n";
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";


    $statusType = "Desistidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $service => $dados)
    {
        $out .= "\t\t\t<value xid='" . $services[$service] . "'>$dados[number]</value>\n";
    }
    //$out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $statusType = "Atendidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $service => $dados)
    {
        $out .= "\t\t\t<value xid='" . $services[$service] . "'>$dados[number]</value>\n";
    }
    //$out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function monthWaitingTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(data, ' ', LPAD(HOUR(emissao), 2, '0'), ':00') AS dataHora, ".
            "	data AS data, ".
            "	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS hora, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_espera) / 60)) AS tempoMedioMinutos, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_espera))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_espera) / 60)) AS tempoMaximoMinutos, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_espera))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_CHAMADA . "' OR ".
            "		status = '" . SENHA_RECHAMADA . "' OR ".
            "		status = '" . SENHA_SUSPENSA . "' OR ".
            "		status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_DESISTIDA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY dataHora, data, emissao ".
            "ORDER BY dataHora ";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $out = "";
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_month_waiting_time_avg_max') . "\n";
    }

    foreach($res AS $row)
    {
        if($outputFormat == 'downloadCSV')
        {
            $out .= "$row[data];$row[hora];$row[tempoMedio];$row[tempoMaximo]\n";
        }else
        {
            $out .= "$row[dataHora];$row[tempoMedioMinutos];$row[tempoMaximoMinutos]\n";
        }
    }

    return $out . " ";
}

function monthAttendanceTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(data, ' ', LPAD(HOUR(emissao), 2, '0'), ':00') AS dataHora, ".
            "	data AS data, ".
            "	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS hora, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMedioMinutos, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMaximoMinutos, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY dataHora, data, emissao ".
            "ORDER BY dataHora";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $out = "";
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data_hora;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_month_waiting_time_avg_max') . "\n";
    }

    foreach($res AS $row)
    {
        if($outputFormat == 'downloadCSV')
        {
            $out .= "$row[data];$row[hora];$row[tempoMedio];$row[tempoMaximo]\n";
        }else
        {
            $out .= "$row[dataHora];$row[tempoMedioMinutos];$row[tempoMaximoMinutos]\n";
        }
    }

    return $out . " ";
}

function monthTicketsNumberPerHour($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(data, ' ', LPAD(HOUR(emissao), 2, '0'), ':00') AS dataHora, ".
            "	data AS data, ".
            "	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS hora, ".
            "	count(*) AS number, ".
            "	status ".
            "FROM senhas AS s ".
            "INNER JOIN servicos AS serv ON serv.id_servico = s.servico_destino ".
            "WHERE	data LIKE '$date%' AND ".
            "       tempo_atendimento IS NOT NULL AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' OR ".
            "		status = '" . SENHA_DESISTIDA . "' ".
            "	) ";

    if(isset($extra['entidade']) AND $extra['entidade'] != '')
    {
        $sql .= " AND serv.id_entidade IN ($extra[entidade]) ";
    }

    if(isset($extra['servico']) AND $extra['servico'] != '')
    {
        $sql .= " AND s.servico_destino IN ($extra[servico]) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    $sql .=	"GROUP BY dataHora, status, data, emissao ".
            "ORDER BY dataHora";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $dados = array();
    foreach($res AS $row)
    {
        if(!isset($dados[$row['dataHora']]))
        {
            $dados[$row['dataHora']] = array();
            $dados[$row['dataHora']][SENHA_TERMINADA] = 0;
            $dados[$row['dataHora']][SENHA_DESISTIDA] = 0;
        }

        $label = $row['status'];
        if($label == SENHA_REDIRECCAO)
        {
            $label = SENHA_TERMINADA;
        }

        $dados[$row['dataHora']][$label] = $row['number'];
    }

    $out = '';
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;numero_atendidas;numero_desistidas\n";
        $out = translate('word_excel_out_month_tickets_number_per_hour') . "\n";
    }

    foreach($dados AS $dataHora => $values)
    {
        if($outputFormat == 'downloadCSV')
        {
            $parts = explode(' ', $dataHora);
            $out .= "$parts[0];$parts[1];" . $values[SENHA_TERMINADA] . ";" . $values[SENHA_DESISTIDA] . "\n";
        }else
        {
            $out .= "$dataHora;" . $values[SENHA_TERMINADA] . ";" . $values[SENHA_DESISTIDA] . "\n";
        }
    }

    return $out . " ";
}

function employeAttendanceTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS horas, ".
            "	s.id_colaborador, ".
            "	emp.nome AS colaborador_nome, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedioSecs, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximoSecs, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas AS s ".
            "LEFT JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE	s.data = '$date' AND ".
            "	s.id_colaborador IS NOT NULL AND ".
            "	(	s.status = '" . SENHA_REDIRECCAO . "' OR ".
            "		s.status = '" . SENHA_TERMINADA . "' ".
            "	) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .=	"GROUP BY horas, id_colaborador ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idColaborador = $row['id_colaborador'];

        $chart[$idColaborador]['nome'] = $row['colaborador_nome'];
        $chart[$idColaborador][$hora]['tempoMedio'] = $row['tempoMedio'];
        $chart[$idColaborador][$hora]['tempoMaximo'] = $row['tempoMaximo'];
        $chart[$idColaborador][$hora]['tempoMedioSecs'] = $row['tempoMedioSecs'];
        $chart[$idColaborador][$hora]['tempoMaximoSecs'] = $row['tempoMaximoSecs'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;colaborador;tempo_medio;tempo_maximo\n";
        $out = translate('word_excel_out_employe_attendance_time_avg_max') . "\n";

        foreach($chart AS $idColaborador => $values)
        {
            foreach($values AS $hora => $tempos)
            {
                if($hora == 'nome')
                    continue;
                $out .= "$date;$hora;$values[nome];$tempos[tempoMedio];$tempos[tempoMaximo]\n";
            }
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";
    foreach($chart AS $idColaborador => $values)
    {

        // dump para cada servico o tempo medio e maximo em dois graph's
        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Avg: $values[nome]' balloon_text='{description}'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMedio]'>$tempos[tempoMedioSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;

        $out .= "\t\t<graph gid='$idGraph' axis='left' title='Max: $values[nome]' balloon_text='{description}' hidden='true'>\n";
        foreach($values AS $hora => $tempos)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "' description='$tempos[tempoMaximo]'>$tempos[tempoMaximoSecs]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;
    }
    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function employeTicketsNumberPerHourAndEmploye($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(LPAD(HOUR(ADDTIME(emissao, tempo_espera)), 2, '0'), ':00') AS horas, ".
            "	s.id_colaborador, ".
            "	emp.nome AS colaborador_nome, ".
            "	count(*) AS number ".
            "FROM senhas AS s ".
            "LEFT JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE	s.data = '$date' AND ".
            "	s.id_colaborador IS NOT NULL AND ".
            "	(	status = '" . SENHA_REDIRECCAO . "' OR ".
            "		status = '" . SENHA_TERMINADA . "' ".
            "	) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .=	"GROUP BY horas, id_colaborador ".
            "ORDER BY horas";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $chart = array();
    $horas = array();
    $outputCSV = array();

    $id = 0;
    foreach($res AS $row)
    {

        $hora = $row['horas'];
        if(!isset($horas[$hora]))
        {
            $horas[$hora] = $id++;
        }
        $idHora = $horas[$hora];
        $idColaborador = $row['id_colaborador'];

        $chart[$idColaborador]['nome'] = $row['colaborador_nome'];
        $chart[$idColaborador][$hora]['number'] = $row['number'];

        if(!isset($outputCSV[$row['colaborador_nome']][$hora]))
        {
            $outputCSV[$row['colaborador_nome']][$hora] = 0;
        }
        $outputCSV[$row['colaborador_nome']][$hora] = $row['number'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;colaborador;numero_atendimentos\n";
        $out = translate('word_excel_out_employe_tickets_number_per_hour_employe') . "\n";

        foreach($outputCSV AS $colaborador => $values)
        {
            foreach($values AS $hora => $number)
            {
                $out .= "$date;$hora;$colaborador;$number\n";
            }
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($horas AS $hour => $value)
    {
        $out .= "\t\t<value xid='$value'>$hour</value>\n";
    }
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";
    foreach($chart AS $idColaborador => $values)
    {

        $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$values[nome]' balloon_text='{value}'>\n";
        foreach($values AS $hora => $dados)
        {
            if($hora == 'nome')
                continue;
            $out .= "\t\t\t<value xid='" . $horas[$hora] . "'>$dados[number]</value>\n";
        }
        $out .= "\t\t</graph>\n";

        $idGraph++;
    }
    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function employeTicketsNumberPerEmploye($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $chart = array();
    $colaboradores = array();
    $totais = array();
    $outputCSV = array();

    $totais['Desistidas'] = 0;
    $totais['Atendidas'] = 0;


    // get all employes
    $sql =	"SELECT e.nome ".
            "FROM empregados AS e ".
            "INNER JOIN local_colaborador AS lc ON e.id_empregado = lc.id_colaborador ".
            "WHERE 1 ";

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND e.id_empregado IN ($extra[colaborador]) ";
    }
    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND lc.id_local IN ($extra[local]) ";
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $id = 0;
    foreach($res AS $row)
    {
        $colaborador = $row['nome'];
        if(!isset($colaboradores[$colaborador]))
        {
            $colaboradores[$colaborador] = $id++;
        }

        $chart['Desistidas'][$colaborador]['number'] = 0;
        $chart['Atendidas'][$colaborador]['number'] = 0;
    }


    // get stats
    $sql = 	"SELECT	s.servico_destino AS idService, ".
            "	emp.nome AS nome, ".
            "	status, ".
            "	count(*) AS number ".
            "FROM senhas AS s ".
            "INNER JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	s.status = '" . SENHA_DESISTIDA . "' OR ".
            "		s.status = '" . SENHA_REDIRECCAO . "' OR ".
            "		s.status = '" . SENHA_TERMINADA . "' ".
            "	) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .=	"GROUP BY s.id_colaborador, s.status ";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    foreach($res AS $row)
    {

        $colaborador = $row['nome'];

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_REDIRECCAO:
            case SENHA_TERMINADA:
            default:
                $label = "Atendidas";
        }

        $chart[$label][$colaborador]['number'] = $row['number'];
        $totais[$label] += $row['number'];

        if(!isset($outputCSV[$colaborador]))
        {
            $outputCSV[$colaborador]["Atendidas"] = 0;
            $outputCSV[$colaborador]["Desistidas"] = 0;
        }
        $outputCSV[$colaborador][$label] = $row['number'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;colaborador;numero_atendidas;numero_desistidas\n";
        $out = translate('word_excel_out_employe_tickets_number_per_employe') . "\n";

        foreach($outputCSV AS $colaborador => $values)
        {
            $out .= "$date;$colaborador;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($colaboradores AS $colaborador => $value)
    {
        $out .= "\t\t<value xid='$value'><![CDATA[$colaborador]]></value>\n";
    }
    //$out .= "\t\t<value xid='$id'><![CDATA[TOTAL]]></value>\n";
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";


    $statusType = "Desistidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $statusType = "Atendidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    $out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function employeMonthAttendanceTimeAvgMax($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    $sql =	"SELECT	CONCAT(data, ' ', LPAD(HOUR(emissao), 2, '0'), ':00') AS dataHora, ".
            "	data AS data, ".
            "	CONCAT(LPAD(HOUR(emissao), 2, '0'), ':00') AS hora, ".
            "	count(*) AS number, ".
            "	ROUND(AVG(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMedioMinutos, ".
            "	SEC_TO_TIME(AVG(TIME_TO_SEC(tempo_atendimento))) AS tempoMedio, ".
            "	ROUND(MAX(TIME_TO_SEC(tempo_atendimento) / 60)) AS tempoMaximoMinutos, ".
            "	SEC_TO_TIME(MAX(TIME_TO_SEC(tempo_atendimento))) AS tempoMaximo ".
            "FROM senhas ".
            "WHERE	data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	) ";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .= "GROUP BY dataHora ".
            "ORDER BY dataHora ";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $out = "";
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;hora;tempo_medio;tempo_maximo;numero_atendimentos\n";
        $out = translate('word_excel_out_employe_month_attendance_time_avg_max') . "\n";
    }

    foreach($res AS $row)
    {
        if($outputFormat == 'downloadCSV')
        {
            $out .= "$row[data];$row[hora];$row[tempoMedio];$row[tempoMaximo];$row[number]\n";
        }else
        {
            $out .= "$row[dataHora];$row[tempoMedioMinutos];$row[tempoMaximoMinutos];$row[number]\n";
        }
    }
    return $out . " ";
}

function employeMonthTicketsNumberPerEmploye($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $chart = array();
    $colaboradores = array();
    $totais = array();
    $outputCSV = array();

    $totais['Desistidas'] = 0;
    $totais['Atendidas'] = 0;


    // get all employes
    $sql =	"SELECT e.nome ".
            "FROM empregados AS e ".
            "INNER JOIN local_colaborador AS lc ON e.id_empregado = lc.id_colaborador ".
            "WHERE 1 ";

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND e.id_empregado IN ($extra[colaborador]) ";
    }
    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND lc.id_local IN ($extra[local]) ";
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $id = 0;
    foreach($res AS $row)
    {
        $colaborador = $row['nome'];
        if(!isset($colaboradores[$colaborador]))
        {
            $colaboradores[$colaborador] = $id++;
        }

        $chart['Desistidas'][$colaborador]['number'] = 0;
        $chart['Atendidas'][$colaborador]['number'] = 0;
    }


    // get stats
    $sql = 	"SELECT	s.servico_destino AS idService, ".
            "	emp.nome AS nome, ".
            "	status, ".
            "	count(*) AS number ".
            "FROM senhas AS s ".
            "INNER JOIN empregados AS emp ON emp.id_empregado = s.id_colaborador ".
            "WHERE	s.data LIKE '$date%' AND ".
            "	(	status = '" . SENHA_DESISTIDA . "' OR ".
            "		status = '" . SENHA_TERMINADA . "' OR ".
            "		status = '" . SENHA_REDIRECCAO . "' ".
            "	)";

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $sql .= " AND s.id_loja IN ($extra[local]) ";
    }

    if(isset($extra['colaborador']) AND $extra['colaborador'] != '')
    {
        $sql .= " AND s.id_colaborador IN ($extra[colaborador]) ";
    }

    $sql .=	"GROUP BY s.id_colaborador, status";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    foreach($res AS $row)
    {

        $colaborador = $row['nome'];

        $label = "";
        switch($row['status'])
        {
            case SENHA_DESISTIDA:
                $label = "Desistidas";
                break;
            case SENHA_TERMINADA:
            case SENHA_REDIRECCAO:
                $label = "Atendidas";
                break;
            default:
                continue;
        }

        $chart[$label][$colaborador]['number'] = $row['number'];
        $totais[$label] += $row['number'];

        if(!isset($outputCSV[$colaborador]))
        {
            $outputCSV[$colaborador]["Atendidas"] = 0;
            $outputCSV[$colaborador]["Desistidas"] = 0;
        }
        $outputCSV[$colaborador][$label] = $row['number'];
    }

    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
        //$out = "data;colaborador;numero_atendidas;numero_desistidas\n";
        $out = translate('word_excel_out_employe_tickets_number_per_employe') . "\n";

        foreach($outputCSV AS $colaborador => $values)
        {
            $out .= "$date;$colaborador;$values[Atendidas];$values[Desistidas]\n";
        }

        return $out;
    }

    $out = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    $out .= "<chart>\n";

    $out .= "\t<series>\n";
    foreach($colaboradores AS $colaborador => $value)
    {
        $out .= "\t\t<value xid='$value'><![CDATA[$colaborador]]></value>\n";
    }
    //$out .= "\t\t<value xid='$id'><![CDATA[TOTAL]]></value>\n";
    $out .= "\t</series>\n";

    $idGraph = 0;
    $out .= "\t<graphs>\n";


    $statusType = "Desistidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    //$out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $statusType = "Atendidas";
    $values = $chart[$statusType];

    // dump para cada servico o tempo medio e maximo em dois graph's
    $out .= "\t\t<graph gid='$idGraph' type='column' axis='left' title='$statusType' balloon_text='Foram " . strtolower($statusType) . " {value} senhas'>\n";
    foreach($values AS $colaborador => $dados)
    {
        $out .= "\t\t\t<value xid='" . $colaboradores[$colaborador] . "'>$dados[number]</value>\n";
    }
    //$out .= "\t\t\t<value xid='$id'>$totais[$statusType]</value>\n";
    $out .= "\t\t</graph>\n";
    $idGraph++;


    $out .= "\t</graphs>\n";

    $out .= "</chart>\n";

    return $out;
}

function resumeServicesDay($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    // gel all services and store
//    $sql =	"SELECT	s.id_servico, ".
//            "	s.nome AS serviceName, ".
//            "	e.id_entidade, ".
//            "	e.nome AS entitieName ".
//            "FROM servicos AS s ".
//            "INNER JOIN entidades AS e ON e.id_entidade = s.id_entidade ";

    $sql = "select l.id_loja, l.nome local,
                s.id_servico, s.nome serviceName,
                e.id_entidade, e.nome entitieName
			from lojas l
			inner join lojas_entidades le on le.id_loja=l.id_loja
			inner join servicos s on s.id_entidade=le.id_entidade
                        inner join entidades e on e.id_entidade=s.id_entidade
                        where 1 ";

    if (count($extra))
    {
        foreach ($extra as $k => $v)
        {
            $aux = unserialize($v);
            if (!is_array($aux))
            {
                $aux = array();
                array_push($aux, $v);
            }

            switch ($k)
            {
                case "local":
                    $sql .= "and l.id_loja in (".implode(",", $aux).") ";
                    break;
                case "servico":
                    $sql .= "and s.id_servico in (".implode(",", $aux).") ";
                    break;
                default:
                    break;
            }
        }
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $senhasObj = new Senhas();

    $numerosSenhas = $senhasObj->GetNumeroSenhasPorServico($date);
    $temposSenhas = $senhasObj->GetTemposPorServico($date);

    //$out = "entidade;local;servico;data;numero_emitidas;numero_atendidas;numero_desistidas;tempo_medio_espera;tempo_maximo_espera;tempo_medio_atendimento;tempo_maximo_atendimento\n";
    $out = translate('word_excel_out_resume_services_day') . "\n";

    foreach($res AS $row)
    {
        $nomeLocal = $row['local'];
        $nomeEntidade = $row['entitieName'];
        $idServico = $row['id_servico'];
        $nomeServico = $row['serviceName'];

        $emissoes = 0;
        $atendimentos = 0;
        $desistencias = 0;
        if(isset($numerosSenhas[$idServico]['Emitidas']))
        {
            $emissoes = $numerosSenhas[$idServico]['Emitidas'];
        }
        if(isset($numerosSenhas[$idServico]['Terminadas']))
        {
            $atendimentos = $numerosSenhas[$idServico]['Terminadas'];
        }
        if(isset($numerosSenhas[$idServico]['Desistidas']))
        {
            $desistencias = $numerosSenhas[$idServico]['Desistidas'];
        }

        $tempoMedioEspera = '00:00:00';
        $tempoMaximoEspera = '00:00:00';
        $tempoMedioAtendimento = '00:00:00';
        $tempoMaximoAtendimento = '00:00:00';
        if(isset($temposSenhas[$idServico]['espera']))
        {
            $tempoMedioEspera = $temposSenhas[$idServico]['espera'];
        }
        if(isset($temposSenhas[$idServico]['esperaMax']))
        {
            $tempoMaximoEspera = $temposSenhas[$idServico]['esperaMax'];
        }
        if(isset($temposSenhas[$idServico]['atendimento']))
        {
            $tempoMedioAtendimento = $temposSenhas[$idServico]['atendimento'];
        }
        if(isset($temposSenhas[$idServico]['atendimentoMax']))
        {
            $tempoMaximoAtendimento = $temposSenhas[$idServico]['atendimentoMax'];
        }

        $out .= "$nomeEntidade;$nomeLocal;$nomeServico;$date;$emissoes;$atendimentos;$desistencias;$tempoMedioEspera;$tempoMaximoEspera;$tempoMedioAtendimento;$tempoMaximoAtendimento\n";
    }

    return $out;
}

function resumeEmployesDay($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    // gel all employes and stores
//	$sql =	"SELECT	e.id_empregado, ".
//		"	e.nome AS employeName, ".
//		"	(	SELECT l.nome ".
//		"		FROM local_colaborador AS lc ".
//		"		INNER JOIN lojas AS l ON l.id_loja = lc.id_local ".
//		"		WHERE	lc.id_colaborador = e.id_empregado ".
//		"		LIMIT 1 ".
//		"	) AS storeName, ".
//		"	ec.id_entidade, ".
//		"	ent.nome AS entitieName ".
//		"FROM empregados AS e ".
//		"INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = e.id_empregado ".
//		"INNER JOIN entidades AS ent ON ent.id_entidade = ec.id_entidade ";

    $sql =	"SELECT distinct c.id_empregado, ".
            "	c.nome AS colaborador, ".
            "	(	SELECT	b.nome ".
            "		FROM log_acessos_empregados AS lae ".
            "		INNER JOIN balcoes AS b ON b.id_balcao = lae.id_balcao ".
            "		WHERE	lae.id_empregado = c.id_empregado AND ".
            "			lae.acesso = 'Entrada' ".
            "		ORDER BY lae.data_hora DESC ".
            "		LIMIT 1 ".
            "	) AS ultimo_balcao, ".
            "	l.id_loja id_loja, l.nome AS loja ".
            "FROM empregados AS c ".
            "inner join local_colaborador lc on lc.id_colaborador=c.id_empregado ".
            "inner join lojas l on l.id_loja=lc.id_local ".
            "where 1 ";

    if (count($extra))
    {
        foreach ($extra as $k => $v)
        {
            $aux = unserialize($v);
            if (!is_array($aux))
            {
                $aux = array();
                array_push($aux, $v);
            }

            switch ($k)
            {
                case "local":
                    $sql .= "and l.id_loja in (".implode(",", $aux).") ";
                    break;
                case "colaborador":
                    $sql .= "and c.id_empregado in (".implode(",", $aux).") ";
                    break;
                default:
                    break;
            }
        }
    }

    //$res = $dbConn->executarSQL($sql, true)->GetRows();
    $res = $dbConn->getRows($sql);

    $senhasObj = new Senhas();

    $numerosSenhas = $senhasObj->GetNumeroSenhasPorColaborador($date, false, true, true);
    $temposSenhas = $senhasObj->GetTemposPorColaborador($date, false, true, true);

//	$out = "entidade;loja;colaborador;data;numero_atendidas;numero_desistidas;tempo_medio_atendimento;tempo_maximo_atendimento;tempo_medio_desistencias;tempo_maximo_desistencias\n";
//    $out = "loja;colaborador;data;numero_atendidas;numero_desistidas;tempo_medio_atendimento;tempo_maximo_atendimento;tempo_medio_desistencias;tempo_maximo_desistencias\n";
    $out = translate('word_excel_out_resume_employes_day') . "\n";
    foreach($res AS $row)
    {
        $nomeLoja = $row['loja'];
//		$nomeEntidade = $row['entitieName'];
        $idColaborador = $row['id_empregado'];
        $nomeColaborador = $row['colaborador'];
//		$idEntidade = $row['id_entidade'];
        $idLoja = $row["id_loja"];

        $atendimentos = 0;
        $desistencias = 0;
//		if(isset($numerosSenhas[$idEntidade][$idColaborador]['Terminadas'])){
//			$atendimentos = $numerosSenhas[$idEntidade][$idColaborador]['Terminadas'];
//		}
//		if(isset($numerosSenhas[$idEntidade][$idColaborador]['Desistidas'])){
//			$desistencias = $numerosSenhas[$idEntidade][$idColaborador]['Desistidas'];
//		}
        if(isset($numerosSenhas[$idColaborador][$idLoja]['Terminadas']))
        {
            $atendimentos = $numerosSenhas[$idColaborador][$idLoja]['Terminadas'];
        }
        if(isset($numerosSenhas[$idColaborador][$idLoja]['Desistidas']))
        {
            $desistencias = $numerosSenhas[$idColaborador][$idLoja]['Desistidas'];
        }

        $tempoMedioAtendimento = '00:00:00';
        $tempoMaximoAtendimento = '00:00:00';
        $tempoMedioDesistencia = '00:00:00';
        $tempoMaximoDesistencia = '00:00:00';
        if(isset($temposSenhas[$idColaborador][$idLoja]['atendimento']))
        {
            $tempoMedioAtendimento = $temposSenhas[$idColaborador][$idLoja]['atendimento'];
        }
        if(isset($temposSenhas[$idColaborador][$idLoja]['atendimentoMax']))
        {
            $tempoMaximoAtendimento = $temposSenhas[$idColaborador][$idLoja]['atendimentoMax'];
        }
        if(isset($temposSenhas[$idColaborador][$idLoja]['desistencia']))
        {
            $tempoMedioDesistencia = $temposSenhas[$idColaborador][$idLoja]['desistencia'];
        }
        if(isset($temposSenhas[$idColaborador][$idLoja]['desistenciaMax']))
        {
            $tempoMaximoDesistencia = $temposSenhas[$idColaborador][$idLoja]['desistenciaMax'];
        }

        $out .= "$nomeLoja;$nomeColaborador;$date;$atendimentos;$desistencias;$tempoMedioAtendimento;$tempoMaximoAtendimento;$tempoMedioDesistencia;$tempoMaximoDesistencia\n";
    }

    return $out;
}

function resumeServicesDayHours($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    // gel all services and store
//    $sql =	"SELECT	s.id_servico, ".
//            "	s.nome AS serviceName, ".
//            "	e.id_entidade, ".
//            "	e.nome AS entitieName ".
//            "FROM servicos AS s ".
//            "INNER JOIN entidades AS e ON e.id_entidade = s.id_entidade ";

    $sql = "select l.id_loja, l.nome local,
                s.id_servico, s.nome serviceName,
                e.id_entidade, e.nome entitieName
			from lojas l
			inner join lojas_entidades le on le.id_loja=l.id_loja
			inner join servicos s on s.id_entidade=le.id_entidade
                        inner join entidades e on e.id_entidade=s.id_entidade
                        where 1 ";

    if (count($extra))
    {
        foreach ($extra as $k => $v)
        {
            $aux = unserialize($v);
            if (!is_array($aux))
            {
                $aux = array();
                array_push($aux, $v);
            }

            switch ($k)
            {
                case "local":
                    $sql .= "and l.id_loja in (".implode(",", $aux).") ";
                    break;
                case "servico":
                    $sql .= "and s.id_servico in (".implode(",", $aux).") ";
                    break;
                default:
                    break;
            }
        }
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $senhasObj = new Senhas();

    $numerosSenhas = $senhasObj->GetNumeroSenhasPorServico($date, true);
    $temposSenhas = $senhasObj->GetTemposPorServico($date, true);

    //$out = "entidade;local;servico;data;hora;numero_emitidas;numero_atendidas;numero_desistidas;tempo_medio_espera;tempo_maximo_espera;tempo_medio_atendimento;tempo_maximo_atendimento\n";
    $out = translate('word_excel_out_resume_services_day_hour') . "\n";
    foreach($res AS $row)
    {
        $nomeLocal = $row['local'];
        $nomeEntidade = $row['entitieName'];
        $idServico = $row['id_servico'];
        $nomeServico = $row['serviceName'];

        if(!isset($numerosSenhas[$idServico]))
        {
            $out .= "$nomeEntidade;$nomeServico;$date;00:00;0;0;0;00:00:00;00:00:00;00:00:00;00:00:00\n";
            continue;
        }

        foreach($numerosSenhas[$idServico] AS $hora => $values)
        {
            $emissoes = 0;
            $atendimento = 0;
            $desistencias = 0;
            if(isset($values['Emitidas']))
            {
                $emissoes = $values['Emitidas'];
            }
            if(isset($values['Terminadas']))
            {
                $atendimentos = $values['Terminadas'];
            }
            if(isset($values['Desistidas']))
            {
                $desistencias = $values['Desistidas'];
            }

            $tempoMedioEspera = '00:00:00';
            $tempoMaximoEspera = '00:00:00';
            $tempoMedioAtendimento = '00:00:00';
            $tempoMaximoAtendimento = '00:00:00';
            if(isset($temposSenhas[$idServico][$hora]['espera']))
            {
                $tempoMedioEspera = $temposSenhas[$idServico][$hora]['espera'];
            }
            if(isset($temposSenhas[$idServico][$hora]['esperaMax']))
            {
                $tempoMaximoEspera = $temposSenhas[$idServico][$hora]['esperaMax'];
            }
            if(isset($temposSenhas[$idServico][$hora]['atendimento']))
            {
                $tempoMedioAtendimento = $temposSenhas[$idServico][$hora]['atendimento'];
            }
            if(isset($temposSenhas[$idServico][$hora]['atendimentoMax']))
            {
                $tempoMaximoAtendimento = $temposSenhas[$idServico][$hora]['atendimentoMax'];
            }

            $out .= "$nomeEntidade;$nomeLocal;$nomeServico;$date;$hora;$emissoes;$atendimentos;$desistencias;$tempoMedioEspera;$tempoMaximoEspera;$tempoMedioAtendimento;$tempoMaximoAtendimento\n";
        }
    }

    return $out;
}

function resumeEmployesDayHours($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{

    // gel all employes and stores
//	$sql =	"SELECT	e.id_empregado, ".
//		"	e.nome AS employeName, ".
//		"	(	SELECT l.nome ".
//		"		FROM local_colaborador AS lc ".
//		"		INNER JOIN lojas AS l ON l.id_loja = lc.id_local ".
//		"		WHERE	lc.id_colaborador = e.id_empregado ".
//		"		LIMIT 1 ".
//		"	) AS storeName, ".
//		"	ec.id_entidade, ".
//		"	ent.nome AS entitieName ".
//		"FROM empregados AS e ".
//		"INNER JOIN entidade_colaborador AS ec ON ec.id_colaborador = e.id_empregado ".
//		"INNER JOIN entidades AS ent ON ent.id_entidade = ec.id_entidade ";

    $sql =	"SELECT distinct c.id_empregado, ".
            "	c.nome AS colaborador, ".
            "	(	SELECT	b.nome ".
            "		FROM log_acessos_empregados AS lae ".
            "		INNER JOIN balcoes AS b ON b.id_balcao = lae.id_balcao ".
            "		WHERE	lae.id_empregado = c.id_empregado AND ".
            "			lae.acesso = 'Entrada' ".
            "		ORDER BY lae.data_hora DESC ".
            "		LIMIT 1 ".
            "	) AS ultimo_balcao, ".
            "	l.id_loja id_loja, l.nome AS loja ".
            "FROM empregados AS c ".
            "inner join local_colaborador lc on lc.id_colaborador=c.id_empregado ".
            "inner join lojas l on l.id_loja=lc.id_local ".
            "where 1 ";

    if (count($extra))
    {
        foreach ($extra as $k => $v)
        {
            $aux = unserialize($v);
            if (!is_array($aux))
            {
                $aux = array();
                array_push($aux, $v);
            }

            switch ($k)
            {
                case "local":
                    $sql .= "and l.id_loja in (".implode(",", $aux).") ";
                    break;
                case "colaborador":
                    $sql .= "and c.id_empregado in (".implode(",", $aux).") ";
                    break;
                default:
                    break;
            }
        }
    }

    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

    $senhasObj = new Senhas();

    $numerosSenhas = $senhasObj->GetNumeroSenhasPorColaborador($date, true, true, true);
    $temposSenhas = $senhasObj->GetTemposPorColaborador($date, true, true, true);

//	$out = "entidade;loja;colaborador;data;hora;numero_atendidas;numero_desistidas;tempo_medio_atendimento;tempo_maximo_atendimento;tempo_medio_desistencias;tempo_maximo_desistencias\n";
//    $out = "loja;colaborador;data;hora;numero_atendidas;numero_desistidas;tempo_medio_atendimento;tempo_maximo_atendimento;tempo_medio_desistencias;tempo_maximo_desistencias\n";
    $out = translate('word_excel_out_resume_employes_day_hours') . "\n";
    foreach($res AS $row)
    {
        $nomeLoja = $row['loja'];
//		$nomeEntidade = $row['entitieName'];
        $idColaborador = $row['id_empregado'];
        $nomeColaborador = $row['colaborador'];
//		$idEntidade = $row['id_entidade'];
        $idLoja = $row["id_loja"];

        if(!isset($numerosSenhas[$idColaborador][$idLoja]))
        {
            $out .= "$nomeLoja;$nomeColaborador;$date;00:00;0;0;00:00:00;00:00:00;00:00:00;00:00:00\n";
            continue;
        }

        foreach($numerosSenhas[$idColaborador][$idLoja] AS $hora => $values)
        {
            $atendimentos = 0;
            $desistencias = 0;
            if(isset($numerosSenhas[$idColaborador][$idLoja][$hora]['Terminadas']))
            {
                $atendimentos = $numerosSenhas[$idColaborador][$idLoja][$hora]['Terminadas'];
            }
            if(isset($numerosSenhas[$idColaborador][$idLoja][$hora]['Desistidas']))
            {
                $desistencias = $numerosSenhas[$idColaborador][$idLoja][$hora]['Desistidas'];
            }

            $tempoMedioAtendimento = '00:00:00';
            $tempoMaximoAtendimento = '00:00:00';
            $tempoMedioDesistencia = '00:00:00';
            $tempoMaximoDesistencia = '00:00:00';
            if(isset($temposSenhas[$idColaborador][$idLoja][$hora]['atendimento']))
            {
                $tempoMedioAtendimento = $temposSenhas[$idColaborador][$idLoja][$hora]['atendimento'];
            }
            if(isset($temposSenhas[$idColaborador][$idLoja][$hora]['atendimentoMax']))
            {
                $tempoMaximoAtendimento = $temposSenhas[$idColaborador][$idLoja][$hora]['atendimentoMax'];
            }
            if(isset($temposSenhas[$idColaborador][$idLoja][$hora]['desistencia']))
            {
                $tempoMedioDesistencia = $temposSenhas[$idColaborador][$idLoja][$hora]['desistencia'];
            }
            if(isset($temposSenhas[$idColaborador][$idLoja][$hora]['desistenciaMax']))
            {
                $tempoMaximoDesistencia = $temposSenhas[$idColaborador][$idLoja][$hora]['desistenciaMax'];
            }

            $out .= "$nomeLoja;$nomeColaborador;$date;$hora;$atendimentos;$desistencias;$tempoMedioAtendimento;$tempoMaximoAtendimento;$tempoMedioDesistencia;$tempoMaximoDesistencia\n";
        }
    }

    return $out;
}

function statistics_servicesAvgMaxWaitTime($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $out = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];


    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if(isset($extra['idLoja']))
    {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
        $tempos = $obj->getDataDummyFunction2($groupBy, $startDate, $endDate, $stats);
    }else
    {
        $tempos = $obj->getDataDummyFunction1($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $headerArray = array();
    $arrayNullValues = array();
    if($storeFilter)
    {
        if(!isset($tempos[$storeId]))
        {
            $tempos = array();
        }else
        {
            $tempos = $tempos[$storeId];

            // keep only the services associated with the store
            $sql =	"SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);

            $storeServices = array();
            foreach($res AS $row)
            {
                $storeServices[] = $row['id_servico'];
            }

            foreach($tempos AS $serviceId => $values)
            {
                if(!in_array($serviceId, $storeServices))
                {
                    unset($tempos[$serviceId]);
                }
            }
        }
    }

    //debug(print_r($tempos, true));

    foreach($tempos AS $idService => $times)
    {
        foreach($times AS $date => $timeType)
        {
            if(!isset($newTempos[$date]))
            {
                $newTempos[$date] = array();
            }
            $newTempos[$date][$idService] = $timeType['espera'];
        }

        if(!in_array($idService, $headerArray))
        {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60*60;
    $incDates["day"] = 24*(60*60); //86400;
    $incDates["month"] = 30*(24*60*60); //2592000;
    $incDates["year"] = 12*(30*(24*60*60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]])
    {
        if(!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)]))
        {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if($countTest == count($newTempos))
    {
        $newTempos = array();
    }

    ksort($newTempos);


    // download in CSV??
    if($outputFormat == 'downloadCSV' AND count($headerArray) > 0)
    {

        $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";
        //$res = $dbConn->executarSQL($sql)->GetRows();
        $res = $dbConn->getRows($sql);

        $headerNames = array();
        $headerStack = array();
        foreach($res AS $row)
        {
            $headerNames[$row['id_servico']] = $row['nome'];
        }

        $header = "date";
        $headerStack['Data'] = 'date';
        foreach($headerArray AS $idService)
        {
            if(isset($headerNames[$idService]))
            {
                $header .= ";$headerNames[$idService]";
                $headerStack[$headerNames[$idService]] = 'integer';
            }else
            {
                $header .= ";service_$idService";
                $headerStack['service_'.$idService] = 'integer';
            }
        }
        $header .= "\n";

        $out = $header . $out;
        $writer->writeSheetHeader($sheetName, $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
    }
    $format = array('font'=>'Calibri','font-size'=>12);
    foreach($newTempos AS $date => $services)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idService)
        {
            $out .= ";";
            if(isset($services[$idService]))
            {
                $out .= "$services[$idService]";
                array_push($rowStack,$services[$idService], $format);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow($sheetName, $rowStack, $format);
    }

    return $out . " ";
}

function statistics_servicesAvgMaxAttendanceTime($writer, $sheetName,$dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $out = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];
    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if(isset($extra['idLoja']))
    {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
         
        $tempos = $obj->getDataDummyFunction4($groupBy, $startDate, $endDate, $stats, $storeId);


    }else
    {
        $tempos = $obj->getDataDummyFunction3($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $newTemposMax = array();
    $headerArray = array();
    $arrayNullValues = array();
    if($storeFilter)
    {
        if(!isset($tempos[$storeId]))
        {
            $tempos = array();
        }else
        {
            $tempos = $tempos[$storeId];

            // keep only the services associated with the store
            $sql =	"SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            $storeServices = array();
            foreach($res AS $row)
            {
                $storeServices[] = $row['id_servico'];
            }

            foreach($tempos AS $serviceId => $values)
            {
                if(!in_array($serviceId, $storeServices))
                {
                    unset($tempos[$serviceId]);
                }
            }
        }
    }


    if (empty($tempos)) {
        echo '<script>alert("Sem dados a apresentar");window.history.go(-1);</script>'; 
        die();
        exit;

    }

    foreach($tempos AS $idService => $times)
    {
        foreach($times AS $date => $timeType)
        {
            if(!isset($newTempos[$date]))
            {
                $newTempos[$date] = array();
            }
            $newTempos[$date][$idService] = $timeType['atendimento'];
            $newTemposMax[$date][$idService] = $timeType['atendimentoMax'];
        }

        if(!in_array($idService, $headerArray))
        {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60*60;
    $incDates["day"] = 24*(60*60); //86400;
    $incDates["month"] = 30*(24*60*60); //2592000;
    $incDates["year"] = 12*(30*(24*60*60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]])
    {
        if(!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)]))
        {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $newTemposMax[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if($countTest == count($newTempos))
    {
        $newTempos = array();
        $newTemposMax = array();
    }

    ksort($newTempos);
    ksort($newTemposMax);
    debug(print_r($newTempos, true));


    // download in CSV??
    if($outputFormat == 'downloadCSV' AND count($headerArray) > 0)
    {

        $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";
        //$res = $dbConn->executarSQL($sql)->GetRows();
        $res = $dbConn->getRows($sql);

        $headerNames = array();
        $headerStack = array();
        foreach($res AS $row)
        {
            $headerNames[$row['id_servico']] = $row['nome'];
        }

        $header = "date";
        $headerStack['Data'] = 'date';
        foreach($headerArray AS $idService)
        {
            if(isset($headerNames[$idService]))
            {
                $header .= ";$headerNames[$idService]";
                $headerStack[$headerNames[$idService]] = 'integer';
            }else
            {
                $header .= ";service_$idService";
                $headerStack['service_'.$idService] = 'integer';
            }
        }
        $header .= "\n";

        $out = $header . $out;
        $writer->writeSheetHeader('Avg', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
        $writer->writeSheetHeader('Max', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
    }
    $format = array('font'=>'Calibri','font-size'=>12);
    foreach($newTempos AS $date => $services)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idService)
        {
            $out .= ";";
            if(isset($services[$idService]))
            {
                $out .= "$services[$idService]";
                array_push($rowStack,$services[$idService]);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Avg', $rowStack, $format);
    }

    foreach($newTemposMax AS $date => $services)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idService)
        {
            $out .= ";";
            if(isset($services[$idService]))
            {
                $out .= "$services[$idService]";
                array_push($rowStack,$services[$idService]);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Max', $rowStack, $format);
    }

    return $out . " ";
}

function statistics_servicesTicketsNumber($writer, $sheetName,$dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $out = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $storeFilter = false;
    $storeId = '';
    if(isset($extra['idLoja']))
    {
        // exists stores to hide
        $storeFilter = true;
        $storeId = $extra['idLoja'];
        $senhas = $obj->getDataDummyFunction6($groupBy, $startDate, $endDate, $stats);
    }else
    {
        $senhas = $obj->getDataDummyFunction5($groupBy, $startDate, $endDate, $stats);
    }

    ksort($senhas);

    // switch dimensions
    $newSenhas = array();
    $newSenhasQuit = array();
    $headerArray = array();
    $arrayNullValues = array();
    if($storeFilter)
    {
        if(!isset($senhas[$storeId]))
        {
            $senhas = array();
        }else
        {
            $senhas = $senhas[$storeId];

            // keep only the services associated with the store
            $sql =	"SELECT s.id_servico, s.nome FROM servicos AS s INNER JOIN lojas_entidades AS le ON le.id_entidade = s.id_entidade WHERE le.id_loja IN ($storeId) ";
            //$res = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            $storeServices = array();
            foreach($res AS $row)
            {
                $storeServices[] = $row['id_servico'];
            }

            foreach($senhas AS $serviceId => $values)
            {
                if(!in_array($serviceId, $storeServices))
                {
                    unset($senhas[$serviceId]);
                }
            }
        }
    }
    foreach($senhas AS $idService => $tickets)
    {
        foreach($tickets AS $date => $ticketType)
        {
            if(!isset($newTempos[$date]))
            {
                $newTempos[$date] = array();
                $newSenhasQuit[$date] = array();
            }
            $newSenhas[$date][$idService] = $ticketType['atendidas'];
            $newSenhasQuit[$date][$idService] = $ticketType['desistidas'];
        }

        if(!in_array($idService, $headerArray))
        {
            $headerArray[] = $idService;
            $arrayNullValues[$idService] = 0;
        }
    }


    if (empty($senhas)) {
        echo '<script>alert("Sem dados a apresentar");window.history.go(-1);</script>'; 
        die();
        exit;

    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60*60;
    $incDates["day"] = 24*(60*60); //86400;
    $incDates["month"] = 30*(24*60*60); //2592000;
    $incDates["year"] = 12*(30*(24*60*60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]])
    {
        if(!isset($newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)]))
        {
            $newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $newSenhasQuit[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if($countTest == count($newSenhas))
    {
        $newSenhas = array();
        $newSenhasQuit = array();
    }

    ksort($newSenhas);
    ksort($newSenhasQuit);

 
    // download in CSV??
    if($outputFormat == 'downloadCSV' AND count($headerArray) > 0)
    {

        $sql = "SELECT id_servico, nome FROM servicos WHERE id_servico IN (" . implode(',', $headerArray) . ")";
        //$res = $dbConn->executarSQL($sql)->GetRows();
        $res = $dbConn->getRows($sql);

        $headerNames = array();
        $headerStack = array();
        foreach($res AS $row)
        {
            $headerNames[$row['id_servico']] = $row['nome'];
        }

        $header = "date";
        $headerStack['Data'] = 'date';
        foreach($headerArray AS $idService)
        {
            if(isset($headerNames[$idService]))
            {
                $header .= ";$headerNames[$idService]";
                $headerStack[$headerNames[$idService]] = 'integer';
            }else
            {
                $header .= ";service_$idService";
                $headerStack['service_'.$idService] = 'integer';
            }
        }
        $header .= "\n";

        $out = $header . $out;
        $writer->writeSheetHeader('Attended', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
        $writer->writeSheetHeader('Quitted', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
    }
    $format = array('font'=>'Calibri','font-size'=>12);
    foreach($newSenhas AS $date => $services)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idService)
        {
            $out .= ";";
            if(isset($services[$idService]))
            {
                $out .= "$services[$idService]";
                array_push($rowStack,$services[$idService]);
            } else {
                array_push($rowStack,0);
            }

        }
        $out .= "\n";
        $writer->writeSheetRow('Attended', $rowStack, $format);
    }

    foreach($newSenhasQuit AS $date => $services)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idService)
        {
            $out .= ";";
            if(isset($services[$idService]))
            {
                $out .= "$services[$idService]";
                array_push($rowStack,$services[$idService]);
            } else {
                array_push($rowStack,0);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Quitted', $rowStack, $format);
    }

    return $out . " ";
}

function statistics_employesAvgMaxAttendanceTime($writer, $sheetName, $dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $out = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $serviceFilter = false;
    $serviceId = '';
    if(isset($extra['idServico']))
    {
        // exists services to hide
        $serviceFilter = true;
        $serviceId = $extra['idServico'];
        $tempos = $obj->getDataDummyFunction8($groupBy, $startDate, $endDate, $stats);
    }else
    {
        $tempos = $obj->getDataDummyFunction7($groupBy, $startDate, $endDate, $stats);
    }

    ksort($tempos);

    // switch dimensions
    $newTempos = array();
    $newTemposMax = array();
    $headerArray = array();
    $arrayNullValues = array();
    if($serviceFilter)
    {
        if(!isset($tempos[$serviceId]))
        {
            $tempos = array();
        }else
        {
            $tempos = $tempos[$serviceId];

            $sql =	"SELECT id_empregado, nome FROM empregados ";
            if($stats['employes']['values'] != '')
            {
                $sql .= "WHERE id_empregado IN (" . $stats['employes']['values'] . ") ";
            }
            //$rows = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            foreach($rows AS $row)
            {
                if(!isset($tempos[$row['id_empregado']]))
                {
                    $tempos[$row['id_empregado']] = array();
                }
            }

            ksort($tempos);
        }
    }
    foreach($tempos AS $idEmploye => $times)
    {
        foreach($times AS $date => $timeType)
        {
            if(!isset($newTempos[$date]))
            {
                $newTempos[$date] = array();
                $newTemposMAx[$date] = array();
            }
            $newTempos[$date][$idEmploye] = $timeType['atendimento'];
            $newTemposMax[$date][$idEmploye] = $timeType['atendimentoMax'];
        }

        if(!in_array($idEmploye, $headerArray))
        {
            $headerArray[] = $idEmploye;
            $arrayNullValues[$idEmploye] = 0;
        }
    }

    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60*60;
    $incDates["day"] = 24*(60*60); //86400;
    $incDates["month"] = 30*(24*60*60); //2592000;
    $incDates["year"] = 12*(30*(24*60*60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]])
    {
        if(!isset($newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)]))
        {
            $newTempos[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $newTemposMax[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        } 
    }

    if($countTest == count($newTempos))
    {
        $newTempos = array();
        $newTemposMax = array();
    }

    ksort($newTempos);
    ksort($newTemposMax);


    // download in CSV??
    if($outputFormat == 'downloadCSV' AND count($headerArray) > 0)
    {

        $sql = "SELECT id_empregado, nome FROM empregados WHERE id_empregado IN (" . implode(',', $headerArray) . ")";
        //$res = $dbConn->executarSQL($sql)->GetRows();
        $res = $dbConn->getRows($sql);

        $headerNames = array();
        $headerStack = array();
        foreach($res AS $row)
        {
            $headerNames[$row['id_empregado']] = $row['nome'];
        }

        $header = "date";
        $headerStack['Data'] = 'date';
        foreach($headerArray AS $idEmploye)
        {
            if(isset($headerNames[$idEmploye]))
            {
                $header .= ";$headerNames[$idEmploye]";
                $headerStack[$headerNames[$idEmploye]] = 'integer';
            }else
            {
                $header .= ";employe_$idEmploye";
                $headerStack['employe_'.$idEmploye] = 'integer';
            }
        }
        $header .= "\n";

        $out = $header . $out;

        $writer->writeSheetHeader('Avg', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
        $writer->writeSheetHeader('Max', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
    }

    $format = array('font'=>'Calibri','font-size'=>12);
    foreach($newTempos AS $date => $employes)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idEmploye)
        {
            $out .= ";";
            if(isset($employes[$idEmploye]))
            {
                $out .= "$employes[$idEmploye]";
                array_push($rowStack,$employes[$idEmploye]);
            } else {
                array_push($rowStack,0);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Avg', $rowStack, $format);
    }

    foreach($newTemposMax AS $date => $employes)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idEmploye)
        {
            $out .= ";";
            if(isset($employes[$idEmploye]))
            {
                $out .= "$employes[$idEmploye]";
                array_push($rowStack,$employes[$idEmploye]);
            } else {
                array_push($rowStack,0);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Max', $rowStack, $format);
    }

    return $out . " ";
}

function statistics_employesTicketsNumber($writer, $sheetName, $dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
    $out = "";
    $ssid = $extra['ssid'];
    $stats = $_SESSION['statistics'][$ssid];

    $groupBy = $stats['dates']['frequency'];
    $startDate = $stats['dates']['from'];
    $endDate = $stats['dates']['to'];

    $obj = new Estatisticas();

    $serviceFilter = false;
    $serviceId = '';
    if(isset($extra['idServico']))
    {
        // exists stores to hide
        $serviceFilter = true;
        $serviceId = $extra['idServico'];
        $senhas = $obj->getDataDummyFunction10($groupBy, $startDate, $endDate, $stats);
    }else
    {
        $senhas = $obj->getDataDummyFunction9($groupBy, $startDate, $endDate, $stats);
    }

    ksort($senhas);

    // switch dimensions
    $newSenhas = array();
    $newSenhasQuit = array();
    $headerArray = array();
    $arrayNullValues = array();
    if($serviceFilter)
    {
        if(!isset($senhas[$serviceId]))
        {
            $senhas = array();
        }else
        {
            $senhas = $senhas[$serviceId];

            $sql =	"SELECT id_empregado, nome FROM empregados ";
            if($stats['employes']['values'] != '')
            {
                $sql .= "WHERE id_empregado IN (" . $stats['employes']['values'] . ") ";
            }
            //$rows = $dbConn->executarSQL($sql)->GetRows();
            $res = $dbConn->getRows($sql);
            foreach($rows AS $row)
            {
                if(!isset($senhas[$row['id_empregado']]))
                {
                    $senhas[$row['id_empregado']] = array();
                }
            }

            ksort($senhas);
        }
    }

    foreach($senhas AS $idService => $tickets)
    {
        if(is_numeric($idService)) {
            foreach($tickets AS $date => $ticketType)
            {
                if(!isset($newTempos[$date]))
                {
                    $newTempos[$date] = array();
                }
                $newSenhas[$date][$idService] = $ticketType['atendidas'];
                $newSenhasQuit[$date][$idService] = $ticketType['desistidas'];
            }

            if(!in_array($idService, $headerArray))
            {
                $headerArray[] = $idService;
                $arrayNullValues[$idService] = 0;
            }
        }
    }
    ksort($arrayNullValues);

    $incDates = array();
    $incDates["hour"] = 60*60;
    $incDates["day"] = 24*(60*60); //86400;
    $incDates["month"] = 30*(24*60*60); //2592000;
    $incDates["year"] = 12*(30*(24*60*60)); //31104000;

    $formatDates = array();
    $formatDates["hour"] = "Y-m-d";
    $formatDates["day"] = "Y-m-d";
    $formatDates["month"] = "Y-m";
    $formatDates["year"] = "Y";

    // fill up blank dates
    $startTime = strtotime($startDate);
    $endTime = strtotime($endDate);
    $countTest = 0;
    for($tmpTime = $startTime; $tmpTime <= $endTime; $tmpTime += $incDates[$stats["dates"]["frequency"]])
    {
        if(!isset($newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)]))
        {
            $newSenhas[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $newSenhasQuit[date($formatDates[$stats["dates"]["frequency"]], $tmpTime)] = $arrayNullValues;
            $countTest++;
        }
    }

    if($countTest == count($newSenhas))
    {
        $newSenhas = array();
        $newSenhasQuit = array();
    }

    ksort($newSenhas);
    ksort($newSenhasQuit);

    // download in CSV??
    if($outputFormat == 'downloadCSV' AND count($headerArray) > 0)
    {

        $sql = "SELECT id_empregado, nome FROM empregados WHERE id_empregado IN (" . implode(',',  array_filter($headerArray)) . ")";
        $res = $dbConn->getRows($sql);

        $headerNames = array();
        $headerStack = array();
        $headerStack['Data'] = 'date';
        foreach($res AS $row)
        {
            $headerNames[$row['id_empregado']] = $row['nome'];
            $headerStack[$row['nome']] = 'integer';
        }

        $header = "date";

        
        /*foreach($headerArray AS $idEmploye)
        {
            if(isset($headerNames[$idEmploye]))
            {
                $header .= ";$headerNames[$idEmploye]";
                $headerStack[$headerNames[$idEmploye]] = 'integer';
            }else
            {
                $header .= ";employe_$idEmploye";
                $headerStack['employe_'.$idEmploye] = 'integer';
            }
        }*/

        
        $header .= "\n";
        $out = $header . $out;
         $writer->writeSheetHeader('Attended', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
         $writer->writeSheetHeader('Quitted', $headerStack, $col_options = ['freeze_rows'=>1, 'color'=>'#000000','fill'=>'#d9d9d9','font'=>'Calibri','font-size'=>12,'font-style'=>'bold','height'=>10.5, 'widths'=>[15,20,20,20,15,15,15,15,15,20,20,15]] );
    }

    $format = array('font'=>'Calibri','font-size'=>12);
    foreach($newSenhas AS $date => $employes)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idEmploye)
        {
            $out .= ";";
            if(isset($employes[$idEmploye]))
            {
                $out .= "$employes[$idEmploye]";
                array_push($rowStack,$employes[$idEmploye]);
            } else {
                array_push($rowStack,0);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Attended', $rowStack, $format);
    }

    foreach($newSenhasQuit AS $date => $employes)
    {
        $out .= "$date";
        $rowStack = array($date);
        foreach($headerArray AS $idEmploye)
        {
            $out .= ";";
            if(isset($employes[$idEmploye]))
            {
                $out .= "$employes[$idEmploye]";
                array_push($rowStack,$employes[$idEmploye]);
            } else {
                array_push($rowStack,0);
            }
        }
        $out .= "\n";
        $writer->writeSheetRow('Quitted', $rowStack, $format);
    }

    return $out . " ";
}

function volumeTransaccoes($dbConn, $date, $dataPeriod, $outputFormat, $extra=array())
{
	$data = array();

	$where = " AND appointment_date>=STR_TO_DATE('$date','%Y-%m-%d') ";
	if(isset($extra['date2']))
		$where .= " AND appointment_date<DATE_ADD('$extra[date2]', INTERVAL 1 DAY) ";

	if($extra['dispensador']=='')
	{
		$d = new Dispensador;
		$dispensadores = $d->GetDispensadores();
		$extra['dispensador']=array();

		foreach($dispensadores as $dispensador)
			$extra['dispensador'][]=$dispensador['id_dispensador'];
		$extra['dispensador']=implode(',',$extra['dispensador']);
		if($extra['dispensador']=='')
			$extra['dispensador']=0;

		unset($dispensadores);
		unset($d);
	}

    if(isset($extra['dispensador']) AND $extra['dispensador'] != '')
    {
        $where .= " AND financial_transaction IN (SELECT id FROM transaction_financial WHERE transaction_id IN (SELECT transaction_id FROM transactions WHERE id_dispensador IN ($extra[dispensador]))) ";
    }

    if(isset($extra['local']) AND $extra['local'] != '')
    {
        $where .= " AND financial_transaction IN (SELECT id FROM transaction_financial WHERE transaction_id IN (SELECT transaction_id FROM transactions WHERE id_dispensador IN ( SELECT id_dispensador FROM dispensador WHERE id_loja IN ($extra[local])))) ";
    }

	$sql = "SELECT DATE(appointment_date) data, COUNT(*) pago FROM transaction_appointment t WHERE type='PAID'".
		" $where GROUP BY DATE(appointment_date)";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

	foreach($res AS $row)
	{
		$data[$row["data"]]["pago"] = $row["pago"];
	}

	$sql = "SELECT DATE(appointment_date) data, COUNT(*) naopago FROM transaction_appointment t WHERE type='UNPAID'".
		" $where GROUP BY DATE(appointment_date)";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

	foreach($res AS $row)
	{
		$data[$row["data"]]["naopago"] = $row["naopago"];
	}

	$sql = "SELECT DATE(appointment_date) data, SUM(total_value) volume FROM transaction_appointment t WHERE type='PAID'".
		" $where GROUP BY DATE(appointment_date)";
    //$res = $dbConn->executarSQL($sql)->GetRows();
    $res = $dbConn->getRows($sql);

	foreach($res AS $row)
	{
		$data[$row["data"]]["volume"] = $row["volume"];
	}

	//print_r($data);

    $out = "";
    // download in CSV??
    if($outputFormat == 'downloadCSV')
    {
		//$out = "data;pago;nao-pago;volume\n";
        $out = translate('word_excel_out_volume_transaccoes') . "\n";
    }

    foreach($data AS $date => $row)
    {
		$out .= "$date;$row[pago];$row[naopago];$row[volume]\n";
    }

    return $out . " ";
}

?>