<?php

/* Classe de Gest�ão de Serviços */

class Servico extends AcessoBD
{
    var $bd;

    /*
		Construtor da classe

		0 = Erro da BD
    */
    function Servico()
    {
        global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
        $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
    }

    /*
		Funçã��o de Inserção

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Inserir($dados)
    {
        // verifica se os campos opcionais foram preenchidos
        if ($dados["limite_clientes"] == "" || $dados["limite_clientes"] == "0")
        {
            $dados["limite_clientes"] = "null";
        }
        if ( $dados["identificador"] == "" )
        {
            $dados["identificador"] = "null";
        } else
        {
            $dados["identificador"] = "'" . $dados["identificador"] . "'";
        }

        if ($dados["id_externo"] == "")
            $dados["id_externo"] = "NULL";
        else
            $dados["id_externo"] = "'".trim($dados["id_externo"])."'";

        if ($dados["nome_tipo_destino"] == "")
            $dados["nome_tipo_destino"] = "NULL";
        else
            $dados["nome_tipo_destino"] = "'".trim($dados["nome_tipo_destino"])."'";

        if ( $dados["ordem"] == "" )
            $dados["ordem"] = "null";

	if ( array_key_exists('tipo_agendamento', $dados) && $dados['tipo_agendamento'] )
		$dados['tipo_servico'] = "agendamentos";
	else
		$dados['tipo_servico'] = "normal";

	if($dados['previsao_atendimento'] == '00:00:00' || $dados['previsao_atendimento'] == ''){
		$dados['previsao_atendimento'] = "NULL";
	} else {
		$dados['previsao_atendimento'] = "'$dados[previsao_atendimento]'";
	}


        // efectua a inserção
        $sql = "INSERT INTO servicos (
			nome,
			identificador,
			nome_tipo_destino,
			id_externo,
			limite_clientes,
			ordem,
			nome_ecra_dispensador,
			horario,
			id_entidade,
			prioridade,
			suspensivel,
			reencaminhavel,
			reencaminha_sempre,
			id_form,
			informacao_adicional,
			tipo_servico,
			previsao_atendimento)
			VALUES ('"
                . $dados["nome"] . "',"
                . trim($dados["identificador"]) . ","
                . $dados["nome_tipo_destino"] .","
                . $dados["id_externo"] .","
                . $dados["limite_clientes"].","
                . $dados["ordem"].",'"
                . ($dados["nome_ecra_dispensador"])."',"
                . $dados["horario"]. ","
                . $dados["entidades_trabalho"].","
                . $dados["prioridade"].","
                . (array_key_exists('suspensivel', $dados) && $dados["suspensivel"]?1:0) .","
                . (array_key_exists('reencaminhavel', $dados) && $dados["reencaminhavel"]?1:0) .","
                . (array_key_exists('reencaminha_sempre', $dados) && $dados["reencaminha_sempre"]?1:0) .","
                . (array_key_exists('form', $dados) && $dados["form"]?$dados["form"]:"null") .",'"
		. $dados["informacao_adicional"]."','"
		. $dados["tipo_servico"]."',"
		. $dados["previsao_atendimento"].");";

        if($rs = $this->bd->executarSQL($sql))
        {
            $sql = "SELECT MAX(id_servico) as max FROM servicos ";
            $res = $this->bd->getRows($sql);
            $id = $res[0]["max"];

            $this->SetRedirectionServiceList($id, $dados["servicos_redireccao"]);

            $this->EscreveXMLSync($id, "inserir");

            ///* id_hist */
            $sql = "insert into id_hist (id, name, type) values (
                    ".$id.",
                    '".$dados["nome"]."',
                    'servico')";
            if(!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }

            $objecto = new LogAccao();
            $rs = $objecto->Inserir("Inserção", "Serviço", $dados["nome"]);
            $objecto->fechar();
            return "ok";
        } else
        {
            return 0;
        }
    }

    /*
		Fun��o de leitura de dados

		0 = Erro da BD
		true = Sucesso
    */
    function LerDados($id)
    {
        $sql = "SELECT * FROM servicos WHERE id_servico = " . $id . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
        $_SESSION["sessao_campos"]["servicos_redireccao"] = $this->GetRedirectionServiceList($id);

        return "ok";
    }

    /*
		Fun��o de Edição

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso
    */
    function Editar($dados, $id)
    {
        // verifica se os campos opcionais estão preenchidos

		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array("nome"=>"Nome","identificador" => "Identificador", "horario" => "Horario","prioridade"=>"Prioridade","nome_ecra_dispensador"=>"Nome Ecra");

        if ($dados["limite_clientes"] == "" || $dados["limite_clientes"] == "0")
        {
            $dados["limite_clientes"] = "NULL";
        }

        if ( $dados["identificador"] == "" )
        {
            $dados["identificador"] = "null";
        } else
        {
            $dados["identificador"] = "'" . $dados["identificador"] . "'";
        }

        if ($dados["nome_tipo_destino"] == "")
            $dados["nome_tipo_destino"] = "NULL";
        else
            $dados["nome_tipo_destino"] = "'".trim($dados["nome_tipo_destino"])."'";

        if ($dados["id_externo"] == "")
            $dados["id_externo"] = "NULL";
        else
            $dados["id_externo"] = "'".trim($dados["id_externo"])."'";

        if ( $dados["ordem"] == "" )
            $dados["ordem"] = "null";

	if (array_key_exists('tipo_agendamento', $dados) && $dados['tipo_agendamento'] )
		$dados['tipo_servico'] = "agendamentos";
	else
		$dados['tipo_servico'] = "normal";

	if($dados['previsao_atendimento'] == '00:00:00' || $dados['previsao_atendimento'] == ''){
		$dados['previsao_atendimento'] = "NULL";
	} else {
		$dados['previsao_atendimento'] = "'$dados[previsao_atendimento]'";
	}


        $sql = "UPDATE servicos SET
			nome = '" . $dados["nome"] . "',
			identificador = " . trim($dados["identificador"]) . ",
			nome_tipo_destino = " . trim($dados["nome_tipo_destino"]) . ",
			id_externo = " . $dados["id_externo"]. ",
			limite_clientes = ". $dados["limite_clientes"] .",
			ordem = ".$dados["ordem"].",
			nome_ecra_dispensador = '".($dados["nome_ecra_dispensador"])."',
			horario = ".$dados["horario"].",
			id_entidade = ".$dados["entidades_trabalho"].",
			prioridade = ".$dados["prioridade"].",
			suspensivel = " . (array_key_exists('suspensivel', $dados) && $dados["suspensivel"]?1:0) . ",
			reencaminhavel = " . (array_key_exists('reencaminhavel', $dados) && $dados["reencaminhavel"]?1:0) . ",
			reencaminha_sempre = " . (array_key_exists('reencaminha_sempre', $dados) && $dados["reencaminha_sempre"]?1:0) . ",
			id_form = " . ($dados["form"]?$dados["form"]:"null") . ",
			informacao_adicional = '" . $dados["informacao_adicional"] . "',
			tipo_servico = '" . $dados["tipo_servico"] . "',
			previsao_atendimento = " . $dados["previsao_atendimento"] . "
		WHERE id_servico = " . $id . " ;";

        if($rs = $this->bd->executarSQL($sql))
        {
            // id_hist
            $sql = "update id_hist
                set name='".$dados["nome"]."'
                where id=".$id."
                and type='servico'";
            if (!$rs = $this->bd->executarSQL($sql))
            {
                return 0;
            }

            $this->SetRedirectionServiceList($id, $dados["servicos_redireccao"]);

            $this->EscreveXMLSync($id, "editar");

			/********
			*  Alteracoes na escrita do log de accao, acrescentando informacao
			*********/
            $objecto = new LogAccao();
            unset($oldInfo['sms_senhas']);
			$diff = my_array_diff_values($oldInfo,$newInfo,$labels);
			$msg = "<table><tr><td colspan=3  align=left><b>$newInfo[nome]</b></td></tr>";
			$msg .= action_msg_info($diff,false,'servicos');
			$msg .= "</table>";
			$rs = $objecto->Inserir("Edição", "Serviço", $msg);
            $objecto->fechar();
            return "ok";
        } else
        {
            return 0;
        }

    }

    /*
		Fun��o de Remoção

		0 = Erro da BD
		true = Sucesso
    */
    function Remover($id)
    {
        /*
        servicos
        servicos_balcao
        servicos_dispensador
        servicos_ecra
        servicos_prestados
        */

        $sql = "delete from servicos_ecra where id_servico='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_servico='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from servicos_dispensador where id_servico='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_servico='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from servicos_balcao where id_servico='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_servico='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $sql = "delete from servicos where id_servico='" . $id[0] . "'";
        for ($i=1; $i<count($id); $i++)
            $sql .= " or id_servico='" . $id[$i] . "'";
        if (!$rs = $this->bd->executarSQL($sql)) return 0;

        $this->EscreveXMLSync($id, "remover");

        $numEntradas = count($id);
        $nomes = array();
        $sql = "SELECT nome FROM servicos WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_servico = " . $id[$i] . " OR ";
        $sql .= "id_servico = " . $id[0] . ";";


        if($rs = $this->bd->executarSQL($sql))
        {
            while ($row = $this->bd->obterRegisto($rs)) array_push($nomes, $row["nome"]);

            //for($i = 0; $i < $numEntradas; $i++)
            //{
            //    $this->bd->moverRegisto($rs,$i);
            //    array_push($nomes, $this->bd->obterValor($rs,"nome"));
            //}
        }
        else
            return 0;

        $objecto = new LogAccao();
        for($i = count($nomes)-1; $i >= 0; $i--)
        {
            $rs = $objecto->Inserir("Remoção", "Serviço", $nomes[$i]);
        }
        $objecto->fechar();
        return "ok";

        //~ $sql = "DELETE FROM servicos WHERE ";
        //~ for($i = count($id); $i > 1; $i--)
        //~ $sql .= "id_servico = ". $id[$i-1] . " OR ";
        //~ $sql .= "id_servico = ". $id[0] . ";";

        //~ if($rs = $this->bd->executarSQL($sql))
        //~ {
        //~ $objecto = new LogAccao();
        //~ for($i = count($nomes)-1; $i >= 0; $i--){
        //~ $rs = $objecto->Inserir("Remoção", "Serviço", $nomes[$i]);
        //~ }
        //~ $objecto->fechar();
        //~ return "ok";
        //~ }
        //~ else
        //~ return 0;
    }

    /*
		Procede � cria��o e escrita de um
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
    */

    function EscreveXMLSync($id, $accao, $enderecos_lojas=null)
    {

        if(!is_array($id))
            $id = array($id);

        $numEntradas = count($id);

        $sql = "SELECT * FROM servicos WHERE ";
        for($i = $numEntradas-1; $i > 0; $i--)
            $sql .= "id_servico = " . $id[$i] . " OR ";
        $sql .= "id_servico = " . $id[0] . ";";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $documento = abreXMLSync();
        $raiz = $documento->firstChild;

        if(is_null($enderecos_lojas))
        {
            $loja = new Loja();
            $enderecos = $loja->listaIpLojas();
            //$loja->Fechar();
        } else
        {
            $enderecos = $enderecos_lojas;
        }

        if(count($enderecos) > 0)
        {
            $destinos = $documento->createElement("destinos");
            $raiz->appendChild($destinos);
        }

        for($i = 0 ; $i < count($enderecos) ; $i++)
        {
            $loja = $documento->createElement("loja");
            $loja->nodeValue = $enderecos[$i];
            $destinos->appendChild($loja);
        }

        $numEntradas = $this->bd->obterNumRegistos($rs);

        $servicos = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($servicos, $row);

        for($i = 0 ; $i < $numEntradas ; $i++)
        {
            //$this->bd->moverRegisto($rs, $i);

            $no_servico = $documento->createElement("servico");
            $raiz->appendChild($no_servico);

            $no_servico->setAttribute("id", $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs, "id_servico")*/);
            $no_servico->setAttribute("accao", $accao);

            $elemento = $documento->createElement("nome");
            $elemento->nodeValue = $servicos[$i]["nome"] /*$this->bd->obterValor($rs, "nome")*/;
            $no_servico->appendChild($elemento);

            $valor = $servicos[$i]["limite_clientes"] /*$this->bd->obterValor($rs, "limite_clientes")*/;
            if(isset($valor))
            {
                $elemento = $documento->createElement("limiteClientes");
                $elemento->nodeValue = $valor;
                $no_servico->appendChild($elemento);
            }
        }

        fechaXMLsync($documento);

    }

    /*
		Fun��o de listagem

		0 = Erro da BD
		true = Sucesso
    */

    function Listar()
    {
        if (is_array($_SESSION["entidade"]) && count($_SESSION["entidade"]))
        {
            $variaveis = new Variaveis();
            $max = $variaveis->GetVariavel('factor_prioridade_maxima');
            $high = $variaveis->GetVariavel('factor_prioridade_alta');
            $med = $variaveis->GetVariavel('factor_prioridade_media');
            $low = $variaveis->GetVariavel('factor_prioridade_baixa');
            $min = $variaveis->GetVariavel('factor_prioridade_minima');
            unset($variaveis);

            $sql = "SELECT s.id_servico, s.nome AS servico, s.identificador, s.prioridade, s.ordem,s.limite_clientes, s.nome_ecra_dispensador, e.nome AS entidade
				FROM servicos s 
                                inner join entidades e on (s.id_entidade = e.id_entidade and e.id_entidade in (".implode(",", $_SESSION["entidade"])."))
                                where id_servico > 0 ";

            if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
                $sql .= "ORDER BY s." . $_REQUEST["campo"] . " ";
            else
                $sql .= "ORDER BY s.nome ";

            if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
                $sql .= "DESC";
            else
                $sql .= "ASC";

            global $ERROS, $N_REGISTOS;
            if(!$rs = $this->bd->executarSQL($sql))
            {
                echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
                return;
            }

            $servicos = array();
            while ($row = $this->bd->obterRegisto($rs)) array_push($servicos, $row);

            $n = 1;
            $pagina = 1;
            if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			    $pagina = $_REQUEST['pagina'];
            $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
            $numPaginas = 1; // n�mero de p�ginas de registos
            $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

            // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
            if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] != '' && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
                $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', true) . " ".translate('word_servicos_registados_sitema', true) ."</div>";
            return;
        }

            // calculo do n�mero de p�ginas de registos
            if($numTuplos % $numRegPag == 0)
                $numPaginas = $numTuplos / $numRegPag;
            else
                $numPaginas = (int) ($numTuplos / $numRegPag + 1);

            echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=servicos&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "")  . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "")  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";

            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
                <tr>
    								<td class='button_page' colspan='6'>";

                    if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
                    {
                        $pagAnterior = $_REQUEST["pagina"] - 1;
                        $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                    }
                    else
                    {
                        $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
                        $TEMPLATE_navigation .= "<div> < </div>";
                    }

                    while($n <= $numPaginas)
                    {
                        if($n == $_REQUEST["pagina"])
                            $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                        else
                            $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
                        $n++;
                    }

                    $n = ($pagina - 1)*$numRegPag;
                    $incremento = $n;

                    if($pagina < $numPaginas)
                    {
                        $pagPosterior = $_REQUEST["pagina"] + 1;
                        $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div> > </div></a> ";
                    }
                    else
                    {
                        if($numTuplos % $numRegPag != 0)
                            $numRegPag = $numTuplos % $numRegPag;
                        $TEMPLATE_navigation .= "<div> > </div>";
                    }

            $TEMPLATE_navigation .= "		</td>
    				</tr>";

            echo "<tr class='column_row'>";

            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
                echo "<td width='8' style='padding-left:8px'>" .  translate('word_select') . "</td>";
            }

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"identificador") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=1'><div>".  translate('word_identificador', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"id_entidade") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=0'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=1'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=0'><div>" .translate('word_entity', true). "</div></a></td>";


            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome_ecra_dispensador") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=0'><div>"  .  translate('word_nome_ecra_dispensador')  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=1'><div>"  .  translate('word_nome_ecra_dispensador')  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=0'><div>"  .  translate('word_nome_ecra_dispensador')  . "</div></a></td>";


            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"ordem") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=ordem&ordem=0'><div>" .  translate('word_ordem', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=ordem&ordem=1'><div>" .  translate('word_ordem', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=ordem&ordem=0'><div>" .  translate('word_ordem', true)  . "</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"prioridade") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=0'><div>" .  translate('word_priority', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=1'><div>" .  translate('word_priority', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=0'><div>" .  translate('word_priority', true)  . "</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"limite_clientes") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=0'><div>" .  translate('word_limiar_clientes', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=1'><div>" .  translate('word_limiar_clientes', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=0'><div>" .  translate('word_limiar_clientes', true)  . "</div></a></td>";



            echo "<td width='155'>". translate('word_operations', true)."</td>
				</tr>";



            //while($n < ($numRegPag + $incremento))
            //{
            //    $this->bd->moverRegisto($rs,$n);
            for ($i=$n; $i<$numRegPag + $incremento; $i++)
            {

                echo"<tr class='form-data-tr'>";
                if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                {
                    echo "<td class='form-data-td'>
                            <label class='custom-check-container'>
                                <input name='grupo' type='checkbox' value='" .  $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "' onClick='selectEntireRow(this)'>
                                <span class='custom-checkmark'></span>
                            </label>
                    </td>";
                }

                $prioridade = $servicos[$i]["prioridade"] /*$this->bd->obterValor($rs, "prioridade")*/;
                switch ($prioridade)
                {
                    case $max:
                        $prioridade_str = "M&aacute;xima";
                        break;
                    case $high:
                        $prioridade_str = "Alta";
                        break;
                    case $med:
                        $prioridade_str = "M&eacute;dia";
                        break;
                    case $low:
                        $prioridade_str = "Baixa";
                        break;
                    case $min:
                        $prioridade_str = "M&iacute;nima";
                        break;
                    default:
                        break;
                }

                echo	" <td class='form-data-td'>" . $servicos[$i]["servico"] /*$this->bd->obterValor($rs, "servico") */ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["identificador"] /*$this->bd->obterValor($rs, "identificador") */ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["entidade"] /*$this->bd->obterValor($rs, "entidade")*/ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["nome_ecra_dispensador"] /*($this->bd->obterValor($rs, "nome_ecra_dispensador"))*/ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["ordem"] /*$this->bd->obterValor($rs, "ordem") */ . "</td>
              					<td class='form-data-td'>" . $prioridade_str . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["limite_clientes"] /*$this->bd->obterValor($rs, "limite_clientes")*/ . "</td>
              					<td class='form-data-td'>";
                if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_servicos"] == 2 )
                {
                    echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=servicos&id=" . $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>";

                    if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                    {
                        echo "<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=servicos&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "&id=" . $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
                    }
                }
                else
                {
                    echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=servicos&id=" . $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
                }
                echo	"</td>
				</tr>";

                //$n++;
            }

            //#3 - Re-design present NAVIGATION after table
            echo $TEMPLATE_navigation;

            echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
                echo	"<tr>
					<td class='button'>";
            if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_servicos"] == 2) {
              echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
            }
						echo "<div class='button-thin-green' onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
						<div class='button-thin-green' onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
						<div class='button-thin-green' onClick='removerMarcados(this);'>". translate('word_remove_selected', true)."</div>
						<a href='../horarios/'><div class='button-thin-green'>" .  translate('word_create', true)  . "  ". translate("word_horario", true) ."</div></a>
					</td>

				</tr>";
            }

            echo	"</table>
		</form>";
        }
        else
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem') . " ".translate('word_services') ." ".translate('word_registados_sistema') ."</div>";
                return;
        }
    }

    /*funçao que devolve os dados dos servicos ligado a entidade*/
    function obterDados($id = 0)
    {
        $sql = "SELECT s.nome AS nome ,s.id_servico AS id_servico, e.id_entidade AS id_entidade, e.nome AS entidade
					FROM servicos s , entidades e WHERE s.id_entidade = e.id_entidade";
        if($id!=0)
            $sql .= " AND s.id_entidade = ".$id;
        $sql .= " ORDER BY s.id_entidade, s.nome";
               

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
            
        $num_entidade = $this->bd->obterNumRegistos($rs);

        $servicos = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($servicos, $row);


        $dados = array();
        //for($i=0; $i < $num_entidade; $i++)
        //{
        for ($i=0; $i<$num_entidade; $i++)
        {
            //$this -> bd -> moverRegisto($rs , $i);
            $dados[$i]["id_servico"] = $servicos[$i]["id_servico"]; //$this -> bd -> obterValor($rs , "id_servico");
            $dados[$i]["nome"] = $servicos[$i]["nome"];//$this -> bd -> obterValor($rs , "nome");
            $dados[$i]["id_entidade"] = $servicos[$i]["id_entidade"]; //$this -> bd -> obterValor($rs , "id_entidade");
            $dados[$i]["entidade"] =$servicos[$i]["entidade"]; // $this -> bd -> obterValor($rs , "entidade");
        }

        return $dados;


    }

    function IdExistente($id, $ent)
    {
        $sql = "select count(*) as n from servicos where identificador='" . trim($id) . "' and id_entidade='" . $ent . "'";
        if(!$rs = $this->bd->executarSQL($sql))
            return;
        return $this->bd->obterValor($rs, "n");
    }

    function GetServices($id="")
    {
        $sql = "select * from servicos";
        if ($id != "") $sql .= " WHERE id_servico=".$id;

        return $this->bd->getRows($sql);
    }

    function GetServicos($where="")
    {
//		$sql = "select l.id_loja, l.nome local, e.id_entidade, e.nome entidade, s.id_servico, s.nome servico
//				from lojas_entidades le
//				inner join lojas l on le.id_loja=l.id_loja
//				inner join entidades e on le.id_entidade=e.id_entidade
//				inner join servicos s on le.id_entidade=s.id_entidade";

        //$sql = "select s.id_servico id_servico, s.nome servico, e.nome entidade
        //from servicos s inner join entidades e on e.id_entidade=s.id_entidade";
        /* CHANGED BY NC */
        $sql = 	"select distinct s.id_servico, l.id_loja, s.nome AS servico, l.nome AS local, e.nome AS entidade, s.id_entidade id_entidade, s.nome_ecra_dispensador, s.identificador, s.nome_tipo_destino, s.id_externo, s.horario ".
                "from servicos as s ".
                "inner join entidades as e on e.id_entidade = s.id_entidade ".
                "left join lojas_entidades as le on le.id_entidade = e.id_entidade ".
                "left join lojas as l on l.id_loja = le.id_loja ";

        if (strlen($where))
        {
            $sql .= "where ".$where;
        }

        $sql .= " order by local DESC, entidade, servico";
        $res = $this->bd->executarSQL($sql);

        $servicos = array();
        while ($row = $this->bd->obterRegisto($res))
        {
            array_push($servicos, $row);
        }
        return $servicos;
    }

    /**
     * Get the list of services for what a given service is allowed to redirect
     *
     * @param $id service id
     */
    function GetRedirectionServiceList($id)
    {
        $sql = "select destination_id from servicos_redireccao where source_id=".$id;
        $res = $this->bd->executarSQL($sql);
        $servicos = array();
        while ($res && $row = $this->bd->obterRegisto($res))
        {
            array_push($servicos, $row["destination_id"]);
        }
        return $servicos;
    }

    function SetRedirectionServiceList($id, $aDest)
    {
        $sql = "delete from servicos_redireccao where source_id=".$id;
        if (!$this->bd->executarSQL($sql)) return false;

        if (count($aDest))
        {
            $aux = array();
            foreach ($aDest as $d) array_push($aux, "(".$id.",".$d.")");
            $sql = "insert into servicos_redireccao (source_id, destination_id) values ".implode(", ", $aux);
            if (!$this->bd->executarSQL($sql)) return false;
        }
        return true;
    }

    /*
		Destrutor da classe

		0 = Erro da BD
    */
    function Fechar()
    {
        $this->bd->fecharBD();
    }
}
?>
