<?php
	
/* Classe de Gesto de Servios Prestados numa entidade */

class ServicoPrestado extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function ServicoPrestado() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Funo de insero
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados, $id, $documento)
	{
		$ids = array();
		
		for($i=0 ; $i < count($dados) ; $i++){
			$sql = "INSERT INTO servicos_prestados(id_entidade, id_servico)
					VALUES (".$id.",".$dados[$i].");";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_servico_prestado) FROM servicos_prestados;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids, $this->bd->obterValor($rs, 0));
			
		}
		
//		$this->EscreveXMLSync($ids, "inserir", $documento);
		
		return "ok";
	}

	/*
		Funo de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT id_servico, nome
				FROM servicos 
				WHERE id_servico > 0;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		
		$servicos = array();
		$servicos["nome"] = array();
		$servicos["id"] = array();
			
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$servicos["nome"][$i] = $this->bd->obterValor($rs, "nome");
			$servicos["id"][$i] = $this->bd->obterValor($rs, "id_servico");
		}
		
		$_SESSION["sessao_campos"]["servicos"] = $servicos;
		
		$sql = "SELECT id_servico
				FROM servicos_prestados
				WHERE id_entidade = ".$id.";";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		$servicos_prestados = array();
		
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$servicos_prestados[$i] = $this->bd->obterValor($rs, "id_servico");
		}
		
		$_SESSION["sessao_campos"]["servicos_prestados"]= $servicos_prestados;
		
		return "ok";
	}

	/*
		Funo de edio
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id, $documento)
	{
		$sql = "SELECT id_servico FROM servicos_prestados WHERE id_entidade=".$id.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$existentes = array();
		for ($i = $this->bd->obterNumRegistos($rs)-1 ; $i >= 0 ; $i--){
			$this->bd->moverRegisto($rs, $i);
			array_push($existentes, $this->bd->obterValor($rs,"id_servico"));
		}
		
		if(!is_array($dados))
			$dados = array();
		
		$criar = array_merge(array_diff($dados, $existentes));
		$ids_servicos_prestados = array();
		
		for($i=0 ; $i < count($criar) ; $i++){
			$sql = "INSERT INTO servicos_prestados(id_entidade, id_servico)
					VALUES (".$id.",".$criar[$i].");";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_servico_prestado) FROM servicos_prestados;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_servicos_prestados, $this->bd->obterValor($rs, 0));
			
		}
		
//		$this->EscreveXMLSync($ids_servicos_prestados, "inserir", $documento);
		
		$apagar = array_merge(array_diff($existentes, $dados));
		
		$ids_servicos_prestados = array();
		
		for($i=0 ; $i < count($apagar) ; $i++){
			$sql = "SELECT id_servico_prestado FROM servicos_prestados
					WHERE id_entidade =".$id."
					AND id_servico=".$apagar[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_servicos_prestados, $this->bd->obterValor($rs, "id_servico_prestado"));			
		}
		
	//	$this->EscreveXMLSync($ids_servicos_prestados, "remover", $documento);
		
		for($i=0 ; $i < count($ids_servicos_prestados) ; $i++){
			$sql = "DELETE FROM servicos_prestados
					WHERE id_servico_prestado =".$ids_servicos_prestados[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;		
		}
		
		return "ok";
	}
	
	/*
		Procede  criao e escrita de um 
		ficheiro XML para as alteraes feitas
		serem replicadas pelas base de dados necessrias
	*/
	
	function EscreveXMLSync($id, $accao, $documento){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM servicos_prestados WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_servico_prestado = " . $id[$i] . " OR ";
		$sql .= "id_servico_prestado = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$raiz = $documento->firstChild;
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$no_servico_prestado = $documento->createElement("servicoPrestado");
			$raiz->appendChild($no_servico_prestado);
			
			$no_servico_prestado->setAttribute("id", $this->bd->obterValor($rs, "id_servico_prestado"));
			$no_servico_prestado->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("idServico");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_servico");
			$no_servico_prestado->appendChild($elemento);
			
			$elemento = $documento->createElement("idEntidade");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_entidade");
			$no_servico_prestado->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "promocao_0");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao0");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_1");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao1");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_2");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao2");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_3");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao3");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_4");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao4");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_5");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao5");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
			
			$valor = $this->bd->obterValor($rs, "promocao_6");
			if(isset($valor)){
				$elemento = $documento->createElement("promocao6");
				$elemento->nodeValue = $valor;
				$no_servico_prestado->appendChild($elemento);
			}
		}
		
	}
			
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>