<?php  	

class Sms extends AcessoBD 
{
	var $bd;

	function Sms() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	function Fechar() {
		$this->bd->fecharBD();
	}

	function GetLocais($where="")
	{
		$sql = "select id_loja, nome, horario, sms, sms_alias from lojas";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by nome";
		return $this->bd->getRows($sql);
	}

	function GetEntidades($where="")
	{
		$sql = "select distinct e.id_entidade, e.nome, le.id_loja, e.sms, e.sms_alias
			from entidades e
			inner join lojas_entidades le on le.id_entidade=e.id_entidade
			inner join lojas l on l.id_loja=le.id_loja";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by e.nome";
		return $this->bd->getRows($sql);
	}

	function GetServicos($where="")
	{
		$sql = "select s.id_servico, s.identificador, e.nome entidade, e.id_entidade, s.nome servico, s.nome_ecra_dispensador, s.horario, s.sms_fila, s.sms_tempo, s.sms_senhas,
			s.sms_alias_fila, s.sms_alias_tempo, s.sms_alias_senhas,
			s.sms_text_fila, s.sms_text_tempo, s.sms_text_senhas,
			s.sms_threshold_tempo, s.sms_threshold_senhas,
			s.sms_closing, date_format(s.sms_time_closing,'%k:%i') sms_time_closing, s.sms_text_closing
			from servicos s inner join entidades e on e.id_entidade=s.id_entidade";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by e.nome, s.nome";
		return $this->bd->getRows($sql);
	}


	/**
	 * Get Horario objects. Just the ones that are associated
	 * with the given locais and servicos.
	 *
	 * @param array $locais
	 * @param array $servicos
	 * @return array An array of Horario objects.
	 */
	function GetHorarios($locais, $servicos)
	{

		$horarios = array();
		foreach ($locais as $local) {
			$idHorario = $local['horario'];
			if (!isset($horarios[$idHorario])) {
				$horario = new Horario();
				$horario->get($idHorario);
				$horarios[$idHorario] = $horario;
			}
		}
		foreach ($servicos as $servico) {
			$idHorario = $servico['horario'];
			if (!isset($horarios[$idHorario])) {
				$horario = new Horario();
				$horario->get($idHorario);
				$horarios[$idHorario] = $horario;
			}
		}
		return $horarios;
	}

	function Editar($data, $id="")
	{
		if (is_array($id))
        {
            $sql = "UPDATE servicos SET ";

            $aux = array();

            if (isset($data["change_estado"]))
            {
                array_push($aux, "sms_senhas=".$data["estados_sms"]);
            }
            if (isset($data["change_num_cl"]))
            {
                array_push($aux, "sms_threshold_senhas=".$data["sms_threshold_senhas"]);
            }

            if (isset($data["change_alias"]))
            {
                array_push($aux, "sms_alias_senhas=".$data["sms_alias_senhas"]);
            }           

            if (isset($data["change_text"]))
            {
                array_push($aux, "sms_text_senhas='".$data["sms_text_senhas"]. "'");
            }

            $sql .= implode(", ", $aux)." where id_servico in (".implode(", ", $id).")";

            if (count($aux)) $this->bd->executarSQL($sql);

            
        }
        else
        {		
			$local = $data["local"];
			$entidade = $data["entidade"];
			$servico = $data["servico"];

			$queue = $data["queue"];
			$time = $data["time"];
			$tickets = $data["tickets"];
			$threshold = $data["threshold"];
			$closing = $data["closing"];
			//estados_sms
			$sql = "update servicos set				
					sms_senhas=". $data["estados_sms"] .",			
					sms_alias_senhas='".$data["sms_alias_senhas"]."',
					sms_text_senhas='".$data["sms_text_senhas"]."',
					sms_threshold_senhas=".$data["sms_threshold_senhas"];
				
			$sql .= " where id_servico=".$id;

			
			$this->bd->executarSQL($sql);
		}
		return "ok";
	}

	function Listar()
    {
        if (is_array($_SESSION["entidade"]) && count($_SESSION["entidade"]))
        {
            $variaveis = new Variaveis();
            $max = $variaveis->GetVariavel('factor_prioridade_maxima');
            $high = $variaveis->GetVariavel('factor_prioridade_alta');
            $med = $variaveis->GetVariavel('factor_prioridade_media');
            $low = $variaveis->GetVariavel('factor_prioridade_baixa');
            $min = $variaveis->GetVariavel('factor_prioridade_minima');
            unset($variaveis);

            $sql = "select s.id_servico, s.identificador, e.nome entidade, e.id_entidade, s.nome servico, s.nome_ecra_dispensador, s.horario, s.sms_senhas,
			s.sms_alias_senhas,s.sms_text_senhas,s.sms_threshold_senhas from servicos s inner join entidades e on (e.id_entidade=s.id_entidade and e.id_entidade in (".implode(",", $_SESSION["entidade"]).")) where id_servico > 0 ";

            if(array_key_exists("campo", $_REQUEST) && $_REQUEST["campo"] != "")
                $sql .= "ORDER BY s." . $_REQUEST["campo"] . " ";
            else
                $sql .= "ORDER BY s.nome ";

            if(array_key_exists("ordem", $_REQUEST) && $_REQUEST["ordem"] == 1)
                $sql .= "DESC";
            else
                $sql .= "ASC";

            global $ERROS, $N_REGISTOS;
            if(!$rs = $this->bd->executarSQL($sql))
            {
                echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
                return;
            }

            $servicos = array();
            while ($row = $this->bd->obterRegisto($rs)) array_push($servicos, $row);

            $n = 1;
            $pagina = 1;
            if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			    $pagina = $_REQUEST['pagina'];
            $numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
            $numPaginas = 1; // n�mero de p�ginas de registos
            $numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos

            // caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
            if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] != '' && ($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
                $_REQUEST["pagina"] -= 1;

        // caso n�o existam registos
        if($numTuplos == 0)
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem', true) . " ".translate('word_servicos_registados_sitema', true) ."</div>";
            return;
        }

            // calculo do n�mero de p�ginas de registos
            if($numTuplos % $numRegPag == 0)
                $numPaginas = $numTuplos / $numRegPag;
            else
                $numPaginas = (int) ($numTuplos / $numRegPag + 1);

            echo "
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=sms&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "")  . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST["ordem"] : "")  . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
				<tr>
					<td>
						<table class='data_table' cellspacing='0' cellpadding='0'>";

            //#1 - Re-design: store layout of navigation numbers in
            $TEMPLATE_navigation = "
                <tr>
    								<td class='button_page' colspan='6'>";

                    if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
                    {
                        $pagAnterior = $_REQUEST["pagina"] - 1;
                        $TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
                    }
                    else
                    {
                        $_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
                        $TEMPLATE_navigation .= "<div> < </div>";
                    }

                    while($n <= $numPaginas)
                    {
                        if($n == $_REQUEST["pagina"])
                            $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='current_page'>$n</div></a>";
                        else
                            $TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
                        $n++;
                    }

                    $n = ($pagina - 1)*$numRegPag;
                    $incremento = $n;

                    if($pagina < $numPaginas)
                    {
                        $pagPosterior = $_REQUEST["pagina"] + 1;
                        $TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div> > </div></a> ";
                    }
                    else
                    {
                        if($numTuplos % $numRegPag != 0)
                            $numRegPag = $numTuplos % $numRegPag;
                        $TEMPLATE_navigation .= "<div> > </div>";
                    }

            $TEMPLATE_navigation .= "		</td>
    				</tr>";

            echo "<tr class='column_row'>";

            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
                echo "<td width='8' style='padding-left:8px'>" .  translate('word_select') . "</td>";
            }

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div>". translate('word_name', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div>". translate('word_name', true)."</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"identificador") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=1'><div>".  translate('word_identificador', true)  ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."</div></a></td>";

            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"id_entidade") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=0'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=1'><div>" .translate('word_entity', true). "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=id_entidade&ordem=0'><div>" .translate('word_entity', true). "</div></a></td>";


            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"nome_ecra_dispensador") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=0'><div>"  .  translate('word_nome_ecra_dispensador')  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=1'><div>"  .  translate('word_nome_ecra_dispensador')  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome_ecra_dispensador&ordem=0'><div>"  .  translate('word_nome_ecra_dispensador')  . "</div></a></td>";


            if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"sms_senhas") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=sms_senhas&ordem=0'><div>" .  translate('word_state', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=sms_senhas&ordem=1'><div>" .  translate('word_state', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=sms_senhas&ordem=0'><div>" .  translate('word_state', true)  . "</div></a></td>";

         /*   if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"prioridade") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=0'><div>" .  translate('word_priority', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=1'><div>" .  translate('word_priority', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=prioridade&ordem=0'><div>" .  translate('word_priority', true)  . "</div></a></td>";*/

           /* if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"],"limite_clientes") == 0)
                if ($_REQUEST["ordem"] == 1)
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=0'><div>" .  translate('word_limiar_clientes', true)  . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
                else
                    echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=1'><div>" .  translate('word_limiar_clientes', true)  . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
            else
                echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=limite_clientes&ordem=0'><div>" .  translate('word_limiar_clientes', true)  . "</div></a></td>";*/



            echo "<td width='90'>". translate('word_operations', true)."</td>
				</tr>";



            //while($n < ($numRegPag + $incremento))
            //{
            //    $this->bd->moverRegisto($rs,$n);
            for ($i=$n; $i<$numRegPag + $incremento; $i++)
            {

                echo"<tr class='form-data-tr'>";
                if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                {
                    echo "<td class='form-data-td'>
                            <label class='custom-check-container'>
                                <input name='grupo' type='checkbox' value='" .  $servicos[$i]["id_servico"]  . "' onClick='selectEntireRow(this)'>
                                <span class='custom-checkmark'></span>
                            </label>
                    </td>";
                }

                $prioridade = $servicos[$i]["prioridade"] /*$this->bd->obterValor($rs, "prioridade")*/;
                switch ($prioridade)
                {
                    case $max:
                        $prioridade_str = "M&aacute;xima";
                        break;
                    case $high:
                        $prioridade_str = "Alta";
                        break;
                    case $med:
                        $prioridade_str = "M&eacute;dia";
                        break;
                    case $low:
                        $prioridade_str = "Baixa";
                        break;
                    case $min:
                        $prioridade_str = "M&iacute;nima";
                        break;
                    default:
                        break;
                }

                echo	" <td class='form-data-td'>" . $servicos[$i]["servico"] /*$this->bd->obterValor($rs, "servico") */ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["identificador"] /*$this->bd->obterValor($rs, "identificador") */ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["entidade"] /*$this->bd->obterValor($rs, "entidade")*/ . "</td>
              					<td class='form-data-td'>" . $servicos[$i]["nome_ecra_dispensador"] /*($this->bd->obterValor($rs, "nome_ecra_dispensador"))*/ . "</td>
              					<td class='form-data-td'>" . ($servicos[$i]["sms_senhas"] == '1' ? translate('word_activo',true) : translate('word_inactivo',true)) . "</td>
              					<td class='form-data-td'>";
                if (CENTRAL === FALSE AND $_SESSION["sessao_perms"]["perm_servicos"] == 2 )
                {
                    echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=sms&id=" . $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>";

                    /*if ($_SESSION["sessao_perms"]["all_perm"] == 1)
                    {
                        //echo "<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=sms&pagina=" . (array_key_exists("pagina", $_REQUEST) ? $_REQUEST["pagina"] : "") . "&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST["campo"] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "&id=" . $servicos[$i]["id_servico"]  . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
                        
                    }*/
                }
                else
                {
                    echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=sms&id=" . $servicos[$i]["id_servico"] /*$this->bd->obterValor($rs,"id_servico")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
                }
                echo	"</td>
				</tr>";

                //$n++;
            }

            //#3 - Re-design present NAVIGATION after table
            echo $TEMPLATE_navigation;

            echo "			</table>
					</td>
				</tr>
				<tr>
					<td>
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
            if ($_SESSION["sessao_perms"]["all_perm"] == 1)
            {
                echo	"<tr>
					<td class='button'>";
            
						echo "<div class='button-thin-green' onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
						<div class='button-thin-green' onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
						<div class='button-thin-green' onClick='editarMarcados(\"sms\");'>". translate('word_edit_selected', true)."</div>
					</td>

				</tr>";
            }
            echo	"</table>
		</form>";
        }
        else
        {
            echo "<div class='empty_msg'>".translate('word_nao_existem') . " ".translate('word_services') ." ".translate('word_registados_sistema') ."</div>";
                return;
        }
    }

    function LerDados($id)
    {
        $aux = array();
        if (is_array($id))
        {
            $aux = $id;
        }
        else
        {
            array_push($aux, $id);
        }

        $sql = "SELECT * FROM servicos WHERE id_servico in (" . implode(",", $aux) . ");";
        $res = $this->bd->getRows($sql);
        if (!count($res)) return 0;

        $servicos = array();
        if (is_array($id))
        {
        	foreach ($res as $r)
            {
                array_push($servicos, $r);
            }

            $_SESSION["sessao_campos"]["servicos"] = $servicos;

            /*$sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $res[0]["id_ecra"] . ";";
            $res2 = $this->bd->getRows($sql);
            $servicos_prestados = array();
            $ordem_servicos = array();
            foreach ($res2 as $r)
            {
                array_push($servicos_prestados, $r["id_servico"]);
                array_push($ordem_servicos, $r["ordem"]);
            }
            $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $ordem_servicos;

            $_SESSION["sessao_campos"]["nome_ecras"] = array();

            foreach ($res as $r)
            {
                array_push($_SESSION["sessao_campos"]["nome_ecras"], $r["nome"]);

                $_SESSION["sessao_campos"]["estado"] = $_SESSION["sessao_campos"]["estado"]==$r["estado"]?$r["estado"]:"";
                $_SESSION["sessao_campos"]["id_loja"] = $_SESSION["sessao_campos"]["id_loja"]==$r["id_loja"]?$r["id_loja"]:"";

                $sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $r["id_ecra"] . ";";
                $res2 = $this->bd->getRows($sql);
                $servicos_prestados = array();
                $ordem_servicos = array();
                foreach ($res2 as $r2)
                {
                    array_push($servicos_prestados, $r2["id_servico"]);
                    array_push($ordem_servicos, $r2["ordem"]);
                }
                $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $_SESSION["sessao_campos"]["servicos_ecra"]["id"]==$servicos_prestados?$servicos_prestados:array();
                $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"]==$ordem_servicos?$ordem_servicos:array();
                
            }*/
        }
        else
        {
            $_SESSION["sessao_campos"] = $res[0];
            //$id_ecra = $_SESSION["sessao_campos"]["id_ecra"];
            /*$id_loja = $_SESSION["sessao_campos"]["id_loja"];

            // Otteniamo i servizi associati all'ecra
            $sql = "SELECT id_servico, ordem FROM servicos_ecra WHERE id_ecra = " . $id . ";";
            $res2 = $this->bd->getRows($sql);
            //if(!$rs = $this->bd->executarSQL($sql))
            //    return 0;

            //$num_registos = $this->bd->obterNumRegistos($rs);
            $servicos_prestados = array();
            $ordem_servicos = array();

            foreach ($res2 as $r2)
                {
                    array_push($servicos_prestados, $r2["id_servico"]);
                    array_push($ordem_servicos, $r2["ordem"]);
                }

            

            // Otteniamo i servizi della logia dove � localizzato l'ecra
    //		$servicos_loja = new ServicoPrestado();
    //		$resultado = $servicos_loja->LerDados($id_loja);
    //		$servicos_loja->Fechar();

            $_SESSION["sessao_campos"]["servicos_ecra"]["id"] = $servicos_prestados;
            $_SESSION["sessao_campos"]["servicos_ecra"]["ordem"] = $ordem_servicos;
            */
        }

        return "ok";
    }

    function XLerDadosX($id)
    {	
        $sql = "SELECT * FROM servicos WHERE id_servico in (" . implode(', ', $id) . ") ";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);
        
        $_SESSION["sessao_campos"]["servicos_redireccao"] = $this->GetRedirectionServiceList($id);

        return "ok";
    }

    function GetRedirectionServiceList($id)
    {
        $sql = "select destination_id from servicos_redireccao where source_id=".$id;
        $res = $this->bd->executarSQL($sql);
        $servicos = array();
        while ($res && $row = $this->bd->obterRegisto($res))
        {
            array_push($servicos, $row["destination_id"]);
        }
        return $servicos;
    }
}

?>