<?php  	

class Sms extends AcessoBD 
{
	var $bd;

	function Sms() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	function Fechar() {
		$this->bd->fecharBD();
	}

	function GetLocais($where="")
	{
		$sql = "select id_loja, nome, horario, sms, sms_alias from lojas";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by nome";
		return $this->bd->getRows($sql);
	}

	function GetEntidades($where="")
	{
		$sql = "select distinct e.id_entidade, e.nome, le.id_loja, e.sms, e.sms_alias
			from entidades e
			inner join lojas_entidades le on le.id_entidade=e.id_entidade
			inner join lojas l on l.id_loja=le.id_loja";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by e.nome";
		return $this->bd->getRows($sql);
	}

	function GetServicos($where="")
	{
		$sql = "select s.id_servico, s.identificador, e.nome entidade, e.id_entidade, s.nome servico, s.nome_ecra_dispensador, s.horario, s.sms_fila, s.sms_tempo, s.sms_senhas,
			s.sms_alias_fila, s.sms_alias_tempo, s.sms_alias_senhas,
			s.sms_text_fila, s.sms_text_tempo, s.sms_text_senhas,
			s.sms_threshold_tempo, s.sms_threshold_senhas,
			s.sms_closing, date_format(s.sms_time_closing,'%k:%i') sms_time_closing, s.sms_text_closing
			from servicos s inner join entidades e on e.id_entidade=s.id_entidade";
		if ($where) $sql .= " where ".$where;
		$sql .= " order by e.nome, s.nome";
		return $this->bd->getRows($sql);
	}


	/**
	 * Get Horario objects. Just the ones that are associated
	 * with the given locais and servicos.
	 *
	 * @param array $locais
	 * @param array $servicos
	 * @return array An array of Horario objects.
	 */
	function GetHorarios($locais, $servicos)
	{

		$horarios = array();
		foreach ($locais as $local) {
			$idHorario = $local['horario'];
			if (!isset($horarios[$idHorario])) {
				$horario = new Horario();
				$horario->get($idHorario);
				$horarios[$idHorario] = $horario;
			}
		}
		foreach ($servicos as $servico) {
			$idHorario = $servico['horario'];
			if (!isset($horarios[$idHorario])) {
				$horario = new Horario();
				$horario->get($idHorario);
				$horarios[$idHorario] = $horario;
			}
		}
		return $horarios;
	}

	function Editar($data, $id="")
	{
//		debug(print_r($data, true), $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");

		$local = $data["local"];
		$entidade = $data["entidade"];
		$servico = $data["servico"];

		$queue = $data["queue"];
		$time = $data["time"];
		$tickets = $data["tickets"];
		$threshold = $data["threshold"];
		$closing = $data["closing"];

		// lojas

		$sql = "update lojas set sms=0";
		$this->bd->executarSQL($sql);

		foreach ($local as $l)
		{
			$sql = "update lojas set sms=1, sms_alias='".$data["alias_local_".$l]."' where id_loja=".$l;
			$this->bd->executarSQL($sql);
		}

		// entidades

		$sql = "update entidades set sms=0";
		$this->bd->executarSQL($sql);

		foreach ($entidade as $l)
		{
			$sql = "update entidades set sms=1, sms_alias='".$data["alias_entidade_".$l]."' where id_entidade=".$l;
			$this->bd->executarSQL($sql);
		}

		// servicos

		$sql = "update servicos set
			sms_fila=0,
			sms_tempo=0,
			sms_senhas=0,
			sms_closing=0";
		$this->bd->executarSQL($sql);

//		sms_alias_fila=null,
//		sms_alias_tempo=null,
//		sms_alias_senhas=null,
//		sms_text_fila=null,
//		sms_text_tempo=null,
//		sms_text_senhas=null,
//		sms_threshold_tempo=null,
//		sms_threshold_senhas=null

		foreach ($servico as $l)
		{
			$sql = "update servicos set
				sms_fila=".($queue && in_array($l,$queue)?"1":"0").",
				sms_tempo=".($time && in_array($l,$time)?"1":"0").",
				sms_senhas=".($tickets && in_array($l,$tickets)?"1":"0").",
				sms_closing=".($closing && in_array($l,$closing)?"1":"0");
			if ($queue && in_array($l,$queue))
				$sql .= ", sms_alias_fila='".$data["alias_queue_".$l]."',
					sms_text_fila='".$data["text_queue_".$l]."'";
			if ($time && in_array($l,$time))
				$sql .= ", sms_alias_tempo='".$data["alias_time_".$l]."',
					sms_text_tempo='".$data["text_time_".$l]."',
					sms_threshold_tempo=".$data["threshold_time_".$l];
			if ($tickets && in_array($l,$tickets))
				$sql .= ", sms_alias_senhas='".$data["alias_tickets_".$l]."',
					sms_text_senhas='".$data["text_tickets_".$l]."',
					sms_threshold_senhas=".$data["threshold_tickets_".$l];
			if ($closing && in_array($l,$closing))
				$sql .= ", sms_text_closing='".$data["text_closing_".$l]."',
					sms_time_closing='".$data["time_closing_".$l]."'";
			$sql .= " where id_servico=".$l;
//			debug($sql, $_SERVER["DOCUMENT_ROOT"]."/debug/debug.txt");

			$this->bd->executarSQL($sql);
		}

		return "ok";
	}
}

?>