<?php  

require_once '../../config.inc.php';

$sms = new Sms;
$lj = $sms->GetLocais("sms=1");
$nt = $sms->GetEntidades("e.sms=1 and l.sms=1");
$srv = $sms->GetServicos("s.sms_fila=1 or s.sms_tempo=1 or s.sms_senhas=1");
$hrs = $sms->GetHorarios($lj, $srv);
unset($sms);

header("content-type: text/xml");
$xml = new XMLWriter();
$xml->openMemory();
$xml->startDocument('1.0');
$xml->setIndent(true);

$xml->startElement("mobline-config");

$xml->startElement("timetables");

foreach ($hrs as $h) {

	$xml->startElement("timetable"); // Open the <timetable> tag
	$xml->writeAttribute("id", $h->id);
	$xml->writeAttribute("name", $h->nome);

	$currWeek = $h->getHorarioSemanaCurrent();
	if ($currWeek == null) {
		// There is no weekly definition that is valid for this week,
		// weird...
		$xml->endElement(); // Close the </timetable> tag
		continue;
	}
	for ($i = 1; $i <= 7; $i++) {
		$xml->startElement("day"); // Open the current <day> tag
		$xml->writeAttribute("name", WeekDay::toString($i));

		$periodos = $currWeek->getPeriodos($i);
		if ($periodos != null) {
			foreach ($periodos as $periodo) {
				$xml->startElement("period"); // Open the </period> tag
				$xml->writeAttribute("name", ""); // periodo name is not supported in the new Horario objects
				$xml->writeAttribute("start", $periodo->getInicio());
				$xml->writeAttribute("end", $periodo->getFim());
				$xml->endElement(); // Close the </period> tag
                        }
                }
		$xml->endElement(); // Close the </day> tag
	}
	$xml->endElement(); // Close the </timetable> tag
}

$xml->startElement("locals");
foreach ($lj as $l)
{
	$xml->startElement("local");
	$xml->writeAttribute("id", $l["id_loja"]);
	$xml->writeAttribute("name", $l["nome"]);
	$xml->writeAttribute("timetable-id", $l["horario"]);
	$xml->endElement();
}
$xml->endElement();

$xml->startElement("entities");
foreach ($nt as $n)
{
	$xml->startElement("entity");
	$xml->writeAttribute("id", $n["id_entidade"]);
	$xml->writeAttribute("name", $n["nome"]);
	$xml->writeAttribute("local-id", $n["id_loja"]);
	$xml->endElement();
}
$xml->endElement();

$xml->startElement("services");
foreach ($srv as $s)
{
	$xml->startElement("service");
	$xml->writeAttribute("id", $s["id_servico"]);
	$xml->writeAttribute("name", $s["servico"]);
	$xml->writeAttribute("name-dispenser", $s["nome_ecra_dispensador"]);
	$xml->writeAttribute("identifier", $s["identificador"]);
	$xml->writeAttribute("timetable-id", $s["horario"]);
	$xml->writeAttribute("entity-id", $s["id_entidade"]);
	$xml->endElement();
}
$xml->endElement();

$xml->startElement("notification-config");
foreach ($lj as $l)
{
	$xml->startElement("local-config");
	$xml->writeAttribute("id", $l["id_loja"]);
	$xml->writeAttribute("request-alias", $l["sms_alias"]);
	$xml->endElement();
}

$aux = array();
foreach ($nt as $n)
{
	if (!in_array($n["id_entidade"], $aux))
	{
		array_push($aux, $n["id_entidade"]);
		$xml->startElement("entity-config");
		$xml->writeAttribute("id", $n["id_entidade"]);
		$xml->writeAttribute("request-alias", $n["sms_alias"]);
		$xml->endElement();
	}
}

foreach ($srv as $s)
{
	if (!$s["sms_fila"] && !$s["sms_senhas"] && !$s["sms_tempo"] && !$s["sms_closing"]) {
		continue;
	}

	$xml->startElement("service-config"); // open <services-config>
	$xml->writeAttribute("id", $s["id_servico"]);
	if ($s["sms_fila"])
	{
		$xml->startElement("request-settings");
		$xml->writeAttribute("type", "QUEUE_STATUS");
		$xml->writeAttribute("request-alias", $s["sms_alias_fila"]);
		$xml->writeElement("response-text", $s["sms_text_fila"]);
		$xml->endElement();
	}

	if ($s["sms_senhas"])
	{
		$xml->startElement("request-settings");
		$xml->writeAttribute("type", "BY_TICKETS_REMAINING");
		$xml->writeAttribute("request-alias", $s["sms_alias_senhas"]);
		$xml->writeElement("response-text", $s["sms_text_senhas"]);
		$xml->writeElement("threshold", $s["sms_threshold_senhas"]);
		$xml->endElement();
	}

	if ($s["sms_tempo"])
	{
		$xml->startElement("request-settings");
		$xml->writeAttribute("type", "BY_TIME_REMAINING");
		$xml->writeAttribute("request-alias", $s["sms_alias_tempo"]);
		$xml->writeElement("response-text", $s["sms_text_tempo"]);
		$xml->writeElement("threshold", $s["sms_threshold_tempo"]);
		$xml->endElement();
	}

	if ($s["sms_closing"])
	{
		$xml->startElement("closing-notification");
		$xml->writeAttribute("time", $s["sms_time_closing"]);
		$xml->writeElement("response-text", $s["sms_text_closing"]);
		$xml->endElement();
	}
	$xml->endElement(); // close <services-config>
}
		
$xml->endElement();
$xml->endElement();
$xml->endDocument();
//$file = fopen("mobline-config.xml", "w");
//fwrite($file, $xml->outputMemory());
echo $xml->outputMemory();
?>