<?php
	
/* Classe de Gest�o de Configura��es de Teclados */

class Teclado extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Teclado() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados)
	{
		
		$sql = "SELECT id_tipos_teclado
				FROM tipos_teclado
				WHERE nome_tabela='teclado_".$dados["numero_teclas"]."';";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$id_tipo = $this->bd->obterValor($rs,"id_tipos_teclado");
		
		$sql = "INSERT INTO teclado(nome, tipo_teclado)
				VALUES ('".$dados["nome"]."', 
						".$id_tipo.");";
		
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
						
						
		$sql = "SELECT MAX(id_teclado)
				FROM teclado;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		$id_teclado = $this->bd->obterValor($rs, 0);
						
		$sql = "INSERT INTO teclado_".$dados["numero_teclas"]."(";
		
		for ($i = 1 ; $i < $dados["numero_teclas"] ; $i++) {
			$sql .= "accao_tecla_".$i.", tipo_accao_".$i.", ";
		}
		$sql .= "accao_tecla_".$i.", tipo_accao_".$i.", id_teclado) VALUES ( ";
		
		for ($i = 1 ; $i < $dados["numero_teclas"] ; $i++) {
			if($dados["accao_tecla_".$i] == "")
				$sql .= "null, ";
			else
				$sql .= $dados["accao_tecla_".$i] .", ";
		
			$sql .= $dados["tipo_accao_".$i] .", ";
		}
		if($dados["accao_tecla_".$i] == "")
				$sql .= "null, ";
			else
				$sql .= $dados["accao_tecla_".$i] .", ";
		
			$sql .= $dados["tipo_accao_".$i] .", ".$id_teclado.");";

		if($rs = $this->bd->executarSQL($sql))
		{	
			$this->EscreveXMLSync($id_teclado, "inserir", "teclado_".$dados["numero_teclas"]);
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Configuração Teclado", $dados["nome"]);
			$objecto->fechar();
			return "ok";
		}
		else
			return 0;
	}

	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT t.nome, tt.nome_tabela, tt.numero_teclas
				FROM teclado t, tipos_teclado tt
				WHERE t.tipo_teclado = tt.id_tipos_teclado
				AND t.id_teclado = " . $id . ";";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$campos = $this->bd->obterRegisto($rs);
		
		$sql = "SELECT * FROM ". $campos["nome_tabela"] .
				" WHERE id_teclado=".$id.";";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$_SESSION["sessao_campos"] = array_merge($this->bd->obterRegisto($rs), $campos);
				
		return "ok";
	}

	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id)
	{
		$sql = "SELECT tt.nome_tabela, tt.numero_teclas
				FROM teclado t, tipos_teclado tt
				WHERE t.tipo_teclado = tt.id_tipos_teclado
				AND t.id_teclado = " . $id . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		$aux = $this->bd->obterRegisto($rs);
		
		$sql = "UPDATE teclado SET nome = '" . $dados["nome"] . "'".
				" WHERE id_teclado = " . $id . " ;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$sql = "UPDATE ". $aux["nome_tabela"] ." SET ";
		
		for ($i = 1 ; $i < $aux["numero_teclas"] ; $i++) {
			if($dados["accao_tecla_".$i] == "")
				$sql .= "accao_tecla_".$i." = null, ";
			else
				$sql .= "accao_tecla_".$i." = ".$dados["accao_tecla_".$i] .", ";
		
			$sql .= "tipo_accao_".$i." = ".$dados["tipo_accao_".$i] .", ";
		}
		if($dados["accao_tecla_".$i] == "")
			$sql .= "accao_tecla_".$i." = null, ";
		else
			$sql .= "accao_tecla_".$i." = ".$dados["accao_tecla_".$i] .", ";
	
		$sql .= "tipo_accao_".$i." = ".$dados["tipo_accao_".$i] ." ";
		$sql .= "WHERE id_teclado= " . $id .";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$sql = "SELECT identificador FROM terminal
				WHERE tipo_terminal = 0
				AND id_teclado = ". $id .";";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		for($i = 0 ; $i < $this->bd->obterNumRegistos($rs) ; $i++)
		{
			$this->bd->moverRegisto($rs, $i);
			
			GLOBAL $DIR_XML_DISPWEB;
				
			$ficheiro = $DIR_XML_DISPWEB .$this->bd->obterValor($rs,"identificador").".xml";
			
			$teclado = new Teclado();
			$teclado->escreveServicosXML($id, $ficheiro);
			$teclado->Fechar();
		}
		
		$this->EscreveXMLSync($id, "editar", $aux["nome_tabela"]);
		
		$objecto = new LogAccao();
		$rs = $objecto->Inserir("Edição", "Configuração Teclado", $dados["nome"]);
		$objecto->fechar();
		
		return "ok";

	}

	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id)
	{
		$this->EscreveXMLSync($id, "remover");
		
		$numEntradas = count($id);
		$nomes = array();
		
		$sql = "SELECT nome FROM teclado WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_teclado = " . $id[$i] . " OR ";
		$sql .= "id_teclado = " . $id[0] . ";";

		if($rs = $this->bd->executarSQL($sql)) 
		{
			for($i = 0; $i < $numEntradas; $i++)
			{
				$this->bd->moverRegisto($rs,$i);
				array_push($nomes, $this->bd->obterValor($rs,"nome"));
			}
		}
		else 
			return 0;

		$sql = "DELETE FROM teclado WHERE ";
		for($i = count($id); $i > 1; $i--)
			$sql .= "id_teclado = ". $id[$i-1] . " OR ";
		$sql .= "id_teclado = ". $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$objecto = new LogAccao();
		for($i = count($nomes)-1; $i >= 0; $i--){
			$rs = $objecto->Inserir("Remoção", "Configuração Teclado", $nomes[$i]);
		}
		$objecto->fechar();			
		return "ok";
	}
	
	/*
		Escreve num XML os servi�os associados
		� configura��o de teclado indicada
	*/
	function escreveServicosXML($id, $filepath)
	{
		$sql = "SELECT nome_tabela, numero_teclas
				FROM teclado, tipos_teclado
				WHERE tipo_teclado = id_tipos_teclado
				AND id_teclado = ". $id .";";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$tabela = $this->bd->obterValor($rs, "nome_tabela");
		$teclas = $this->bd->obterValor($rs, "numero_teclas");
		
		$sql = "SELECT * FROM ". $tabela ."
				WHERE id_teclado = ". $id .";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$tuplo = $this->bd->obterRegisto($rs);
		
		$document = new DOMDocument("1.0", "UTF-8" );
		$document->formatOutput = true;
		$root = $document->createElement("layout");
		
		$document->appendChild($root);
		
		for($i = 1 ; $i <= $teclas ; $i++)
		{
			if(isset($tuplo["accao_tecla_".$i]) && $tuplo["accao_tecla_".$i] != 0)
			{
				$servico = obterNomeGeral($tuplo["accao_tecla_".$i], "id_servico", "nome", "servicos" );				
				$root->appendChild($document->createElement("servico", $servico));

			} else {
				$root->appendChild($document->createElement("servico"));
			}
		}
		
		$document->save($filepath);
		
		return $teclas;
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $tabela = null, $enderecos_lojas=null){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM teclado WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_teclado = " . $id[$i] . " OR ";
		$sql .= "id_teclado = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$documento = abreXMLSync();
		$raiz = $documento->firstChild;
		
		
		if(is_null($enderecos_lojas)){
			$loja = new Loja();
			$enderecos = $loja->listaIpLojas();
			//$loja->Fechar();
		} else {
			$enderecos = $enderecos_lojas;
		}
		
		if(count($enderecos) > 0){
			$destinos = $documento->createElement("destinos");
			$raiz->appendChild($destinos);
		}
		
		for($i = 0 ; $i < count($enderecos) ; $i++){
			$loja = $documento->createElement("loja");
			$loja->nodeValue = $enderecos[$i];
			$destinos->appendChild($loja);
		}
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$no_teclado = $documento->createElement("teclado");
			$raiz->appendChild($no_teclado);
			
			$no_teclado->setAttribute("id", $this->bd->obterValor($rs, "id_teclado"));
			$no_teclado->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("nome");
			$elemento->nodeValue = $this->bd->obterValor($rs, "nome");
			$no_teclado->appendChild($elemento);
			
			$elemento = $documento->createElement("idTipoTeclado");
			$elemento->nodeValue = $this->bd->obterValor($rs, "tipo_teclado");
			$no_teclado->appendChild($elemento);
		}
		
		if(!is_null($tabela)) {
			
			$sql = "SELECT * FROM ".$tabela." WHERE ";
			for($i = $numEntradas-1; $i > 0; $i--)
				$sql .= "id_teclado = " . $id[$i] . " OR ";
			$sql .= "id_teclado = " . $id[0] . ";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
			
			$sql = "SHOW FULL COLUMNS FROM ". $tabela .";";
			
			if(!$rs_aux = $this->bd->executarSQL($sql))
				return 0;
				
			$numCampos = $this->bd->obterNumRegistos($rs_aux);
				
			for($i = 0 ; $i < $numEntradas ; $i++){
				$this->bd->moverRegisto($rs, $i);
				
				$no_tipo = $documento->createElement("entradaTipo");
				$raiz->appendChild($no_tipo);
				
				$no_tipo->setAttribute("tabela", $tabela);
				$no_tipo->setAttribute("accao", $accao);
				
				for($j = 0 ; $j < $numCampos ; $j++){
					$this->bd->moverRegisto($rs_aux, $j);
					$campo = $this->bd->obterValor($rs_aux,"Field");
					$valor = $this->bd->obterValor($rs, $campo);

					if( $campo == "id_".$tabela){
						$no_tipo->setAttribute("id", $valor);
					}
					else if (isset($valor)){
						$elemento = $documento->createElement("campo");
						$elemento->nodeValue = $valor;
						$elemento->setAttribute("nome", $campo);
						$no_tipo->appendChild($elemento);
					}
				}
				
			}
		}
		
		fechaXMLsync($documento);
		
	}
	
	/*
		Fun��o de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	
	function Listar()
	{
		$sql = "SELECT t.id_teclado, t.nome, tt.numero_teclas
				FROM teclado t, tipos_teclado tt 
				WHERE t.tipo_teclado = tt.id_tipos_teclado ";
		
		if($_REQUEST["campo"] != "")		
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";	
		else	
			$sql .= "ORDER BY t.nome ";
			
		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";			

		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem', true) ." ".  translate('word_configuracoes_teclados_sistema', true) ."!</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=teclados&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"]  . "&estado=" . $_REQUEST['estado'] . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'><strong>". translate('word_pages', true)." </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&estado=" . $_REQUEST['estado'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&estado=" . $_REQUEST['estado'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&estado=" . $_REQUEST['estado'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&estado=" . $_REQUEST['estado'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if ( $_SESSION["sessao_perms"]["perm_config_teclado"] == 2 ) {
			echo "<td width='8'>&nbsp;</td>";
		}
				
		if (strcmp($_REQUEST["campo"],"nome") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0'><div". translate('word_name', true)."/div></a></td>";

		if (strcmp($_REQUEST["campo"],"numero_teclas") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=numero_teclas&ordem=0'><div>".  translate('word_numero_teclas', true) ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=numero_teclas&ordem=1'><div>".  translate('word_numero_teclas', true) ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=numero_teclas&ordem=0'><div>".  translate('word_numero_teclas', true) ."</div></a></td>";

		echo "<td width='135'>". translate('word_operations', true)."</td>								
				</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>";
			if ( $_SESSION["sessao_perms"]["perm_config_teclado"] == 2 ) {
				echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs,"id_teclado") . "'/></td>";
			}
			echo	"<td>" . $this->bd->obterValor($rs, "nome") . "</td>
					<td>" . $this->bd->obterValor($rs, "numero_teclas") . "</td>			
					<td>";
		if ( $_SESSION["sessao_perms"]["perm_config_teclado"] == 2 ) {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=teclados&id=" . $this->bd->obterValor($rs,"id_teclado") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=teclados&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST['ordem'] . "&id=" . $this->bd->obterValor($rs,"id_teclado") . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
		} else {
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=teclados&id=" . $this->bd->obterValor($rs,"id_teclado") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
		}
			echo	"</td>							
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						 
				<tr>
					<td> 
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
	if ( $_SESSION["sessao_perms"]["perm_config_teclado"] == 2 ) {
		echo	"<tr>
					<td class='button_large'>
						<div onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
						<div onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
						<div onClick='removerMarcados(this);'>". translate('word_remove', true)."</div>
					</td>
				</tr>";
	}
	
	echo	"</table>
		</form>";		
	}
			
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>