<?php
	
/* Classe de Gest�o de Terminais */

class Terminal extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Terminal() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados)
	{
		
	}

	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		
	}

	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id)
	{
		
	}

	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id)
	{
		
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $documento, $tabela = null){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM terminal WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_terminal = " . $id[$i] . " OR ";
		$sql .= "id_terminal = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$raiz = $documento->firstChild;
		
		$loja = new Loja();
		$enderecos = array();
		
		$destinos = $documento->createElement("destinos");
		
		if($raiz->hasChildNodes()) {
			if($raiz->localName == "destinos")
				$destinos = $raiz->firstChild;
			else 
				$destinos = $raiz->insertBefore($destinos, $raiz->firstChild);
		}
		else
			$raiz->appendChild($destinos);
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
						
			$enderecos = array_merge($enderecos, $loja->listaIpLojas($this->bd->obterValor($rs, "id_loja")));
			
			$no_dispensador = $documento->createElement("terminal");
			$raiz->appendChild($no_dispensador);
			
			$no_dispensador->setAttribute("id", $this->bd->obterValor($rs, "id_terminal"));
			$no_dispensador->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("idTipoTerminal");
			$elemento->nodeValue = $this->bd->obterValor($rs, "tipo_terminal");
			$no_dispensador->appendChild($elemento);
			
			$elemento = $documento->createElement("idEstadoTerminal");
			$elemento->nodeValue = $this->bd->obterValor($rs, "estado");
			$no_dispensador->appendChild($elemento);
			
			$elemento = $documento->createElement("estadoBateria");
			$elemento->nodeValue = $this->bd->obterValor($rs, "estado_bateria");
			$no_dispensador->appendChild($elemento);
			
			$elemento = $documento->createElement("idLoja");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_loja");
			$no_dispensador->appendChild($elemento);
			
			$elemento = $documento->createElement("identificadorTerminal");
			$elemento->nodeValue = $this->bd->obterValor($rs, "identificador");
			$no_dispensador->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "id_associacao_terminal");
			if(isset($valor)){
				$elemento = $documento->createElement("idAssociacaoTerminal");
				$elemento->nodeValue = $valor;
				$no_dispensador->appendChild($elemento);
			}
			
			$elemento = $documento->createElement("idTeclado");
			$elemento->nodeValue = $this->bd->obterValor($rs, "id_teclado");
			$no_dispensador->appendChild($elemento);
		}
		
		$enderecos = array_unique($enderecos);
		
		for($i = 0 ; $i < count($enderecos) ; $i++){
			
			$loja = $documento->createElement("loja");
			$loja->nodeValue = $enderecos[$i];
			$destinos->appendChild($loja);
			
		}
		
		if(!is_null($tabela)) {
			
			$sql = "SELECT * FROM ".$tabela." WHERE ";
			for($i = $numEntradas-1; $i > 0; $i--)
				$sql .= "id_terminal = " . $id[$i] . " OR ";
			$sql .= "id_terminal = " . $id[0] . ";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
			
			$sql = "SHOW FULL COLUMNS FROM ". $tabela .";";
			
			if(!$rs_aux = $this->bd->executarSQL($sql))
				return 0;
				
			$numCampos = $this->bd->obterNumRegistos($rs_aux);
				
			for($i = 0 ; $i < $numEntradas ; $i++){
				$this->bd->moverRegisto($rs, $i);
				
				$no_tipo = $documento->createElement("entradaTipo");
				$raiz->appendChild($no_tipo);
				
				$no_tipo->setAttribute("nomeTabela", $tabela);
				$no_tipo->setAttribute("accao", $accao);
				
				for($j = 0 ; $j < $numCampos ; $j++){
					$this->bd->moverRegisto($rs_aux, $j);
					$campo = $this->bd->obterValor($rs_aux,"Field");
					$valor = $this->bd->obterValor($rs, $campo);

					if( $campo == "id_".$tabela){
						$no_tipo->setAttribute("id", $valor);
					}
					else if (isset($valor)){
						$elemento = $documento->createElement("campoTipo");
						$elemento->nodeValue = $valor;
						$elemento->setAttribute("nomeCampo", $campo);
						$no_tipo->appendChild($elemento);
					}
				}
				
			}
		}
		
	}
	
	/*
		Fun��o de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	
	function Listar()
	{
		$sql = "SELECT t.id_terminal, t.identificador, t.estado, tt.nome tipo, l.nome loja
				FROM terminal t, tipos_terminal tt, lojas l
				WHERE l.id_loja = t.id_loja
				AND t.tipo_terminal = tt.id_tipos_terminal ";
		
		if($_REQUEST["campo"] != "")		
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";	
		else	
			$sql .= "ORDER BY t.identificador ";
			
		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";			

		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem', true) ." ". translate('word_terminais', false) ." ".translate('word_registados_sistema', false) ."</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=objectos_tipo&tipomod=terminal&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"] . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='6'><strong>". translate('word_pages', true)." </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?tipomod=terminal&pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?tipomod=terminal&pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?tipomod=terminal&pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?tipomod=terminal&pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>";

		if ( $_SESSION["sessao_perms"]["perm_terminal"] == 2 ) {
			echo "<td width='8'>&nbsp;</td>";
		}
				
		if (strcmp($_REQUEST["campo"],"identificador") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=identificador&ordem=1'><div>".  translate('word_identificador', true) ."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=identificador&ordem=0'><div>".  translate('word_identificador', true)  ."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"estado") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=estado&ordem=1'><div>". translate('word_state', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=estado&ordem=0'><div>". translate('word_state', true)."</div></a></td>";

		if (strcmp($_REQUEST["campo"],"tipo") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=tipo&ordem=0'><div>". translate('word_tipo_terminal', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=tipo&ordem=1'><div>". translate('word_tipo_terminal', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=tipo&ordem=0'><div>". translate('word_tipo_terminal', true)."</div></a></td>";
			
			if (strcmp($_REQUEST["campo"],"loja") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=loja&ordem=0'><div>". translate('word_store', true)."<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=loja&ordem=1'><div>". translate('word_store', true)."<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?tipomod=terminal&pagina=1&campo=loja&ordem=0'><div>". translate('word_store', true)."</div></a></td>";

		echo "<td width='135'>". translate('word_operations', true)."</td>								
				</tr>";	
		
		

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>";
			if ( $_SESSION["sessao_perms"]["perm_terminal"] == 2 ) {
				echo "<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs,"id_terminal") . "'/></td>";
			}
			echo   "<td>" . $this->bd->obterValor($rs,"identificador") . "</td>
					<td>" . obterNomeGeral($this->bd->obterValor($rs,"estado"), "id_estado_terminal", "nome", "estados_terminal") . "</td>
					<td>" . $this->bd->obterValor($rs,"tipo") . "</td>
					<td>" . $this->bd->obterValor($rs,"loja") . "</td>			
					<td>";
		
		if( $_SESSION["sessao_perms"]["perm_terminal"] == 2 ) {
		
			echo		"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=objectos_tipo&tipomod=terminal&id=" . $this->bd->obterValor($rs,"id_terminal") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=objectos_tipo&tipomod=terminal&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"] . "&ordem=" . $_REQUEST['ordem'] ."&id=" . $this->bd->obterValor($rs,"id_terminal") . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
						
		} else {
		
			echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=objectos_tipo&tipomod=terminal&id=" . $this->bd->obterValor($rs,"id_terminal") . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
		}
			echo	"</td>							
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						 
				<tr>
					<td> 
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
	if ( $_SESSION["sessao_perms"]["perm_terminal"] == 2 ) {
		echo	"<tr>
					<td class='button_large'>
						<div onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
						<div onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
						<div onClick='removerMarcados(this);'>". translate('word_remove', true)."</div>
					</td>
				</tr>";
	}
	
	echo	"</table>
		</form>";		
	}
			
			
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>