<?php
	
/* Classe de Gest�o de Tipos */

class Tipo extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function Tipo() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($dados) {
		$modelo = $dados["modelo"];
		$fabricante = $dados["fabricante"];
		$fornecedor = $dados["fornecedor"];
		$sql = "INSERT INTO " . $_REQUEST["tipomod"] . "_dispensador(modelo,fabricante,fornecedor) 
						VALUES ('$modelo', '$fabricante','$fornecedor');";
		if(!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}
		else {
			$autoIncrementId = $this->bd->obterUltimoInsertId();
			$sql = "SELECT id_".$_REQUEST["tipomod"]." , modelo ";
			$sql.= "FROM " . $_REQUEST["tipomod"] . "_dispensador ";
            $sql.= "ORDER BY modelo ASC";
			if($rs = $this->bd->executarSQL($sql)) {
				$_SESSION["sessao_campos_".$_REQUEST["tipomod"]."_inserted_id"] = $autoIncrementId;
                $_SESSION["sessao_campos_".$_REQUEST["tipomod"]] = array();
                foreach ($rs as $val) {
                    $_SESSION["sessao_campos_".$_REQUEST["tipomod"]][$val["id_".$_REQUEST["tipomod"]]] = $val["modelo"];
                }
			}
			return "ok";
		}		
	}

	/*
		Fun��o de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id)
	{
		$sql = "SELECT * FROM tipos_" . $_REQUEST["tipomod"] . " WHERE id_tipos_" . $_REQUEST["tipomod"] . " = " . $id . ";";
		
		if(!$rs_aux = $this->bd->executarSQL($sql))
			return 0;	
						
		$sql = "SHOW FULL COLUMNS FROM " . $this->bd->obterValor($rs_aux,"nome_tabela");

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$numCampos = $this->bd->obterNumRegistos($rs);
		$campos = array();
		$campos["nomes"] = array();
		$campos["tipos"] = array();
		$campos["obrigs"] = array();
		$campos["refs"] = array();
		
		for($i = 0, $j = 1; $i < $numCampos; $i++, $j++)
		{
			$this->bd->moverRegisto($rs,$i);
			$comentario = $this->bd->obterValor($rs,"Comment");
			
			if($comentario == "")
				continue;
				
			$vector = construcaoVector($comentario,",");
			array_push($campos["nomes"], $vector[0]);
			array_push($campos["tipos"], $vector[3]);
			array_push($campos["obrigs"], $vector[5]);
			if ($vector[3] == 16)
				array_push($campos["refs"], $vector[7]);
		}
		$_SESSION["sessao_campos_existentes"] = $campos;
		$_SESSION["sessao_campos"] = array();		
		
		$sql = "SHOW FULL COLUMNS FROM " . $_REQUEST["tipomod"];

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$numCampos = $this->bd->obterNumRegistos($rs);
		$campos_obrig = array();
		
		for($i = 1, $j = 1; $i < $numCampos; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			$comentario = $this->bd->obterValor($rs,"Comment");
			if($comentario != "") {
				$campos_obrig["campo_" . $j] = $comentario;
				$j++;
			}
		}
		$_SESSION["sessao_campos_obrig"] = $campos_obrig;
		
		$sql = "SHOW FULL COLUMNS FROM tipos_" . $_REQUEST["tipomod"];

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$numCampos = $this->bd->obterNumRegistos($rs);
		$campos_tipo = array();
		for($i = 1, $j = 1; $i < $numCampos; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			$comentario = $this->bd->obterValor($rs,"Comment");
			if($comentario != "") {
				$field = $this->bd->obterValor($rs,"Field");
				$campos_tipo["nome_campo_" . $j] = $field;
				$campos_tipo["valor_campo"][$field] = $this->bd->obterValor($rs_aux,$field);
				$campos_tipo["campo_" . $j] = $comentario;
				$j++;
			}
		}
		$_SESSION["sessao_campos_tipo"] = $campos_tipo;
		
		$resultado = "ok";
			
		if( $_REQUEST["tipomod"] == "terminal"){	
			$_SESSION["sessao_campos_tipo"]["valor_campo"]["numero_teclas"] = $this->bd->obterValor($rs_aux,"numero_teclas");
		
			$mapa = new MapaTeclado();
			$resultado = $mapa->LerDados($id);
			$mapa->Fechar();
		}
		
		return $resultado;
	}
	
	
	/*
		Fun��o de leitura de campos comuns � categoria do tipo
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerCampos()
	{		
		$sql = "SHOW FULL COLUMNS FROM " . $_REQUEST["tipomod"];

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$numCampos = $this->bd->obterNumRegistos($rs);
		$campos_obrig = array();
		
		for($i = 1, $j = 1; $i < $numCampos; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			$comentario = $this->bd->obterValor($rs,"Comment");
			if($comentario != "") {
				$campos_obrig["campo_" . $j] = $comentario;
				$j++;
			}
		}
		$_SESSION["sessao_campos_obrig"] = $campos_obrig;
		
		$sql = "SHOW FULL COLUMNS FROM tipos_" . $_REQUEST["tipomod"];

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$numCampos = $this->bd->obterNumRegistos($rs);
		$campos_tipo = array();
		for($i = 1, $j = 1; $i < $numCampos; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			$comentario = $this->bd->obterValor($rs,"Comment");
			if($comentario != "") {
				$campos_tipo["nome_campo_" . $j] = $this->bd->obterValor($rs,"Field");
				$campos_tipo["campo_" . $j] = $comentario;
				$j++;
			}
		}
		$_SESSION["sessao_campos_tipo"] = $campos_tipo;
		
		return "ok";
	}

	/*
		Fun��o de edi��o

		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($dados, $id)
	{
		$nome_campos = array();
	
		$sql = "SHOW FULL COLUMNS FROM tipos_" . $_REQUEST["tipomod"];

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;


		$numCampos = $this->bd->obterNumRegistos($rs);
		
		for($i = 1; $i < $numCampos; $i++)
		{
			$this->bd->moverRegisto($rs,$i);
			if($this->bd->obterValor($rs,"Comment") != "") {
				array_push($nome_campos, $this->bd->obterValor($rs,"Field"));
			}
		}
		
		$sql = "SELECT nome_tabela ";
		
		if($_REQUEST["tipomod"] == "terminal")
			$sql .= ", numero_teclas";
		
		$sql .= " FROM tipos_". $_REQUEST["tipomod"]." ".
				"WHERE id_tipos_". $_REQUEST["tipomod"] . " = " . $id . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$tabela = $this->bd->obterValor($rs,0);
		if($_REQUEST["tipomod"] == "terminal")
			$num_antigo = $this->bd->obterValor($rs,"numero_teclas");
			
		
		$sql = "UPDATE tipos_" . $_REQUEST["tipomod"] . " SET ";
		
		if($_REQUEST["tipomod"] == "terminal")
			$sql .= "numero_teclas = ". $dados["numero_teclas"] .", ";
		
		for ($i = count($nome_campos)-1 ; $i > 0 ; $i--)
			$sql .= $nome_campos[$i] . "= '". $dados[$nome_campos[$i]] ."', ";
		if($i == 0)
			$sql .= $nome_campos[$i] . "= '". $dados[$nome_campos[$i]] ."' ";
			
		$sql .= " WHERE id_tipos_" . $_REQUEST["tipomod"] . " = " . $id . ";";

		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$numTotal = count($dados["nomes"]);
		$foreign_key = "";
		$sql = "";
		
		for($i = 0, $j=0; $i < $numTotal; $i++){
			
			$sql = "ALTER TABLE ".$tabela." 
					ADD COLUMN ";
			
			$sql_temp = "SELECT tipo, tamanho, largura, validacao FROM tipos_campos WHERE id_tipos_campos = " . $dados["tipos"][$i] . ";";
			if(!$rs = $this->bd->executarSQL($sql_temp))
				return 0;
						
			$tipo = $this->bd->obterValor($rs,"tipo");
			$sql .= trataString($dados["nomes"][$i]) . " " . $tipo;		
			if (strcasecmp($tipo,"mediumtext") != 0 && strcasecmp($tipo,"longtext") != 0 && strcasecmp($tipo,"date") != 0 && strcasecmp($tipo,"time") != 0)
			$sql .= "(" . $this->bd->obterValor($rs,"tamanho") . ")";
			
			if($dados["tipos"][$i] == 16)
				$sql .= " UNSIGNED";
			
			$sql .= " DEFAULT '". $dados["valores_omissao"][$i]."' ";
			$sql .= " COMMENT '" . $dados["nomes"][$i] . "," . $this->bd->obterValor($rs,"tamanho") . "," . $this->bd->obterValor($rs,"largura") . "," . $dados["tipos"][$i] . "," . $this->bd->obterValor($rs,"validacao") . "," . $dados["obrigs"][$i] .",0";
			
			if($dados["tipos"][$i]=="16"){
				$sql_temp = "SELECT codigo_tabela FROM campos_referencia 
							WHERE id_campo_referencia=".$dados["refs"][$j].";";
							
				if(!$rs = $this->bd->executarSQL($sql_temp))
					return 0;
					
				$sql .=	",". $dados["refs"][$j]."',
						ADD CONSTRAINT FOREIGN KEY (".trataString($dados["nomes"][$i]).") ".
						$this->bd->obterValor($rs,0)."; ";
					
				$j++;
			} 
			else
				$sql .= "'; "; 
				
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
		}
		
		$documento = abreXMLSync();
		$this->EscreveXMLSync($id, "editar", $documento, $_REQUEST["tipomod"], $dados);
	
		$objecto = new LogAccao();
		$rs = $objecto->Inserir("Edição", "Tipos de " . devolveTipo($_REQUEST["tipomod"]), $dados["nome"]);
		$objecto->fechar();
		
		if($_REQUEST["tipomod"] == "terminal"){
			$tipo_teclado = new TipoTeclado();
			$tipo_teclado->Editar($num_antigo, $dados["numero_teclas"], $documento);
			$tipo_teclado->Fechar();
			$mapa_teclado = new MapaTeclado();
			$mapa_teclado->Editar($dados["codigos"], $id, $dados["nome"], $documento);
			$mapa_teclado->Fechar();
		}
		
		fechaXMLsync($documento);
		
		return "ok";

	}

	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($id)
	{
		$numEntradas = count($id);
		$nomes = array();
		$teclas = array();
		$sql = "SELECT nome, nome_tabela ";
		
		if($_REQUEST["tipomod"] == "terminal")
			$sql .= ", numero_teclas";
			
		$sql .= " FROM tipos_" . $_REQUEST["tipomod"] . " WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_tipos_" . $_REQUEST["tipomod"] . " = " . $id[$i] . " OR ";
		$sql .= "id_tipos_" . $_REQUEST["tipomod"] . " = " . $id[0] . ";";

		if($rs = $this->bd->executarSQL($sql)) 
		{
			for($i = 0; $i < $numEntradas; $i++)
			{
				$this->bd->moverRegisto($rs,$i);
				array_push($nomes, $this->bd->obterValor($rs,"nome"));
				if($_REQUEST["tipomod"] == "terminal")
					array_push($teclas, $this->bd->obterValor($rs,"numero_teclas"));
					
				$sql = "DROP TABLE IF EXISTS " . $this->bd->obterValor($rs,"nome_tabela") . ";";
				if(!$rs_aux = $this->bd->executarSQL($sql))
					return 0;						
			}
		}
		else 
			return 0;
			
		$documento = abreXMLSync();
		$this->EscreveXMLSync($id, "remover", $documento, $_REQUEST["tipomod"]);
	
		$sql = "DELETE FROM tipos_" . $_REQUEST["tipomod"] . " WHERE ";

		for($i = $numEntradas; $i > 1; $i--)
			$sql .= "id_tipos_" . $_REQUEST["tipomod"] . " = ". $id[$i-1] . " OR ";
		$sql .= "id_tipos_" . $_REQUEST["tipomod"] . " = ". $id[0] . ";";

		if($rs = $this->bd->executarSQL($sql))
		{
			$objecto = new LogAccao();
			for($i = count($nomes)-1; $i >= 0; $i--)
				$rs = $objecto->Inserir("Remoção", "Tipos de " . devolveTipo($_REQUEST["tipomod"]), $nomes[$i]);
			$objecto->fechar();
			
			if($_REQUEST["tipomod"] == "terminal"){
				$tipo_teclado = new TipoTeclado();
				$tipo_teclado->Remover($teclas, $documento);
				$tipo_teclado->Fechar();
				$mapa_teclado = new MapaTeclado();
				$mapa_teclado->Remover($id, $nomes, $documento);
				$mapa_teclado->Fechar();
			}
			
			fechaXMLsync($documento);

			return "ok";
		}
		else
			return 0;	
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $documento, $modulo, $dados = null, $enderecos_lojas=null){
	
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM tipos_".$modulo." WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_tipos_".$modulo." = " . $id[$i] . " OR ";
		$sql .= "id_tipos_".$modulo." = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$raiz = $documento->firstChild;
		
		if(is_null($enderecos_lojas)){
			$loja = new Loja();
			$enderecos = $loja->listaIpLojas();
			//$loja->Fechar();
		} else {
			$enderecos = $enderecos_lojas;
		}
		
		if(count($enderecos) > 0){
			$destinos = $documento->createElement("destinos");
			$raiz->appendChild($destinos);
		}
		
		for($i = 0 ; $i < count($enderecos) ; $i++){
			$loja = $documento->createElement("loja");
			$loja->nodeValue = $enderecos[$i];
			$destinos->appendChild($loja);
		}
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		
		switch ($modulo){
			case 'terminal':
				$nome_elemento = "tipoTerminal";
				break;
			case 'impressora':
				$nome_elemento = "tiposImpressora";
				break;
			case 'dispensador':
				$nome_elemento = "tiposDispensador";
				break;
		}
		
		$nomes_tabelas = array();
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			array_push($nomes_tabelas, $this->bd->obterValor($rs, "nome_tabela"));
			
			$no_tipo = $documento->createElement($nome_elemento);
			$raiz->appendChild($no_tipo);
			
			$no_tipo->setAttribute("id", $this->bd->obterValor($rs, "id_tipos_".$modulo));
			$no_tipo->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("nome");
			$elemento->nodeValue = $this->bd->obterValor($rs, "nome");
			$no_tipo->appendChild($elemento);
			
			$elemento = $documento->createElement("nomeTabela");
			$elemento->nodeValue = $this->bd->obterValor($rs, "nome_tabela");
			$no_tipo->appendChild($elemento);
			
			$valor = $this->bd->obterValor($rs, "numero_teclas");
			if(isset($valor)){
				$elemento = $documento->createElement("numeroTeclas");
				$elemento->nodeValue = $valor;
				$no_tipo->appendChild($elemento);
			}
		}
		
		$num_tabelas = count($nomes_tabelas);
		
		for($i = 0 ; $i < $num_tabelas ; $i++){
			
			$no_tabela = $documento->createElement("tabelaTipo");
			$raiz->appendChild($no_tabela);
			
			$no_tabela->setAttribute("nomeTabela", $nomes_tabelas[$i]);
			$no_tabela->setAttribute("accao", $accao);
			
			if(!is_null($dados)){
				$num_campos = count($dados["nomes"]);
				
				for($j=0, $k=0 ; $j < $num_campos ; $j++){
					
					$no_campo = $documento->createElement("campoTabela");
					$no_tabela->appendChild($no_campo);
					
					$no_campo->setAttribute("idCampoTipo", $dados["tipos"][$j]);
					
					if($dados["tipos"][$j] == 16){
						$no_campo->setAttribute("idCampoReferencia", $dados["refs"][$k]);
						$k++;
					}
					
					if($dados["obrigs"][$j])
						$no_campo->setAttribute("obrigatorio", "true");
					else 
						$no_campo->setAttribute("obrigatorio", "false");
					
					if(isset($dados["valores_omissao"]))
						$no_campo->setAttribute("valorOmissao", $dados["valores_omissao"][$j]);
					
					$no_campo->nodeValue = $dados["nomes"][$j];
				}
			}
		}
	}
	
	/*
		Fun��o de listagem
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Listar()
	{
		$sql = "SELECT DISTINCT t.id_tipos_" . $_REQUEST["tipomod"] . ", t.nome 
				FROM tipos_" . $_REQUEST["tipomod"] . " t 
				WHERE t.id_tipos_" . $_REQUEST["tipomod"] . " <> 0 ";		

		if($_REQUEST["campo"] != "")	 
			$sql .= "ORDER BY " . $_REQUEST["campo"] . " ";		
		else			
			$sql .= "ORDER BY nome ";

		if($_REQUEST["ordem"] == 1)
			$sql .= "DESC";
		else 
			$sql .= "ASC";
		
		global $ERROS, $N_REGISTOS;
		if(!$rs = $this->bd->executarSQL($sql))
		{
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$n = 1;
		$numRegPag = $N_REGISTOS; // n�mero de registos por p�gina
		$numPaginas = 1; // n�mero de p�ginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // n�mero total registos
		
		// caso haja elimina��o de registos que dim�nua o n�mero de p�ginas
		if(($numTuplos/$numRegPag) <= ($_REQUEST["pagina"]-1))
			$_REQUEST["pagina"] -= 1;
		
		// caso n�o existam registos
		if($numTuplos == 0)
		{
			echo "<div class='empty_msg'>".translate('word_nao_existem', true) . "". translate('word_tipos_de', true)." " . devolveTipo($_REQUEST["tipomod"]) . " ". translate('word_registados_sietma', false)  ."!</div>";
			return;
		}
		
		// calculo do n�mero de p�ginas de registos
		if($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "	
		
		<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=tipos&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST["ordem"]  . "&tipomod=" . $_REQUEST["tipomod"] . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>													
				<tr>
					<td> 		
						<table class='data_table' cellspacing='0' cellpadding='0'>	
							<tr>
								<td class='button_page' colspan='3'><strong>". translate('word_pages', true)." </strong>";
					

					if($_REQUEST["pagina"] > 1)
					{
						$pagAnterior = $_REQUEST["pagina"] - 1;
						echo "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&tipomod=" . $_REQUEST['tipomod'] . "'><img alt='' src='../img/buttons/button_back.gif'></a> ";
					}
					else
					{
						$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}
										
					while($n <= $numPaginas)
					{
						if($n == $_REQUEST["pagina"])
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&tipomod=" . $_REQUEST['tipomod'] . "'><div class='current_page'>$n</div></a>";
						else 
							echo "<a href='?pagina=$n&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&tipomod=" . $_REQUEST['tipomod'] . "'><div class='other_page'>$n</div></a>";
						$n++;
					}

					$n = ($_REQUEST["pagina"] - 1)*$numRegPag;
					$incremento = $n;
										
					if($_REQUEST["pagina"] < $numPaginas)
					{
						$pagPosterior = $_REQUEST["pagina"] + 1;
						echo "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "&tipomod=" . $_REQUEST['tipomod'] . "'><img alt='' src='../img/buttons/button_forward.gif'></a> ";
					}
					else
					{
						if($numTuplos % $numRegPag != 0)
							$numRegPag = $numTuplos % $numRegPag;
						echo "<img alt='' src='../img/buttons/button_no_page.gif'>";
					}						
					
		echo "		</td>
				</tr>";				
					
		echo "<tr class='column_row'>
					<td width='8'>&nbsp;</td>";

		if (strcmp($_REQUEST["campo"],"nome") == 0)
				if ($_REQUEST["ordem"] == 1)
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0&tipomod=" . $_REQUEST['tipomod'] . "'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
				else
					echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1&tipomod=" . $_REQUEST['tipomod'] . "'><div". translate('word_name', true)."img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else 			
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0&tipomod=" . $_REQUEST['tipomod'] . "'><div". translate('word_name', true)."/div></a></td>";

		echo "<td width='135'>". translate('word_operations', true)."</td>								
				</tr>";	

		while($n < ($numRegPag + $incremento)) 
		{
			$this->bd->moverRegisto($rs,$n);

			echo"<tr>
					<td><input name='grupo' type='checkbox' value='" . $this->bd->obterValor($rs,"id_tipos_". $_REQUEST["tipomod"]) ."'/></td>
					<td>" . $this->bd->obterValor($rs,"nome") . "</td>
					<td>";
					
		if ( $_SESSION["sessao_perms"]["perm_tipos_".$_REQUEST["tipomod"]] == 2 ) {
		echo			"<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=tipos&id=" . $this->bd->obterValor($rs,"id_tipos_". $_REQUEST["tipomod"]) . "&tipomod=" . $_REQUEST["tipomod"] . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_edit', true) ."</div></a>
						<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=tipos&pagina=" . $_REQUEST["pagina"] . "&campo=" . $_REQUEST["campo"]  . "&ordem=" . $_REQUEST['ordem'] . "&id=" . $this->bd->obterValor($rs,"id_tipos_" . $_REQUEST["tipomod"]) . "&tipomod=" . $_REQUEST["tipomod"] . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>". translate('word_remove', true)."</div></a>";
		} else {
			echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=tipos&id=" . $this->bd->obterValor($rs,"id_tipos_". $_REQUEST["tipomod"]) . "&tipomod=" . $_REQUEST["tipomod"] . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>". translate('word_details', true)."</div></a>";
		}
			echo	"</td>							
				</tr>";
			
			$n++;
		} 		
		echo "			</table>
					</td>
				</tr>						 
				<tr>
					<td> 
						<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
					</td>
				</tr>";
	if ( $_SESSION["sessao_perms"]["perm_tipos_".$_REQUEST["tipomod"]] == 2 ) {
		echo	"<tr>
					<td class='button_large'>
						<div onClick='seleccionaCaixa(true)'>". translate('word_mark_all', true)."</div>
						<div onClick='seleccionaCaixa(false)'>". translate('word_unmark_all', true)."</div>
						<div onClick='removerMarcados(this);'>". translate('word_remove', true)."</div>
					</td>
				</tr>";
	}
	
	echo	"</table>
		</form>";		
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>