<?php
	
/* Classe de Gest�o de Configura��es de Teclados */

class TipoTeclado extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function TipoTeclado() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Fun��o de inser��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($num_teclas, $documento)
	{	
		$sql = "SELECT nome_tabela FROM tipos_teclado WHERE numero_teclas=".$num_teclas.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		if($this->bd->obterNumRegistos($rs) != 0)
			return "ok";

		$sql = "INSERT INTO tipos_teclado(nome_tabela, numero_teclas)
				VALUES ('teclado_".$num_teclas."', ".$num_teclas.");";
			
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$foreign_key = "";
		$sql= "CREATE TABLE IF NOT EXISTS teclado_".$num_teclas." (
			  		id_teclado_".$num_teclas." integer UNSIGNED NOT NULL auto_increment,
			  		id_teclado integer UNSIGNED NOT NULL, ";
        
		for ($i = 1 ; $i <= $num_teclas ; $i++){
			$sql .= "accao_tecla_".$i." integer UNSIGNED,";
			$sql .= "tipo_accao_".$i." tinyint UNSIGNED NOT NULL DEFAULT 0 ,";
			
			$foreign_key .= ", FOREIGN KEY (accao_tecla_".$i.") REFERENCES servicos (id_servico)
							ON UPDATE CASCADE ON DELETE SET NULL ";
		}
         
		$sql .= "PRIMARY KEY  (id_teclado_".$num_teclas."),
				FOREIGN KEY (id_teclado) REFERENCES teclado (id_teclado) ON UPDATE CASCADE ON DELETE CASCADE ";
				
		$sql .= $foreign_key;
			
		$sql .= " )
            ENGINE=INNODB DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci AUTO_INCREMENT=1;";
												
		if($rs = $this->bd->executarSQL($sql))
		{	
			$sql = "SELECT MAX(id_tipos_teclado) FROM tipos_teclado;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
			
			$this->EscreveXMLSync($this->bd->obterValor($rs, 0), "inserir", $documento);
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Tipos de Teclado", "Teclado ".$num_teclas);
			$objecto->fechar();
			return "ok";
		}
		else
			return 0;
	}

	/*
		Fun��o de edi��o
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($num_antigo, $num_novo, $documento)
	{
		if($num_antigo == $num_novo)
			return "ok";
	
		$num_remover = array();
		array_push($num_remover, $num_antigo);
		
		$objecto = new TipoTeclado();
		$rem = $objecto->Remover($num_remover, $documento);
		$objecto->Fechar();
		
		$objecto = new TipoTeclado();
		$ins = $objecto->Inserir($num_novo, $documento);
		$objecto->Fechar();
		
		if($rem == 0 || $ins == 0)
			return 0;
		else
			return "ok";

	}

	/*
		Fun��o de remo��o
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function Remover($num_teclas, $documento)
	{
		$numEntradas = count($num_teclas);
		
		for($i = $numEntradas-1; $i >= 0; $i--) {
		
			$sql = "SELECT id_tipos_teclado FROM tipos_teclado WHERE numero_teclas=".$num_teclas[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			if($this->bd->obterNumRegistos($rs) == 0)
				continue;
				
			$id_tipo = $this->bd->obterValor($rs, "id_tipos_teclado");
				
			$sql = "SELECT nome FROM tipos_terminal WHERE numero_teclas = ".$num_teclas[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			if($this->bd->obterNumRegistos($rs) != 0)
				continue;
				
			$this->EscreveXMLSync($id_tipo, "remover", $documento);
				
			$sql = "DROP TABLE IF EXISTS teclado_".$num_teclas[$i].";";
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "DELETE FROM tipos_teclado WHERE numero_teclas=".$num_teclas[$i].";";
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
			
			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Remoção", "Tipos de Teclado", "Teclado ".$num_teclas[$i]);
			$objecto->fechar();
		}			
		
		return "ok";
	}
	
	/*
		Procede � cria��o e escrita de um 
		ficheiro XML para as altera��es feitas
		serem replicadas pelas base de dados necess�rias
	*/
	
	function EscreveXMLSync($id, $accao, $documento){
		
		if(!is_array($id))
			$id = array($id);
		
		$numEntradas = count($id);
		
		$sql = "SELECT * FROM tipos_teclado WHERE ";
		for($i = $numEntradas-1; $i > 0; $i--)
			$sql .= "id_tipos_teclado = " . $id[$i] . " OR ";
		$sql .= "id_tipos_teclado = " . $id[0] . ";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;

		$raiz = $documento->firstChild;
		
		$numEntradas = $this->bd->obterNumRegistos($rs);
		$numero_teclas = array();
		
		for($i = 0 ; $i < $numEntradas ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			array_push($numero_teclas, $this->bd->obterValor($rs, "numero_teclas"));
			
			$no_tipo = $documento->createElement("tiposTeclado");
			$raiz->appendChild($no_tipo);
			
			$no_tipo->setAttribute("id", $this->bd->obterValor($rs, "id_tipos_teclado"));
			$no_tipo->setAttribute("accao", $accao);
			
			$elemento = $documento->createElement("nomeTabela");
			$elemento->nodeValue = $this->bd->obterValor($rs, "nome_tabela");
			$no_tipo->appendChild($elemento);
			
			$elemento = $documento->createElement("numeroTeclas");
			$elemento->nodeValue = $this->bd->obterValor($rs, "numero_teclas");
			$no_tipo->appendChild($elemento);			
		}
		
	}
	
	/*
		Destrutor da classe
		
		0 = Erro da BD
	*/		
	function Fechar()
	{
		$this->bd->fecharBD();
	}
}
?>