<?php
session_start();

require_once("../config.inc.php");

if($_SESSION["sessao_autenticado"] == 0)
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR);

if(!$_SESSION["sessao_perms"]["perm_tipos_utilizadores"])
    header("Location: http://" . $_SERVER['HTTP_HOST'] . $DIR ."/" );
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Zqueue - <?php   echo  translate('word_tipo_utilizador', false) ?></title>

        <link rel="stylesheet" type="text/css" media="screen" href="../css/estilo.css">

        <!-- Re-design -->
        <link rel="stylesheet" type="text/css" media="screen" href="../css/components/custom-form.css">

        <script type="text/javascript" src="<?php   echo getPathScriptJS("menu.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("validacoes.js"); ?>"></script>
        <script type="text/javascript" src="<?php   echo getPathScriptJS("funcoes.js"); ?>"></script>

    </head>
    <body>
        <?php
        include("../cabecalho.php");
        ?>

        <div class="full_area">
          <!-- Title + Description -->
          <div class="form-title">
            <h2 class="text-bold text-green-light"><?php   echo  translate('word_inserir_tipo_de', true) ?> Utilizador</h2>

            <!-- Extra description -->
            <div class="form-extra-desc text-bold text-gray-dark">
              <?php   echo  translate('word_por_favor_preencha_seguintes_campos_obrigatorios', false) ?>
              <font class="text-green-light">* </font>
              <?php   echo  translate('word_sao_preencimento_obrigatorio', false) ?>
            </div>
          </div>

          <!-- Main Table Content -->
          <div class="form-table-container">

            <div class="form-flex-container">
              <!-- form fields -->
              <table cellspacing="0" cellpadding="0">
                <tr>
                  <td width="">
                    <form class="form_template" action="../accoes_intermedias/accaoEditar.php?modulo=tipos_utilizadores&id=<?php  echo @$_REQUEST["id"];?>" method="post">
                      <div class="form_template_flex_container">
                        <!-- Form main table -->
                        <table id="form_table" cellspacing="0" cellpadding="0">
                          <!-- Name -->
                          <tr>
                            <!-- field name -->
                            <td class="formname_space">
                              <font class="text-green-light">* </font><?php   echo  translate('word_name', true) ?>
                            </td>
                            <!-- field input -->
                            <td class="input_space">
                              <input disabled id="nome" name="nome" type="text" maxlength="30" size="52" value="<?php  echo $_SESSION["sessao_campos"]["nome"]; ?>">

                              <!-- Error message -->
                              <span id="msg_nome" class="error_msg">&nbsp;</span>
                            </td>
                          </tr>

                        </table>

                      </div>

                      <table cellspacing="0" cellpadding="0">
                        <tr>
                          <td class="formname_space">
                            <?php   echo  translate('word_permissoes', false) ?>:
                          <td>
                            <!-- Selectable list -->
                            <div class="form-selectable-table">

                              <table id="form_table" class="data_table" cellspacing="0">
                                <!-- Header -->
                                <tr class='column_row'>
                                    <td>
                                        <div>Serviço</div>
                                    </td>
                                    <td>
                                        <div><?php   echo  translate('word_permissao_leitura', false) ?></div>
                                    </td>
                                    <td>
                                        <div><?php   echo  translate('word_permissao_para', false) ?> <?php   echo  translate('word_escrita', false) ?></div>
                                    </td>
                                </tr>

                                <!-- Entidades -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_servicos"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_entitys", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_entidade"] > 0)
                                        { ?>
                                        <label class='custom-check-container form-centered-check'>
                                          <input disabled name="grupo[]" type="checkbox" value="perm_entidade" checked id="perm_entidade"/>
                                          <span class='custom-checkmark'></span>
                                        </label>
                                            <?php  } else
                                        { ?>
                                        <label class='custom-check-container form-centered-check'>
                                          <input disabled name="grupo[]" type="checkbox" value="perm_entidade" id="perm_entidade"/>
                                          <span class='custom-checkmark'></span>
                                        </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_entidade"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_entidade'))" name="grupo[]" type="checkbox" value="perm_entidade_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_entidade'))" name="grupo[]" type="checkbox" value="perm_entidade_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Servicos -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_servicos"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_services", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_servicos"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_servicos" checked id="perm_servicos"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_servicos" id="perm_servicos"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_servicos"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_servicos'))" name="grupo[]" type="checkbox" value="perm_servicos_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_servicos'))" name="grupo[]" type="checkbox" value="perm_servicos_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Lojas -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_lojas"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_locals", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_lojas"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_lojas" checked id="perm_lojas"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_lojas" id="perm_lojas"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_lojas"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_lojas'))" name="grupo[]" type="checkbox" value="perm_lojas_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_lojas'))" name="grupo[]" type="checkbox" value="perm_lojas_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Dispensador -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_dispensador"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div> <?php   echo  translate('word_disp', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_dispensador"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_dispensador" checked id="perm_dispensador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_dispensador" id="perm_dispensador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_dispensador"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_dispensador'))" name="grupo[]" type="checkbox" value="perm_dispensador_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_dispensador'))" name="grupo[]" type="checkbox" value="perm_dispensador_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Servicos dispensador -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_servicos_dispensador"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div> <?php   echo  translate('word_services', true) ?> <?php   echo  translate('word_disp') ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_servicos_dispensador"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_servicos_dispensador" checked id="perm_servicos_dispensador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_servicos_dispensador" id="perm_servicos_dispensador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_servicos_dispensador"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_servicos_dispensador'))" name="grupo[]" type="checkbox" value="perm_servicos_dispensador_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_servicos_dispensador'))" name="grupo[]" type="checkbox" value="perm_servicos_dispensador_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Ecra -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_ecra"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div> <?php   echo  translate("word_ecra", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_ecra"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_ecra" checked id="perm_ecra"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_ecra" id="perm_ecra"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_ecra"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_ecra'))" name="grupo[]" type="checkbox" value="perm_ecra_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_ecra'))" name="grupo[]" type="checkbox" value="perm_ecra_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <?php  if (SMS)  { ?>
                                  <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_sms"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div> <?php   echo  translate("word_sms", true) ?></div></td>
                                    <td class="form-data-td">
                                            <?php  if($_SESSION["sessao_campos"]["perm_sms"] > 0)
                                            { ?>
                                              <label class='custom-check-container form-centered-check'>
                                                    <input disabled name="grupo[]" type="checkbox" value="perm_sms" checked id="perm_sms"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                                <?php  } else
                                            { ?>
                                              <label class='custom-check-container form-centered-check'>
                                                    <input disabled name="grupo[]" type="checkbox" value="perm_sms" id="perm_sms"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                                <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                            <?php  if($_SESSION["sessao_campos"]["perm_sms"] > 1)
                                            { ?>
                                              <label class='custom-check-container form-centered-check'>
                                                    <input disabled etElementById('perm_sms'))" name="grupo[]" type="checkbox" value="perm_sms_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                                <?php  } else
                                            { ?>
                                              <label class='custom-check-container form-centered-check'>
                                                    <input disabled etElementById('perm_sms'))" name="grupo[]" type="checkbox" value="perm_sms_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                                <?php  } ?>
                                    </td>
                                </tr>
                                <?php  }  ?>
                                <?php  if (CONTENTS) { ?>
                                  <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_conteudos"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div> <?php   echo  translate("word_contents", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_conteudos"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_conteudos" checked id="perm_conteudos"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_conteudos" id="perm_conteudos"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_conteudos"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_conteudos'))" name="grupo[]" type="checkbox" value="perm_conteudos_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_conteudos'))" name="grupo[]" type="checkbox" value="perm_conteudos_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>
                                <?php  } ?>

                                <!-- Utilizadores -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_utilizadores"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_managers', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_utilizadores"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_utilizadores" checked id="perm_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_utilizadores" id="perm_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_utilizadores"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_utilizadores'))" name="grupo[]" type="checkbox" value="perm_utilizadores_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_utilizadores'))" name="grupo[]" type="checkbox" value="perm_utilizadores_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Empregados -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_empregados"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_costumers", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_empregados"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_empregados" checked id="perm_empregados"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_empregados" id="perm_empregados"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_empregados"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_empregados'))" name="grupo[]" type="checkbox" value="perm_empregados_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_empregados'))" name="grupo[]" type="checkbox" value="perm_empregados_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Balcoes -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_balcoes"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_agencies', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_balcoes"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_balcoes" checked id="perm_balcoes"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_balcoes" id="perm_balcoes"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_balcoes"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_balcoes'))" name="grupo[]" type="checkbox" value="perm_balcoes_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_balcoes'))" name="grupo[]" type="checkbox" value="perm_balcoes_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Horarios -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_horarios"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_schedule', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_horarios"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_horarios" checked id="perm_horarios"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_horarios" id="perm_horarios"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_horarios"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_horarios'))" name="grupo[]" type="checkbox" value="perm_horarios_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_horarios'))" name="grupo[]" type="checkbox" value="perm_horarios_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Forms -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_forms"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_forms', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_forms"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_forms" checked id="perm_forms"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_forms" id="perm_forms"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_forms"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_forms'))" name="grupo[]" type="checkbox" value="perm_forms_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_forms'))" name="grupo[]" type="checkbox" value="perm_forms_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Tipos Utilizadorez -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_tipos_utilizadores"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_tipos_de', true)  ?> <?php   echo  translate('word_utilizadores', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_utilizadores"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_utilizadores" checked id="perm_tipos_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_utilizadores" id="perm_tipos_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_utilizadores"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_utilizadores'))" name="grupo[]" type="checkbox" value="perm_tipos_utilizadores_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_utilizadores'))" name="grupo[]" type="checkbox" value="perm_tipos_utilizadores_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Tipos processadores -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_tipos_processador"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_tipo_processador', true)?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_processador"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_processador" checked id="perm_tipos_processador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_processador" id="perm_tipos_processador"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_processador"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_processador'))" name="grupo[]" type="checkbox" value="perm_tipos_processador_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_processador'))" name="grupo[]" type="checkbox" value="perm_tipos_processador_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Tipos impressoras -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_tipos_impressora"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_tipo_impressora', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_impressora"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_impressora" checked id="perm_tipos_impressora"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_impressora" id="perm_tipos_impressora"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_impressora"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_impressora'))" name="grupo[]" type="checkbox" value="perm_tipos_impressora_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_impressora'))" name="grupo[]" type="checkbox" value="perm_tipos_impressora_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Tipos ecras -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_tipos_ecra"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_tipo_ecra', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_ecra"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_ecra" checked id="perm_tipos_ecra"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_tipos_ecra" id="perm_tipos_ecra"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  }  ?>
                                    </td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_tipos_ecra"] > 1)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_ecra'))" name="grupo[]" type="checkbox" value="perm_tipos_ecra_esc" checked/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled etElementById('perm_tipos_ecra'))" name="grupo[]" type="checkbox" value="perm_tipos_ecra_esc"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                </tr>

                                <!-- Estatisticas -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_estatisticas"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_statistics", true) ?> </div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_estatisticas"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_estatisticas" checked id="perm_estatisticas"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_estatisticas" id="perm_estatisticas"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Logs acoes -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_log_accoes"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_actions', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_log_accoes"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_accoes" checked id="perm_log_accoes"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_accoes" id="perm_log_accoes"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Logs acessos users -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_log_acessos_utilizadores"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_access', true) ?> <?php   echo  translate('word_managers', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_log_acessos_utilizadores"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_acessos_utilizadores" checked id="perm_log_acessos_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_acessos_utilizadores" id="perm_log_acessos_utilizadores"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Logs acessos empregados -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_log_acessos_empregados"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate('word_access', true) ?> <?php   echo  translate("word_costumers", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_log_acessos_empregados"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_acessos_empregados" checked id="perm_log_acessos_empregados"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_log_acessos_empregados" id="perm_log_acessos_empregados"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Resumo servicos -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_resumo_servico"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_resume", true) ?> <?php   echo  translate('word_by')?> <?php   echo  translate("word_service", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_resumo_servico"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_servico" checked id="perm_resumo_servico"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_servico" id="perm_resumo_servico"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Resumo empregados -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_resumo_empregado"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_resume", true) ?> <?php   echo  translate('word_by')?> <?php   echo  translate('word_costumer', true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_resumo_empregado"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_empregado" checked id="perm_resumo_empregado"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_empregado" id="perm_resumo_empregado"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Resumo sistema -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_resumo_sistema"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_resume", true) ?> <?php   echo  translate("word_do", true) ?> <?php   echo  translate("word_system", true) ?></div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_resumo_sistema"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_sistema" checked id="perm_resumo_sistema"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_resumo_sistema" id="perm_resumo_sistema"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                                <!-- Exports -->
                                <tr class="form-data-tr <?php   if($_SESSION["sessao_campos"]["perm_exports"] > 0) echo "form-tr-selected"; ?>">
                                    <td class="form-data-td form-select-td-padding"><div><?php   echo  translate("word_exports", true) ?> </div></td>
                                    <td class="form-data-td">
                                        <?php  if($_SESSION["sessao_campos"]["perm_exports"] > 0)
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_exports" checked id="perm_exports"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } else
                                        { ?>
                                          <label class='custom-check-container form-centered-check'>
                                                <input disabled name="grupo[]" type="checkbox" value="perm_exports" id="perm_exports"/>
                                            <span class='custom-checkmark'></span>
                                          </label>
                                            <?php  } ?>
                                    </td>
                                    <td class="form-data-td"></td>
                                </tr>

                              </table>

                            </div>
                          </td>
                        </tr>

                        <!-- Buttons -->
                        <tr class="form-tr-buttons-container">

                          <td class="button">
                            <a  href="javascript:history.back()"><div class="button-thin-green"><?php   echo  translate('word_cancel', true) ?></div></a>
                          </td>


                        </tr>
                      </table>


                    </form>
                  </td>
                </tr>
              </table>

            </div>

            <!-- Form Error -->
            <div class="form-error-session">
              <span id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></span>
            </div>

          </div>

        </div>

        <table class="full_area" cellpadding="0" cellspacing="0" style="display:none">
            <tr>
                <td>&nbsp;</td>
                <td class="content">
                    <table class="title_space" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="module_space" width="380">
                                <?php   echo  translate('word_detalhes_de', true) ?> <?php   echo  translate('word_tipo_utilizador', false) ?> </td>
                            <td class="function_space" width="110">
                            </td>
                            <td class="function_space" width="120">
                            </td>
                            <td class="function_space" width="160">
                                <a class="function" href="index.php"><div><?php   echo  translate('word_prev', true) ?></div><img alt="Recuar" src="../img/buttons/button_back.gif"></a>
                            </td>
                        </tr>
                    </table>
                    <table width="770" cellspacing="0" cellpadding="0">
                        <tr>
                            <td class="bg_form_left">&nbsp;</td>
                            <td width="758">
                                <form class="form_template" id='lista' action="../accoes_intermedias/accaoEditar.php?modulo=tipos_utilizadores&id=<?php  echo $_REQUEST["id"];?>" method="post">
                                    <table id="form_table" cellspacing="0" cellpadding="0">
                                        <tr>
                                            <td class="question_space" colspan="2">

                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_space">
                                                <?php   echo  translate('word_name', true) ?>:&nbsp;
                                            </td>
                                            <td class="input disabled_space">
                                                <input id="nome" name="nome" type="text" maxlength="30" size="52" value="<?php  echo $_SESSION["sessao_campos"]["nome"]; ?>" readonly>
                                                <span id="msg_nome" class="error_msg">&nbsp;</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="formname_type">
                                                <?php   echo  translate('word_permissoes', false) ?>:&nbsp;
                                            </td>
                                            <td class="input disabled_space_type">
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <table class='data_table' cellspacing='0' cellpadding='0'>

                                                    <tr class='column_row'>
                                                        <td class='column_cell'>
                                                            <div></div>
                                                        </td>
                                                        <td class='column_cell'>
                                                            <div><?php   echo  translate('word_permissao_leitura', false) ?></div>
                                                        </td>
                                                        <td class='column_cell'>
                                                            <div><?php   echo  translate('word_permissao_para', false) ?> <?php   echo  translate('word_escrita', false) ?></div>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_entitys", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_entidade"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_entidade" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_entidade"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_entidade"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_entidade_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_entidade_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_services", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_servicos"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_servicos" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_servicos"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_servicos"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_servicos_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_servicos_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_locals", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_lojas"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_lojas" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_lojas"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_lojas"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_lojas_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_lojas_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"> <?php   echo  translate('word_disp', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_dispensador"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_dispensador" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_dispensador"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_dispensador"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_dispensador_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_dispensador_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"> <?php   echo  translate("word_ecra", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_ecra"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_ecra" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_ecra"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_ecra"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_ecra_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_ecra_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <?php 
                                                    if (SMS)
                                                    {
                                                        ?>
                                                    <tr>
                                                        <td><div align="left"> <?php   echo  translate("word_sms", true) ?></div></td>
                                                        <td>
                                                                <?php  if($_SESSION["sessao_campos"]["perm_sms"] > 0)
                                                                { ?>
                                                            <input disabled name="grupo[]" type="checkbox" value="perm_sms" checked/>
                                                                    <?php  } else
                                                                { ?>
                                                            <input disabled name="grupo[]" type="checkbox" value="perm_sms"/>
                                                                    <?php  } ?>
                                                        </td>
                                                        <td>
                                                                <?php  if($_SESSION["sessao_campos"]["perm_sms"] > 1)
                                                                { ?>
                                                            <input disabled name="grupo[]" type="checkbox" value="perm_sms_esc" checked/>
                                                                    <?php  } else
                                                                { ?>
                                                            <input disabled name="grupo[]" type="checkbox" value="perm_sms_esc"/>
                                                                    <?php  } ?>
                                                        </td>
                                                    </tr>
                                                        <?php 
                                                    }

                                                    if (CONTENTS)
                                                    {
                                                        ?>
                                                    <tr>
                                                        <td><div align="left"> <?php   echo  translate("word_contents", true) ?></div></td>
                                                        <td>
                                                                <?php  if($_SESSION["sessao_campos"]["perm_conteudos"] > 0)
                                                                { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_conteudos" checked/>
                                                                    <?php  } else
                                                                { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_conteudos"/>
                                                                    <?php  } ?>
                                                        </td>
                                                        <td>
                                                                <?php  if($_SESSION["sessao_campos"]["perm_conteudos"] > 1)
                                                                { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_conteudos_esc" checked/>
                                                                    <?php  } else
                                                                { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_conteudos_esc"/>
                                                                    <?php  } ?>
                                                        </td>
                                                    </tr>
                                                        <?php 
                                                    }
                                                    ?>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_managers', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_utilizadores"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_utilizadores" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_utilizadores"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_utilizadores"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_utilizadores_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_utilizadores_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_costumers", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_empregados"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_empregados" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_empregados"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_empregados"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_empregados_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_empregados_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_agencies', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_balcoes"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_balcoes" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_balcoes"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_balcoes"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_balcoes_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_balcoes_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_schedule', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_horarios"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_horarios" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_horarios"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_horarios"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_horarios_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_horarios_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_forms', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_forms"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_forms" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_forms"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_forms"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_forms_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_forms_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_tipos_de', true)  ?> <?php   echo  translate('word_utilizadores', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_utilizadores"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_utilizadores" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_utilizadores"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_utilizadores"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_utilizadores_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_utilizadores_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_tipo_processador', true)?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_processador"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_processador" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_processador"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_processador"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_processador_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_processador_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_tipo_impressora', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_impressora"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_impressora" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_impressora"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_impressora"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_impressora_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_impressora_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    <tr/>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_tipo_ecra', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_ecra"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_ecra" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_ecra"/>
                                                                <?php  } ?>
                                                        </td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_tipos_ecra"] > 1)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_ecra_esc" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_tipos_ecra_esc"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_statistics", true) ?> </div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_estatisticas"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_estatisticas" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_estatisticas"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_actions', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_log_accoes"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_accoes" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_accoes"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_access', true) ?> <?php   echo  translate('word_managers', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_log_acessos_utilizadores"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_acessos_utilizadores" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_acessos_utilizadores"/>
                                                                <?php  } ?>
                                                        </td>
                                                    <tr/>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate('word_access', true) ?> <?php   echo  translate("word_costumers", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_log_acessos_empregados"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_acessos_empregados" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_log_acessos_empregados"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_resume", true) ?> <?php   echo  translate('word_by')?> <?php   echo  translate("word_service", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_resumo_servico"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_servico" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_servico"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_resume", true) ?> <?php   echo  translate('word_by')?> <?php   echo  translate('word_costumer', true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_resumo_empregado"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_empregado" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_empregado"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_resume", true) ?> <?php   echo  translate("word_do", true) ?> <?php   echo  translate("word_system", true) ?></div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_resumo_sistema"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_sistema" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_resumo_sistema"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td><div align="left"><?php   echo  translate("word_exports", true) ?> </div></td>
                                                        <td>
                                                            <?php  if($_SESSION["sessao_campos"]["perm_exports"] > 0)
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_exports" checked/>
                                                                <?php  } else
                                                            { ?>
                                                            <input disabled  name="grupo[]" type="checkbox" value="perm_exports"/>
                                                                <?php  } ?>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2">
                                                <div id="msg_erro" class="error_space">&nbsp;<?php  echo $_SESSION["sessao_msg"]; ?></div>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class='button_large' colspan="2">
                                                <a href="javascript:history.back()"><div><?php   echo  translate('word_back', true) ?></div></a>
                                            </td>
                                        </tr>

                                    </table>
                                </form>
                            </td>
                            <td class="bg_form_right">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="bg_form_bottom" colspan="3">&nbsp;</td>
                        </tr>
                    </table>
                </td>
                <td>&nbsp;</td>
            </tr>
        </table>

        <?php
        $_SESSION["sessao_msg"] = "&nbsp;"; // limpa a variavel que guarda a ultima mensagem de erro
        ?>

        <?php
        include("../rodape.php");
        ?>
