<?php

/* Classe de Gest�o de Utilizadores */

class Utilizador extends AcessoBD {

	var $bd;

	/*
	  Construtor da classe

	  0 = Erro da BD
	 */

	function Utilizador() {
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}

	/*
	  Fun��o que verifica a autentica��o do utilizador

	  0 = Erro da BD
	  1 = Erro Utilizador
	  2 = Erro Chave
	  3 = Erro Tentativas
	  4 = Erro Inactivo
	  true = Sucesso
	 */

	function VerificarUtilizador($utilizador, $chave) {

		$sql = "SELECT * FROM utilizadores WHERE nome_utilizador='$utilizador';";

		$id_loja = array();
		$id_entidade = array();
		$nome_entidade = array();
		if ($rs = $this->bd->executarSQL($sql)) {
			$tuplo = $this->bd->obterRegisto($rs);

			$id_utilizador = $tuplo["id_utilizadores"];
			$id_tipo_utilizador = $tuplo["id_tipos_utilizadores"];
			$nome = $tuplo["nome"];

			if ($tuplo) {

				$num_tentativas = $tuplo["num_tentativas"];
				$blocked = false;
				if ($num_tentativas > 1000) {
					// $num_tentativas is a timestamp that indicates when the user was blocked
					if (time() < $num_tentativas + WRONG_PASS_BLOCK_TIME) {
						$blocked = true;
					}
				}


				if (!$blocked) {
					global $TRINCO;

					$sql = "SELECT * FROM utilizadores WHERE palavra_chave = '" . $tuplo["palavra_chave"] . "';";
					if (!$rs = $this->bd->executarSQL($sql))
						return 0;

					$rs = $this->bd->obterRegisto($rs);

					$num_tentativas++;

					//$temp = $tuplo["palavra_chave"] . " e " . $rs[0] . " e " . $chave;
					//debug($temp);
					//if (strcasecmp($tuplo["palavra_chave"], $chave) == 0) { // 0 caso sejam iguais
					if (password_verify($chave, $tuplo["palavra_chave"])) {
						if ($tuplo["estado"] == 3) { // verifica se o utilizador est� inactivo
							return 4;
						}
						$_SESSION["sessao_nome"] = $nome;

						if ($num_tentativas != 1) { // verifica se � necess�rio actualizar o n�mero de tentativas para 0
							$sql = "UPDATE utilizadores SET num_tentativas=0, estado=1 WHERE id_utilizadores=" . $id_utilizador . ";";

							if (!$rs = $this->bd->executarSQL($sql)) {
								return 0;
							}
						}

						$sql = "SELECT * FROM tipos_utilizadores WHERE id_tipos_utilizadores=" . $id_tipo_utilizador . ";";

						if ($rs = $this->bd->executarSQL($sql)) {
							$tuplo = $this->bd->obterRegisto($rs);
							$_SESSION["sessao_tipo"] = $tuplo["nome"];

							$sql_ent = "SELECT e.id_entidade , e.nome FROM utilizadores_entidades ue , entidades e
								WHERE ue.id_entidade = e.id_entidade AND ue.id_utilizadores = " . $id_utilizador . ";";
							if (!$rs_e = $this->bd->executarSQL($sql_ent)) {
								return 0;
							}

							$id_entidade = array();
							$nome_entidade = array();
        					while ($row = $this->bd->obterRegisto($rs_e)) {
        						array_push($id_entidade,$row["id_entidade"]);
        						array_push($nome_entidade,$row["nome"]);
        					}


							/*$num_entidade = $this->bd->obterNumRegistos($rs_e);
							for ($i = 0; $i < $num_entidade; $i++) {
								$this->bd->moverRegisto($rs_e, $i);
								    
								$id_entidade[$i] = $this->bd->obterValor($rs_e, "id_entidade");
								$nome_entidade[$i] = $this->bd->obterValor($rs_e, "nome");
							}*/
								
							$sql_l = "SELECT e.id_loja , e.nome FROM utilizadores_lojas ue , lojas e
								WHERE ue.id_loja = e.id_loja AND ue.id_utilizadores = " . $id_utilizador . ";";
							if (!$rs_l = $this->bd->executarSQL($sql_l)) {
								return 0;
							}
							$id_loja = array();
							while ($row = $this->bd->obterRegisto($rs_l)) {
        						array_push($id_loja,$row["id_loja"]);
        					}
							/*$num_lojas = $this->bd->obterNumRegistos($rs_l);
							for ($i = 0; $i < $num_lojas; $i++) {
								$this->bd->moverRegisto($rs_l, $i);
								$id_loja[$i] = $this->bd->obterValor($rs_l, "id_loja");
							}*/

							/* $nPerm = count($rs);
							  $perms = array();

							  for($i = 2; $i < $nPerm; $i++)
							  array_push($perms, $tuplo[$i]);

							  $_SESSION["sessao_perms"] = $perms; */
							$_SESSION["sessao_perms"] = $tuplo;
							//					file_put_contents("/tmp/debug.txt" , 	"perm  ".$tuplo["all_perm"]."\n",FILE_APPEND);
						} else {
							return 0;
						}

						$_SESSION["sessao_id_utilizador"] = $id_utilizador;
						if ($tuplo["all_perm"] == 1) {
							$_SESSION["super_user"] = $tuplo["all_perm"];
						}
						$_SESSION["sessao_autenticado"] = 1;

						global $LANG;
						$_SESSION["sessao_lang_correcta"] = $LANG;
						$_SESSION["langArray"] = array();

						if (count($id_loja) == 0 && count($id_entidade) == 0) {
							$lojas = new Loja();
							$id_loja = $lojas->obterDados();
							$lojas->Fechar();
							$entidades = new Entidade();
							$res = $entidades->obterDados();

							for ($i = 0; $i < count($res); $i++) {
								$id_entidade[$i] = $res[$i]["id_entidade"];
								$nome_entidade[$i] = $res[$i]["nome"];
							}
							$entidades->Fechar();
						}

			       
			            
						$_SESSION["entidade"] = $id_entidade;
						if ($_SESSION["entidade"] == null) {
							$_SESSION["entidade"] = array();
						}
						$_SESSION["loja"] = $id_loja;
						if ($_SESSION["loja"] == null) {
							$_SESSION["loja"] = array();
						}
						$_SESSION["nome_entidade"] = $nome_entidade;
						if ($_SESSION["nome_entidade"] == null) {
							$_SESSION["nome_entidade"] = array();
						}

						return "ok";
					} else {
						$sql = "UPDATE utilizadores SET num_tentativas=" . $num_tentativas . " WHERE id_utilizadores = " . $id_utilizador . " ;";

						if (!$rs = $this->bd->executarSQL($sql)) {
							return 0;
						}

						if ($num_tentativas < 3) { // verifica se n�o atingiu o n�mero m�ximo de tentativas
							return 2;
						} else {
							$sql = "UPDATE utilizadores SET num_tentativas=".time().", estado='2' WHERE id_utilizadores=" . $id_utilizador . ";";
							if ($rs = $this->bd->executarSQL($sql)) {
								return 3;
							} else {
								return 0;
							}
						}
					}
				} else {
					return 3;
				}
			} else {
				return 1;
			}
		} else {
			return 0; // e' aki taky
		}
	}

	/*
	  Fun��o de Inserção

	  0 = Erro da BD
	  5 = Erro Existente
	  true = Sucesso
	 */

	function Inserir($dados) {
		if ($dados["tipos_utilizadores"] == '') {
			$dados["tipos_utilizadores"] = 2;
		}
		/* 		else{
		  $dados["lojas"] = setAdministrador("id_loja" , "lojas");
		  $dados["entidades"] = setAdministrador("id_entidade" , "entidades");

		  }
		 */
		$sql = "INSERT INTO utilizadores (id_tipos_utilizadores, nome, nome_utilizador, palavra_chave, estado) VALUES ('"
				. $dados["tipos_utilizadores"] . "', '"
				. $dados["nome"] . "', '"
				. $dados["nome_utilizador"] . "', '"
				. password_hash($dados["palavra_chave"], PASSWORD_BCRYPT) . "' ,'"
				. $dados["estado"] . "');";

		if ($rs = $this->bd->executarSQL($sql)) {


			$sql = "SELECT MAX(id_utilizadores) as max FROM utilizadores;";

			/*if (!$rs = $this->bd->executarSQL($sql)) {
				return 0;
			}

			//$num_util = $this->bd->obterNUmRegistos($rs);
			$id = $this->bd->obterValor($rs, 0);
			*/
			$res = $this->bd->getRows($sql);
            $id = $res[0]["max"];
			if($id == 0)
				return 0;
			/* id_hist */
			$sql = "insert into id_hist (id, name, type) values (
                    " . $id . ",
                    '" . $dados["nome"] . "',
                    'utilizador')";
			if (!$rs = $this->bd->executarSQL($sql)) {
				return 0;
			}

			$objecto = new LogAccao();
			$rs = $objecto->Inserir("Inserção", "Utilizador", $dados["nome"]);
			$objecto->fechar();
		} else {
			return 0;
		}

		if ($dados["tipos_utilizadores"] == 1) {

			$obj = new Loja();
			$dados["lojas"] = $obj->obterDados();
			$obj->Fechar();
			$obj = new Entidade();
			$res = $obj->obterDados();
			$obj->Fechar();
			$entidades = array();
			for ($i = 0; $i < count($res); $i++)
				$dados["entidades"][$i] = $res[$i]["id_entidade"];
		}


		$oggetto1 = new UtilizadorEntidade();
		$ris = $oggetto1->Inserir($id, $dados["entidades"]);
		$oggetto1->fechar();
		$oggetto = new UtilizadorLoja();
		$ris = $oggetto->Inserir($id, $dados["lojas"]);
		$oggetto->fechar();


		return "ok";
	}

	function setAdministrador($id, $tabela) {


		$sql = "select " . $id . " from " . $nome . ";";
		if (!$rs = $this->bd->executarSQL($sql))
			return 0;


		$tuplo = $this->bd->obterRegisto($rs);
		return $tuplo;
	}

	/*
	  Fun��o de leitura de dados

	  0 = Erro da BD
	  true = Sucesso
	 */

	function LerDados($id) {
		$sql = "SELECT * FROM utilizadores WHERE id_utilizadores = " . $id . ";";
		if (!$rs = $this->bd->executarSQL($sql))
			return 0;

		$tuplo = $this->bd->moverRegisto($rs, 0);
		$_SESSION["sessao_campos"] = $this->bd->obterRegisto($rs);

		//obter os dados das entidades associada ao utilizador
		$obj = new UtilizadorEntidade();
		$ris = $obj->LerDados($id);
		$obj->fechar();

		//obter os dados das lojas associada ao utilizador
		$obj = new UtilizadorLoja();
		$ris = $obj->LerDados($id);
		$obj->fechar();

		return "ok";
	}

	/*
	  Fun��o de Edição

	  0 = Erro da BD
	  5 = Erro Existente
	  true = Sucesso
	 */

	function Editar($dados, $id) {
		$oldInfo = $_SESSION["sessao_campos"];
		$newInfo = $dados;
		$labels = array(
			"estado" => translate("word_state", true),
			"nome" => translate("word_name", true),
			"nome_utilizador" => translate("word_user_name", true),
			"palavra_chave" => translate("word_pass", true));

		if ($dados["tipos_utilizadores"] == '')
			$dados["tipos_utilizadores"] = 2;

		if($dados["palavra_chave"] == "")
            $dados["palavra_chave"] = "null";
		else {
                $sql = "SELECT palavra_chave FROM utilizadores WHERE  id_utilizadores=".$id;;
                $rs = $this->bd->executarSQL($sql);
                $tuplo = $this->bd->obterRegisto($rs);
                $old_password = $tuplo["palavra_chave"];
                if($old_password != $dados["palavra_chave"]) {
                    $dados["palavra_chave"] = password_hash($dados["palavra_chave"], PASSWORD_BCRYPT);
                }
            }

		$sql = "UPDATE utilizadores SET nome = '" . $dados["nome"] . "',
			nome_utilizador = '" . $dados["nome_utilizador"] . "',
			palavra_chave = '" . $dados["palavra_chave"] . "' ,
			estado = '" . $dados["estado"] . "',";
		if ($dados["estado"] = 1)
			$sql .= "num_tentativas = '0',";
		$sql .= "id_tipos_utilizadores = '" . $dados["tipos_utilizadores"] . "'
			WHERE id_utilizadores = " . $id . " ;";

		if ($rs = $this->bd->executarSQL($sql)) {
			/* id_hist */
			$sql = "update id_hist
                set name='" . $dados["nome"] . "'
                where id=" . $id . "
                and type='utilizador'";
			if (!$rs = $this->bd->executarSQL($sql)) {
				return 0;
			}

			/*if ($dados["tipos_utilizadores"] == 1) {
				$obj = new Loja();
				$dados["lojas"] = $obj->obterDados();
				$obj->Fechar();
				$obj = new Entidade();
				$res = $obj->obterDados();
				$obj->Fechar();
				$entidades = array();
				for ($i = 0; $i < count($res); $i++)
					$dados["entidades"][$i] = $res[$i]["id_entidade"];
			}*/

			$o = new UtilizadorEntidade();

			$ris = $o->Editar($id, $dados["entidades"]);
			$o->fechar();

			$o = new UtilizadorLoja();
			$ris = $o->Editar($id, $dados["lojas"]);
			$o->fechar();

			$objecto = new LogAccao();

			$oldInfo['id_utilizadores'] = null;
			$oldInfo['id_tipos_utilizadores'] = null;
			if ($oldInfo['palavra_chave'] != $newInfo['palavra_chave']) {
				$oldInfo['palavra_chave'] = '****';
				$newInfo['palavra_chave'] = '*****';
			}
			$diff = my_array_diff_values($oldInfo, $newInfo, $labels);

			// Faz o mesmo para as entidades
			$locaisOld = $oldInfo['lojas'];
			$EntidadesOld = $oldInfo['entidades'];
			$locaisNew = $dados['lojas'];
			$EntidadesNew = $dados['entidades'];
			//$diffServicos = my_array_diff_values4($locaisOld,$locaisNew,$EntidadesOld,$EntidadesNew);

			$msg = "<table><tr><td colspan=3 align=left><b>$newInfo[nome]</b></td></tr>";
			$msg .= action_msg_info($diff, false, 'gestores');
			//$msg .= action_msg_info($diffServicos,false,'gestores');
			$msg .= "</table>";

			$rs = $objecto->Inserir("Edição", "Utilizador", $msg);
			$objecto->fechar();
			return "ok";
		}
		else
			return 0;
	}

	/*
	  Fun��o de Remoção

	  0 = Erro da BD
	  true = Sucesso
	 */

	function Remover($id) {
		/*
		  utilizadores
		  utilizadores_entidades
		  utilizadores_lojas
		 */

		$numEntradas = count($id);
		$nomes = array();
		$sql = "SELECT nome FROM utilizadores WHERE ";
		for ($i = $numEntradas - 1; $i > 0; $i--)
			$sql .= "id_utilizadores = " . $id[$i] . " OR ";
		$sql .= "id_utilizadores = " . $id[0] . ";";

		if ($rs = $this->bd->executarSQL($sql)) {
			for ($i = 0; $i < $numEntradas; $i++) {
				$this->bd->moverRegisto($rs, $i);
				array_push($nomes, $this->bd->obterValor($rs, "nome"));
			}
		} else {
			return 0;
		}

		$sql = "delete from utilizadores_lojas where id_utilizadores='" . $id[0] . "'";
		for ($i = 1; $i < count($id); $i++) {
			$sql .= " or id_utilizadores='" . $id[$i] . "'";
		}
		if (!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}

		$sql = "delete from utilizadores_entidades where id_utilizadores='" . $id[0] . "'";
		for ($i = 1; $i < count($id); $i++) {
			$sql .= " or id_utilizadores='" . $id[$i] . "'";
		}
		if (!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}

		$sql = "delete from utilizadores where id_utilizadores='" . $id[0] . "'";
		for ($i = 1; $i < count($id); $i++) {
			$sql .= " or id_utilizadores='" . $id[$i] . "'";
		}
		if (!$rs = $this->bd->executarSQL($sql)) {
			return 0;
		}

		$objecto = new LogAccao();
		for ($i = count($nomes) - 1; $i >= 0; $i--) {
			$rs = $objecto->Inserir("Remoção", "Utilizador", $nomes[$i]);
		}
		$objecto->fechar();
		return "ok";
	}

	/*
	  Fun��o de listagem

	  0 = Erro da BD
	  true = Sucesso
	 */

	function Listar() {

		$sql = "SELECT distinct u.id_utilizadores, u.id_tipos_utilizadores, u.nome as nome, u.estado, tu.nome as nometipo " .
				"FROM utilizadores AS u " .
				"INNER JOIN tipos_utilizadores AS tu ON tu.id_tipos_utilizadores = u.id_tipos_utilizadores
                left join utilizadores_lojas ul on ul.id_utilizadores=u.id_utilizadores ";

		$whereArray = array();
		if (getRequestValue("tipos_utilizadores") != "") {  // tipo de utilizador
			$whereArray[] = "u.id_tipos_utilizadores = " . getRequestValue("tipos_utilizadores");
		}

		if (getRequestValue("estado") != "") {  // estado
			$whereArray[] = "u.estado = " . getRequestValue("estado");
		}

		if (getRequestValue("loja") != "") {  // estado
			$whereArray[] = "ul.id_loja = " . getRequestValue("loja");
		}

		$where = "";
		if (count($whereArray) > 0) {
			$where = "WHERE (" . implode(') AND (', $whereArray) . ")";
		}

		$orderBy = "ORDER BY u.nome";
		if (getRequestValue("campo") != "") {
			$orderBy = "ORDER BY u." . getRequestValue("campo");
		}
		if (getRequestValue("ordem") == 1) {
			$orderBy .= " DESC";
		} else {
			$orderBy .= " ASC";
		}

		$sql = "$sql $where $orderBy";

		global $ERROS, $N_REGISTOS;
		if (!$rs = $this->bd->executarSQL($sql)) {
			echo "<div id='msg_erro' class='error_space'> " . $ERROS[0] . " </div>";
			return;
		}

		$utilizadores = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($utilizadores, $row);

		$n = 1;
		$pagina = 1;
        if(array_key_exists('pagina', $_REQUEST) && $_REQUEST['pagina'] != '')
			$pagina = $_REQUEST['pagina'];

		$numRegPag = $N_REGISTOS; // numero de registos por pagina
		$numPaginas = 1; // numero de paginas de registos
		$numTuplos = $this->bd->obterNumRegistos($rs); // numero total registos
		// caso haja eliminacao de registos que diminua o numero de paginas
		if (($numTuplos / $numRegPag) <= (intval(getRequestValue("pagina")) - 1))
			$_REQUEST["pagina"] -= 1;

		// caso nao existam registos
		if ($numTuplos == 0) {
			echo "<div class='empty_msg'>" . translate('word_nao_existem') . " " . translate('word_utilizadores', false) . " " . translate('word_registados_sistema', false) . "</div>";
			return;
		}

		// calculo do numero de paginas de registos
		if ($numTuplos % $numRegPag == 0)
			$numPaginas = $numTuplos / $numRegPag;
		else
			$numPaginas = (int) ($numTuplos / $numRegPag + 1);

		echo "
			<form class='form_template' id='lista' action='../accoes_intermedias/accaoRemover.php?modulo=utilizadores&pagina=" . getRequestValue("pagina") . "&campo=" . getRequestValue("campo") . "&ordem=" . getRequestValue("ordem") . "&tipos_utilizadores=" . getRequestValue("ordem") . "&estado=" . getRequestValue('estado') . "' method='post'>
			<table class='form_table' cellspacing='0' cellpadding='0'>
			<tr>
			<td>
			<table class='data_table' cellspacing='0' cellpadding='0'>";

      //#1 - Re-design: store layout of navigation numbers in
      $TEMPLATE_navigation = "
				<tr>
					<td class='button_page' colspan='6'>";


					if(array_key_exists("pagina", $_REQUEST) && $_REQUEST["pagina"] > 1)
					{
							$pagAnterior = $_REQUEST["pagina"] - 1;
							$TEMPLATE_navigation .= "<a href='?pagina=$pagAnterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> < </div></a> ";
					}
					else
					{
							$_REQUEST["pagina"] = 1; // na primeira vez n�o h� request
							$TEMPLATE_navigation .= "<div> < </div>";
					}

					while($n <= $numPaginas)
					{
							if($n == $_REQUEST["pagina"])
									$TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : ""). "'><div class='current_page'>$n</div></a>";
							else
									$TEMPLATE_navigation .= "<a href='?pagina=$n&campo=" . (array_key_exists("campo", $_REQUEST) ? $_REQUEST['campo'] : "") . "&ordem=" . (array_key_exists("ordem", $_REQUEST) ? $_REQUEST['ordem'] : "") . "'><div class='other_page'>$n</div></a>";
							$n++;
					}

					$n = ($pagina - 1)*$numRegPag;
					$incremento = $n;

					if($pagina < $numPaginas)
					{
							$pagPosterior = $_REQUEST["pagina"] + 1;
							$TEMPLATE_navigation .= "<a href='?pagina=$pagPosterior&campo=" . $_REQUEST['campo'] . "&ordem=" . $_REQUEST['ordem'] . "'><div> > </div></a> ";
					}
					else
					{
							if($numTuplos % $numRegPag != 0)
									$numRegPag = $numTuplos % $numRegPag;
							$TEMPLATE_navigation .= "<div> > </div>";
					}

		$TEMPLATE_navigation .= "		</td>
			</tr>";

		echo "<tr class='column_row'>";

		if (getSessionValue("super_user") == 1) {
			echo "<td width='18' style='padding-left:8px' >" .  translate('word_select') . "</td>";
		}

		if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"], "nome") == 0)
			if ($_REQUEST["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0" . "&tipos_utilizadores=" . $_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=1" . "&tipos_utilizadores=" . $_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>" . translate('word_name', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=nome&ordem=0" . "&tipos_utilizadores=" . (array_key_exists("tipos_utilizadores", $_REQUEST) ? $_REQUEST['tipos_utilizadores'] : "") . "&estado=" . (array_key_exists("estado", $_REQUEST) ?$_REQUEST['estado'] : "") . "'><div>" . translate('word_name', true) . "</div></a></td>";

//		if (strcmp(getRequestValue("campo"), "lojas") == 0){
//			if ($_REQUEST["ordem"] == 1){
//				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=lojas&ordem=0" . "&tipos_utilizadores=" .$_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>Locais<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
//			}else{
//				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=lojas&ordem=1" . "&tipos_utilizadores=" .$_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>Locais<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
//			}
//		}else{
//			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=lojas&ordem=0" . "&tipos_utilizadores=" .$_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>Locais</div></a></td>";
		echo "<td class='column_cell'><div>" . translate('word_locals', true) . "</div></td>";
//		}

		if (array_key_exists("campo", $_REQUEST) && strcmp($_REQUEST["campo"], "estado") == 0)
			if ($_REQUEST["ordem"] == 1)
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=0" . "&tipos_utilizadores=" . $_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>" . translate('word_state', true) . "<img alt='' src='../img/buttons/order_desc.gif'></div></a></td>";
			else
				echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=1" . "&tipos_utilizadores=" . $_REQUEST['tipos_utilizadores'] . "&estado=" . $_REQUEST['estado'] . "'><div>" . translate('word_state', true) . "<img alt='' src='../img/buttons/order_asc.gif'></div></a></td>";
		else
			echo "<td class='column_cell'><a class='data_order' href='?pagina=1&campo=estado&ordem=0" . "&tipos_utilizadores=" . (array_key_exists("tipos_utilizadores", $_REQUEST) ? $_REQUEST['tipos_utilizadores'] : "") . "&estado=" . (array_key_exists("estado", $_REQUEST) ? $_REQUEST['estado'] : "") . "'><div>" . translate('word_state', true) . "</div></a></td>";

		echo "<td width='155'>" . translate('word_operations', true) . "</td>
			</tr>";



		//while ($n < ($numRegPag + $incremento)) {
		//	$this->bd->moverRegisto($rs, $n);
		for ($i=$n; $i<($numRegPag + $incremento); $i++)
        {

			// saber qual o estado
			$estado = obterEstadoUtilizador($utilizadores[$i]["estado"] /*$this->bd->obterValor($rs, "estado")*/);
			$lojas = $this->obterLojasUtilizador($this->bd->obterValor($rs, "id_utilizadores"));

			echo"<tr class='form-data-tr'>";
			if ($_SESSION["super_user"] == 1) {

				echo "<td class='form-data-td'>
								<label class='custom-check-container'>
										<input name='grupo' type='checkbox' value='" . $utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs,"id_utilizadores")*/ . "' onClick='selectEntireRow(this)'>
										<span class='custom-checkmark'></span>
								</label>
						</td>";

			}
			/* <td>" . $this->bd->obterValor($rs,5) . "</td> */
			echo "<td class='form-data-td'>" . $utilizadores[$i]["nome"] /*$this->bd->obterValor($rs, 2)*/ . "</td>
						<td class='form-data-td'>$lojas</td>
						<td class='form-data-td'>" . $estado . "</td>
						<td class='form-data-td'>";

			if (getSessionValue("super_user") == 1) {
				echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=utilizadores&id=" . $utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs, "id_utilizadores")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_edit', true) . "</div></a>
					<a class='function' href='../accoes_intermedias/accaoRemover.php?modulo=utilizadores&pagina=" . getRequestValue("pagina") . "&campo=" . getRequestValue("campo") . "&ordem=" . getRequestValue('ordem') . "&tipos_utilizadores=" . getRequestValue('tipos_utilizadores') . "&estado="
					. getRequestValue('estado') . "&id=" . $utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs, "id_utilizadores")*/ . "' onClick='return confirmarRemocao(this)'><img alt='Remover' src='../img/buttons/button_delete.gif'><div>" . translate('word_remove', true) . "</div></a>";
			} else {
				if ($utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs, "id_utilizadores")*/ == getSessionValue('sessao_id_utilizador') && $_SESSION["sessao_perms"]["perm_utilizadores"] == 2) {
					echo "<a class='function' href='../accoes_intermedias/accaoLer.php?modulo=utilizadores&id=" . $utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs, "id_utilizadores")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_edit', true) . "</div></a>";
				} else {
					echo "<a class='function' href='../accoes_intermedias/accaoLer.php?accao=ver_detalhes&modulo=utilizadores&id=" . $utilizadores[$i]["id_utilizadores"] /*$this->bd->obterValor($rs, "id_utilizadores")*/ . "'><img alt='Editar' src='../img/buttons/button_edit.gif'><div>" . translate('word_details', true) . "</div></a>";
				}
			}
			echo "</td>
				</tr>";

			//$n++;
		}


  //#3 - Re-design present NAVIGATION after table
  echo $TEMPLATE_navigation;

		echo "			</table>
			</td>
			</tr>
			<tr>
			<td>
			<div id='msg_erro' class='error_space'> " . $_SESSION['sessao_msg'] . " </div>
			</td>
			</tr>";


		if ($_SESSION["super_user"] == 1) {

			echo "<tr>
				<td class='button'>";
				if (getSessionValue("super_user") == 1) {
					echo "<div class='button-full-green' onClick='navigateToUrl(\"inserir.php\")'>". translate('word_insert_new', true)."</div>";
				}

			echo	"<div class='button-thin-green' onClick='seleccionaCaixa(true)'>" . translate('word_mark_all', true) . "</div>
					<div class='button-thin-green' onClick='seleccionaCaixa(false)'>" . translate('word_unmark_all', true) . "</div>
					<div class='button-thin-green' onClick='removerMarcados(this);'>" . translate('word_remove_selected', true) . "</div>
				</td>
				</tr>";
		}

		echo "</table>
			</form>";
	}

	function obterLojasUtilizador($idUtilizador = 0) {

		$sql = "SELECT DISTINCT l.id_loja, l.nome " .
				"FROM lojas AS l " .
				"INNER JOIN utilizadores_lojas AS ul ON ul.id_loja = l.id_loja " .
				"WHERE ul.id_utilizadores = $idUtilizador";
		$res = $this->bd->getRows($sql);

		$results = array();
		$count = 0;
		$full = false;
		foreach ($res AS $row) {
			if ($count > 3) {
				$full = true;
				break;
			}
			$results[] = $row['nome'];

			$count++;
		}

		if ($full) {
			$results[] = "... (" . (count($res) - 3) . ")";
		}
		$str = implode(', ', $results) . "&nbsp;";

		return $str;
	}

	function GetSuperusers() {
		$sql = "select u.id_utilizadores id from utilizadores u inner join tipos_utilizadores tu on (tu.id_tipos_utilizadores=u.id_tipos_utilizadores and tu.all_perm!=0)";
		//$res = $this->bd->executarSQL($sql)->GetRows();
		$res = $this->bd->getRows($sql);

		$out = array();
		foreach ($res as $r) {
			array_push($out, $r["id"]);
		}
		return $out;
	}

	function ObterUtilizadorDados($id) {
		$sql = "SELECT * FROM utilizadores WHERE id_utilizadores = " . $id . ";";
		$res = $this->bd->getRows($sql);

		return $res;
		
	}

	/*
	  Destrutor da classe

	  0 = Erro da BD
	 */

	function Fechar() {
		$this->bd->fecharBD();
	}

}

?>
