<?php
	
/* Classe de Gestão de utilizador asociado a entidades */

class UtilizadorEntidade extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function UtilizadorEntidade() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Função de inserção
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($id , $dados){
		
		if(!is_array($dados)){
			$temp=$dados;		
			$dados = array();
			$dados[0] = $temp;
		}		
		
		for($i=0 ; $i < count($dados) ; $i++){ 
			$sql = "INSERT INTO utilizadores_entidades(id_utilizadores, id_entidade)
					VALUES (".$id.",".$dados[$i].");";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
		}		

		
		return "ok";
	}
 
	/*
		Função de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/
	function LerDados($id="")
    {
        $sql = "SELECT id_entidade, nome
				FROM entidades 
				WHERE id_entidade > 0;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);
            
        $num_registos = $this->bd->obterNumRegistos($rs);
        
        $entidades = array();
        $entidades["nome"] = array();
        $entidades["id"] = array();
            
        for ($i = 0; $i < $num_registos ; $i++){
            //$this->bd->moverRegisto($rs, $i);
            
            $entidades["nome"][$i] = $dados[$i]["nome"]; 
            $entidades["id"][$i] = $dados[$i]["id_entidade"]; 
        }

        $_SESSION["sessao_campos"]["entidade"] = $entidades;
        
        $sql = "SELECT id_entidade
                FROM utilizadores_entidades
                WHERE id_utilizadores = ".$id.";";


        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
            
        
        $locais_trabalho = array();
        $dados2 = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados2, $row);

        $num_registos = $this->bd->obterNumRegistos($rs);
        $locais_rel = array();       
        for ($i = 0; $i < $num_registos ; $i++){
            $locais_trabalho[$i] = $dados2[$i]["id_entidade"];
        }

        $_SESSION["sessao_campos"]["utilizadores_entidades"]= $locais_trabalho;
        
        return "ok";
       
    }

	function LerDadosDELETE($id)
	{
		$sql = "SELECT id_entidade, nome
				FROM entidades 
				WHERE id_entidade > 0;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		
		$entidade = array();
		$entidade["nome"] = array();
		$entidade["id"] = array();
			
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$entidade["nome"][$i] = $this->bd->obterValor($rs, "nome");
			$entidade["id"][$i] = $this->bd->obterValor($rs, "id_entidade");
		}
		
		$_SESSION["sessao_campos"]["entidade"] = $entidade;
		
		$sql = "SELECT id_entidade
				FROM utilizadores_entidades
				WHERE id_utilizadores = ".$id.";";
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		$util_entid = array();
		
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$util_entid[$i] = $this->bd->obterValor($rs, "id_entidade");
		}
		
		$_SESSION["sessao_campos"]["utilizadores_entidades"]= $util_entid;
		
		return "ok";
	}
	 
	 
	/*
		Função de edição
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/

	function Editar($id , $dados)
    {

        if (!is_array($dados))
        {
            $aux = array();
            if ($dados) array_push($aux, $dados);
            unset($dados);
            $dados = $aux;
        }
        
        $sql = "delete from utilizadores_entidades where id_utilizadores= " . $id;

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
            
        for($i=0 ; $i < count($dados) ; $i++){
            $sql = "INSERT INTO utilizadores_entidades(id_utilizadores, id_entidade)
                    VALUES (".$id.",".$dados[$i].");";
    
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
        }

        return "ok";
    }

	function EditarDELETE($id , $dados)
	{	
		if(!is_array($dados)){
			$temp=$dados;		
			$dados = array();
			$dados[0] = $temp;
		}		
		
		$sql = "SELECT id_entidade FROM utilizadores_entidades WHERE id_utilizadores=".$id.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$existentes = array();
		for ($i = $this->bd->obterNumRegistos($rs)-1 ; $i >= 0 ; $i--){
			$this->bd->moverRegisto($rs, $i);
			array_push($existentes, $this->bd->obterValor($rs,"id_entidade"));
		}
		
		if(!is_array($dados))
			$dados = array();
		
		$criar = array_merge(array_diff($dados, $existentes));
		$ids_entidade = array();
		
		for($i=0 ; $i < count($criar) ; $i++){
			$sql = "INSERT INTO utilizadores_entidades(id_utilizadores, id_entidade)
					VALUES (".$id.",".$criar[$i].");";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_utilizadores_entidades) FROM utilizadores_entidades;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_entidade, $this->bd->obterValor($rs, 0));
			
		}
		
		//$this->EscreveXMLSync($ids_entidade, "inserir", $documento);
		
		$apagar = array_merge(array_diff($existentes, $dados));
		
		$ids_entidade = array();
		
		for($i=0 ; $i < count($apagar) ; $i++){
			$sql = "SELECT id_utilizadores_entidades FROM utilizadores_entidades
					WHERE id_utilizadores =".$id."
					AND id_entidade=".$apagar[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_entidade, $this->bd->obterValor($rs, "id_utilizadores_entidades"));			
		}
		
	//	$this->EscreveXMLSync($ids_entidade, "remover", $documento);
		
		for($i=0 ; $i < count($ids_entidade) ; $i++){
			$sql = "DELETE FROM utilizadores_entidades
					WHERE id_utilizadores_entidades =".$ids_entidade[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;		
		}
		
		return "ok";
	}
		
 	
	function Fechar()
	{
		$this->bd->fecharBD();
	}

}	
?>
