<?php
	
/* Classe de Gestão de utilizador asociado a lojas */

class UtilizadorLoja extends AcessoBD{
	var $bd;
	
	/*
		Construtor da classe
		
		0 = Erro da BD
	*/
	function UtilizadorLoja() 
	{
		global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
		$conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
		$this->bd = new AcessoBD($conn);
		return $this->bd;
	}
	
	/*
		Função de inserção
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Inserir($id , $dados){
		
		if(!is_array($dados)){
			$temp=$dados;		
			$dados = array();
			$dados[0] = $temp;
		}
		
		for($i=0 ; $i < count($dados) ; $i++){
			$sql = "INSERT INTO utilizadores_lojas(id_utilizadores, id_loja)
					VALUES (".$id.",".$dados[$i].");";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
		}		

		
		return "ok";
	}
 
	/*
		Função de leitura de dados
		
		0 = Erro da BD
		true = Sucesso	
	*/

	function LerDados($id="")
    {
        $sql = "SELECT id_loja, nome
                FROM lojas 
                WHERE id_loja > 0;";

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;

        $dados = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados, $row);
            
        $num_registos = $this->bd->obterNumRegistos($rs);
        
        $lojas = array();
        $lojas["nome"] = array();
        $lojas["id"] = array();
            
        for ($i = 0; $i < $num_registos ; $i++){
            //$this->bd->moverRegisto($rs, $i);
            
            $lojas["nome"][$i] = $dados[$i]["nome"]; 
            $lojas["id"][$i] = $dados[$i]["id_loja"]; 
        }

        $_SESSION["sessao_campos"]["lojas"] = $lojas;
        
        $sql = "SELECT id_loja
                FROM utilizadores_lojas
                WHERE id_utilizadores = ".$id.";";
                 $res = $this->bd->getRows($sql);


        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
      
        
        $locais_trabalho = array();
        $dados2 = array();
        while ($row = $this->bd->obterRegisto($rs)) array_push($dados2, $row);

        $num_registos = $this->bd->obterNumRegistos($rs);
        $locais_rel = array();       
        for ($i = 0; $i < $num_registos ; $i++){
            $locais_trabalho[$i] = $dados2[$i]["id_loja"];
        }
      
        $_SESSION["sessao_campos"]["utilizadores_lojas"]= $locais_trabalho;
        
        return "ok";

       
    }

	function LerDadosDELETE($id)
	{
		$sql = "SELECT id_loja, nome
				FROM lojas 
				WHERE id_loja > 0;";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		
		$loja = array();
		$loja["nome"] = array();
		$loja["id"] = array();
			
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$loja["nome"][$i] = $this->bd->obterValor($rs, "nome");
			$loja["id"][$i] = $this->bd->obterValor($rs, "id_loja");
		}
		
		$_SESSION["sessao_campos"]["lojas"] = $loja;
		
		$sql = "SELECT id_loja
				FROM utilizadores_lojas
				WHERE id_utilizadores = ".$id.";";
				
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
			
		$num_registos = $this->bd->obterNumRegistos($rs);
		$util_lojas = array();
		
		for ($i = 0; $i < $num_registos ; $i++){
			$this->bd->moverRegisto($rs, $i);
			
			$util_lojas[$i] = $this->bd->obterValor($rs, "id_loja");
		}
		var_dump('prestados_count111');var_dump($util_lojas);die();
		$_SESSION["sessao_campos"]["utilizadores_lojas"]= $util_lojas;
		
		return "ok";
	}
	 
	/*
		Função de edição
		
		0 = Erro da BD
		5 = Erro Existente
		true = Sucesso	
	*/
	function Editar($id , $dados)
    {

        if (!is_array($dados))
        {
            $aux = array();
            if ($dados) array_push($aux, $dados);
            unset($dados);
            $dados = $aux;
        }
        
        $sql = "delete from utilizadores_lojas where id_utilizadores= " . $id;

        if(!$rs = $this->bd->executarSQL($sql))
            return 0;
            
        for($i=0 ; $i < count($dados) ; $i++){
            $sql = "INSERT INTO utilizadores_lojas(id_utilizadores, id_loja)
                    VALUES (".$id.",".$dados[$i].");";
  
            if(!$rs = $this->bd->executarSQL($sql))
                return 0;
        }

        return "ok";
    }

	function EditarDELETE($id , $dados)
	{	
		if(!is_array($dados)){
			$temp=$dados;		
			$dados = array();
			$dados[0] = $temp;
		}		
		
		$sql = "SELECT id_loja FROM utilizadores_lojas WHERE id_utilizadores=".$id.";";
		
		if(!$rs = $this->bd->executarSQL($sql))
			return 0;
		
		$existentes = array();
		for ($i = $this->bd->obterNumRegistos($rs)-1 ; $i >= 0 ; $i--){
			$this->bd->moverRegisto($rs, $i);
			array_push($existentes, $this->bd->obterValor($rs,"id_loja"));
		}
		
		if(!is_array($dados))
			$dados = array();
		
		$criar = array_merge(array_diff($dados, $existentes));
		$ids_lojas = array();
		
		for($i=0 ; $i < count($criar) ; $i++){
			$sql = "INSERT INTO utilizadores_lojas(id_utilizadores, id_loja)
					VALUES (".$id.",".$criar[$i].");";

			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			$sql = "SELECT MAX(id_utilizadores_lojas) FROM utilizadores_lojas;";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_lojas, $this->bd->obterValor($rs, 0));
			
		}
		
		//$this->EscreveXMLSync($ids_lojas, "inserir", $documento);
		
		$apagar = array_merge(array_diff($existentes, $dados));
		
		$ids_lojas = array();
		
		for($i=0 ; $i < count($apagar) ; $i++){
			$sql = "SELECT id_utilizadores_lojas FROM utilizadores_lojas
					WHERE id_utilizadores =".$id."
					AND id_loja=".$apagar[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;
				
			array_push($ids_lojas, $this->bd->obterValor($rs, "id_utilizadores_lojas"));			
		}
		
	//	$this->EscreveXMLSync($ids_lojas, "remover", $documento);
		
		for($i=0 ; $i < count($ids_lojas) ; $i++){
			$sql = "DELETE FROM utilizadores_lojas
					WHERE id_utilizadores_lojas =".$ids_lojas[$i].";";
			
			if(!$rs = $this->bd->executarSQL($sql))
				return 0;		
		}
		
		return "ok";
	}
		
 	
	function Fechar()
	{
		$this->bd->fecharBD();
	}

}	
?>