<?php 

function ligarBDMySQLi($servidor, $username, $password, $nomebd)
{   
    $OpensslEncryption = new Openssl_EncryptDecrypt;
    $c = base64_decode($password);
    $password = $OpensslEncryption->decrypt($c, ENCRYPTION_KEY);

    $conn = mysqli_init();
    mysqli_real_connect($conn, $servidor, $username, $password, $nomebd, 3306);
    return $conn;
}

function getApplicationRoot()
{
    global $root_uri;
    if ($root_uri == null) {
         return "/Zqueue/";
        if ($dir = trim(dirname($_SERVER['SCRIPT_NAME']), '\,/')) {
            $root_uri = "$dir";
        }
        else {
            $root_uri = '';
        }
        
        // Get the folder this script belongs to since it is the base folder
        $curr_folder = basename(dirname(__FILE__));

        // Here we will set the root_uri to the root path up to the folder this
        // file belongs to. For instance with the root_uri set to
        // "some_folder/Terminal/some_other_folder/Terminal/accoesIntermedias" and the
        // curr_folder set to "Terminal", the root_uri will be set to
        // "some_folder/Terminal/some_other_folder/Terminal"
        $curr_folder_last_pos = strrpos($root_uri, $curr_folder);
        $root_uri = '/' . substr($root_uri, 0, strlen($curr_folder) + $curr_folder_last_pos) . '/';
        if ($root_uri == '//') {
            $root_uri = '/' . $curr_folder . '/';
        }
    }
   
    return $root_uri;
}

function getApplicationVersion() {
  $version = file(dirname(__FILE__) .'/VERSION');
  return trim($version[0]);
}

// Checks for multiple slashes in the request URI. If found, they are
// removed and the page is redirected to the new URI.
function checkEmptyFolders() {
    $uri = preg_replace('#//+#', '/', $_SERVER['REQUEST_URI']);
    $reqUriMinusScriptName = str_replace($_SERVER['SCRIPT_NAME'], '', $_SERVER['REQUEST_URI']);
    if ($reqUriMinusScriptName != $_SERVER['REQUEST_URI'] && substr($reqUriMinusScriptName, 0, 1) == '/') {
        // Slashes were added after the script name such as example.com/Zqueue/index.php/
        $uri = substr($uri, 0, -1);
    }
    if ($uri != $_SERVER['REQUEST_URI']) {
        header('Location: ' . $uri);
        exit();
    }
}

function construirNome($filepath)
{
    $path = pathinfo($filepath);
    $file_name = $path["dirname"]."/".basename($filepath,".".$path["extension"]).".".$path["extension"];


    for($i=1 ; file_exists($file_name) ; $i++)
    {
        $index = "_".sprintf("%02d", $i).".".$path["extension"];
        $file_name = $path["dirname"]."/".basename($filepath,".".$path["extension"]).$index;
    }

    return $file_name;
}


function ordenacao($array,$valrev=0)
{
    if ($valrev == 1)
    {
        arsort($array);
    }
    else
    {
        asort($array);
    }
    return $array;

}


function aksort($array,$valrev=false,$keyrev=false)
{
    if ($valrev)
    {
        arsort($array);
    }
    else
    {
        asort($array);
    }

    $vals = array_count_values($array);
    $i = 0;
    foreach ($vals AS $val=>$num)
    {
        $first = array_splice($array,0,$i);
        $tmp = array_splice($array,0,$num);
        if ($keyrev)
        {
            krsort($tmp);
        } else
        {
            ksort($tmp);
        }
        $array = array_merge($first,$tmp,$array);
        unset($tmp);
        $i = $num;
    }
    return $array;
}




//função que limpa a pasta dos downloads onde estam os graficos
function cleanDownload()
{
    //  $seconds_old = 3600;
    //$directory = "/var/www/html/Zqueue/download";
    $directory =  "/var/www/html/" . getApplicationRoot() . "/download";

    if( !$dirhandle = @opendir($directory) )
        return;

    while( false !== ($filename = readdir($dirhandle)) )
    {
        if( $filename != "." && $filename != "..")
        {
            $tmp = explode("." , $filename);
            if(strcasecmp($tmp[1] , "php") != 0)
            {
                $filename = $directory. "/". $filename;
                @unlink($filename);
            }
        }
    }
}

function devolveNome($tabela , $str , $id)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "SELECT nome FROM ".$tabela." WHERE id_".$str."=".$id.";";
    $rs = $bd->executarSQL($sql);
    return $bd -> obterValor($rs , "nome");

}


function trunkString($string , $start , $end)
{
    $newString = substr($string , $start , $end);

    return $newString;
}

function CalculaValorMedia($arrayValor , $Agrupado , $nomeGrupo , $Loja = null , $data = null)
{
    $resultado = array();
    $res["valor"] = 0;
    $j = 0;
    $k = 0;
    $array_count_occ = array_count_values($Agrupado);
    $keys_occ = array_keys($array_count_occ);

    $num_iter = 0;
    for($i=0; $i<=count($arrayValor); $i++)
    {
        if(strcasecmp($Agrupado[$i] , $keys_occ[$j]) == 0 && ($i + 1)  <= count($arrayValor))
        {
            $res["valor"] += $arrayValor[$i];
            $num_iter ++ ;

        }
        else
        {
            $res["valor"] = (int) ($res["valor"] / $num_iter);
            $num_iter = 1;
            $res["nomeservico"] = $nomeGrupo[$i-1];
            //  file_put_contents("/tmp/debug.txt" , "\n servico    ". $res["nomeservico"]."    loja    ".$Loja[$i-1], FILE_APPEND);
            $res["id_servico"]=$Agrupado[$i - 1];
            if(count($data) != 0)
                $res["data"] = $data[$i-1];
            if(count($Loja) != 0)
                $res["nomelocal"] = $Loja[$i-1];
            $resultado[$k] = $res;
            $k ++;
            $j = ($j+1) % count($keys_occ);
            $res["valor"] = $arrayValor[$i];

        }
    }
    return $resultado;
}

function CalculaValor($arrayValor ,$Agrupado, $nomeGrupo , $Loja = null , $data=null)
{
    $resultado = array();
    $res["valor"] = 0;
    $j = 0;
    $k = 0;
    $array_count_occ = array_count_values($Agrupado);
    $keys_occ = array_keys($array_count_occ);
    $num_iter = 0;
    for($i=0; $i<=count($arrayValor); $i++)
    {

        if(strcasecmp($Agrupado[$i] , $keys_occ[$j]) == 0 && ($i + 1)  <= count($arrayValor))
            $res["valor"] += $arrayValor[$i];
        else
        {
            $res["nomeservico"] = $nomeGrupo[$i-1];
            $res["id_servico"]=$Agrupado[$i - 1];
            if(count($data) != 0)
                $res["data"] = $data[$i-1];
            if(count($Loja) != 0)
                $res["nomelocal"] = $Loja[$i-1];
            $resultado[$k] = $res;
            $k ++;
            $j = ($j+1) % count($keys_occ);
            $res["valor"] = $arrayValor[$i];
        }
    }
    return $resultado;
}


function devolveGrupo($Agrupado, $grupo)
{

    //ligaçao o dataBase
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$var = new AcessoBD();
    //$var->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $var = new AcessoBD($conn); 



    //Obtener nome do grupo
    $sql_nome = "SELECT nome from";
    if(strcasecmp($grupo ,"servico" )==0)
        $sql_nome = $sql_nome." servicos where id_servico = ";
    if(strcasecmp($grupo ,"loja")==0)
        $sql_nome = $sql_nome." lojas where id_loja = ";
    if(strcasecmp($grupo ,"colaborador")==0)
        $sql_nome = $sql_nome." empregados where id_empregado = ";

    $sql_nome1 = $sql_nome."".$Agrupado[0].";";

    if(strcasecmp($grupo ,"balcao") != 0)
    {
        if(!$rsNome = $var -> executarSQL($sql_nome1))
            return;

        $NomeGrupo[0] = $var -> obterValor($rsNome , "nome");
        $nome = $NomeGrupo[0];
        $id = $Agrupado[0];
        $pos = strlen($sql_nome);
        for($j =1; $j< count($Agrupado); $j++)
        {

            if($id != $Agrupado[$j] || strlen($sql_nome) > $pos)
            {
                $id = $Agrupado[$j];
                $sql_nome = substr($sql_nome, 0 , $pos -1);
                $sql_nome =$sql_nome."".$Agrupado[$j];
                if(!$rsNome = $var -> executarSQL($sql_nome))
                    return;
                $nome =     $var -> obterValor($rsNome , "nome");

            }
            $NomeGrupo[$j] = $nome;
        }
    }
    else
        $NomeGrupo = $Agrupado;

    return $NomeGrupo;

}

function modifyData($data)
{
    $data_sec = strtotime($data);
    $data_max = strftime("%Y-%m-%d" , $data_sec);
    $aaaa_mm_gg = explode("-", $data_max);
    $ano = (int) $aaaa_mm_gg[0];
    $mes = (int) $aaaa_mm_gg[1];
    $dia = (int) $aaaa_mm_gg[2] - 1;
    if($dia == 0 && ($mes == 12  || $mes == 10 || $mes == 7 || $mes == 5))
    {
        $dia = 30 ;
        $mes = $mes - 1;
    }
    if($dia == 0 && $mes == 3 && ($ano % 4) == 0)
    {
        $dia = 29 ;
        $mes = $mes - 1;
    }
    if($dia == 0 && $mes == 3 && ($ano % 4) != 0)
    {
        $dia = 28;
        $mes = $mes - 1;
    }
    if($dia == 0 && ($mes == 11  || $mes == 9 || $mes == 8 || $mes == 6 || $mes == 4 || $mes == 2))
    {
        $dia = 31;
        $mes = $mes - 1;
    }
    if($dia == 0 && $mes == 1)
    {
        $dia = 31;
        $mes = 12;
        $ano = $ano - 1;
    }
    if($mes < 10)
        $mes = "0".$mes;
    if($dia < 10)
        $dia = "0".$dia;

    $data =$ano."-".$mes."-".$dia;
    return $data;

}
/* Gest�o de Sess�es */
// Fun��o que inicia as vari�veis de sess�o do utilizador
function iniciaVariaveisSessao()
{
    global $LANG;
    session_start();


    $_SESSION["sessao_autenticado"] = 0;
    $_SESSION["sessao_nome"] = 0;
    $_SESSION["sessao_tipo"] = 0;
    $_SESSION["sessao_id_cliente"] = 0;
    $_SESSION["sessao_cliente"] = 0;
    $_SESSION["sessao_estado"] = 0; // controlar o estado por sess�o e n�o por qualquer liga��o de forma a n�o poder haver 3 tentativas em diferentes sess�es (computadores)
    $_SESSION["sessao_perms"] = 0;
    $_SESSION["sessao_filenames"] = 0;
    $_SESSION["sessao_id_utilizador"]=0;
    $_SESSION["statistics"] = array();
    $_SESSION["sessao_lang_correcta"]=$LANG;
    $_SESSION["langArray"] = array();
}

function removeVariaveisSessao()
{
    //unset($_SESSION['sessao_autenticado']);
    //unset($sessao_autenticado);
    unset($_SESSION['sessao_nome']);
    unset($sessao_nome);
    unset($_SESSION['sessao_tipo']);
    unset($sessao_tipo);
    unset($_SESSION['sessao_id_cliente']);
    unset($sessao_id_cliente);
    unset($_SESSION['sessao_cliente']);
    unset($sessao_cliente);
    unset($_SESSION['sessao_estado']);
    unset($sessao_estado);
    unset($_SESSION['sessao_perms']);
    unset($sessao_perms);
    unset($_SESSION['sessao_filenames']);
    unset($sessao_filenames);
    unset($_SESSION['sessao_id_utilizador']);
    unset($sessao_id_utilizador);
    unset($_SESSION['statistics']);
    unset($statistics);
    unset($_SESSION['sessao_lang_correcta']);
    unset($sessao_lang_correcta);
    unset($_SESSION['langArray']);
    unset($langArray);
}

//Converte os caracteres com acentos para caracteres html
function htmlString($str)
{
    $str = str_replace("ã", "&atilde;", $str);
    $str = str_replace("Ã", "&Atilde;", $str);

    $str = str_replace("á", "&aacute;", $str);
    $str = str_replace("Á", "&Aacute;", $str);

    $str = str_replace("à", "&agrave;", $str);
    $str = str_replace("À", "&Agrave;", $str);

    $str = str_replace("â", "&acirc;", $str);
    $str = str_replace("Â", "&Acirc;", $str);

    $str = str_replace("ç", "&ccedil;", $str);
    $str = str_replace("Ç", "&Ccedil;", $str);

    $str = str_replace("é", "&eacute;", $str);
    $str = str_replace("É", "&Eacute;", $str);

    $str = str_replace("ê", "&ecirc;", $str);
    $str = str_replace("Ê", "&Ecirc;", $str);

    $str = str_replace("í", "&iacute;", $str);
    $str = str_replace("Í", "&Iacute;", $str);

    $str = str_replace("õ", "&otilde;", $str);
    $str = str_replace("Õ", "&Otilde;", $str);

    $str = str_replace("ó", "&oacute;", $str);
    $str = str_replace("Ó", "&Oacute;", $str);

    $str = str_replace("ò", "&ograve;", $str);
    $str = str_replace("Ò", "&Ograve;", $str);

    $str = str_replace("ú", "&uacute;", $str);
    $str = str_replace("Ú", "&Uacute;", $str);

    return $str;
}

function asciiString($str)
{
    $str = str_replace("ã", "a", $str);
    $str = str_replace("Ã", "A", $str);

    $str = str_replace("á", "a", $str);
    $str = str_replace("Á", "A", $str);

    $str = str_replace("à", "a", $str);
    $str = str_replace("À", "A", $str);

    $str = str_replace("â", "a", $str);
    $str = str_replace("Â", "A", $str);

    $str = str_replace("ç", "c", $str);
    $str = str_replace("Ç", "C", $str);

    $str = str_replace("é", "e", $str);
    $str = str_replace("É", "E", $str);

    $str = str_replace("ê", "e", $str);
    $str = str_replace("Ê", "E", $str);

    $str = str_replace("í", "i", $str);
    $str = str_replace("Í", "I", $str);

    $str = str_replace("õ", "o", $str);
    $str = str_replace("Õ", "O", $str);

    $str = str_replace("ó", "o", $str);
    $str = str_replace("Ó", "O", $str);

    $str = str_replace("ò", "o", $str);
    $str = str_replace("Ò", "O", $str);

    $str = str_replace("ú", "u", $str);
    $str = str_replace("Ú", "U", $str);

    return $str;
}



// Função que devolve o caminho (path) absoluto até ao
// módulo da aplicação recebido como argumento.
function devolveCaminhoAbsoluto($modulo)
{
    global $DIR;

    $path = "http://" . $_SERVER['HTTP_HOST'] . $DIR . $modulo;

    return $path;
}

function devolveDataHora()
{

    $meses = array(
            translate("word_janeiro"),
            translate("word_fevereiro"),
            translate("word_marco"),
            translate("word_abril"),
            translate("word_maio"),
            translate("word_junho"),
            translate("word_julho"),
            translate("word_agosto"),
            translate("word_setembro"),
            translate("word_outubro"),
            translate("word_novembro"),
            translate("word_dezembro"));

    $dias = array(
            "Sun" => translate("word_domingo"),
            "Mon" => translate("word_segunda_feira"),
            "Tue" => translate("word_terca_feira"),
            "Wed" => translate("word_quarta_feira"),
            "Thu" => translate("word_quinta_feira"),
            "Fri" => translate("word_sexta_feira"),
            "Sat" => translate("word_sabado"));

    $datahora = "<span>" . $dias[date("D")] . ", " . date("j") . " ".translate("word_de")." " . $meses[date("n")-1] . " ".translate("word_de")." " . date("Y") . "</span>&nbsp;&nbsp;" . "<span>" . date("H:i") . "</span>";
    return $datahora;
}

function devolveMesAno($mes, $ano)
{
    $meses = array(
            translate("word_janeiro"),
            translate("word_fevereiro"),
            translate("word_marco"),
            translate("word_abril"),
            translate("word_maio"),
            translate("word_junho"),
            translate("word_julho"),
            translate("word_agosto"),
            translate("word_setembro"),
            translate("word_outubro"),
            translate("word_novembro"),
            translate("word_dezembro"));
    return $meses[$mes-1] . " ".translate("word_de")." " . $ano;
}

function devolveDia($diasemana, $dia)
{
    $dias = array(
            "Sun" => translate("word_domingo"),
            "Mon" => translate("word_segunda_feira"),
            "Tue" => translate("word_terca_feira"),
            "Wed" => translate("word_quarta_feira"),
            "Thu" => translate("word_quinta_feira"),
            "Fri" => translate("word_sexta_feira"),
            "Sat" => translate("word_sabado"));
    return $dias[$diasemana] . " " . $dia;
}

/* Fun��o que constroi uma lista de campos din�micos*/

function construirCampos($campos, $form_n, $tipo, $valor_post=false)
{

    $numCampos = count($campos);

    if($tipo != "inserir_tipo")
    {
        if($tipo == "editar" || $tipo == "detalhes")
        {
            $numCampos-=2;
        }

        $numCampos--;
    }
    $numCampos /= 2;

    if($tipo == "single")
    {
        $numCampos = 1;
    }

    $validacao = "existeErro = 0;";

    if($tipo == "inserir")
    {
        $validacao .= "for(var i = 1; i <= ". $numCampos ."; i++){";
    }else
    {
        $validacao .= "for(var i = 0; i < ". $numCampos ."; i++){";
    }
    $validacao .= "limpaMsgErro('msg_' + document.forms[".$form_n."].elements[i].name); }";

    for($i = 1; $i <= $numCampos; $i++)
    {
        $args = construcaoVector($campos["campo_".$i],",");

        if($tipo != "single")
        {
            echo "<tr>";
        }
        echo "<td class='formname_space'>";

        if($args[5] == 1)
        {
            echo "<font class='error_msg'>* </font>";
        }
        echo $args[0].":";

        echo "  </td><td class='input_space'>";

        $field = $campos["nome_campo_".$i];
        if($valor_post)
        {
            $valor = $_POST["$field"];
        }else
        {
            $valor = $campos["valor_campo"][$field];
        }
        switch($args[3])
        {
            case 7:
                echo "<textarea ";
                if($tipo == "detalhes" || $args[6])
                    echo "readonly=\"readonly\" ";
                echo "class='" . $field . "' id='" . $field . "' name='" . $field . "' rows='" . $args[1] . "' cols='" . $args[2] . "'>" . $valor . "</textarea>";
                break;
            case 10:
                echo "<input ";
                if($tipo == "detalhes" || $args[6])
                {
                    echo "readonly=\"readonly\" ";
                }
                echo "id='" . $field . "' name='" . $field . "' type='text' maxlength='10' size='11' value='" . $valor . "'>";
                if($tipo != "detalhes")
                {

                    if($tipo != "single")
                    {
                        echo "<a href='javascript:var cal1 = new calendar1(document.forms[".$form_n."].elements[\"$field\"]);";
                    }else
                    {
                        if($campos["ordem"] != -1)
                        {
                            echo "<a href='javascript:var cal1 = new calendar1(document.forms[".$form_n."].elements[\"$field\"][".$campos["ordem"]."]);";
                        }else
                        {
                            echo "<a href='javascript:var cal1 = new calendar1(document.forms[".$form_n."].elements[\"$field\"]);";
                        }
                    }
                    echo "cal1.year_scroll = true;
                    cal1.time_comp = false;
                    cal1.popup();'><img src='../img/calendario/cal.gif' width='16' height='16' border='0' alt='".translate("word_get_calendar", true)."'></a>
                        <font class='info_msg'>(aaaaa-mm-dd)</font>";
                }
                break;
            case 12:
                echo "<input ";
                if($tipo == "detalhes" || $args[6])
                {
                    echo "disabled=\"disabled\" ";
                }
                echo "id='" . $field . "' name='" . $field . "' type='file' size='" . $args[2] . "' value='" . $_FILES[$field]['tmp_name'] . "'>";
                array_push($_SESSION["sessao_filenames"],$field);
                break;
            case 16:
                if(!isset($args[7]))
                {
                    break;
                }
                if ($tipo == "detalhes" || $args[6])
                {
                    echo construirCampoReferencia($args[7],$field,$valor, 1);
                }else
                {
                    echo construirCampoReferencia($args[7],$field,$valor,0);
                }
                break;
            default:
                echo "<input ";
                if($tipo == "detalhes" || $args[6])
                {
                    echo "readonly=\"readonly\" ";
                }
                echo "id='" . $field . "' name='" . $field . "' type='text' maxlength='" . $args[1] . "' size='" . $args[2] . "' value='" . $valor . "'>";
                break;
        }

        if($tipo != "single")
        {
            echo "      <span id='msg_" . $field . "' class='error_msg'>&nbsp;</span></td></tr>";
        }else
        {
            echo "      <span id='msg_" . $field . $campos["ordem"] . "' class='error_msg'>&nbsp;</span></td>";
        }

        //  echo "<a href=\"\"><pre>"; echo print_r($args); echo "</pre></a>";
        if($args[5] == 1)
        {
            if($args[3] != 16)
            {
                $validacao .= "validaPreenchido(document.forms[".$form_n."].elements['" . $field . "'].value, 'msg_" . $field . "'); ";
            }
        }else
        {
            $validacao .= "validaSeleccionado(document.forms[".$form_n."].elements['" . $field . "'].value, 'msg_" . $field . "'); ";
        }

        if(strcasecmp($args[4],"nenhuma") != 0)
        {
            $validacao .= $args[4] . "(document.forms[".$form_n."].elements['" . $field . "'].value, 'msg_" . $field . "'); ";
        }
    }

    $validacao .= "if(existeErro == 1) { document.getElementById('msg_erro').innerHTML = erro[0]; } else { document.getElementById('msg_erro').innerHTML = '&nbsp;';";
    if($tipo != "single")
    {
        $validacao .= "document.forms[".$form_n."].submit();";
    }
    $validacao .= "}";
    return $validacao;
}

/* Constroi a caixa de seleccao para efectuar
   indicar o item associado ao terminal*/

function construirAssociacaoTerminal($tabela, $seleccionado, $leitura = false)
{

    if($leitura)
    {
        echo "<input type='text' readonly='readonly' name='id_associado' value='";
        switch ($tabela)
        {
            case 'empregados':
                echo obterNomeGeral($seleccionado, "id_empregado", "nome", $tabela);
                break;
            case 'dispensador':
                echo obterNomeGeral($seleccionado, "id_dispensador", "identificador", $tabela);
                break;
            case 'balcoes':
                echo obterNomeGeral($seleccionado, "id_balcao","nome", $tabela);
                break;
            default:
                echo "". translate('word_no', false) ." atribu&iacute;do";
                break;
        }
        echo "'>";
    } else
    {

        switch ($tabela)
        {
            case 'empregados':
                construirListaGeral("id_associado", "empregados", "id_empregado", "nome", $seleccionado, "". translate('word_no', false) ." atribu&iacute;do");
                break;
            case 'dispensador':
                construirListaGeral("id_associado", "dispensador", "id_dispensador", "identificador", $seleccionado,"". translate('word_no', false) ." atribu&iacute;do");
                break;
            case 'balcoes':
                construirListaGeral("id_associado", "balcoes", "id_balcao", "nome", $seleccionado,"". translate('word_no', false) ." atribu&iacute;do");
                break;
            default:
                echo "<input type='text' readonly='readonly' name='id_associado' value='". translate('word_no', false) ." atribu&iacute;do'>";
                break;
        }
    }
}


/* Constroi a caixa de seleccao relativa
   a um campo do tipo referencia */

function construirCampoReferencia($tipo_ref, $field, $opcao_seleccionada, $leitura)
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "SELECT codigo_seleccao FROM campos_referencia
        WHERE id_campo_referencia=".$tipo_ref." ;";


    $rs = $bd->executarSQL($sql);
    $sql = $bd->obterValor($rs,0);

    if($tipo_ref == "7")
        $sql .= $_SESSION["sessao_campos"]["numero_teclas"] .";";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    $html = "<select name='".$field."' id='".$field."'>";
    $html .= "\n<option value='' selected>Escolha...</option>";

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        $valor = $bd->obterValor($rs, "valor");
        $label = $bd->obterValor($rs, "label");

        if($leitura == 1 && strcasecmp($opcao_seleccionada,$valor) == 0)
            return "<input type=\"text\" readonly=\"readonly\" id=\"".$field."\" name=\"".$field."\" value=\"".$label."\">";

        if(strcasecmp($opcao_seleccionada,$valor) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            $html .= "\n<option value='" . $valor . "' selected>" . $label . "</option>";
        else
            $html .= "\n<option value='" . $valor . "'>" . $label . "</option>";
    }

    $html .= "</select>";

    if($leitura == 1)
        return "<input type=\"text\" readonly=\"readonly\" id=\"".$field."\" name=\"".$field."\" value=\"&lt;sem associa&ccedil;&atilde;o&gt;\">";
    else
        return $html;

}

/* Gest�o de ListBoxes */



function construirListaLojaEntidade($nome, $tabela, $valor, $label, $opcao_seleccionada = "", $grupo ,
        $opcao_vazia = "Escolha...", $script = "" , $id_filtro = '' ,$valor_filtro = '')
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $valores = array();
    $labels = array();

    if(!is_array($grupo))
    {
        $temp = $grupo;
        $grupo[0] = $temp;
    }

    $sql = "SELECT DISTINCT t." . $valor . ", t.". $label ." FROM ".$tabela." t, lojas_entidades le
        WHERE (t.".$valor."=".$grupo[0];
    for($i=1; $i < count($grupo); $i++)
        $sql .= " OR t.".$valor." = ".$grupo[$i];
    $sql = $sql . ") ";
    if($valor_filtro != '')
        $sql = $sql . " AND t.".$valor."=le.".$valor." AND le.".$id_filtro."=".$valor_filtro;

    $sql = $sql . " ORDER BY t.". $valor ." ASC ;";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($valores,$bd->obterValor($rs, $valor));
        if (strcmp($tabela, "servicos") == 0)
        { /* encode services .. */
            array_push($labels, $bd->obterValor($rs, $label));
        } else
        {
            array_push($labels,$bd->obterValor($rs, $label));
        }
    }

    echo "<select name='".$nome."' id='".$nome."' onChange='".$script."'>";
    echo "\n<option value='' selected>".$opcao_vazia."</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($opcao_seleccionada,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";




}

function construirListaBalcoes($estado , $valor, $id = '' , $filtro='' , $tipo)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $valores = array();
    $labels = array();

    $sql = "SELECT id_balcao , nome FROM balcoes WHERE estado = ".$estado;

    if($filtro != '')
        $sql = $sql . " AND ".$id." = ".$filtro;

    $sql = $sql . " ORDER BY nome ASC;";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($valores,$bd->obterValor($rs,"id_balcao"));
        array_push($labels,$bd->obterValor($rs,"nome"));
    }

    switch($nome)
    {
        default:
            if($opcao == '')
                echo "<select name='balcao' id='balcao'>";
            else
                echo "<select name='balcao' id='balcao' $opcao>";
            break;
    }

    if($tipo == 1)
        echo "<option value='' selected>TODOS</option>";
    if($tipo == 2)
        echo "<option value='' selected>Escolha...</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($valor,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";

}




// Funcao que constroi a listbox de registos dado o nome da tabela
function construirLista($nome, $tipo, $valor , $filtro = '', $script = '', $width = 0, $output=true, $escolha=false)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);

    $valores = array();
    $labels = array();

    switch($nome)
    {
        case 'estado': //utilizador
            $valores = array(1,2,3);
            //$labels = array("Activo","Bloqueado","Inactivo");
            $labels = array(translate('word_activo', true),translate('word_bloqueado', true),translate('word_inactivo', true));
            break;

        case 'estados_balcao': 
            $valores = array(4,3,1,2,5);
            $labels = array(translate('word_disponivel', true),translate('word_fechado', true),translate('word_in_attendance', true),"Suspenso", "Serviço interno");
            break;

        case 'estados_ecra': 
            $valores = array(1,2);
            $labels = array(translate('word_activo', true),translate('word_inactivo', true));
            break;
        case 'estados_sms': 
            $valores = array(1,0);
            $labels = array(translate('word_activo', true),translate('word_inactivo', true));
            break;

        case 'estados_dispensador': 
            $valores = array(1,0);
            $labels = array(translate('word_operational', true),translate('word_notoperational', true));
            break;

        case 'tipo':
            $valores = array(1,2,3);
            //$labels = array("Terminado", "Suspensa", "Redireccao");
            $labels = array(translate('word_finished', true), translate('word_suspensa', true), translate('word_redireccao', true));
            break;

        case 'servico':
        case 'servicos':
        case 'services':
            if (trim($filtro)!="|" && trim($filtro) != '')
            {
                $filtro_arr = explode("|", $filtro);
                $loja = trim($filtro_arr[0]);
                $entidade = isset($filtro_arr[1])?trim($filtro_arr[1]):"";

                if (!strlen($entidade))
                {
                    $entidades = array();
                    $sql = "select id_entidade from lojas_entidades where id_loja='".$loja."'";
                    $rs = $bd->executarSQL($sql);
                    while ($row = $bd->obterRegisto($rs))
                    {
                        array_push($entidades, $row['id_entidade']);
                    }
                    $sql = "select id_servico, nome from servicos where id_entidade in ('".implode("','", $entidades)."')";
                }
                else
                {
                    $sql = "select id_servico, nome from servicos where id_entidade='".$entidade."'";
                }
            }
            else
            {
                $sql = "select id_servico, nome from servicos";
            }
            $rs = $bd->executarSQL($sql);
            while ($row = $bd->obterRegisto($rs))
            {
                array_push($valores, $row['id_servico']);
                array_push($labels, $row['nome']);
            }
            break;

        case 'opcoesResumoMensal';
            $sql = "SELECT DISTINCT DATE_FORMAT(data, '%Y-%m') AS label, CONCAT(DATE_FORMAT(data, '%Y-%m'), '-01') AS value FROM senhas order by label desc ";
           
            //$rs = $bd->executarSQL($sql)->GetRows();
            $rs = $bd->getRows($sql);

            foreach($rs AS $row)
            {
                
                array_push($valores, $row['value']);
                array_push($labels, $row['label']);
            }

            break;

        case 'colaboradores':
        case 'empregados':
        case 'employes':
            $sql =  "SELECT id_empregado, ".
                    "   nome ".
                    "FROM empregados ";
            if($filtro != '')
            {
                $sql .= " WHERE id_empregado IN (" . implode(',', explode('|', $filtro)) . ")";
            }
            $rs = $bd->GetRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_empregado']);
                array_push($labels, $row['nome']);
            }

            break;

        case 'entidades':
        case 'entities':
            $sql =  "SELECT id_entidade, ".
                    "   nome ".
                    "FROM entidades ";
            //$rs = $bd->executarSQL($sql)->GetRows();
            $rs = $bd->getRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_entidade']);
                array_push($labels, $row['nome']);
            }

            break;

        case 'lojas':
        case 'stores':
            $sql =  "SELECT id_loja, ".
                    "   nome ".
                    "FROM lojas ";
            if($filtro != '')
            {
                $sql .= "WHERE id_loja IN ($filtro)";
            }
            $rs = $bd->GetRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_loja']);
                array_push($labels, $row['nome']);
            }

            break;
        case "tipos_utilizadores":
            $sql = "select id_tipos_utilizadores id, nome
                from tipos_utilizadores ";
            if ($filtro != '')
            {
                $sql .= $filtro;
            }
            $sql .= " order by nome";
            $rs = $bd->GetRows($sql);

            foreach ($rs AS $row)
            {
                array_push($valores, $row['id']);
                array_push($labels, $row['nome']);
            }
            break;
        default:
            if ($nome == "entidade")
            {
                $sql = "SELECT e.id_" . $nome . ", e.nome FROM entidades e";
                if($filtro != '')
                    $sql = $sql . " ,  lojas_entidades le where e.id_entidade = le.id_entidade and le.id_loja = ".$filtro;
                $sql = $sql .";";
            } else
            {
                $sql = "SELECT id_" . $nome . ", nome FROM ". $nome."s;";
            }
            if(strcasecmp($_SESSION["sessao_tipo"],"Gestor") != 0 && strcasecmp($nome,"tipos_utilizadores") == 0)
                $sql = "SELECT id_" . $nome . ", nome FROM $nome WHERE id_" . $nome . " != 1;";

            $rs = $bd->executarSQL($sql);
            $num = $bd->obterNumRegistos($rs);
            $data = array();
            while ($row = $bd->obterRegisto($rs)) array_push($data, $row);

            for($i = 0; $i < $num; $i++)
            {
                //$bd->moverRegisto($rs,$i);
                array_push($valores, $data[$i]["id_" . $nome] /*$bd->obterValor($rs,"id_" . $nome)*/);
                array_push($labels, $data[$i]["nome"] /*$bd->obterValor($rs,"nome")*/);
            }

            break;
    }

    $html = "";
    $strWidth = "";
    if($width > 0)
    {
        $strWidth = "width:" . $width . "px;";
    }
    $strScript = "";
    if($script != '')
    {
        $strScript = "onChange = '$script'";
    }

    switch($nome)
    {
        default:
            $html .= "<select name='$nome' id='$nome' $strWidth $strScript>";
    }

    if(!$escolha)
    {
        if($tipo == 1)
        {
            $html .= "<option value='' selected>-- ".translate("word_all")." --</option>";
        }else if($tipo == 2)
        {
            $html .= "<option value='' selected>-- ".translate("word_choose")." --</option>";
        }
    }

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        $selected = "";
        if(strcasecmp($valor,$valores[$i]) == 0)
        { //caso algum filtro esteja accionado ou algum valor esteja seleccionado
            $selected = "selected";
        }
        $html .= "<option value='$valores[$i]' $selected>$labels[$i]</option>";
    }
    $html .= "</select>";

    if(!$output)
    {
        return $html;
    }
    echo $html;
}

function construirListaNewDropDown($includeAll, $functionName, $nome, $tipo, $valor , $filtro = '', $script = '', $width = 0, $output=true, $escolha=false, $selecao, $selectedInput)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);

    $valores = array();
    $labels = array();
    $selecao = explode(',', $selecao);
    $selecao = array_filter($selecao);
    switch($nome)
    {
        case 'estado': //utilizador
            $valores = array(1,2,3);
            //$labels = array("Activo","Bloqueado","Inactivo");
            $labels = array(translate('word_activo', true),translate('word_bloqueado', true),translate('word_inactivo', true));
            break;

        case 'tipo':
            $valores = array(1,2,3);
            //$labels = array("Terminado", "Suspensa", "Redireccao");
            $labels = array(translate('word_finished', true), translate('word_suspensa', true), translate('word_redireccao', true));
            break;

        case 'servico':
        case 'servicos':
        case 'services':
            if (trim($filtro)!="|" && trim($filtro) != '')
            {
                $filtro_arr = explode("|", $filtro);
                $loja = trim($filtro_arr[0]);
                $entidade = isset($filtro_arr[1])?trim($filtro_arr[1]):"";

                if (!strlen($entidade))
                {
                    $entidades = array();
                    $sql = "select id_entidade from lojas_entidades where id_loja='".$loja."'";
                    $rs = $bd->executarSQL($sql);
                    while ($row = $bd->obterRegisto($rs))
                    {
                        array_push($entidades, $row['id_entidade']);
                    }
                    $sql = "select id_servico, nome from servicos where id_entidade in ('".implode("','", $entidades)."')";
                }
                else
                {
                    $sql = "select id_servico, nome from servicos where id_entidade='".$entidade."'";
                }
            }
            else
            {
                $sql = "select id_servico, nome from servicos";
            }
            $rs = $bd->executarSQL($sql);
            while ($row = $bd->obterRegisto($rs))
            {
                array_push($valores, $row['id_servico']);
                array_push($labels, $row['nome']);
            }
            break;

        case 'opcoesResumoMensal';
            $sql = "SELECT DISTINCT DATE_FORMAT(data, '%Y-%m') AS label, CONCAT(DATE_FORMAT(data, '%Y-%m'), '-01') AS value FROM senhas";
           
            //$rs = $bd->executarSQL($sql)->GetRows();
            $rs = $bd->getRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['value']);
                array_push($labels, $row['label']);
            }

            break;

        case 'colaboradores':
        case 'empregados':
        case 'employes':
            $sql =  "SELECT id_empregado, ".
                    "   nome ".
                    "FROM empregados ";
            if($filtro != '')
            {
                $sql .= " WHERE id_empregado IN (" . implode(',', explode('|', $filtro)) . ")";
            }
            $rs = $bd->GetRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_empregado']);
                array_push($labels, $row['nome']);
            }

            break;

        case 'entidades':
        case 'entities':
            $sql =  "SELECT id_entidade, ".
                    "   nome ".
                    "FROM entidades ";
            //$rs = $bd->executarSQL($sql)->GetRows();
            $rs = $bd->getRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_entidade']);
                array_push($labels, $row['nome']);
            }

            break;

        case 'lojas':
        case 'stores':
            $sql =  "SELECT id_loja, ".
                    "   nome ".
                    "FROM lojas ";
            if($filtro != '')
            {
                $sql .= "WHERE id_loja IN ($filtro)";
            }
            $rs = $bd->GetRows($sql);

            foreach($rs AS $row)
            {
                array_push($valores, $row['id_loja']);
                array_push($labels, $row['nome']);
            }

            break;
        case "tipos_utilizadores":
            $sql = "select id_tipos_utilizadores id, nome
                from tipos_utilizadores ";
            if ($filtro != '')
            {
                $sql .= $filtro;
            }
            $sql .= " order by nome";
            $rs = $bd->GetRows($sql);

            foreach ($rs AS $row)
            {
                array_push($valores, $row['id']);
                array_push($labels, $row['nome']);
            }
            break;
        case "periodSelection2":
            $valores = $valor;
            $labels = $filtro;
            break;
        default:
            if ($nome == "entidade")
            {
                $sql = "SELECT e.id_" . $nome . ", e.nome FROM entidades e";
                if($filtro != '')
                    $sql = $sql . " ,  lojas_entidades le where e.id_entidade = le.id_entidade and le.id_loja = ".$filtro;
                $sql = $sql .";";
            } else
            {
                $sql = "SELECT id_" . $nome . ", nome FROM ". $nome."s;";
            }
            if(strcasecmp($_SESSION["sessao_tipo"],"Gestor") != 0 && strcasecmp($nome,"tipos_utilizadores") == 0)
                $sql = "SELECT id_" . $nome . ", nome FROM $nome WHERE id_" . $nome . " != 1;";

            $rs = $bd->executarSQL($sql);
            $num = $bd->obterNumRegistos($rs);
            $data = array();
            while ($row = $bd->obterRegisto($rs)) array_push($data, $row);

            for($i = 0; $i < $num; $i++)
            {
                //$bd->moverRegisto($rs,$i);
                array_push($valores, $data[$i]["id_" . $nome] /*$bd->obterValor($rs,"id_" . $nome)*/);
                array_push($labels, $data[$i]["nome"] /*$bd->obterValor($rs,"nome")*/);
            }
            
            break;
    }

    $html = "";
    $strWidth = "";
    if($width > 0)
    {
        $strWidth = "width:" . $width . "px;";
    }
    $strScript = "";
    if($script != '')
    {
        $strScript = "onChange = '$script'";
    }

    /*switch($nome)
    {
        default:            
            $html .= "<select name='$nome' id='$nome' $strWidth $strScript>";
    }*/

  /*  if(!$escolha)
    {
        if($tipo == 1)
        {
            $html .= "<option value='' selected>-- ".translate("word_all")." --</option>";
        }else if($tipo == 2)
        {
            $html .= "<option value='' selected>-- ".translate("word_choose")." --</option>";
        }
    }*/
    $isFrequency = ''; 
    if(is_string($selectedInput))
        $isFrequency = "class='frequency'";

    $num = count($valores);  

    if (count($selecao) == 0) {
        $escolhaHtml = "<i class=\"uil uil-check section-selected\"></i>";
    } else {
        $escolhaHtml = "<i class=\"uil uil-check section-selected\" style=\"display:none;\"></i>";
    }
    if($includeAll)
        $html .= "<a href=\"#\" value='' class='section-all'>" . ($escolhaHtml) .translate("word_all")."</a>";

    for($i = 0; $i < $num; $i++)
    {
        $selected = "";
        $escolhaHtml = "<i class=\"uil uil-check section-selected\" style=\"display:none;\"></i>";
        //if(strcasecmp($selecao[$i],$valores[$i]) == 0)
        if(in_array($valores[$i], $selecao, true) || $selectedInput == $valores[$i])
        { //caso algum filtro esteja accionado ou algum valor esteja seleccionado
            $selected = "selected='selected'";
            $escolhaHtml = "<i class=\"uil uil-check section-selected\"></i>";
        }
        $html .= "<a $selectedInput $isFrequency $selecao[$i] href=\"#\" value='$valores[$i]' $selected>" . ($escolhaHtml) . $labels[$i] . "</a>";
        //$html .= "<option value='$valores[$i]' $selected>$labels[$i]</option>";
    }
    $html .= "<a href=\"#\" value='' class='section-button' onClick='onSubmit_" . $functionName . "();'>".translate("word_choose")."</a>";
    //$html .= "</select>";

    if(!$output)
    {
        return $html;
    }
    echo $html;
}
/*
        $html .= "<div class=\"sec-center\">";
        $html .= "<input class=\"dropdown\" type=\"checkbox\" id=\"dropdown\" name=\"dropdown\"/>";
        $html .= "<label class=\"for-dropdown\" for=\"dropdown\">Dropdown Menu <i class=\"uil uil-arrow-down\"></i></label>";
        $html .= "<div class=\"section-dropdown\">";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<input class=\"dropdown-sub\" type=\"checkbox\" id=\"dropdown-sub\" name=\"dropdown-sub\"/>";
        $html .= "<label class=\"for-dropdown-sub\" for=\"dropdown-sub\">Dropdown Sub <i class=\"uil uil-plus\"></i></label>";
        $html .= "<div class=\"section-dropdown-sub\">";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "</div>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "</div>";
        $html .= "</div>";*/

function construirListaGeralServicos($nome, $tabela, $valor, $label, $opcao_seleccionada = "",
        $opcao_vazia = "", $script = "" , $id_filtro = '' ,$valor_filtro = '')
{
    $valores = array();
    $labels = array();
    $entidades = array();


    if (!strlen($opcao_vazia)) $opcao_vazia = "-- ".translate("word_choose")." --";

    $obj = new Servico();
    if($valor_filtro == '')
        $servicos_entidade = $obj -> obterDados();
    else
        $servicos_entidade = $obj -> obterDados($valor_filtro);
    $obj->Fechar();

    $num = count($servicos_entidade);

    for($i = 0; $i < $num; $i++)
    {
        array_push($valores,$servicos_entidade[$i]["id_servico"]);
        array_push($labels, $servicos_entidade[$i]["nome"]);
        array_push($entidades, $servicos_entidade[$i]["entidade"]);

    }

    echo "<select name='".$nome."' id='".$nome."' onChange='".$script."'>";
    echo "\n<option value='' selected>".$opcao_vazia."</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($opcao_seleccionada,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i]." (".$entidades[$i].")" . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i]." (".$entidades[$i].")" . "</option>";
    }
    echo "</select>";
}

function construirListaGeral($nome, $tabela, $valor, $label, $opcao_seleccionada = "",
        $opcao_vazia = "", $script = "" , $id_filtro = '' ,$valor_filtro = '')
{
    if (!strlen($opcao_vazia)) $opcao_vazia = "-- ".translate("word_choose")." --";


    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);

    $valores = array();
    $labels = array();

    switch ($tabela)
    {
        case "lojas":

            $sql = "select t.".$valor.", t.".$label."
                FROM lojas t
                inner join lojas_entidades le on t.".$valor."=le.".$valor;

           $sql = "SELECT id_loja, nome
                FROM lojas 
                WHERE id_loja > 0;";


            $aux = array();
            /*if (is_array($_SESSION["loja"]) && !empty($_SESSION["loja"]))
            {
                array_push($aux, "t.id_loja in (".implode(",", $_SESSION["loja"]).")");
            }
            if ($valor_filtro!='')
            {
                array_push($aux, "le.".$id_filtro."=".$valor_filtro);
            }

            if (count($aux)) $sql .= " where ".implode(" and ", $aux);
            $sql .= " ORDER BY t.". $valor ." ASC ";
*/
            break;
        default:
            $sql = "SELECT t." . $valor . ", t.". $label ." FROM ".$tabela." t";
            if($valor_filtro != '')
                $sql = $sql . ", lojas_entidades le WHERE t.".$valor."=le.".$valor." AND le.".$id_filtro."=".$valor_filtro;

            $sql = $sql . " ORDER BY t.". $valor ." ASC ";

            // estados de dispensador: 1 e 4 referen-se ao mesmo estado: Operacional
            // Isto teve de ser martelado... senão aparecia o estado Operacional duplicado
            // IMPORTANTE: devem exitir os 2 "Operacionais" (1 e 4) na tabela de estados_dispensador!
            if ("estados_dispensador" == $tabela)
            {
                $sql .= " limit 3";

                if ($opcao_seleccionada == 4) $opcao_seleccionada = 1;
            }
            break;
    }

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);
    $data = array();
    while ($row = $bd->obterRegisto($rs)) array_push($data, $row);

    for($i = 0; $i < $num; $i++)
    {
        //$bd->moverRegisto($rs,$i);
        array_push($valores, $data[$i][$valor] /*$bd->obterValor($rs, $valor)*/);
        if($data[$i][$label] == "Activo")
            array_push($labels,translate('word_activo', true));    
        else if($data[$i][$label] == "Inactivo")
            array_push($labels,translate('word_inactivo', true));  
        else 
        if (strcmp($tabela, "servicos") == 0)
        { /* encode services .. */
            array_push($labels, $data[$i][$label] /*$bd->obterValor($rs, $label)*/);
        }
        else if (strcmp($tabela, "empregados") == 0)
        {
            array_push($labels, $data[$i][$label] /*$bd->obterValor($rs, $label)*/);
        }
        else
        {            
            array_push($labels,$data[$i][$label] /*$bd->obterValor($rs, $label)*/);
        }
    }

    echo "<select name='".$nome."' id='".$nome."' onChange='".$script."'>";
    echo "\n<option value='' selected>".$opcao_vazia."</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($opcao_seleccionada,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";
}

function construirListaEntidadeServicos($nome, $opcao_seleccionada = "", $grupo ,
        $opcao_vazia = "Escolha...", $script = "" , $id_filtro = '' ,$valor_filtro = '')
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $valores = array();
    $labels = array();

    if(!is_array($grupo))
    {
        $temp = $grupo;
        $grupo[0] = $temp;
    }

    $sql = "SELECT DISTINCT t.nome, t.id_servico FROM servicos t
        WHERE ";

    if($valor_filtro != '')
        $sql .= " t.id_entidade = ".$valor_filtro;
    else
    {
        $sql .= "(t.id_entidade = ".$grupo[0];
        for($i=1; $i < count($grupo); $i++)
            $sql .= " OR t.id_entidade = ".$grupo[$i];
        $sql .=  ") ";

    }
    $sql .= " ORDER BY t.id_servico  ASC ;";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($valores,$bd->obterValor($rs, "id_servico"));
        array_push($labels, $bd->obterValor($rs, "nome"));

    }

    echo "<select name='".$nome."' id='".$nome."' onChange='".$script."'>";
    echo "\n<option value='' selected>".$opcao_vazia."</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($opcao_seleccionada,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";




}

function construirListaCampos($numero, $seleccionado)
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $valores = array();
    $labels = array();

    $sql = "SELECT id_tipos_campos, nome FROM tipos_campos ORDER BY nome ASC ;";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($valores,$bd->obterValor($rs, "id_tipos_campos"));
        array_push($labels,$bd->obterValor($rs, "nome"));
    }

    if($_REQUEST["id"])
        echo "<select name='tipos[]' onChange='inserirCampoReferencia(this,".$numero.",".$_REQUEST["id"].")' >";
    else
        echo "<select name='tipos[]' onChange='inserirCampoReferencia(this,".$numero.",0)' >";
    echo "\n<option value='' selected>Escolha...</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($seleccionado,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";
}


function construirListaServicos($numero, $seleccionado, $form=0)
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $valores = array();
    $labels = array();

    $sql = "SELECT id_servico, nome FROM servicos ORDER BY nome ASC ;";

    $rs = $bd->executarSQL($sql);
    $num = $bd->obterNumRegistos($rs);

    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($valores,$bd->obterValor($rs, "id_servico"));
        array_push($labels,$bd->obterValor($rs, "nome"));
    }

    echo "<select name='accao_tecla_".$numero."' onChange='actualizaForm(".$form.");' >";

    echo "\n<option value='' selected>Escolha...</option>";

    $num = count($valores);

    for($i = 0; $i < $num; $i++)
    {
        if(strcasecmp($seleccionado,$valores[$i]) == 0)//caso algum filtro esteja accionado ou algum valor esteja seleccionado
            echo "\n<option value='" . $valores[$i] . "' selected>" . $labels[$i] . "</option>";
        else
            echo "\n<option value='" . $valores[$i] . "'>" . $labels[$i] . "</option>";
    }
    echo "</select>";
}


function construirTipoAccao($nome, $seleccionado, $enabled = 1)
{


    if($seleccionado == 0)
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"0\" checked=\"checked\" ";
    } else
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"0\" ";
    }
    if($enabled)
        echo "/>";
    else
        echo "disabled=\"disabled\"/>";
    echo translate("word_call", true)." ".translate("word_ticket", true)." &nbsp;&nbsp;";

    if($seleccionado == 1)
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"1\" checked=\"checked\" ";
    } else
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"1\" ";
    }
    if($enabled)
        echo "/>";
    else
        echo "disabled=\"disabled\"/>";
    echo translate("word_recall", true)." ".translate("word_ticket", true)." &nbsp;&nbsp;";

    if($seleccionado == 2)
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"2\" checked=\"checked\" ";
    } else
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"2\" ";
    }
    if($enabled)
        echo "/>";
    else
        echo "disabled=\"disabled\"/>";
    echo translate("word_call", true)." ".translate("word_ticket", true)." ".translate("word_before", true)." &nbsp;&nbsp;<br/>";

    if($seleccionado == 3)
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"3\" checked=\"checked\" ";
    } else
    {
        echo "<input type=\"radio\" name=\"".$nome."\" value=\"3\" ";
    }
    if($enabled)
        echo "/>";
    else
        echo "disabled=\"disabled\"/>";
    echo translate("word_open", true)." / ".translate("word_close", true)." ".translate("word_services", true)." &nbsp;&nbsp;";

}


// Fun��o que constr�i a um vector com os elementos separados por virgulas (tokenizer)
function construcaoVector($string, $tok)
{
    $vector = array();
    $token = strtok($string, $tok);
    while($token != "")
    {
        array_push($vector,$token);
        $token = strtok($tok);
    }
    return $vector;
}


// Fun��o que devolve o nome correcto do tipo de m�dulo
function devolveTipo($modulo)
{

    // Nomes dos Tipos de Objectos do Sistema
    if(strcmp($modulo, "terminal") == 0)
        return "Terminal";
    if(strcmp($modulo, "impressora") == 0)
        return "Impressora";
    if(strcmp($modulo, "dispensador") == 0)
        return "Dispensador";
    if(strcmp($modulo, "processador") == 0)
        return "Processador";
    if(strcmp($modulo, "ecra") == 0)
        return "Ecra";


    // Nomes das Medidas das Estat�sticas
    if(strcmp( $modulo, "atendimento") == 0)
        return "Média do Tempo de Atendimento";
    if(strcmp( $modulo, "espera") == 0)
        return "Média do Tempo de Espera";
    if(strcmp( $modulo, "numero_atendimento") == 0)
        return "Total de Clientes Atendidos";
    if(strcmp( $modulo, "numero_desistencia") == 0)
        return "Total de Desistências";
    if(strcmp( $modulo, "produtividade") == 0)
        return "Produtividade";

    // Nomes dos grupos das Estat�sticas
    if(strcmp( $modulo, "loja") == 0)
        return "Loja";
    if(strcmp( $modulo, "servico") == 0)
        return "Serviço";
    if(strcmp( $modulo, "colaborador") == 0)
        return "Colaborador";
    if(strcmp( $modulo, "balcao") == 0)
        return "Balcão";
    if(strcmp( $modulo, "entidade") == 0)
        return "Entidade";

}

function debug($str)
{
    if(DEBUG != true)
        return;

    if(!is_null($str) && is_array($str))
        $str = print_r($str, true);

    $backtrace = debug_backtrace();

    $file = basename($backtrace[0]['file']);
    if($file == 'AcessoBD.class.php' || $file == 'DBAccess.class.php')
    {
        $backtrace = $backtrace[1];
    }else
    {
        $backtrace = $backtrace[0];
    }

    $fp = fopen(DIR_DEBUG . "/debug.txt","a+");
    $header = "\n\n------------------------------- [" . devolveHoje(true) . "] --- $backtrace[file]:$backtrace[line]\n\n";
    fputs($fp, $header . $str);
    fclose($fp);
}

/*
   function debug($str, $file="") {
   if (strlen($file)) $fp = fopen($file,"a");
   else $fp = fopen("debug.txt","a");
   fputs($fp,$str."\n\n--NEXT--\n\n");
   fclose($fp);
   }
*/

function devolveHoje($complete)
{
    $data = date("Y-m-d");
    if ($complete)
        $data .= " " . date("H:i:s");
    return $data;
}


// Fun��o que faz o tratamento de uma string
function trataString($str)
{
    $str = strtolower($str);
    $str = str_replace(" ", "_", $str);
    $as = array("�", "�", "�", "�", "�", "�", "�", "�");
    $str = str_replace($as, "a", $str);
    $es = array("�", "�", "�", "�", "�", "�");
    $str = str_replace($es, "e", $str);
    $is = array("�", "�", "�", "�", "�", "�");
    $str = str_replace($is, "i", $str);
    $os = array("�", "�", "�", "�", "�", "�", "�", "�");
    $str = str_replace($os, "o", $str);
    $us = array("�", "�", "�", "�", "�", "�");
    $str = str_replace($us, "u", $str);
    $cs = array("�", "�");
    $str = str_replace($cs, "c", $str);

    return $str;
}

function obterNomeGeral($valor, $entrada, $saida, $tabela)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);

    $sql = "SELECT ".$saida." FROM ".$tabela." WHERE ".$entrada."='". $valor ."';";

    if(!$rs = $bd->executarSQL($sql))
        return 0;
    else {
        $nome = $bd->obterRegisto($rs)[$saida];
        if ($nome != "")
            return $nome;
        else
            return translate('word_sem_associacao');
    }
}

function obterTipoUtilizador($tipo)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "SELECT nome FROM tipos_utilizadores WHERE id_tipos_utilizadores=". $tipo .";";

    if (($rs = $bd->executarSQL($sql)) == 0)
        return 0;
    else
        return $bd->obterValor($rs,0);

}

function obterEstadoUtilizador($tipo)
{
    $estado = "";
    switch($tipo)
    {
        case 1:
            $estado = translate('word_activo',true);//"Activo";
            break;
        case 2:
            $estado = translate('word_bloqueado',true);//"Bloqueado";
            break;
        case 3:
            $estado = translate('word_inactivo',true);//"Inactivo";
            break;
        default: break;
    }
    return $estado;
}

function obterEstadoGeral($estado)
{    
    switch($estado)
    {
        case "Operacional":
            $estado = translate('word_operational',true);
            break;
        case "Inoperacional":
            $estado = translate('word_notoperational',true);
            break;
        case "Activo":
            $estado = translate('word_activo',true);
            break;
        case "Inactivo":
            $estado = translate('word_inactivo',true);
            break;
        case "Fechado":
            $estado = translate('word_fechado',true);
            break;
        case "Disponivel":
            $estado = translate('word_disponivel',true);
            break;
        case "Em atendimento":
            $estado = translate('word_in_attendance',true);
            break;
        default: break;
    }
    return $estado;
}


function obterTabela($bd, $nome)
{
    $sql = "SHOW FULL COLUMNS FROM " . $nome . ";";
    $tabela = $bd->executarSQL($sql);
    return $tabela;
}

function obterNome($bd, $tipo, $id, $escolha) // $escolha = 1 -> nome / $escolha = 2 -> nome  da tabela

{
    switch($escolha)
    {
        case 1:
            $sql = "SELECT nome FROM " . $tipo . " WHERE id_" . $tipo . " = " . $id . ";";
            break;
        case 2:
            $sql = "SELECT nome_tabela FROM " . $tipo . " WHERE id_" . $tipo . " = " . $id . ";";
            break;
        case 3:
            $sql = "SELECT nome FROM " . $tipo . " WHERE nome_tabela = blocos_" . $id . ";";
            break;
        case 4:
            return "blocos_" . $id;
            break;
        default:
            break;
    }

    if($rs = $bd->executarSQL($sql))
        return $bd->obterValor($rs,0);
    else
        return 0;
}

/*
 * Obtem os tempos (minimo e maximo) de atendimento usando a
 * instancia da base de dados ($bd) passada como argumento.
 *
 * Devolve um array que contem os tempos minimo e maximo de
 * atendimento ou 0 caso aconteca algum erro.
*/
function obterTemposAtendimento($bd)
{
    $sql = "SELECT nome, valor FROM variaveis
        WHERE nome='tempo_minimo_atendimento' OR nome='tempo_maximo_atendimento';";

    if(!$rs = $bd->executarSQL($sql))
        return 0;

    $tempo_maximo = 0;
    $tempo_minimo = 0;

    for($i = 0; $i < $bd->obterNumRegistos($rs) ; $i++)
    {
        $bd->moverRegisto($rs,$i);

        if($bd->obterValor($rs, "nome") == "tempo_minimo_atendimento")
            $tempo_minimo = $bd->obterValor($rs, "valor");

        if($bd->obterValor($rs, "nome") == "tempo_maximo_atendimento")
            $tempo_maximo = $bd->obterValor($rs, "valor");
    }

    $res = array();
    array_push($res, $tempo_minimo);
    array_push($res, $tempo_maximo);

    return $res;
}

function listar($tabela, $id, $nome)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "SELECT ".$id." id, ".$nome." FROM ".$tabela." WHERE ".$id." > 0";

    $rs = $bd->executarSQL($sql);

    $items = array();

    for ( $i = 0 ;  $i < $bd->obterNumRegistos($rs) ; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push( $items, $bd->obterRegisto($rs));
    }

    return $items;

}

/*
   Cria um documento XML com os elementos raiz
   para ser utilizado para a sincroniza��o de
   bases de dados.
*/

function abreXMLSync()
{

    $documento = new DOMDocument("1.0", "UTF-8" );
    $documento->formatOutput = true;
    $root = $documento->createElement("actualizacaoSistema");
    $documento->appendChild($root);

    return $documento;
}

/*
   Grava o documento XML num ficheiro com o
   formato adequado � sincroniza��o de base
   de dados
*/

function fechaXMLsync($documento)
{

    GLOBAL $DIR_XML_DISPWEB;

    $data = date("Y-m-d_H.i.s");

    $ficheiro_base = $DIR_XML_DISPWEB ."SyncSystem_".$data;
    $ficheiro = $ficheiro_base .".xml";

    for($i=1 ; file_exists($ficheiro) ; $i++)
    {
        $ficheiro = $ficheiro_base."_".sprintf("%02d", $i).".xml";
    }
    //file_put_contents("/tmp/debug.txt", "\n directori xml   ".$ficheiro , FILE_APPEND);
    $documento->save($ficheiro);
}


function fechaXMLResumo($documento)
{

    GLOBAL $DIR_XML_RESUMO;

    $ficheiro_base = $DIR_XML_RESUMO."resumo";
    $ficheiro = $ficheiro_base.".xml";

    for($i=1 ; file_exists($ficheiro) ; $i++)
    {
        $ficheiro = $ficheiro_base."_".sprintf("%02d", $i).".xml";
    }
    //file_put_contents("/tmp/debug.txt", "\n directori xml   ".$ficheiro , FILE_APPEND);
    $documento->save($ficheiro);
}

function devolveSegundos($hora)
{
    $tempoSegundos;
    $tempo = array();
    $tempo = construcaoVector($hora, ":");

    $tempoSegundos = $tempo[0]*3600;
    $tempoSegundos += $tempo[1]*60;

    return $tempoSegundos;
}

/*
 * Converte um identificador do estado de uma senha
 * num nome.
*/
function devolveTipoSenha($id)
{
    $tipo = "";
    switch($id)
    {
        case 1: $tipo = "Terminado";
            break;
        case 2: $tipo = "Suspensa";
            break;
        case 3: $tipo = "Redireccao";
            break;
    }
    return $tipo;
}
/*
 * Devolve o mo'dulo que o utilizador esta' a visualizar.
*/
function obtemModuloActual()
{
    $uri = $_SERVER['REQUEST_URI'];
    $parts = explode("/",$uri);
    $modulo = $parts[count($parts) - 2];

    if ($modulo == 'servicos')
    {
        if ($parts[count($parts) - 1] == 'senhas.php')
        {
            // modulo de contagem de senhas (servicos/senhas.php)
            $modulo = 'contagemsenhas';
        }
    }
    return $modulo;
}

/*
 * Devolve o nome do menu (modulo geral) ao qual o $modulo pertence.
*/
function obtemModuloGeral($modulo)
{
    /* TODO: colocar info dos menus na BD/array global/XML */
    $administracao = array("servicos","entidades","lojas",
            "objectos_tipo", "ecras", "dispensadores", "conteudos");
    $negocio = array ("utilizadores", "colaboradores", "balcoes","horarios_loja","horarios_promocao","horarios", "contagemsenhas",  "promocoes", "tipos_utilizadores", "forms", "sms");
    $registos = array ("estatisticas", "previsoes", "log_accoes",
            "log_acessos_utilizadores", "log_acessos_colaboradores", "atendimentos", "atendimentosBalcao", "resumoSistema", "volumeTransaccoes", "form_submissions", "exports");

    if (in_array($modulo, $administracao))
    {
        $modulo = "administracao";
    } else if (in_array($modulo, $negocio))
    {
        $modulo = "negocio";
    } else if (in_array($modulo, $registos))
    {
        $modulo = "relatorios";
    }
    return $modulo;
}

/*
 * Função de debug.
*/
function debugSQL($str)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "INSERT INTO debug(msg) VALUES ('$str');";
    if(!$rs = $bd->executarSQL($sql))
        return 0;
    else
        return 1;
}

/*
 * Devolve a classe CSS de um dado menu,
 * consoante este esteja activo ou não.
*/
function obterClasseMenu($menu)
{
    if ($_SESSION["menu_actual"] == $menu)
    {
        echo "class=\"menu_" . $menu . "_enabled\"";
    } else
    {
        echo "class=\"menu_" . $menu . "_disabled\"";
    }
}

/*
 * Gerador de páginas.
*/
function drawPaginas($url2spread, $numPaginas, $pagina, $accoes = false)
{
    global $N_REGISTOS;
    $n = 1;
    $numRegPag = $N_REGISTOS; // numero de registos por pagina
    if($pagina == '')
        $pagina = 1;
    if($pagina > $numPaginas)
        $pagina = $numPaginas;



    $html = "<table class='paginas_table' cellspacing='0' cellpadding='0'><tr><td class='button_page' style='width: 230px;'>";
    if($pagina > 1)
    {
        $pagAnterior = $pagina - 1;
        $html .= "<a href='?pagina=$pagAnterior&campo=" . (array_key_exists('campo', $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" .  (array_key_exists('ordem', $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div> < </div></a> ";
    }
    else
    {
        $pagina = 1; // na primeira vez n�o h� request
        $html .= "<div> < </div>";
    }

    while($n <= $numPaginas)
    {

        if( ($n >= ($pagina - 3)) && ($n <= ($pagina + 3)) ){
          if($n == $pagina)
              $html .= "<a href='?pagina=$n&campo=" . (array_key_exists('campo', $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists('ordem', $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><span class='current_page'>$n</span></a>";
          else
              $html .= "<a href='?pagina=$n&campo=" . (array_key_exists('campo', $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists('ordem', $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><span class='other_page'>$n</span></a>";
        }

        $n++;
    }

    $n = ($pagina - 1)*$numRegPag;
    $incremento = $n;

    if($pagina < $numPaginas)
    {
        $pagPosterior = $pagina + 1;
        $html .= "<a href='?pagina=$pagPosterior&campo=" . (array_key_exists('campo', $_REQUEST) ? $_REQUEST['campo'] : '') . "&ordem=" . (array_key_exists('ordem', $_REQUEST) ? $_REQUEST['ordem'] : '') . "'><div> > </div></a> ";
    }
    else
    {
        if($numTuplos % $numRegPag != 0)
            $numRegPag = $numTuplos % $numRegPag;
        $html .= "<div> > </div>";
    }

/*
  $html = "<table class='paginas_table' cellspacing='0' cellpadding='0'><tr><td style='width: 190px;'>";
 if($pagina > 1)
    {
        $html .= "<a href='$url2spread&pagina=1'> |< </a>";
        $html .= "<a href='$url2spread&pagina=" . ($pagina - 1) . "'> < </a> ";
    }else
    {
        $html .= " |< ";
        $html .= " < ";
    }

    $html .= "<strong>&nbsp;P&aacute;gina $pagina/$numPaginas&nbsp;</strong>";

    if($pagina < $numPaginas)
    {
        $html .= "<a href='$url2spread&pagina=" . ($pagina + 1) . "'> > </a>";
        $html .= "<a href='$url2spread&pagina=$numPaginas'> >| </a>";
    }else
    {
        $html .= " > ";
        $html .= " >| ";
    }
    */

    $html .= "&nbsp;&nbsp;</td><td style='width: 130px;'>" . translate('word_num_pagina', true) . "<input id='selectPageInput' onKeyDown='if (event.keyCode == 13) jumpToPage(\"$url2spread\");' maxlength='4' size='3' value='#'/>&nbsp;</td>
  <td class='button'>
    <a href='javascript: jumpToPage(\"$url2spread\")'>
      <div class='button-thin-green'style='width: 40px;' >OK</div>
    </a>";

    if($accoes)
        $html .= "</td><td style='width:50%'><div class='menu_accoes'><font class='function_space_accoes'>$accoes</font></div>";
    $html .= "</td></tr></table>";

    return $html;
}

function GetIdServicos($id_entidade='')
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select id_servico from servicos";
    if ($id_entidade) $sql .= " where id_entidade='" . $id_entidade . "'";
    $sql .= " order by nome";
    $rs = $bd->executarSQL($sql);

    $servicos = array();
    $num = $bd->obterNumRegistos($rs);
    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($servicos, $bd->obterValor($rs, 'id_servico'));
    }
    //~ print_r($servicos);
    return $servicos;
}

function GetIdEntidades($id_loja='', $id_servico='')
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select distinct e.id_entidade from entidades e, lojas_entidades le, servicos s where e.id_entidade=le.id_entidade and e.id_entidade=s.id_entidade";
    if ($id_loja) $sql .= " and le.id_loja='" . $id_loja . "'";
    if ($id_servico) $sql .= " and s.id_servico='" . $id_servico . "'";
    $sql .= " order by e.nome";
    $rs = $bd->executarSQL($sql);

    $entidades = array();
    $num = $bd->obterNumRegistos($rs);
    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($entidades, $bd->obterValor($rs, 'id_entidade'));
    }
    //~ print_r($servicos);
    return $entidades;
}

function GetIdLojas()
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select id_loja from lojas order by nome";
    $rs = $bd->executarSQL($sql);

    $lojas = array();
    $num = $bd->obterNumRegistos($rs);
    for($i = 0; $i < $num; $i++)
    {
        $bd->moverRegisto($rs,$i);
        array_push($lojas, $bd->obterValor($rs, 'id_loja'));
    }
    return $lojas;
}

function GetNomeServico($id)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select nome from servicos where id_servico='" . $id . "'";
    $rs = $bd->executarSQL($sql);

    return $bd->obterValor($rs, 'nome');
}

function GetNomeEntidade($id)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select nome from entidades where id_entidade='" . $id . "'";
    $rs = $bd->executarSQL($sql);

    return $bd->obterValor($rs, 'nome');
}

function GetNomeLoja($id)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $sql = "select nome from lojas where id_loja='" . $id . "'";
    $rs = $bd->executarSQL($sql);

    return $bd->obterValor($rs, 'nome');
}

function GetSecondsFromTimeString($str)
{
    $arr = explode(':', $str);

    @$sec = $arr[2];
    @$sec += ($arr[1] * 60);
    @$sec += ($arr[0] * 3600);

    return $sec;
}

function Timestamp_to_Time($timestamp)
{
    $h = intval($timestamp / 3600);
    $h = $h>9?$h:("0".$h);
    $m = intval(($timestamp % 3600) / 60 );
    $m = $m>9?$m:("0".$m);
    $s = ($timestamp % 3600) % 60;
    $s = $s>9?$s:("0".$s);
    return $h . ":" . $m . ":" . $s;
}

function HTMLprint_r($var)
{
    echo str_replace("\n", "<br/>", print_r($var, true));
}

function getRequestValue($field, $defaultValue = '')
{
    if(isset($_REQUEST[$field]))
    {
        if (is_array($_REQUEST[$field]))
        {
            return serialize($_REQUEST[$field]);
        }
        else return $_REQUEST[$field];
    }
    return $defaultValue;
}

function getSessionValue($field, $defaultValue = '')
{
    if(isset($_SESSION[$field]))
    {
        return $_SESSION[$field];
    }
    return $defaultValue;
}


// "desenha" um ecran de multipla seleccao no ecran das estatisticas
function construirMultipleSelect($modulo, $title, $options = "", $filter="|", $id_cliente = -1, $escolha=false)
{
    $html = "";

    $html .= "<table>";
    $html .= "  <tr><td class=\"form-extra-desc text-bold text-gray-dark\">" . translate('word_add', true) . ":</td><td class=\"form-extra-desc text-bold text-gray-dark\">$title:</td></tr><tr>";
    if($options == "")
    {
        $html .= "  <td style=\"vertical-align: top;width: 155px;\"><div class=\"custom-select\">" . construirLista($modulo, 2, "", $filter, "estatisticasAddListItem(this);", 150, false, $escolha) . "</div></td>";
    }else
    {
        $html .= "  <td>$options</td>";
    }

    $html .= makeMultipleSelect($modulo);

    $html .= "  </tr>";
    
    $html .= "</table>";

    return $html;
}

// "desenha" um ecran de multipla seleccao no ecran das estatisticas
function construirMultipleSelectNewDropDown($includeAll, $functionName, $modulo, $title, $options = "", $filter="|", $cols, $selecao, $id_cliente = -1, $escolha=false)
{
    $html .= "<div class=\"sec-center sec-center-top\">";
    $html .= "<input class=\"dropdown\" type=\"checkbox\" id=\"dropdown$cols\" name=\"dropdown$cols\"/>";
    $html .= "<label class=\"for-dropdown$cols\" for=\"dropdown$cols\">$title <i class=\"uil uil-angle-down\"></i></label>";
    $html .= "<div class=\"section-dropdown\" id=\"$functionName\">";
    $html .= construirListaNewDropDown($includeAll, $functionName, $modulo, 2, $options, $filter, "estatisticasAddListItem(this);", 150, false, $escolha,  $selecao, $id_cliente);
    $html .= "</div>";
    //$html .= makeMultipleSelect($modulo);

    //$html .= "  </tr>";
    
    $html .= "</div>";

    return $html;
}
/*$html .= "<input class=\"dark-light\" type=\"checkbox\" id=\"dark-light\" name=\"dark-light\"/>";
        $html .= "<label for=\"dark-light\"></label>";
        $html .= "<div class=\"light-back\"></div>";
        $html .= "<a href=\"https://front.codes/\" class=\"logo\" target=\"_blank\">";
        $html .= "<img src=\"https://assets.codepen.io/1462889/fcy.png\" alt=\"\">";
        $html .= "</a>";
        $html .= "<div class=\"sec-center\">";
        $html .= "<input class=\"dropdown\" type=\"checkbox\" id=\"dropdown\" name=\"dropdown\"/>";
        $html .= "<label class=\"for-dropdown\" for=\"dropdown\">Dropdown Menu <i class=\"uil uil-arrow-down\"></i></label>";
        $html .= "<div class=\"section-dropdown\">";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<input class=\"dropdown-sub\" type=\"checkbox\" id=\"dropdown-sub\" name=\"dropdown-sub\"/>";
        $html .= "<label class=\"for-dropdown-sub\" for=\"dropdown-sub\">Dropdown Sub <i class=\"uil uil-plus\"></i></label>";
        $html .= "<div class=\"section-dropdown-sub\">";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "</div>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "<a href=\"#\">Dropdown Link <i class=\"uil uil-arrow-right\"></i></a>";
        $html .= "</div>";
        $html .= "</div>";*/

function makeMultipleSelect($modulo)
{
    $html = "   <td style=\"height:100px; overflow:auto; border:1px solid;\">";

    $html .= "  <div style=\"width:150px; height:100px; overflow:auto;\">";
    $html .= "  <table id=\"list_table_$modulo\" style=\"width:100%;\">";
    $html .= "      <tr id=\"null_item_$modulo\"></tr>";
    $html .= "  </table>";
    $html .= "  </div>";
    $html .= "  </td>";

    return $html;
}


function devolveNumeroTotal($tabela, $filter = "")
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $bd = new AcessoBD($conn);

    $whereSQL = "";
    if($filter != '')
    {
        $field = "";
        switch($tabela)
        {
            case 'empregados':
                $field = "id_empregado";
                break;
            case 'servicos':
                $field = "id_servico";
                break;
            case 'lojas':
                $field = "id_loja";
                break;
            default:
                $field = "id_$tabela";
        }
        $whereSQL = "WHERE $field IN ($filter)";
    }

    $sql = "SELECT COUNT(nome) AS count FROM `$tabela` $whereSQL";
    $rs = $bd->executarSQL($sql);
    if($rs === FALSE)
    {
        return 0;
    }
    return $bd->obterValor($rs , "count");

}



/**
 * $type can be: "column"; "line"; "stock"
 */
function dumpGrafico($id, $type, $settingsFile, $dataFile="", $downloadURL='')
{
    // dump html stuff
    $str = "<script type=\"text/javascript\" src=\"../charts/swfobject.js\"></script>
        <div id=\"$id\">
        <!--strong>You need to upgrade your Flash Player</strong-->
        </div>

        <script type=\"text/javascript\">
        // <![CDATA[
        var so = new SWFObject(\"../charts/am$type.swf\", \"am$type\", \"758\", \"500\", \"8\", \"#FFFFFF\");
    so.addVariable(\"path\", \"../charts/\");
    so.addVariable(\"settings_file\", escape(\"$settingsFile\"));  // you can set two or more different settings files here (separated by commas)
            ";
    if($dataFile != "")
    {
        $str .= "so.addVariable(\"data_file\", escape(\"$dataFile\"));
                ";
    }
    $str .= "   so.addVariable(\"preloader_color\", \"#999999\");
    so.write(\"$id\");
    // ]]>
    </script>";

    if($downloadURL != '')
    {
        $str .= dumpExportButton($downloadURL);
    }
    return $str;
}

/**
 * $type can be: "column"; "line"; "stock"
 */
function dumpGraficoJs($id, $dataFile="", $downloadURL="")
{
    if($dataFile != "")
    {
        $url = $dataFile;
    }
    // dump html stuff
    $str = "<div id=\"$id\">\n".
        $url."\n".
        "</div>";

  /*  if($dataFile != "")
    {
        $param2 = mysql_escape_string($dataFile);
    }*/


    if($downloadURL != '')
    {
        $str .= dumpExportButton($downloadURL);
    }
    return $str;
}


/**
 * dump html to a button
 */
function dumpExportButton($downloadURL, $textBefore="", $title='Exportar (.csv)', $align='right')
{
    $html = "";
    $title = translate('word_exportar_xlsx', true);

    $extraCell = "<td>&nbsp;</td>";
    $alignHtml = "";

    switch($align)
    {
        case 'left':
            $alignHtml = "text-align: left;";
            break;
        case 'center':
            $alignHtml = "text-align: center;";
            break;
        case 'rigth':
            $alignHtml = "text-align: right;";
            break;
    }

    if($textBefore != '')
    {
        $extraCell = "<td style='text-align: right;'><strong>$textBefore</strong>&nbsp;</td>";
    }

    $html .= "<table width='100%'>";
    $html .= "<tr><td>&nbsp;</td></tr>";
    $html .= "<tr>";//$extraCell";
    $html .= "<td style='$alignHtml' class='button' width=132><a href=\"$downloadURL\"><div class='button-thin-green'>$title</div></a></td>";
    $html .= "</tr>";
    $html .= "<tr><td>&nbsp;</td></tr>";
    $html .= "</table>";

    return $html;
}


function PostRequest($url, $_data)
{

    // convert variables array to string:
    $data = array();
    while(list($n,$v) = each($_data))
    {
        $data[] = "$n=$v";
    }
    $data = implode('&', $data);
    // format --> test1=a&test2=b etc.

    // parse the given URL
    $url = parse_url($url);

    $portToConnect = 80;
    switch($url['scheme'])
    {
        case 'http':
            $portToConnect = 80;
            break;
        case 'https':
            $portToConnect = 443;
            break;
        default:
            echo "Erro ao enviar post";
            return false;
            break;
    }

    // extract host and path:
    $host = $url['host'];
    $path = $url['path'];

    // open a socket connection on port 80
    $fp = fsockopen("ssl://".$host, $portToConnect, $err, $strErr, 1.0);
    if($fp === FALSE)
    {
        return false;
    }

    // send the request headers:
    fputs($fp, "POST $path HTTP/1.1\r\n");
    fputs($fp, "Host: $host\r\n");
    fputs($fp, "Content-type: application/x-www-form-urlencoded\r\n");
    fputs($fp, "Content-length: ". strlen($data) ."\r\n");
    fputs($fp, "Connection: close\r\n\r\n");
    fputs($fp, $data);

    $result = '';
    //  while(!feof($fp)) {
    //      // receive the results of the request
    //      $result .= fgets($fp, 128);
    //  }

    // close the socket connection:
    fclose($fp);

    // split the result header from the content
    //  $result = explode("rnrn", $result, 2);

    //  $header = isset($result[0]) ? $result[0] : '';
    //  $content = isset($result[1]) ? $result[1] : '';

    // return as array:
    //  return array($header, $content);
    return true;
}

/* Mediante as mesmas keys de $a1 e $a2 devolve um array resultante com apenas as keys que apresentem valores diferentes indicando o nome da key, valor de a1 e a2.
Ex:
a1 = array("a" => 1 , "b" => 2, "c" => 3, "d" => 4);
a2 = array("a" => 3 , "b" => 1, "c" => 2);
Res:
[0] -> [key] : a , [old] : 1 , [new] : 3
[1] -> [key] : b , [old] : 2 , [new] : 1
[2] -> [key] : c , [old] : 3 , [new] : 2

O array $matchArray é utilizado para alterar o valor de 'key' no array final*/

function my_array_diff_values($a1,$a2,$matchArray=false) {
    $ret = array();
    if (!$matchArray)
        $matchArray = array_combine(array_keys($a1),array_keys($a1));
    foreach($a1 as $k => $v) {
        if (!is_numeric($k) && (@$a2[$k] || ($a1[$k] == 1 && !@$a2[$k])) && @$a2[$k] != $v) {
            if (!@$matchArray[$k])
                $matchArray[$k] = $k;
            array_push($ret,array("key" => @$matchArray[$k], "old" => $v , "new" => @$a2[$k]));
        }
    }
    return $ret;
}

function my_array_diff_values2($a1,$a2,$matchArray=false)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  


  $oldIds = array_combine($a1['id'], $a1['ordem']);

  $newIds = array();
  foreach ($a2 as $key => $val) {
    $a = explode(',',$val);
        $a = str_replace(array('(',')'),'',$a);
        // a[0] = disp_id, a[1] = svc_id, a[2] = order
        $newIds[trim($a[1])] = trim($a[2]);
    }

  $turnedOff = array_diff(array_keys($oldIds), array_keys($newIds));
  $turnedOn = array_diff(array_keys($newIds), array_keys($oldIds));

  $orderChanged = array_diff_assoc($newIds, $oldIds);

  $allIds = array_unique(array_merge($turnedOn, $turnedOff, array_keys($orderChanged)));

  // get nomes
  $sql =  "SELECT id_servico AS id, nome ".
          "FROM servicos ".
          "WHERE id_servico IN (" . implode(', ', $allIds) . ")";
  $rs = $bd->executarSQL($sql, true);

  $services = array();
  while ($rs && $row = $bd->obterRegisto($rs)){
    $services[$row['id']] = $row['nome'];
    }

  $ret = array();

  foreach($turnedOn AS $id){
    $ret[] = array("key" => $services[$id], "old" => "off", "new" => "on");
        }

  foreach($turnedOff AS $id){
    $ret[] = array("key" => $services[$id], "old" => "on", "new" => "off");
        }

  foreach($orderChanged AS $id => $order){
    $oldOrder = "-";
    if(isset($oldIds[$id])){
      $oldOrder = $oldIds[$id];
            }
    $ret[] = array("key" => $services[$id], "old" => "$oldOrder", "new" => "$order");
        }

    return $ret;
}


function my_array_diff_values3($a1,$a2, $a3)
{
    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $ret = array();
    $oldIds = array();
    $oldPri = array();

    for($n=0;$n<count($a1);$n++)
    {
        if(array_search($a1[$n][id_servico],$oldIds) == false && isset($a1[$n][id_servico]))
        {
            array_push($oldIds,intval($a1[$n][id_servico]));
        }
        if($a1[$n][servico_prioritario] == 1)
        {
            array_push($oldPri,intval($a1[$n][id_servico]));
        }
    }

    for($i=0;$i<count($oldIds);$i++)
    {
        if(is_int(array_search($oldIds[$i],$a2)) == false)
        {
            $sql = "SELECT nome FROM servicos WHERE id_servico = ".$oldIds[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "on" , "new" => "off"));
        }
    }

    for($i=0;$i<count($a2);$i++)
    {
        if(is_int(array_search($a2[$i],$oldIds)) == false)
        {
            $sql = "SELECT nome FROM servicos WHERE id_servico = ".$a2[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "off" , "new" => "on"));
        }
    }

    for($i=0;$i<count($oldPri);$i++)
    {
        if(is_int(array_search($oldPri[$i],$a3)) == false)
        {
            $sql = "SELECT nome FROM servicos WHERE id_servico = ".$oldPri[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome")." - Prioridade","old" => "on" , "new" => "off"));
        }
    }

    for($i=0;$i<count($a3);$i++)
    {
        if(is_int(array_search($a3[$i],$oldPri)) == false)
        {
            $sql = "SELECT nome FROM servicos WHERE id_servico = ".$a3[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome")." - Prioridade","old" => "off" , "new" => "on"));
        }
    }

    return $ret;
}

function my_array_diff_values4($a1,$a2, $a3, $a4)
{

    global $NOME_BD, $NOME_SERVIDOR, $USERNAME, $PASSWORD;
    //$bd = new AcessoBD();
    //$bd->ligarBD($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD);
    $conn = ligarBDMySQLi($NOME_SERVIDOR, $USERNAME, $PASSWORD, $NOME_BD); // Se falhar retorna 0
    $bd = new AcessoBD($conn);  

    $ret = array();

    for($i=0;$i<@count($a1);$i++)
    {
        if(is_array($a2) && is_int(array_search($a1[$i],$a2)) == false)
        {
            $sql = "SELECT nome FROM lojas WHERE id_loja = ".$a1[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "on" , "new" => "off"));
        }
    }
    for($i=0;$i<@count($a2);$i++)
    {
        if(is_array($a1) && is_int(array_search($a2[$i],$a1)) == false)
        {
            $sql = "SELECT nome FROM lojas WHERE id_loja = ".$a2[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "off" , "new" => "on"));
        }
    }

    for($i=0;$i<@count($a3);$i++)
    {
        if(is_array($a4) && is_int(array_search($a3[$i],$a4)) == false)
        {
            $sql = "SELECT nome FROM entidades WHERE id_entidade = ".$a3[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "on" , "new" => "off"));
        }
    }
    for($i=0;$i<@count($a4);$i++)
    {
        if(is_array($a3) && is_int(array_search($a4[$i],$a3)) == false)
        {
            $sql = "SELECT nome FROM entidades WHERE id_entidade = ".$a4[$i];
            $rs = $bd->executarSQL($sql);
            array_push($ret,array("key"=> $bd -> obterValor($rs , "nome"),"old" => "off" , "new" => "on"));
        }
    }

    return $ret;
}


/* Devolve uma string que contém um conjunto de mensagens referente à alteração de campos aquando da edição */

    function action_msg_info($diff,$table=true,$tipo='') {
        $msg = '';
        if ($table)
            $msg = "<table>";
        foreach ($diff as $change) {
            switch($tipo)
            {
                case 'dispensador':
                    //if(!($change[old] == 1 && $change['new'] == 'on'))
                    {
                        if(!($change['old'] == 1 && $change['new'] == ''))
                        {
                            $msg .= "<tr><td align=left>".$change['key']."</td><td>".$change['old']."</td><td>".$change['new']."</td></tr>";
                        }
                    }
                    break;
                default:
                    if(!is_array($change['old']) && !($change['old'] == 1 && $change['new'] == 'on'))
                    {
                        if($change['old'] == 1 && $change['new'] == '')
                        {
                            $msg .= "<tr><td align=left>".$change['key']."</td><td>".$change['old']."</td><td>off</td></tr>";
                        }
                        else
                        {
                            $msg .= "<tr><td align=left>".$change['key']."</td><td>".$change['old']."</td><td>".$change['new'] ."</td></tr>";
                        }
                    }
                    break;
            }
        }
        if (!$msg)
            $msg = "<tr><td align=left>" . translate("msg_nao_alteracao") . "</td></tr>";
        if ($table)
            $msg .= "</table>";
        return $msg;
    }



if (!function_exists('json_decode')) {


    // Taken from http://stackoverflow.com/questions/3480074/how-do-i-convert-unicode-codepoints-to-hexadecimal-html-entities
    function unenc_utf16_code_units_cb1($matches) {
        $hi_surr = hexdec($matches[1]);
        $lo_surr = hexdec($matches[2]);
        $scalar = (0x10000 + (($hi_surr & 0x3FF) << 10) |
                ($lo_surr & 0x3FF));
        return "&#x" . dechex($scalar) . ";";
    }
    function unenc_utf16_code_units_cb2($matches) {
        //just to remove leading zeros
        return "&#x" . dechex(hexdec($matches[1])) . ";";
    }
    function unenc_utf16_code_units($string) {
        /* go for possible surrogate pairs first */
        $string = preg_replace_callback(
            '/\\\\U(D[89ab][0-9a-f]{2})\\\\U(D[c-f][0-9a-f]{2})/i',
            "unenc_utf16_code_units_cb1",
            $string);
        /* now the rest */
        $string = preg_replace_callback('/\\\\U([0-9a-f]{4})/i',
            "unenc_utf16_code_units_cb2",
            $string);
        return $string;
    }


    // The result will be an associated array by force
    // so the $assoc parameter is here just for compatibility
    // with the default json_decode function
    function json_decode($json, $assoc=false) {
        $comment = false;
        $out = '$x=';


        //$json = preg_replace(array("/\\\\u000a/i", "/\\\\u000d/i"), array("\\n", "\\r"), $json);
        //$json = html_entity_decode(preg_replace("/U\+([0-9A-F]{4})/i", "&#\\1;", $string), ENT_NOQUOTES, 'UTF-8');
        $json = unenc_utf16_code_units($json);

        for ($i = 0; $i < strlen($json); $i++) {
            if (!$comment) {
                if (($json[$i] == '{') || ($json[$i] == '['))
                    $out .= ' array(';
                else if (($json[$i] == '}') || ($json[$i] == ']'))
                    $out .= ')';
                else if ($json[$i] == ':')
                    $out .= '=>';
                else
                    $out .= $json[$i];
            }
            else
                $out .= $json[$i];
            if ($json[$i] == '"' && $json[($i - 1)] != "\\")
                $comment = !$comment;
        }
        eval($out . ';');
        return $x;
    }
}

if (!function_exists('json_encode')) {
    function json_encode( $data ) {
        if( is_array($data) || is_object($data) ) {
            $islist = is_array($data) && ( empty($data) || array_keys($data) === range(0,count($data)-1) );

            if( $islist ) {
                $json = '[' . implode(',', array_map('json_encode', $data) ) . ']';
            } else {
                $items = Array();
                foreach( $data as $key => $value ) {
                    $items[] = json_encode("$key") . ':' . json_encode($value);
                }
                $json = '{' . implode(',', $items) . '}';
            }
        } elseif( is_string($data) ) {
            # Escape non-printable or Non-ASCII characters.
            # I also put the \\ character first, as suggested in comments on the 'addclashes' page.
            $string = '"' . addcslashes($data, "\\\"\n\r\t/" . chr(8) . chr(12)) . '"';
            $json    = '';
            $len    = strlen($string);
            # Convert UTF-8 to Hexadecimal Codepoints.
            for( $i = 0; $i < $len; $i++ ) {

                $char = $string[$i];
                $c1 = ord($char);

                # Single byte;
                if( $c1 <128 ) {
                    $json .= ($c1 > 31) ? $char : sprintf("\\u%04x", $c1);
                    continue;
                }

                # Double byte
                $c2 = ord($string[++$i]);
                if ( ($c1 & 32) === 0 ) {
                    $json .= sprintf("\\u%04x", ($c1 - 192) * 64 + $c2 - 128);
                    continue;
                }

                # Triple
                $c3 = ord($string[++$i]);
                if( ($c1 & 16) === 0 ) {
                    $json .= sprintf("\\u%04x", (($c1 - 224) <<12) + (($c2 - 128) << 6) + ($c3 - 128));
                    continue;
                }

                # Quadruple
                $c4 = ord($string[++$i]);
                if( ($c1 & 8 ) === 0 ) {
                    $u = (($c1 & 15) << 2) + (($c2>>4) & 3) - 1;

                    $w1 = (54<<10) + ($u<<6) + (($c2 & 15) << 2) + (($c3>>4) & 3);
                    $w2 = (55<<10) + (($c3 & 15)<<6) + ($c4-128);
                    $json .= sprintf("\\u%04x\\u%04x", $w1, $w2);
                }
            }
        } else {
            # int, floats, bools, null
            $json = strtolower(var_export( $data, true ));
        }
        return $json;
    }
}

?>
